/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.order.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.source.dto.extend.ClueWarehouseGroupRuleShipmentRespDto;
import com.yunxi.dg.base.center.source.dto.extend.OrderItemResultRespDto;
import com.yunxi.dg.base.center.source.dto.extend.SourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.action.IDgMqMessageAction;
import com.yunxi.dg.base.center.trade.config.DgPerformOrderGlobalConfig;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgGiftTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.ISourceOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.ISourceRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderAddrExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.SourceOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.SourceRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgLogicWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderOutNoticeSyncRecordRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderHandleService;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.center.trade.service.proxy.IDgSourceApiService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgPerformOrderHandleServiceImpl
implements IDgPerformOrderHandleService {
    private static final Logger log = LoggerFactory.getLogger(DgPerformOrderHandleServiceImpl.class);
    @Value(value="${oms.sale.order.phy.source.enable:true}")
    private Boolean phySourceEnable;
    @Resource
    private IDgMqMessageAction dgMqMessageAction;
    @Resource
    private IDgSourceApiService sourceApiService;
    @Resource
    private IDgPerformOrderService performOrderService;
    @Resource
    private ISourceRecordDomain sourceRecordDomain;
    @Resource
    private ISourceOrderItemDomain sourceOrderItemDomain;
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IDgPerformOrderExtDomain performOrderDomain;
    @Resource
    private IDgPerformOrderItemExtDomain performOrderItemExtDomain;
    @Resource
    private IDgPerformOrderAddrExtDomain performOrderAddrExtDomain;
    @Resource
    private DgPerformOrderGlobalConfig performOrderGlobalConfig;
    @Resource
    private ILogicWarehouseApiProxy logicWarehouseApi;

    @Override
    public RestResponse<Void> modifyChildOrderBySplit(DgPerformOrderRespDto dto, List<DgPerformOrderRespDto> childOrderList) {
        this.performOrderDomain.modifyChildOrderBySplit(dto, childOrderList);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> resetChannelPreemptForSplit(DgPerformOrderRespDto dto, List<DgPerformOrderRespDto> childOrderList) {
        if (CollectionUtils.isNotEmpty(childOrderList)) {
            List orderIds = childOrderList.stream().map(BaseDto::getId).collect(Collectors.toList());
            List saleOrderItemRespDtoList = this.performOrderItemExtDomain.queryNormalItemsByOrderIds(orderIds);
            Map<Long, List<DgPerformOrderItemDto>> orderItemsMap = saleOrderItemRespDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemDto::getOrderId));
            this.inventoryApiServcie.resetChannelPreemptForSplit(dto, childOrderList, orderItemsMap);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> resetOrderBizForSplit(DgPerformOrderRespDto dto, List<DgPerformOrderRespDto> childOrderList) {
        return null;
    }

    @Override
    public RestResponse<Void> changeGiftTypeForOrderItem(DgBizPerformOrderReqDto request) {
        Integer giftType = DgGiftTypeEnum.PLATFORM.getType();
        if (request.getManualCreate().booleanValue()) {
            giftType = DgGiftTypeEnum.MANUAL.getType();
        }
        List saleOrderItemRespDtos = this.performOrderItemExtDomain.queryOrderItemByOrderId(request.getId());
        AssertUtils.notEmpty((Collection)saleOrderItemRespDtos, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728\u5546\u54c1", (Object[])new Object[]{request.getId()});
        List orderGiftRespDtos = saleOrderItemRespDtos.stream().filter(dto -> {
            DgPerformOrderItemRespDto item = dto;
            return item.getGift() != null ? DgGiftEnum.GIFT.getType().equals(item.getGift()) : item.getPayAmount() == null || item.getPayAmount().compareTo(BigDecimal.ZERO) == 0;
        }).collect(Collectors.toList());
        Integer finalGiftType = giftType;
        Optional.ofNullable(orderGiftRespDtos).ifPresent(orderGiftRespDtoList -> orderGiftRespDtoList.forEach(item -> {
            DgPerformOrderItemReqDto performOrderItemReqDto = new DgPerformOrderItemReqDto();
            performOrderItemReqDto.setId(item.getId());
            performOrderItemReqDto.setGiftType(finalGiftType);
            this.performOrderItemExtDomain.updateSelective(performOrderItemReqDto);
        }));
        return RestResponse.VOID;
    }

    @Override
    public void saveLogisticsCompanyInfo(DgPerformOrderRespDto req) {
        List orderItemReqDtoList = this.performOrderItemExtDomain.queryNormalItemByOrderId(req.getId());
        AssertUtils.notEmpty((Collection)orderItemReqDtoList, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728\u5546\u54c1");
        if (StringUtils.isNotBlank((CharSequence)((DgPerformOrderItemRespDto)orderItemReqDtoList.get(0)).getPerformOrderItemExtensionDto().getLogisticsCompany())) {
            DgOutDeliveryResultReqDto outDeliveryResultReqDto = new DgOutDeliveryResultReqDto();
            ArrayList shippingInfoList = Lists.newArrayList();
            orderItemReqDtoList.forEach(saleOrderItemReqDto -> {
                Date deliveryTime = Optional.ofNullable(saleOrderItemReqDto.getDeliveryTime()).orElse(req.getDeliveryTime());
                DgWmsShippingInfoReqDto shippingInfoReqDto = new DgWmsShippingInfoReqDto();
                shippingInfoReqDto.setShippingNo(saleOrderItemReqDto.getInvoiceNo());
                shippingInfoReqDto.setShippingCompanyCode(saleOrderItemReqDto.getPerformOrderItemExtensionDto().getLogisticsCompanyCode());
                shippingInfoReqDto.setShippingCompanyName(saleOrderItemReqDto.getPerformOrderItemExtensionDto().getLogisticsCompany());
                shippingInfoReqDto.setDeliveryTime(deliveryTime);
                shippingInfoList.add(shippingInfoReqDto);
            });
            List shippingInfoListOfDistinct = shippingInfoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DgWmsShippingInfoReqDto>(Comparator.comparing(DgWmsShippingInfoReqDto::getShippingNo))), ArrayList::new));
            outDeliveryResultReqDto.setShippingInfoList(shippingInfoListOfDistinct);
            log.info("[\u4fdd\u5b58\u8ba2\u5355\u7269\u6d41\u4fe1\u606f]\u4fdd\u5b58\u5e73\u53f0\u5355\uff1a{}\uff0c\u7269\u6d41\u4fe1\u606f\u4e3a\uff1a{}", (Object)req.getPlatformOrderNo(), (Object)JSON.toJSONString((Object)outDeliveryResultReqDto));
        } else if (StringUtils.isNotBlank((CharSequence)req.getPerformOrderExtensionDto().getLogisticsCompany())) {
            DgOutDeliveryResultReqDto outDeliveryResultReqDto = new DgOutDeliveryResultReqDto();
            DgWmsShippingInfoReqDto shippingInfoReqDto = new DgWmsShippingInfoReqDto();
            shippingInfoReqDto.setShippingNo(req.getPerformOrderExtensionDto().getInvoiceNo());
            shippingInfoReqDto.setShippingCompanyCode(req.getPerformOrderExtensionDto().getLogisticsCompanyCode());
            shippingInfoReqDto.setShippingCompanyName(req.getPerformOrderExtensionDto().getLogisticsCompany());
            shippingInfoReqDto.setDeliveryTime(req.getDeliveryTime());
            outDeliveryResultReqDto.setShippingInfoList((List)Lists.newArrayList((Object[])new DgWmsShippingInfoReqDto[]{shippingInfoReqDto}));
            log.info("[\u4fdd\u5b58\u8ba2\u5355\u7269\u6d41\u4fe1\u606f]\u4fdd\u5b58\u5e73\u53f0\u5355\uff1a{}\uff0c\u7269\u6d41\u4fe1\u606f\u4e3a\uff1a{}", (Object)req.getPlatformOrderNo(), (Object)JSON.toJSONString((Object)outDeliveryResultReqDto));
        }
    }

    @Override
    public void setOrderLogicalWarehouse(DgPerformOrderRespDto dto, DgBizPerformOrderReqDto saleOrderRespDto) {
        String logicalWarehouseCode = null;
        if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDto.getItemList())) {
            logicalWarehouseCode = ((DgPerformOrderItemReqDto)saleOrderRespDto.getItemList().get(0)).getLogicalWarehouseCode();
        } else {
            AssertUtils.notEmpty((Collection)saleOrderRespDto.getGiftList(), (String)"\u8d60\u54c1\u5217\u8868\u4e3a\u7a7a");
            logicalWarehouseCode = ((DgPerformOrderItemReqDto)saleOrderRespDto.getGiftList().get(0)).getLogicalWarehouseCode();
        }
        log.info("[\u4ee3\u53d1\u8ba2\u5355]\u8bbe\u7f6e\u53d1\u8d27\u4ed3\u4e3a\uff1a{}", (Object)logicalWarehouseCode);
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        updateReqDto.setId(dto.getId());
        updateReqDto.setLogicalWarehouseCode(logicalWarehouseCode);
        updateReqDto.setDeliveryLogicalWarehouseCode(logicalWarehouseCode);
        this.performOrderDomain.update(updateReqDto);
    }

    @Override
    public void appointAfterSaleWarehouse(DgPerformOrderRespDto respDto) {
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(respDto.getId());
        if (DgSaleOrderTypeEnum.EXCHANGE_FIX_ORDER.getType().equals(saleOrderRespDto.getOrderType()) || DgSaleOrderTypeEnum.AFTER_SALE_ORDER.getType().equals(saleOrderRespDto.getOrderType())) {
            String warehouseCode = this.performOrderGlobalConfig.getAfterSaleWarehouseCode();
            String warehouseName = this.performOrderGlobalConfig.getAfterSaleWarehouseName();
            String warehouseId = this.performOrderGlobalConfig.getAfterSaleWarehouseId();
            if (DgSaleOrderTypeEnum.EXCHANGE_FIX_ORDER.getType().equals(saleOrderRespDto.getOrderType())) {
                warehouseId = this.performOrderGlobalConfig.getExchangeFixWarehouseId();
                warehouseCode = this.performOrderGlobalConfig.getExchangeFixWarehouseCode();
                warehouseName = this.performOrderGlobalConfig.getExchangeFixWarehouseName();
            } else if (StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getLogicalWarehouseCode())) {
                LogicWarehouseRespDto logicWarehousePageRespDto = (LogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryLogicWarehouseByCode(saleOrderRespDto.getLogicalWarehouseCode()));
                warehouseId = logicWarehousePageRespDto.getId() + "";
                warehouseCode = saleOrderRespDto.getLogicalWarehouseCode();
                warehouseName = logicWarehousePageRespDto.getWarehouseName();
            }
            DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
            updateReqDto.setLogicalWarehouseId(Long.valueOf(warehouseId));
            updateReqDto.setLogicalWarehouseCode(warehouseCode);
            updateReqDto.setLogicalWarehouseName(warehouseName);
            updateReqDto.setDeliveryLogicalWarehouseCode(warehouseCode);
            log.info("[\u6307\u5b9a\u4ed3\u5e93]\u6307\u5b9a\u4ed3\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)updateReqDto));
            this.performOrderDomain.update(updateReqDto);
        }
    }

    @Override
    public RestResponse<Void> deducateInventoryForOrder(Long orderId) {
        DgPerformOrderRespDto performOrderRespDto = this.performOrderDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)performOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        List performOrderItemRespDtos = this.performOrderItemExtDomain.queryNormalItemByOrderId(orderId);
        this.inventoryApiServcie.deducateAllInventory(performOrderRespDto, performOrderItemRespDtos);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> sendMsgForShipmentEnterprise(Long saleOrderId, DgOutDeliveryResultReqDto request) {
        DgPerformOrderRespDto saleOrderRespDto = new DgPerformOrderRespDto();
        saleOrderRespDto.setId(saleOrderId);
        DgPerformOrderOutNoticeSyncRecordRespDto syncRecordRespDto = this.performOrderService.saveOutNoticeRecord(this.performOrderDomain.queryDtoById(saleOrderId), request);
        CubeBeanUtils.copyProperties((Object)request, (Object)syncRecordRespDto, (String[])new String[0]);
        return this.dgMqMessageAction.sendMsgForAllDelivery(saleOrderRespDto, request);
    }

    @Override
    public InventoryOperateRespDto preemptLogicInventoryByOrderAppointDeliveryWarehouse(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        Long orderId = respDto.getId();
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        AssertUtils.notBlank((String)saleOrderRespDto.getLogicalWarehouseCode(), (String)"\u8ba2\u5355\u5c1a\u672a\u6307\u5b9a\u53d1\u8d27\u903b\u8f91\u4ed3");
        List saleOrderItemRespDtos = this.performOrderItemExtDomain.queryNormalItemByOrderId(orderId);
        saleOrderRespDto.setDeliveryLogicalWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
        InventoryOperateRespDto inventoryOperateRespDto = this.inventoryApiServcie.preemptLogicInventoryBackResult(saleOrderRespDto, saleOrderItemRespDtos);
        log.info("[\u6307\u5b9a\u4ed3\u5e93\u9884\u5360\u5e93\u5b58]\u9884\u5360\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateRespDto));
        if (inventoryOperateRespDto.getFailList() == null || inventoryOperateRespDto.getFailList().isEmpty()) {
            log.info("[\u6307\u5b9a\u4ed3\u5e93\u9884\u5360\u5e93\u5b58]\u9884\u5360\u6210\u529f");
            DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
            updateReqDto.setId(orderId);
            updateReqDto.setDeliveryLogicalWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
            this.performOrderDomain.update(updateReqDto);
        }
        return inventoryOperateRespDto;
    }

    @Override
    public SourceOrderResultRespDto autoSearchSource(Long saleOrderId) {
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(saleOrderId);
        List saleOrderItemRespDtos = this.performOrderItemExtDomain.queryNormalItemByOrderId(saleOrderId);
        DgPerformOrderAddrDto performOrderAddrDto = this.performOrderAddrExtDomain.queryAddressByOrderId(saleOrderId);
        SourceOrderResultRespDto sourceOrderResultRespDto = this.sourceApiService.searchSource(saleOrderRespDto, saleOrderItemRespDtos, performOrderAddrDto);
        return sourceOrderResultRespDto;
    }

    @Override
    public InventoryOperateRespDto preemptLogicInventoryBySource(String sgOrderNo) {
        AssertUtils.notBlank((String)sgOrderNo, (String)"sgOrderNo \u4e0d\u80fd\u4e3a\u7a7a");
        SourceRecordDto sourceRecordRespDto = this.sourceRecordDomain.querySourceRecordBySgOrderNo(sgOrderNo);
        AssertUtils.notNull((Object)sourceRecordRespDto, (String)"\u5bfb\u6e90\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728");
        List sourceOrderItemRespDtos = this.sourceOrderItemDomain.querySourceItemBySgOrderNo(sgOrderNo);
        log.info("[\u6839\u636e\u5bfb\u6e90\u7ed3\u679c\u5360\u5355]\u5bfb\u6e90\u5931\u8d25\uff0c\u5bfb\u6e90\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)sourceOrderItemRespDtos));
        if (SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceRecordRespDto.getSgStatus())) {
            SourceOrderItemDto sourceOrderItemRespDto = (SourceOrderItemDto)sourceOrderItemRespDtos.get(0);
            DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoByOrderNo(sourceRecordRespDto.getOrderNo());
            List saleOrderItemRespDtoList = this.performOrderItemExtDomain.queryNormalItemByOrderId(saleOrderRespDto.getId());
            saleOrderRespDto.setDeliveryLogicalWarehouseCode(sourceOrderItemRespDto.getSgWarehouseCode());
            InventoryOperateRespDto inventoryOperateRespDto = this.inventoryApiServcie.preemptLogicInventoryBackResult(saleOrderRespDto, saleOrderItemRespDtoList);
            if (inventoryOperateRespDto.getFailList() == null || inventoryOperateRespDto.getFailList().size() == 0) {
                DgLogicWarehouseReqDto logicWarehouseReqDto = new DgLogicWarehouseReqDto();
                logicWarehouseReqDto.setDeliveryLogicWarehouseCode(sourceOrderItemRespDto.getSgWarehouseCode());
                this.updateDeliveryLogicWarehouse(saleOrderRespDto.getId(), logicWarehouseReqDto);
            }
            return inventoryOperateRespDto;
        }
        log.warn("[\u6839\u636e\u5bfb\u6e90\u7ed3\u679c\u5360\u5355]\u5bfb\u6e90\u5931\u8d25\uff0c\u65b9\u6cd5\u8c03\u7528\u94fe\u4e0d\u5e94\u8be5\u8c03\u7528\u5f53\u524d\u65b9\u6cd5\uff0c\u5f53\u524d\u65b9\u6cd5\u53ea\u5904\u7406\u5bfb\u6e90\u6210\u529f\u7684\u573a\u666f");
        throw DgPcpTradeExceptionCode.SOURCE_RESULT_EXCEPTION.builderException();
    }

    @Override
    public InventoryOperateRespDto preemptLogicInventoryBySource(DgPerformOrderRespDto respDto, SourceOrderResultRespDto sourceOrderResultRespDto) {
        AssertUtils.notNull((Object)sourceOrderResultRespDto, (String)"\u5bfb\u6e90\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("[\u6839\u636e\u5bfb\u6e90\u7ed3\u679c\u5360\u5355]\u5bfb\u6e90\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)sourceOrderResultRespDto));
        if (SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
            OrderItemResultRespDto sourceOrderItemRespDto = (OrderItemResultRespDto)sourceOrderResultRespDto.getOrderItemResultRespDtoList().get(0);
            DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(respDto.getId());
            List saleOrderItemRespDtoList = this.performOrderItemExtDomain.queryNormalItemByOrderId(respDto.getId());
            saleOrderRespDto.setDeliveryLogicalWarehouseCode(sourceOrderItemRespDto.getDeliveryLogicWarehouseCode());
            InventoryOperateRespDto inventoryOperateRespDto = this.inventoryApiServcie.preemptLogicInventoryBackResult(saleOrderRespDto, saleOrderItemRespDtoList);
            if (inventoryOperateRespDto.getFailList() == null || inventoryOperateRespDto.getFailList().size() == 0) {
                DgLogicWarehouseReqDto logicWarehouseReqDto = new DgLogicWarehouseReqDto();
                logicWarehouseReqDto.setDeliveryLogicWarehouseCode(sourceOrderItemRespDto.getDeliveryLogicWarehouseCode());
                this.updateDeliveryLogicWarehouse(saleOrderRespDto.getId(), logicWarehouseReqDto);
            }
            return inventoryOperateRespDto;
        }
        log.warn("[\u6839\u636e\u5bfb\u6e90\u7ed3\u679c\u5360\u5355]\u5bfb\u6e90\u5931\u8d25\uff0c\u65b9\u6cd5\u8c03\u7528\u94fe\u4e0d\u5e94\u8be5\u8c03\u7528\u5f53\u524d\u65b9\u6cd5\uff0c\u5f53\u524d\u65b9\u6cd5\u53ea\u5904\u7406\u5bfb\u6e90\u6210\u529f\u7684\u573a\u666f");
        throw DgPcpTradeExceptionCode.SOURCE_RESULT_EXCEPTION.builderException();
    }

    @Override
    public void updateDeliveryLogicWarehouse(Long saleOrderId, DgLogicWarehouseReqDto logicWarehouseReqDto) {
        AssertUtils.notBlank((String)logicWarehouseReqDto.getDeliveryLogicWarehouseCode(), (String)"deliveryLogicWarehouseCode \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        updateReqDto.setId(saleOrderId);
        updateReqDto.setDeliveryLogicalWarehouseCode(logicWarehouseReqDto.getDeliveryLogicWarehouseCode());
        log.info("[\u66f4\u65b0\u53d1\u8d27\u903b\u8f91\u4ed3]\u4fee\u6539\u53d1\u8d27\u903b\u8f91\u4ed3\u7684\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)logicWarehouseReqDto));
        this.performOrderDomain.update(updateReqDto);
    }

    @Override
    public List<InventoryOperateRespDto> resetLogicalPreemptForSplit(DgPerformOrderRespDto saleOrderRespDto, List<DgPerformOrderRespDto> childSaleOrderList) {
        if (CollectionUtils.isNotEmpty(childSaleOrderList)) {
            List orderIds = childSaleOrderList.stream().map(BaseDto::getId).collect(Collectors.toList());
            List saleOrderItemRespDtoList = this.performOrderItemExtDomain.queryNormalItemsByOrderIds(orderIds);
            Map<Long, List<DgPerformOrderItemRespDto>> orderItemsMap = saleOrderItemRespDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemDto::getOrderId));
            return this.inventoryApiServcie.resetLogicalPreemptForSplit(saleOrderRespDto, childSaleOrderList, orderItemsMap);
        }
        return null;
    }

    @Override
    public DgArrangeShipmentEnterpriseReqDto autoShipmentEnterpriseSource(DgPerformOrderRespDto respDto) {
        if (!this.phySourceEnable.booleanValue()) {
            log.info("[\u7269\u6d41\u5bfb\u6e90]\u672a\u5f00\u542f\u81ea\u52a8\u7269\u6d41\u5bfb\u6e90\uff0c\u8fd4\u56de\u7a7a");
            return null;
        }
        AssertUtils.notBlank((String)respDto.getSaleOrderNo(), (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto performOrderRespDto = this.performOrderDomain.queryDtoById(respDto.getId());
        AssertUtils.notNull((Object)performOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        List saleOrderItemRespDtos = this.performOrderItemExtDomain.queryNormalItemByOrderId(respDto.getId());
        DgPerformOrderAddrDto saleOrderAddrRespDto = this.performOrderAddrExtDomain.queryAddressByOrderId(respDto.getId());
        AssertUtils.notBlank((String)performOrderRespDto.getDeliveryLogicalWarehouseCode(), (String)"\u8ba2\u5355\u65e0\u5b9e\u9645\u53d1\u8d27\u903b\u8f91\u4ed3");
        AssertUtils.isNull((Object)performOrderRespDto.getPlanShipmentEnterpriseCode(), (String)"\u8ba2\u5355\u5df2\u6709\u6307\u5b9a\u7269\u6d41\u5546\uff0c\u65e0\u9700\u5bfb\u6e90", (Object[])new Object[0]);
        SourceOrderResultRespDto sourceOrderResultRespDto = this.sourceApiService.shippingSearchSource(performOrderRespDto, saleOrderItemRespDtos, saleOrderAddrRespDto);
        AssertUtils.notNull((Object)sourceOrderResultRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u7269\u6d41\u5bfb\u6e90\u8bb0\u5f55");
        DgArrangeShipmentEnterpriseReqDto reqDto = null;
        if (SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
            reqDto = new DgArrangeShipmentEnterpriseReqDto();
            reqDto.setShipmentEnterpriseCode(((ClueWarehouseGroupRuleShipmentRespDto)sourceOrderResultRespDto.getClueWarehouseGroupRuleShipmentRespDtoList().get(0)).getShipmentEnterpriseCode());
            reqDto.setShipmentEnterpriseName(((ClueWarehouseGroupRuleShipmentRespDto)sourceOrderResultRespDto.getClueWarehouseGroupRuleShipmentRespDtoList().get(0)).getShipmentEnterpriseName());
            reqDto.setShipmentEnterpriseId(((ClueWarehouseGroupRuleShipmentRespDto)sourceOrderResultRespDto.getClueWarehouseGroupRuleShipmentRespDtoList().get(0)).getShipmentEnterpriseId());
            reqDto.setOrderId(performOrderRespDto.getId());
        } else {
            log.info("[\u7269\u6d41\u5bfb\u6e90]\u5bfb\u6e90\u5931\u8d25-\u8fd4\u56de");
        }
        return reqDto;
    }

    @Override
    public InventoryOperateRespDto preemptLogicInventoryByDeliveryWarehouse(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        List saleOrderItemRespDtos = this.performOrderItemExtDomain.queryNormalItemByOrderId(orderId);
        return this.inventoryApiServcie.preemptLogicInventoryBackResult(saleOrderRespDto, saleOrderItemRespDtos);
    }

    @Override
    public Boolean preemptLogicoInventoryAndReleaseInventory(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        AssertUtils.notBlank((String)saleOrderRespDto.getLogicalWarehouseCode(), (String)"\u8ba2\u5355\u5c1a\u672a\u6307\u5b9a\u53d1\u8d27\u903b\u8f91\u4ed3");
        List saleOrderItemRespDtos = this.performOrderItemExtDomain.queryNormalItemByOrderId(orderId);
        saleOrderRespDto.setDeliveryLogicalWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
        Boolean result = this.inventoryApiServcie.releaseAndpreemptInventory(saleOrderRespDto, saleOrderItemRespDtos);
        log.info("[\u6307\u5b9a\u4ed3\u5e93\u9884\u5360\u5e93\u5b58]\u9884\u5360\u6210\u529f");
        if (!result.booleanValue()) {
            log.error("[\u6307\u5b9a\u4ed3\u5e93\u9884\u5360\u5e93\u5b58]\u6307\u5b9a\u4ed3\u5e93\u9884\u5360\u5e93\u5b58\u5931\u8d25");
            throw DgPcpTradeExceptionCode.PREEMPT_LOGICAL_BY_APPOINT_EXCEPTION.builderException();
        }
        log.info("[\u6307\u5b9a\u4ed3\u5e93\u9884\u5360\u5e93\u5b58]\u9884\u5360\u6210\u529f");
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        updateReqDto.setId(orderId);
        updateReqDto.setDeliveryLogicalWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
        this.performOrderDomain.update(updateReqDto);
        return result;
    }

    @Override
    public void resetToCsAudit(DgPerformOrderRespDto saleOrderRespDto) {
        Boolean cancelResult = this.inventoryApiServcie.releaseChannelInventory(saleOrderRespDto);
        if (!cancelResult.booleanValue()) {
            throw DgPcpTradeExceptionCode.CHECK_STATUS_ORDER_CANCEL_INVENTORY_CANCEL_FAIL.builderException();
        }
        this.performOrderDomain.cleanSourceData(saleOrderRespDto.getId());
    }

    @Override
    public RestResponse<Boolean> preemptChannelInventory(Long orderId) {
        DgPerformOrderRespDto performOrderRespDto = this.performOrderDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)performOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        List performOrderItemRespDtos = this.performOrderItemExtDomain.queryNormalItemByOrderId(orderId);
        return new RestResponse((Object)this.inventoryApiServcie.preemptChannelInventory(performOrderItemRespDtos, performOrderRespDto));
    }
}

