/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.track;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.client.collector.executor.receive.TrackDataReceiveExecutor;
import com.dtyunxi.cube.component.track.commons.constant.TransactionStatusEnum;
import com.dtyunxi.cube.component.track.commons.vo.collect.TrackReceiveVo;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.trade.anno.LogIntercepts;
import com.yunxi.dg.base.center.trade.dao.vo.TradeTrackDataBizVo;
import com.yunxi.dg.base.center.trade.track.OperationTypeHelper;
import com.yunxi.dg.base.center.trade.track.enums.OrderOperationTypeEnum;
import com.yunxi.dg.base.center.trade.track.handle.TrackLogHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TradeTrackDataReceiveExecutor
implements TrackDataReceiveExecutor {
    private static final Logger logger = LoggerFactory.getLogger(TradeTrackDataReceiveExecutor.class);
    private static final Map<TrackLogHandle, FilterMetadata> CACH_FILTER_META = Maps.newConcurrentMap();
    @Resource
    private List<TrackLogHandle> trackLogHandleList;

    public void receiveData(TrackReceiveVo trackReceiveVo) {
        logger.debug("\u3010TradeTrackDataReceiveExecutor\u63a5\u6536\u5230\u65e5\u5fd7\u6570\u636e\u3011");
        TransactionStatusEnum statusEnum = TransactionStatusEnum.forCode((int)trackReceiveVo.getCurrentTransactionNodeRecordVo().getNodeStatus());
        OperationTypeHelper.OperationTypeMetadata operationTypeMetadata = OperationTypeHelper.getOperationType(trackReceiveVo.getCurrentTransactionNodeVo().getNodeApiClass(), trackReceiveVo.getCurrentTransactionNodeVo().getNodeApiMethod());
        if (operationTypeMetadata == null) {
            logger.warn("\u3010TradeTrackDataReceiveExecutor\u63a5\u6536\u5230\u65e5\u5fd7\u6570\u636e\u3011\u65e5\u5fd7\u62e6\u622a\u5c1a\u672a\u5305\u542b{}", (Object)trackReceiveVo.getCurrentTransactionNodeVo().getNodeApiMethod().toUpperCase());
            return;
        }
        TradeTrackDataBizVo tradeTrackDataBizVo = new TradeTrackDataBizVo();
        Map bizParams = trackReceiveVo.getCurrentTransactionNodeRecordVo().getBizParams();
        Map bizResult = trackReceiveVo.getCurrentTransactionNodeRecordVo().getBizResult();
        bizParams.putAll(bizResult);
        CubeBeanUtils.copyProperties((Object)tradeTrackDataBizVo, (Object)bizParams, (String[])new String[0]);
        String bizCode = MapUtils.getString((Map)bizParams, (Object)"transaction.track.node.biz.code", (String)"");
        Long headSaleOrderId = Optional.ofNullable(bizParams.get("saleOrderId")).map(String::valueOf).map(Long::valueOf).orElse(null);
        for (TrackLogHandle trackLogHandle : this.trackLogHandleList) {
            List optDataVoList;
            ArrayList<TradeTrackDataBizVo.OptDataVo> optResultList = new ArrayList<TradeTrackDataBizVo.OptDataVo>();
            FilterMetadata filterMetadata = this.getHandleFilterMetadata(trackLogHandle);
            Boolean isMatch = this.matchFilterMetadata(filterMetadata, statusEnum, bizCode);
            if (!isMatch.booleanValue()) continue;
            if (statusEnum.equals((Object)TransactionStatusEnum.T_ERROR)) {
                TradeTrackDataBizVo.OptDataVo optDataVo = new TradeTrackDataBizVo.OptDataVo();
                optDataVo.setBizId(headSaleOrderId);
                optDataVo.setOptResult(trackReceiveVo.getCurrentTransactionNodeRecordVo().getNodeApiExceptionMessage());
                Throwable bizErrorException = trackReceiveVo.getCurrentTransactionNodeRecordVo().getBizErrorException();
                if (bizErrorException instanceof BizException) {
                    BizException bizException = (BizException)bizErrorException;
                    optDataVo.setCode(bizException.getCode());
                }
                optDataVo.setIsExceptionMsg(Boolean.TRUE);
                optResultList.add(optDataVo);
            }
            if (CollectionUtils.isNotEmpty((Collection)(optDataVoList = tradeTrackDataBizVo.getOptDataVoList()))) {
                optResultList.addAll(optDataVoList);
            } else {
                List optDataVos = Optional.ofNullable(bizParams.get("optDataVoList")).map(obj -> (List)obj).orElse(null);
                if (CollectionUtils.isNotEmpty((Collection)optDataVos)) {
                    optResultList.addAll(optDataVos);
                }
            }
            optResultList.forEach(item -> {
                item.setBizId(Optional.ofNullable(item.getBizId()).orElse(headSaleOrderId));
                item.setOptTime(trackReceiveVo.getCurrentTransactionNodeRecordVo().getAccessTime());
                item.setOperationType(operationTypeMetadata.getOperationTypeName());
            });
            logger.debug("\u3010TradeTrackDataReceiveExecutor\u63a5\u6536\u5230\u65e5\u5fd7\u6570\u636e\u3011optResultList={}", (Object)JSON.toJSONString(optResultList));
            if (CollectionUtils.isEmpty(optResultList) && headSaleOrderId != null) {
                TradeTrackDataBizVo.OptDataVo optDataVo = new TradeTrackDataBizVo.OptDataVo();
                optDataVo.setBizId(headSaleOrderId);
                optDataVo.setOptTime(trackReceiveVo.getCurrentTransactionNodeRecordVo().getAccessTime());
                optDataVo.setOperationType(operationTypeMetadata.getOperationTypeName());
                optResultList.add(optDataVo);
            }
            trackLogHandle.intercept(optResultList);
        }
    }

    private Boolean matchFilterMetadata(FilterMetadata filterMetadata, TransactionStatusEnum statusEnum, String bizCode) {
        boolean matchTransactionStatus = filterMetadata.getTransactionStatusEnumList() != null ? filterMetadata.getTransactionStatusEnumList().contains(statusEnum) : Boolean.TRUE.booleanValue();
        boolean matchBizCode = filterMetadata.getBizModuleCode() != null ? filterMetadata.getBizModuleCode().contains(bizCode) : Boolean.TRUE.booleanValue();
        return matchTransactionStatus && matchBizCode;
    }

    private FilterMetadata getHandleFilterMetadata(TrackLogHandle trackLogHandle) {
        FilterMetadata filterMetadata = CACH_FILTER_META.get(trackLogHandle);
        if (filterMetadata != null) {
            return filterMetadata;
        }
        LogIntercepts logIntercepts = trackLogHandle.getClass().getAnnotation(LogIntercepts.class);
        Object[] transactionStatusEnums = logIntercepts.transactionStatus();
        OrderOperationTypeEnum[] orderOperationTypeEnums = logIntercepts.operationTypes();
        Object[] bizCodes = logIntercepts.bizCodes();
        FilterMetadata filterMetadata1 = new FilterMetadata();
        if (transactionStatusEnums.length != 0) {
            filterMetadata1.setTransactionStatusEnumList(Lists.newArrayList((Object[])transactionStatusEnums));
        }
        if (orderOperationTypeEnums.length != 0) {
            filterMetadata1.setOrderOperationTypeEnumList(Lists.newArrayList((Object[])orderOperationTypeEnums));
        }
        if (bizCodes.length != 0) {
            filterMetadata1.setBizModuleCode(Lists.newArrayList((Object[])bizCodes));
        }
        CACH_FILTER_META.put(trackLogHandle, filterMetadata1);
        return filterMetadata1;
    }

    class FilterMetadata {
        private List<TransactionStatusEnum> transactionStatusEnumList;
        private List<OrderOperationTypeEnum> orderOperationTypeEnumList;
        private List<String> bizModuleCode;

        FilterMetadata() {
        }

        public List<TransactionStatusEnum> getTransactionStatusEnumList() {
            return this.transactionStatusEnumList;
        }

        public void setTransactionStatusEnumList(List<TransactionStatusEnum> transactionStatusEnumList) {
            this.transactionStatusEnumList = transactionStatusEnumList;
        }

        public void addTransactionStatusEnum(TransactionStatusEnum transactionStatusEnum) {
            this.transactionStatusEnumList.add(transactionStatusEnum);
        }

        public List<OrderOperationTypeEnum> getOrderOperationTypeEnumList() {
            return this.orderOperationTypeEnumList;
        }

        public void setOrderOperationTypeEnumList(List<OrderOperationTypeEnum> orderOperationTypeEnumList) {
            this.orderOperationTypeEnumList = orderOperationTypeEnumList;
        }

        public void addOperationTypeEnum(OrderOperationTypeEnum operationTypeEnum) {
            this.orderOperationTypeEnumList.add(operationTypeEnum);
        }

        public List<String> getBizModuleCode() {
            return this.bizModuleCode;
        }

        public void setBizModuleCode(List<String> bizModuleCode) {
            this.bizModuleCode = bizModuleCode;
        }
    }
}

