/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.tc.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.RefWarehousePageDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.RefWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IRefWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizSaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ModifyLogicalWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OutDeliveryResultReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.trade.action.tc.IDgTcPerformOrderAction;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderOptService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.vo.ModifyLogicalWarehouseContext;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgTcPerformOrderActionImpl
implements IDgTcPerformOrderAction {
    private static final Logger log = LoggerFactory.getLogger(DgTcPerformOrderActionImpl.class);
    @Resource
    private ISaleOrderService saleOrderService;
    @Resource
    private ISaleOrderOptService saleOrderOptService;
    @Resource
    private ICsLogicWarehouseQueryApi logicWarehouseExposedQueryApi;
    @Resource
    private IChannelWarehouseApi channelWarehouseQueryApi;
    @Resource
    private IRefWarehouseQueryApi csRelWarehouseQueryApi;

    @Override
    public RestResponse<String> addSaleOrder(BizSaleOrderReqDto addReqDto) {
        return new RestResponse((Object)this.saleOrderService.addSaleOrder(addReqDto));
    }

    @Override
    public RestResponse<Void> modifySaleOrder(SaleOrderReqDto modifyReqDto) {
        this.saleOrderService.modifySaleOrder(modifyReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> removeSaleOrder(String ids, Long instanceId) {
        this.saleOrderService.removeSaleOrder(ids, instanceId);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> changeDeliveredForOrder(OutDeliveryResultReqDto reqDto) {
        this.saleOrderService.changeDeliveredForOrder(reqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> changeOrderRemark(SaleOrderReqDto reqDto) {
        this.saleOrderService.changeOrderInfo(reqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> changeLogicalWarehouse(ModifyLogicalWarehouseReqDto reqDto) {
        AssertUtils.notEmpty((Collection)reqDto.getOrderIdList(), (String)"orderIdList\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((String)reqDto.getLogicalWarehouseCode(), (String)"logicalWarehouseCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<DgSaleOrderEo> dgSaleOrderEos = this.saleOrderService.queryEoByIds(reqDto.getOrderIdList());
        List defaultWarehouseCodeList = dgSaleOrderEos.stream().filter(eo -> StringUtils.isNotEmpty((CharSequence)eo.getDefaultLogicalWarehouseCode())).map(DgSaleOrderEo::getDefaultLogicalWarehouseCode).distinct().collect(Collectors.toList());
        defaultWarehouseCodeList.add(reqDto.getLogicalWarehouseCode());
        CsLogicWarehouseParamQueryDto logicWarehouseParamQueryDto = new CsLogicWarehouseParamQueryDto();
        logicWarehouseParamQueryDto.setWarehouseCodeList(defaultWarehouseCodeList);
        RestResponse listRestResponse = this.logicWarehouseExposedQueryApi.queryList(defaultWarehouseCodeList);
        List logicWarehousePageRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        if (CollectionUtils.isEmpty((Collection)logicWarehousePageRespDtos)) {
            throw PcpTradeExceptionCode.WAREHOUSE_NOT_EXIT.buildBizException(new Object[]{"\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728"});
        }
        Map<String, CsLogicWarehouseRespDto> warehouseMap = logicWarehousePageRespDtos.stream().collect(Collectors.toMap(CsLogicWarehouseRespDto::getWarehouseCode, Function.identity()));
        Map<Object, Object> channelWarehouseRespDtoMap = Maps.newHashMap();
        if (dgSaleOrderEos.stream().anyMatch(saleOrderEo -> !this.saleOrderService.isClaimOrder(saleOrderEo.getOrderType()))) {
            List channelWarehouseCodeList = dgSaleOrderEos.stream().filter(eo -> StringUtils.isNotEmpty((CharSequence)eo.getChannelWarehouseCode())).map(DgSaleOrderEo::getChannelWarehouseCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(channelWarehouseCodeList)) {
                throw PcpTradeExceptionCode.WAREHOUSE_NOT_EXIT.buildBizException(new Object[]{"\u6e20\u9053\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"});
            }
            Set channelWarehouseCodes = channelWarehouseCodeList.stream().collect(Collectors.toSet());
            List channelWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.channelWarehouseQueryApi.queryByCodes(channelWarehouseCodes));
            if (CollectionUtils.isEmpty((Collection)channelWarehouseRespDtos)) {
                throw PcpTradeExceptionCode.WAREHOUSE_NOT_EXIT.buildBizException(new Object[]{"\u6e20\u9053\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728"});
            }
            channelWarehouseRespDtoMap = channelWarehouseRespDtos.stream().collect(Collectors.toMap(ChannelWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        }
        RefWarehousePageDto queryDto = new RefWarehousePageDto();
        queryDto.setWarehouseCode(reqDto.getLogicalWarehouseCode());
        queryDto.setWarehouseType(Integer.valueOf(1));
        queryDto.setRefWarehouseType(Integer.valueOf(0));
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(1));
        log.info("\u6307\u5b9a\u7684\u903b\u8f91\u4ed3\u67e5\u7269\u7406\u4ed3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDto));
        PageInfo csRelWarehouseRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csRelWarehouseQueryApi.queryByPage(queryDto, Integer.valueOf(1), Integer.valueOf(100)));
        log.info("\u6307\u5b9a\u7684\u903b\u8f91\u4ed3\u67e5\u7269\u7406\u4ed3\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)csRelWarehouseRespDtoPageInfo));
        RefWarehouseRespDto csRelWarehouseRespDto = null;
        if (csRelWarehouseRespDtoPageInfo != null && CollectionUtils.isNotEmpty((Collection)csRelWarehouseRespDtoPageInfo.getList())) {
            csRelWarehouseRespDto = (RefWarehouseRespDto)csRelWarehouseRespDtoPageInfo.getList().get(0);
        }
        ModifyLogicalWarehouseContext modifyLogicalWarehouseContext = new ModifyLogicalWarehouseContext();
        BeanUtil.copyProperties((Object)reqDto, (Object)((Object)modifyLogicalWarehouseContext), (String[])new String[0]);
        modifyLogicalWarehouseContext.setDgSaleOrderEos(dgSaleOrderEos);
        modifyLogicalWarehouseContext.setLogicWarehouseWarehouseMap(warehouseMap);
        modifyLogicalWarehouseContext.setChannelWarehouseRespDtoMap(channelWarehouseRespDtoMap);
        modifyLogicalWarehouseContext.setPhysicsWarehouseByLogic(csRelWarehouseRespDto);
        this.saleOrderOptService.changeLogicalWarehouse(modifyLogicalWarehouseContext);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateEasVerifyStatus(String saleOrderNo) {
        this.saleOrderService.updateEasVerifyStatus(saleOrderNo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateEasOutOrderNo(List<String> saleOrders, String easOutOrderNo) {
        this.saleOrderService.updateEasOutOrderNo(saleOrders, easOutOrderNo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> sendEasSaleOrderRest(String saleOrderNo) {
        this.saleOrderService.sendEasSaleOrderRest(saleOrderNo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> easCancelOrderLock(String platformOrderNo) {
        this.saleOrderService.easCancelOrderLock(platformOrderNo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> easDeleteOrderLock(String platformOrderNo) {
        this.saleOrderService.easDeleteOrderLock(platformOrderNo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cspCancelOrderLock(String platformOrderNo) {
        this.saleOrderService.cspCancelOrderLock(platformOrderNo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cspObsoleteByPlatformOrderNo(String platformOrderNo) {
        this.saleOrderService.cspObsoleteByPlatformOrderNo(platformOrderNo);
        return RestResponse.VOID;
    }
}

