/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleTransferTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderTagRecordReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagBaseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTransferLackDetailRestDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTransferOrderRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.domain.entity.ISaleTransferOrderDetailDomain;
import com.yunxi.dg.base.center.trade.domain.entity.ISaleTransferOrderDomain;
import com.yunxi.dg.base.center.trade.eo.SaleTransferOrderDetailEo;
import com.yunxi.dg.base.center.trade.eo.SaleTransferOrderEo;
import com.yunxi.dg.base.center.trade.service.tc.IOrderTagRecordService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleTransferOrderService;
import com.yunxi.dg.base.center.trade.utils.AssertUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleTransferOrderServiceImpl
implements ISaleTransferOrderService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ISaleTransferOrderDomain saleTransferOrderDomain;
    @Resource
    private ISaleTransferOrderDetailDomain saleTransferOrderDetailDomain;
    @Resource
    private IOrderTagRecordService orderTagRecordService;

    @Override
    public Long addSaleTransferOrder(SaleTransferOrderReqDto addReqDto) {
        this.logger.info("\u65b0\u589e\u9500\u552e\u8c03\u62e8\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        AssertUtil.isTrue((boolean)CollectionUtil.isEmpty((Collection)addReqDto.getSaleTransferOrderDetailReqDtoList()), (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        SaleTransferOrderEo saleTransferOrderEo = new SaleTransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)saleTransferOrderEo);
        this.saleTransferOrderDomain.insert((BaseEo)saleTransferOrderEo);
        ArrayList saleTransferOrderEos = new ArrayList();
        DtoHelper.dtoList2EoList((Collection)addReqDto.getSaleTransferOrderDetailReqDtoList(), saleTransferOrderEos, SaleTransferOrderDetailEo.class);
        saleTransferOrderEos.forEach(eo -> {
            eo.setOrderId(saleTransferOrderEo.getId());
            eo.setSaleOrderNo(saleTransferOrderEo.getSaleOrderNo());
            eo.setTransferOrderNo(saleTransferOrderEo.getTransferOrderNo());
        });
        this.saleTransferOrderDetailDomain.insertBatch(saleTransferOrderEos);
        if (saleTransferOrderEo.getTransferType().equals(SaleTransferTypeEnum.SALE_REPLENISH.getCode())) {
            this.addGSBHTag(addReqDto.getSaleOrderNos());
        }
        return saleTransferOrderEo.getId();
    }

    @Override
    public void addBatchSaleTransferOrder(List<SaleTransferOrderReqDto> addReqDtos) {
        this.logger.info("\u6279\u91cf\u65b0\u589e\u9500\u552e\u8c03\u62e8\uff1a{}", (Object)JSON.toJSONString(addReqDtos));
        addReqDtos.forEach(a -> {
            a.setId(Long.valueOf(IdGenrator.getDistributedId()));
            a.getSaleTransferOrderDetailReqDtoList().forEach(d -> {
                d.setOrderId(a.getId());
                d.setSaleOrderNo(a.getSaleOrderNo());
                d.setTransferOrderNo(a.getTransferOrderNo());
            });
        });
        this.saleTransferOrderDomain.insertBatch(addReqDtos.stream().map(d -> (SaleTransferOrderEo)BeanUtil.copyProperties((Object)d, SaleTransferOrderEo.class, (String[])new String[0])).collect(Collectors.toList()));
        this.saleTransferOrderDetailDomain.insertBatch(addReqDtos.stream().flatMap(a -> a.getSaleTransferOrderDetailReqDtoList().stream().map(b -> (SaleTransferOrderDetailEo)BeanUtil.copyProperties((Object)b, SaleTransferOrderDetailEo.class, (String[])new String[0]))).collect(Collectors.toList()));
    }

    @Override
    public void modifySaleTransferOrder(SaleTransferOrderReqDto modifyReqDto) {
        SaleTransferOrderEo saleTransferOrderEo = new SaleTransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)saleTransferOrderEo);
        this.saleTransferOrderDomain.updateSelective((BaseEo)saleTransferOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSaleTransferOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.saleTransferOrderDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SaleTransferOrderRespDto queryById(Long id) {
        SaleTransferOrderEo saleTransferOrderEo = (SaleTransferOrderEo)this.saleTransferOrderDomain.selectByPrimaryKey(id);
        SaleTransferOrderRespDto saleTransferOrderRespDto = new SaleTransferOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)saleTransferOrderEo, (BaseVo)saleTransferOrderRespDto);
        return saleTransferOrderRespDto;
    }

    @Override
    public PageInfo<SaleTransferOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SaleTransferOrderReqDto saleTransferOrderReqDto = (SaleTransferOrderReqDto)JSON.parseObject((String)filter, SaleTransferOrderReqDto.class);
        SaleTransferOrderEo saleTransferOrderEo = new SaleTransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)saleTransferOrderReqDto, (BaseEo)saleTransferOrderEo);
        PageInfo eoPageInfo = this.saleTransferOrderDomain.selectPage((BaseEo)saleTransferOrderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SaleTransferOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<SaleTransferOrderRespDto> queryByParam(SaleTransferOrderReqDto reqDto) {
        this.logger.info("\u67e5\u8be2\u9500\u552e\u8c03\u62e8\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        SaleTransferOrderEo queryEo = new SaleTransferOrderEo();
        queryEo.setDr(0);
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)queryEo);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)queryEo);
        queryWrapper.in(CollectionUtil.isNotEmpty((Collection)reqDto.getTransferTypeList()), SaleTransferOrderEo::getTransferType, (Collection)reqDto.getTransferTypeList());
        queryWrapper.in(CollectionUtil.isNotEmpty((Collection)reqDto.getSaleOrderNos()), SaleTransferOrderEo::getSaleOrderNo, (Collection)reqDto.getSaleOrderNos());
        List select = this.saleTransferOrderDomain.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<SaleTransferOrderRespDto> list = new ArrayList<SaleTransferOrderRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, list, SaleTransferOrderRespDto.class);
        return list;
    }

    @Override
    public void removeSaleTransferOrderByParam(SaleTransferOrderReqDto reqDto) {
        this.logger.info("\u65b0\u589e\u9500\u552e\u8c03\u62e8\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isTrue((StringUtils.isBlank((CharSequence)reqDto.getTransferOrderNo()) && StringUtils.isBlank((CharSequence)reqDto.getSaleOrderNo()) && StringUtils.isBlank((CharSequence)reqDto.getPlatformOrderNo()) ? 1 : 0) != 0, (String)"\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
        SaleTransferOrderEo queryEo = new SaleTransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)queryEo);
        List select = this.saleTransferOrderDomain.selectList((BaseEo)queryEo);
        SaleTransferOrderEo eo = new SaleTransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
        this.saleTransferOrderDomain.logicDelete((BaseEo)eo);
        if (CollectionUtil.isNotEmpty((Collection)select) && ((SaleTransferOrderEo)select.get(0)).getTransferType().equals(SaleTransferTypeEnum.SALE_REPLENISH.getCode())) {
            this.removeGSBHTag(select.stream().map(SaleTransferOrderEo::getSaleOrderNo).collect(Collectors.toList()));
        }
    }

    @Override
    public List<SaleTransferLackDetailRestDto> queryLackDetail(List<String> saleOrderNos) {
        return null;
    }

    @Override
    public List<SaleTransferLackDetailRestDto> querySaleDetailList(List<String> saleOrderNos) {
        this.logger.info("\u83b7\u53d6\u9500\u552e\u660e\u7ec6\u9700\u6c42\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString(saleOrderNos));
        List saleOrderDetailVos = this.saleTransferOrderDomain.querySaleOrderDetail(saleOrderNos);
        ArrayList<SaleTransferLackDetailRestDto> list = new ArrayList<SaleTransferLackDetailRestDto>();
        if (CollectionUtil.isNotEmpty((Collection)saleOrderDetailVos)) {
            CubeBeanUtils.copyCollection(list, (Collection)saleOrderDetailVos, SaleTransferLackDetailRestDto.class);
        }
        return list;
    }

    private void addGSBHTag(List<String> saleOrderNos) {
        this.logger.info("\u6253\u8865\u8d27\u8c03\u62e8\u6807\u7b7e\uff1a{}", (Object)JSON.toJSONString(saleOrderNos));
        try {
            List saleOrderEos = this.saleTransferOrderDomain.querySaleOrderId(saleOrderNos);
            if (CollectionUtil.isEmpty((Collection)saleOrderEos)) {
                this.logger.info("\u627e\u4e0d\u5230\u9500\u552eid");
                return;
            }
            OrderTagRecordReqDto reqDto = new OrderTagRecordReqDto();
            reqDto.setOrderIds(saleOrderEos.stream().map(BaseEo::getId).collect(Collectors.toList()));
            reqDto.setTagCode("GSBH");
            List<OrderTagRecordRespDto> orderTagRecordList = this.orderTagRecordService.queryByParam(reqDto);
            Map<Object, Object> tagMap = new HashMap();
            if (CollectionUtil.isNotEmpty(orderTagRecordList)) {
                tagMap = orderTagRecordList.stream().collect(Collectors.toMap(OrderTagBaseRespDto::getOrderId, Function.identity(), (v1, v2) -> v2));
            }
            HashMap finalTagMap = tagMap;
            saleOrderEos.forEach(e -> {
                if (ObjectUtil.isEmpty(finalTagMap.get(e.getId()))) {
                    OrderTagRecordReqDto req = new OrderTagRecordReqDto();
                    req.setOrderId(e.getId());
                    req.setTagCode("GSBH");
                    this.orderTagRecordService.addOrderTagRecord(req);
                }
            });
        }
        catch (Exception e2) {
            this.logger.error("\u6253\u8865\u8d27\u8c03\u62e8\u6807\u7b7e\u5f02\u5e38");
            this.logger.error(e2.getMessage(), (Throwable)e2);
        }
    }

    private void removeGSBHTag(List<String> saleOrderNos) {
        this.logger.info("\u67e5\u8be2\u662f\u5426\u8fd8\u6709\u8865\u8d27\u8c03\u62e8\uff1a{}", (Object)JSON.toJSONString(saleOrderNos));
        try {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SaleTransferOrderEo::getSaleOrderNo, saleOrderNos);
            queryWrapper.eq(SaleTransferOrderEo::getTransferType, (Object)SaleTransferTypeEnum.SALE_REPLENISH.getCode());
            queryWrapper.eq(BaseEo::getDr, (Object)0);
            List list = this.saleTransferOrderDomain.getMapper().selectList((Wrapper)queryWrapper);
            Map<Object, Object> map = new HashMap();
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                map = list.stream().collect(Collectors.toMap(SaleTransferOrderEo::getSaleOrderNo, Function.identity(), (v1, v2) -> v2));
            }
            HashMap finalMap = map;
            ArrayList removeSaleOrderNos = new ArrayList();
            saleOrderNos.forEach(e -> {
                if (ObjectUtil.isEmpty(finalMap.get(e))) {
                    removeSaleOrderNos.add(e);
                }
            });
            if (CollectionUtil.isEmpty(removeSaleOrderNos)) {
                this.logger.info("\u65e0\u9700\u8981\u5220\u9664\u7684\u8ba2\u5355");
                return;
            }
            List saleOrderEos = this.saleTransferOrderDomain.querySaleOrderId(removeSaleOrderNos);
            if (CollectionUtil.isEmpty((Collection)saleOrderEos)) {
                this.logger.info("\u627e\u4e0d\u5230\u8ba2\u5355ID");
                return;
            }
            OrderTagRecordReqDto req = new OrderTagRecordReqDto();
            req.setOrderIds(saleOrderEos.stream().map(BaseEo::getId).collect(Collectors.toList()));
            req.setTagCode("GSBH");
            List<OrderTagRecordRespDto> orderTagRecordRespList = this.orderTagRecordService.queryByParam(req);
            if (CollectionUtil.isEmpty(orderTagRecordRespList)) {
                this.logger.info("\u6ca1\u6709\u627e\u5230\u9500\u552e\u8c03\u62e8\u6807\u7b7e");
                return;
            }
            orderTagRecordRespList.forEach(t -> this.orderTagRecordService.removeOrderTagRecordById(t.getId()));
        }
        catch (Exception e2) {
            this.logger.error("\u67e5\u8be2\u662f\u5426\u8fd8\u6709\u8865\u8d27\u8c03\u62e8\u5f02\u5e38");
            this.logger.error(e2.getMessage(), (Throwable)e2);
        }
    }
}

