/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.order.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.api.inventory.ILogicInventoryExposedQueryApi;
import com.yunxi.dg.base.center.inventory.dto.baseorder.DeliveredOutResultInfoDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.baseorder.DeliveredOutResultInfoRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryBasicsQueryReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryBasicsQueryRespDto;
import com.yunxi.dg.base.center.inventory.proxy.baseorder.IInOutResultOrderApiProxy;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuDgRespDto;
import com.yunxi.dg.base.center.item.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgGiftTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.OriginSaleOrderEnum;
import com.yunxi.dg.base.center.trade.dao.vo.ModifyGoodsItemRowVo;
import com.yunxi.dg.base.center.trade.domain.mode.IDgCalculatorAmountModeDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderGoodsItemExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgModifyOrderItemForDifferenceReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgModifyOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgRemoveGiftBySkuReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemExtRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderItemService;
import com.yunxi.dg.base.center.trade.vo.DgPerformOrderItemChangeVo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgPerformOrderItemServiceImpl
implements IDgPerformOrderItemService {
    private static final Logger log = LoggerFactory.getLogger(DgPerformOrderItemServiceImpl.class);
    private static final String REPLACE_DIFFERENT_FLAG = "1";
    @Resource
    private IDgCalculatorAmountModeDomain dgCalculatorAmountMode;
    @Resource
    private IDgPerformOrderExtDomain performOrderDomain;
    @Resource
    private IDgPerformOrderExtDomain performOrderInfoDomain;
    @Resource
    private IDgPerformOrderItemExtDomain performOrderItemExtDomain;
    @Resource
    private IDgPerformOrderGoodsItemExtDomain performOrderGoodsItemDomain;
    @Resource
    private IInOutResultOrderApiProxy inOutResultOrderApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private ILogicInventoryExposedQueryApi inventoryExposedQueryApi;

    @Override
    public int optimisticModifySaleOrderItem(DgPerformOrderItemEo saleOrderItemEo, LambdaQueryWrapper<DgPerformOrderItemEo> queryWrapper, int idealCount, Integer needChangeItemNum, boolean needThrow) {
        return this.performOrderItemExtDomain.optimisticModifySaleOrderItem(saleOrderItemEo, queryWrapper, idealCount, needChangeItemNum, needThrow);
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItemByOrderId(Long orderId) {
        return this.performOrderItemExtDomain.queryNormalItemByOrderId(orderId);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#modifyOrderItemReqDto.orderId")
    @Transactional(rollbackFor={Exception.class})
    public void manualModifyOrderItem(DgModifyOrderItemReqDto modifyOrderItemReqDto) {
        AssertUtils.notNull((Object)modifyOrderItemReqDto.getOriginalOrderGoodsId(), (String)"originalOrderGoodsId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyOrderItemReqDto.getOrderId(), (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderItemRespDto oriOrderItemRespDto = this.performOrderItemExtDomain.queryById(modifyOrderItemReqDto.getOriginalOrderGoodsId());
        List performOrderItemRespDtos = this.performOrderItemExtDomain.queryOrderItemByOrderId(modifyOrderItemReqDto.getOriginalOrderGoodsId());
        AssertUtils.notNull((Object)oriOrderItemRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728\u8be5\u5546\u54c1");
        log.info("[\u624b\u52a8\u4fee\u6539\u5546\u54c1]\u539f\u8ba2\u5355\u5546\u54c1\u884c\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)oriOrderItemRespDto));
        if (StringUtils.equals((CharSequence)oriOrderItemRespDto.getStatus(), (CharSequence)DgSaleOrderItemStatusEnum.CANCEL.getCode())) {
            throw DgPcpTradeExceptionCode.EXCHANGE_EXCEPTION_BY_ITEM_CANCEL.builderException();
        }
        if (Objects.nonNull(modifyOrderItemReqDto.getItemNum())) {
            oriOrderItemRespDto.setItemNum(modifyOrderItemReqDto.getItemNum());
        } else {
            modifyOrderItemReqDto.setItemNum(oriOrderItemRespDto.getItemNum());
        }
        modifyOrderItemReqDto.setGift(oriOrderItemRespDto.getGift());
        ArrayList itemEoList = Lists.newArrayList();
        if (StringUtils.equals((CharSequence)modifyOrderItemReqDto.getType(), (CharSequence)DgSaleOrderItemTypeEnum.COMBINATION.getType())) {
            modifyOrderItemReqDto.setPayAmount(oriOrderItemRespDto.getPayAmount());
            modifyOrderItemReqDto.setRealPayAmount(oriOrderItemRespDto.getRealPayAmount());
            modifyOrderItemReqDto.setDiscountAmount(oriOrderItemRespDto.getDiscountAmount());
            modifyOrderItemReqDto.setPrice(oriOrderItemRespDto.getPrice());
            log.info("[\u91d1\u989d\u8ba1\u7b97]\u8ba1\u7b97\u7ec4\u5408\u5546\u54c1\u5747\u644a\u91d1\u989d\uff0c\u7ec4\u5408\u5546\u54c1\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyOrderItemReqDto));
            if (StringUtils.isNotBlank((CharSequence)oriOrderItemRespDto.getGroupSkuCode())) {
                throw DgPcpTradeExceptionCode.EXCHANGE_EXCEPTION_BY_COMBINATION.builderException();
            }
            modifyOrderItemReqDto.getSubItemList().forEach(saleOrderItemReqDto -> {
                if (!DgGiftEnum.GIFT.getType().equals(oriOrderItemRespDto.getGift()) && NumberUtil.equals((BigDecimal)saleOrderItemReqDto.getSalePrice(), (BigDecimal)BigDecimal.ZERO)) {
                    saleOrderItemReqDto.setGift(DgGiftEnum.GIFT.getType());
                    saleOrderItemReqDto.setGiftType(DgGiftTypeEnum.MANUAL.getType());
                } else {
                    saleOrderItemReqDto.setGift(oriOrderItemRespDto.getGift());
                }
            });
            List<DgPerformOrderItemRespDto> subItemEos = this.bundleItemDivide((DgPerformOrderItemReqDto)modifyOrderItemReqDto, oriOrderItemRespDto, null);
            itemEoList.addAll(subItemEos);
        } else {
            DgPerformOrderItemRespDto newOrderItemEo = new DgPerformOrderItemRespDto();
            CubeBeanUtils.copyProperties((Object)newOrderItemEo, (Object)oriOrderItemRespDto, (String[])new String[0]);
            newOrderItemEo.setImgUrl(modifyOrderItemReqDto.getImgUrl());
            newOrderItemEo.setItemNum(oriOrderItemRespDto.getItemNum());
            newOrderItemEo.setIsOrigin(OriginSaleOrderEnum.FALSE.getType());
            newOrderItemEo.setSkuCode(modifyOrderItemReqDto.getSkuCode());
            newOrderItemEo.setSkuName(modifyOrderItemReqDto.getSkuName());
            newOrderItemEo.setItemName(modifyOrderItemReqDto.getItemName());
            newOrderItemEo.setItemCode(modifyOrderItemReqDto.getItemCode());
            newOrderItemEo.setItemId(modifyOrderItemReqDto.getItemId());
            newOrderItemEo.setItemBackCategoryOneCode(modifyOrderItemReqDto.getItemBackCategoryOneCode());
            newOrderItemEo.setItemBackCategoryOneName(modifyOrderItemReqDto.getItemBackCategoryOneName());
            newOrderItemEo.setItemBackCategoryTwoCode(modifyOrderItemReqDto.getItemBackCategoryTwoCode());
            newOrderItemEo.setItemBackCategoryTwoName(modifyOrderItemReqDto.getItemBackCategoryTwoName());
            newOrderItemEo.setItemBackCategoryThirdCode(modifyOrderItemReqDto.getItemBackCategoryThirdCode());
            newOrderItemEo.setItemBackCategoryThirdName(modifyOrderItemReqDto.getItemBackCategoryThirdName());
            newOrderItemEo.setItemBackCategoryFourthCode(modifyOrderItemReqDto.getItemBackCategoryFourthCode());
            newOrderItemEo.setItemBackCategoryFourthName(modifyOrderItemReqDto.getItemBackCategoryFourthName());
            itemEoList.add(newOrderItemEo);
        }
        DgPerformOrderRespDto performOrderRespDto = this.performOrderInfoDomain.queryDtoById(modifyOrderItemReqDto.getOrderId());
        Long originOrderId = Optional.ofNullable(performOrderRespDto.getOriginOrderId()).orElse(performOrderRespDto.getId());
        DgPerformOrderItemChangeVo saleOrderItermChangeVo = new DgPerformOrderItemChangeVo();
        saleOrderItermChangeVo.setOriginOrderId(originOrderId);
        saleOrderItermChangeVo.setSaleOrderId(performOrderRespDto.getId());
        saleOrderItermChangeVo.setSaleOrderNo(performOrderRespDto.getSaleOrderNo());
        saleOrderItermChangeVo.setPerformOrderItemRespDtos((List)itemEoList);
        this.performOrderItemExtDomain.insertBatchItemVo(saleOrderItermChangeVo);
        this.removeOrderItemAndGoodsItem(modifyOrderItemReqDto.getOriginalOrderGoodsId());
        this.updateOrderItemCount(modifyOrderItemReqDto.getOrderId());
    }

    private void updateOrderItemCount(Long orderId) {
        List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList = this.queryNormalItemByOrderId(orderId);
        BigDecimal totalOrderItemCount = saleOrderItemRespDtoList.stream().map(DgPerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        updateReqDto.setId(orderId);
        updateReqDto.setGoodsTotalNum(totalOrderItemCount);
        this.performOrderDomain.update(updateReqDto);
    }

    public void removeOrderItemAndGoodsItem(Long saleOrderItemId) {
        DgPerformOrderItemEo removeEo = new DgPerformOrderItemEo();
        removeEo.setId(saleOrderItemId);
        this.performOrderItemExtDomain.logicDeleteById(saleOrderItemId);
        ModifyGoodsItemRowVo modifyGoodsItemRowVo = new ModifyGoodsItemRowVo();
        modifyGoodsItemRowVo.setQueryBelongOrderItemId(saleOrderItemId);
        this.performOrderGoodsItemDomain.removeOrderItem(modifyGoodsItemRowVo);
    }

    public List<DgPerformOrderItemRespDto> bundleItemDivide(DgPerformOrderItemReqDto modifyOrderItemReqDto, DgPerformOrderItemRespDto oriOrderItemDto, Consumer<DgPerformOrderItemRespDto> subItemExtendsFunc) {
        List subItemList = modifyOrderItemReqDto.getSubItemList();
        subItemList.sort(Comparator.comparing(DgPerformOrderItemDto::getGift).reversed());
        ArrayList subItemEos = Lists.newArrayList();
        for (int i = 0; i < subItemList.size(); ++i) {
            DgPerformOrderItemReqDto subItemReqDto = (DgPerformOrderItemReqDto)subItemList.get(i);
            DgPerformOrderItemRespDto itemEo = new DgPerformOrderItemRespDto();
            if (oriOrderItemDto != null) {
                CubeBeanUtils.copyProperties((Object)itemEo, (Object)oriOrderItemDto, (String[])new String[]{"imgUrl", "createTime", "updateTime"});
            }
            CubeBeanUtils.copyProperties((Object)itemEo, (Object)subItemReqDto, (String[])new String[0]);
            itemEo.setIsOrigin(OriginSaleOrderEnum.FALSE.getType());
            itemEo.setGroupItemName(modifyOrderItemReqDto.getItemName());
            itemEo.setGroupItemPayAmount(modifyOrderItemReqDto.getPayAmount());
            itemEo.setGroupItemRealPayAmount(modifyOrderItemReqDto.getRealPayAmount());
            itemEo.setGroupItemDiscountAmount(modifyOrderItemReqDto.getDiscountAmount());
            itemEo.setGroupOriginNum(modifyOrderItemReqDto.getItemNum());
            itemEo.setGroupItemNum(subItemReqDto.getItemNum());
            itemEo.setGroupSkuCode(modifyOrderItemReqDto.getSkuCode());
            itemEo.setGroupItemId(modifyOrderItemReqDto.getItemId());
            itemEo.setGroupItemPrice(modifyOrderItemReqDto.getPrice());
            itemEo.setType(DgSaleOrderItemTypeEnum.COMBINATION.getType());
            itemEo.setItemNum(modifyOrderItemReqDto.getItemNum().multiply(subItemReqDto.getItemNum()));
            if (subItemExtendsFunc != null) {
                subItemExtendsFunc.accept(itemEo);
            }
            if (DgGiftEnum.NOT_GIFT.getType().equals(modifyOrderItemReqDto.getGift())) {
                this.dgCalculatorAmountMode.calculatorGroupItemAmount(modifyOrderItemReqDto, (DgPerformOrderItemDto)itemEo, i);
            } else {
                itemEo.setPayAmount(BigDecimal.ZERO);
                itemEo.setDiscountAmount(BigDecimal.ZERO);
                itemEo.setRealPayAmount(BigDecimal.ZERO);
                itemEo.setSalePrice(BigDecimal.ZERO);
                itemEo.setPrice(BigDecimal.ZERO);
                itemEo.setItemIntegral(BigDecimal.ZERO);
            }
            subItemEos.add(itemEo);
        }
        return subItemEos;
    }

    @Override
    public void manualModifyOrderItemForDifference(DgPerformOrderRespDto saleOrderRespDto, DgModifyOrderItemForDifferenceReqDto modifyOrderItemForDifferenceReqDto) {
        AssertUtils.notNull((Object)modifyOrderItemForDifferenceReqDto.getOriginalOrderItemId(), (String)"originalOrderItemId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)saleOrderRespDto.getId(), (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderItemRespDto oriOrderItemDto = this.performOrderItemExtDomain.queryById(modifyOrderItemForDifferenceReqDto.getOriginalOrderItemId());
        AssertUtils.notNull((Object)oriOrderItemDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728\u8be5\u5546\u54c1");
        log.info("[\u624b\u52a8\u4fee\u6539\u5546\u54c1]\u539f\u8ba2\u5355\u5546\u54c1\u884c\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)oriOrderItemDto));
        this.checkOrderItemForDifference(oriOrderItemDto, modifyOrderItemForDifferenceReqDto);
        ArrayList newOrderItemEoList = Lists.newArrayList();
        AssertUtils.notEmpty((Collection)modifyOrderItemForDifferenceReqDto.getNewOrderItemList(), (String)"\u66ff\u6362\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        for (int i = 0; i < modifyOrderItemForDifferenceReqDto.getNewOrderItemList().size(); ++i) {
            DgPerformOrderItemReqDto modifyOrderItemReqDto = (DgPerformOrderItemReqDto)modifyOrderItemForDifferenceReqDto.getNewOrderItemList().get(i);
            modifyOrderItemReqDto.setGift(oriOrderItemDto.getGift());
            if (oriOrderItemDto.getPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                this.dgCalculatorAmountMode.calculatorOrderItemAmountForDifference(modifyOrderItemReqDto, oriOrderItemDto, i, modifyOrderItemForDifferenceReqDto.getNewOrderItemList().size() - 1);
            } else {
                modifyOrderItemReqDto.setSalePrice(BigDecimal.ZERO);
            }
            if (CollectionUtils.isNotEmpty((Collection)modifyOrderItemReqDto.getSubItemList())) {
                modifyOrderItemReqDto.getSubItemList().forEach(saleOrderItemReqDto -> {
                    if (!DgGiftEnum.GIFT.getType().equals(oriOrderItemDto.getGift()) && NumberUtil.equals((BigDecimal)saleOrderItemReqDto.getSalePrice(), (BigDecimal)BigDecimal.ZERO)) {
                        saleOrderItemReqDto.setGift(DgGiftEnum.GIFT.getType());
                        saleOrderItemReqDto.setGiftType(DgGiftTypeEnum.MANUAL.getType());
                    } else {
                        saleOrderItemReqDto.setGift(oriOrderItemDto.getGift());
                    }
                });
                List<DgPerformOrderItemRespDto> saleOrderItemEos = this.bundleItemDivide(modifyOrderItemReqDto, oriOrderItemDto, subItemEo -> {});
                newOrderItemEoList.addAll(saleOrderItemEos);
                continue;
            }
            DgPerformOrderItemRespDto saleOrderItemEo2 = new DgPerformOrderItemRespDto();
            CubeBeanUtils.copyProperties((Object)saleOrderItemEo2, (Object)oriOrderItemDto, (String[])new String[]{"createTime", "updateTime"});
            CubeBeanUtils.copyProperties((Object)saleOrderItemEo2, (Object)modifyOrderItemReqDto, (String[])new String[]{"createTime", "updateTime"});
            saleOrderItemEo2.setIsOrigin(OriginSaleOrderEnum.FALSE.getType());
            if (NumberUtil.equals((BigDecimal)modifyOrderItemReqDto.getPayAmount(), (BigDecimal)BigDecimal.ZERO)) {
                saleOrderItemEo2.setGift(DgGiftEnum.GIFT.getType());
                saleOrderItemEo2.setGiftType(DgGiftTypeEnum.MANUAL.getType());
            }
            newOrderItemEoList.add(saleOrderItemEo2);
        }
        newOrderItemEoList.stream().forEach(saleOrderItemEo -> saleOrderItemEo.getPerformOrderItemExtensionDto().setReplaceDifferentFlag(REPLACE_DIFFERENT_FLAG));
        Long originOrderId = Optional.ofNullable(saleOrderRespDto.getOriginOrderId()).orElse(saleOrderRespDto.getId());
        DgPerformOrderItemChangeVo saleOrderItermChangeVo = new DgPerformOrderItemChangeVo();
        saleOrderItermChangeVo.setOriginOrderId(originOrderId);
        saleOrderItermChangeVo.setSaleOrderId(saleOrderRespDto.getId());
        saleOrderItermChangeVo.setSaleOrderNo(saleOrderRespDto.getSaleOrderNo());
        saleOrderItermChangeVo.setPerformOrderItemRespDtos((List)newOrderItemEoList);
        this.performOrderItemExtDomain.insertBatchItemVo(saleOrderItermChangeVo);
        this.removeOrderItemAndGoodsItem(modifyOrderItemForDifferenceReqDto.getOriginalOrderItemId());
        this.updateOrderItemCount(saleOrderRespDto.getId());
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#modifyOrderItemReqDto.orderId")
    @Transactional(rollbackFor={Exception.class})
    public List<Long> manualModifyOrderItemBySkucode(DgModifyOrderItemReqDto modifyOrderItemReqDto) {
        AssertUtils.notNull((Object)modifyOrderItemReqDto.getOrderId(), (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)modifyOrderItemReqDto.getReplaceSkuCode(), (String)"replaceSkuCode \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyOrderItemReqDto.getIfGift(), (String)"ifGift \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderItemReqDto reqDto = new DgPerformOrderItemReqDto();
        reqDto.setSkuCode(modifyOrderItemReqDto.getReplaceSkuCode());
        reqDto.setOrderId(modifyOrderItemReqDto.getOrderId());
        reqDto.setStatus(DgSaleOrderItemStatusEnum.NORMAL.getCode());
        reqDto.setGift(modifyOrderItemReqDto.getIfGift() != false ? DgGiftEnum.GIFT.getType() : DgGiftEnum.NOT_GIFT.getType());
        List performOrderItemRespDtos = this.performOrderItemExtDomain.queryList(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)performOrderItemRespDtos)) {
            performOrderItemRespDtos.forEach(item -> {
                DgModifyOrderItemReqDto changeItemReq = new DgModifyOrderItemReqDto();
                CubeBeanUtils.copyProperties((Object)changeItemReq, (Object)modifyOrderItemReqDto, (String[])new String[0]);
                changeItemReq.setOriginalOrderGoodsId(item.getId());
                this.manualModifyOrderItem(changeItemReq);
            });
        } else {
            log.warn("[\u901a\u8fc7skucode\u4fee\u6539\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u4e0d\u5b58\u5728skucode={}\u7684\u5546\u54c1", (Object)modifyOrderItemReqDto.getOrderId(), (Object)modifyOrderItemReqDto.getReplaceSkuCode());
            AssertUtils.notEmpty((Collection)performOrderItemRespDtos, (String)"\u8ba2\u5355\u5546\u54c1/\u8d60\u54c1\u4e0d\u5b58\u5728");
        }
        return Lists.newArrayList((Object[])new Long[]{modifyOrderItemReqDto.getOrderId()});
    }

    private void checkOrderItemForDifference(DgPerformOrderItemRespDto oriOrderItemDto, DgModifyOrderItemForDifferenceReqDto modifyOrderItemForDifferenceReqDto) {
        if (Objects.equals(oriOrderItemDto.getGift(), DgGiftEnum.GIFT.getType())) {
            throw DgPcpTradeExceptionCode.MODIFY_ITEM_FOR_DIFFERENCE_NOT_PERMISSIONS.builderException();
        }
        BigDecimal payAmountOfNewItems = modifyOrderItemForDifferenceReqDto.getNewOrderItemList().stream().map(DgPerformOrderItemDto::getPayAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (oriOrderItemDto.getPayAmount().compareTo(payAmountOfNewItems) != 0) {
            throw DgPcpTradeExceptionCode.MODIFY_ITEM_FOR_DIFFERENCE_EXCEPTION.buildBizException(new Object[]{"\u66ff\u6362\u7684\u5546\u54c1\u603b\u6210\u4ea4\u91d1\u989d\u4e0e\u539f\u5546\u54c1\u4e0d\u4e00\u81f4"});
        }
        BigDecimal discountAmountOfNewItems = modifyOrderItemForDifferenceReqDto.getNewOrderItemList().stream().map(DgPerformOrderItemDto::getDiscountAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (oriOrderItemDto.getDiscountAmount().compareTo(discountAmountOfNewItems) != 0) {
            throw DgPcpTradeExceptionCode.MODIFY_ITEM_FOR_DIFFERENCE_EXCEPTION.buildBizException(new Object[]{"\u66ff\u6362\u7684\u5546\u54c1\u603b\u4f18\u60e0\u4e0e\u539f\u5546\u54c1\u4e0d\u4e00\u81f4"});
        }
        if (StringUtils.isNotBlank((CharSequence)oriOrderItemDto.getGroupSkuCode())) {
            for (DgPerformOrderItemReqDto subOrderItemReqDto : modifyOrderItemForDifferenceReqDto.getNewOrderItemList()) {
                if (!CollectionUtils.isNotEmpty((Collection)subOrderItemReqDto.getSubItemList())) continue;
                throw DgPcpTradeExceptionCode.EXCHANGE_EXCEPTION_BY_COMBINATION.builderException();
            }
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#saleOrderId")
    @Transactional(rollbackFor={Exception.class})
    public void removeSaleOrderItem(Long saleOrderId, Long id) {
        AssertUtils.notNull((Object)id, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderItemRespDto performOrderItemRespDto = (DgPerformOrderItemRespDto)this.performOrderItemExtDomain.selectByPrimaryKey(id);
        AssertUtils.notNull((Object)performOrderItemRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728\u8be5\u5546\u54c1");
        if (!DgGiftTypeEnum.AUTO.getType().equals(performOrderItemRespDto.getGiftType()) && !DgGiftTypeEnum.MANUAL.getType().equals(performOrderItemRespDto.getGiftType())) {
            log.warn("[\u5220\u9664\u5546\u54c1]\u5f53\u524d\u8ba2\u5355\u5546\u54c1\u5c5e\u4e8e\u539f\u5355\u5546\u54c1\u6216\u8005\u975e\u8d60\u54c1\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff0c\u5546\u54c1\u884cid={}", (Object)id);
            throw DgPcpTradeExceptionCode.REMOVE_GOOD_IEM_FAIL.builderException();
        }
        this.removeOrderItemAndGoodsItem(id);
        List<DgPerformOrderItemRespDto> saleOrderItemRespDtos = this.queryNormalItemByOrderId(saleOrderId);
        BigDecimal remainTotalItemCount = saleOrderItemRespDtos.stream().map(DgPerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        updateReqDto.setId(saleOrderId);
        updateReqDto.setGoodsTotalNum(remainTotalItemCount);
        this.performOrderDomain.update(updateReqDto);
    }

    @Override
    public void removeSaleOrderItemBySku(DgRemoveGiftBySkuReqDto reqDto) {
        DgPerformOrderItemReqDto queryDto = new DgPerformOrderItemReqDto();
        queryDto.setOrderId(reqDto.getSaleOrderId());
        queryDto.setSkuCodeList(reqDto.getSkuCodeList());
        List saleOrderItemEos = this.performOrderItemExtDomain.queryList(queryDto);
        AssertUtils.notEmpty((Collection)saleOrderItemEos, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        if (CollectionUtils.isNotEmpty((Collection)saleOrderItemEos)) {
            List orderItemEos = saleOrderItemEos.stream().filter(saleOrderItemEo -> DgGiftTypeEnum.MANUAL.getType().equals(saleOrderItemEo.getGiftType())).collect(Collectors.toList());
            log.info("[\u6307\u5b9asku\u5220\u9664\u8d60\u54c1]\u6ee1\u8db3\u5220\u9664\u8d60\u54c1\u7684sku\u6709\uff1a{}", (Object)JSON.toJSONString(orderItemEos));
            AssertUtils.notEmpty(orderItemEos, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
            Collections.sort(orderItemEos, Comparator.comparing(BaseDto::getId));
            for (DgPerformOrderItemRespDto orderItemEo : orderItemEos) {
                this.performOrderItemExtDomain.logicDeleteById(orderItemEo.getId());
            }
            List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList = this.queryNormalItemByOrderId(reqDto.getSaleOrderId());
            BigDecimal remainTotalCount = saleOrderItemRespDtoList.stream().map(DgPerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            DgPerformOrderReqDto updateOrderEo = new DgPerformOrderReqDto();
            updateOrderEo.setId(reqDto.getSaleOrderId());
            updateOrderEo.setGoodsTotalNum(remainTotalCount);
            this.performOrderDomain.update(updateOrderEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualAddSaleOrderItems(DgBizPerformOrderReqDto saleOrderReqDto) {
        AssertUtils.notNull((Object)saleOrderReqDto.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList mergeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)saleOrderReqDto.getItemList())) {
            saleOrderReqDto.getItemList().stream().forEach(saleOrderItemReqDto -> saleOrderItemReqDto.setGift(DgGiftEnum.NOT_GIFT.getType()));
            mergeList.addAll(saleOrderReqDto.getItemList());
        }
        if (CollectionUtils.isNotEmpty((Collection)saleOrderReqDto.getGiftList())) {
            saleOrderReqDto.getGiftList().stream().forEach(saleOrderItemReqDto -> {
                this.checkOrderItem((DgPerformOrderItemReqDto)saleOrderItemReqDto);
                saleOrderItemReqDto.setGift(DgGiftEnum.GIFT.getType());
                if (saleOrderItemReqDto.getGiftType() == null) {
                    saleOrderItemReqDto.setGiftType(DgGiftTypeEnum.MANUAL.getType());
                }
                saleOrderItemReqDto.setDiscountAmount(saleOrderItemReqDto.getItemNum().multiply(saleOrderItemReqDto.getSalePrice()));
                saleOrderItemReqDto.setPayAmount(BigDecimal.ZERO);
            });
            mergeList.addAll(saleOrderReqDto.getGiftList());
        }
        if (CollectionUtils.isNotEmpty((Collection)mergeList)) {
            mergeList.forEach(saleOrderItemReqDto -> {
                this.checkOrderItem((DgPerformOrderItemReqDto)saleOrderItemReqDto);
                saleOrderItemReqDto.setIsOrigin(OriginSaleOrderEnum.FALSE.getType());
                saleOrderItemReqDto.setOrderId(saleOrderReqDto.getId());
            });
            DgPerformOrderRespDto performOrderRespDto = this.performOrderDomain.queryDtoById(saleOrderReqDto.getId());
            BigDecimal addItemCount = mergeList.stream().map(DgPerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
            updateReqDto.setId(performOrderRespDto.getId());
            updateReqDto.setGoodsTotalNum(addItemCount.add(performOrderRespDto.getGoodsTotalNum()));
            this.performOrderDomain.update(updateReqDto);
            Long originOrderId = Optional.ofNullable(performOrderRespDto.getOriginOrderId()).orElse(performOrderRespDto.getId());
            ArrayList insertBatchEos = Lists.newArrayList();
            HashMap dtoEoMap = new HashMap();
            mergeList.forEach(dto -> {
                DgPerformOrderItemRespDto itemEo = new DgPerformOrderItemRespDto();
                CubeBeanUtils.copyProperties((Object)itemEo, (Object)dto, (String[])new String[0]);
                insertBatchEos.add(itemEo);
                dtoEoMap.put(dto, itemEo);
            });
            log.info("[\u624b\u52a8\u6dfb\u52a0\u5546\u54c1]\u6dfb\u52a0\u5546\u54c1\u5217\u8868\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)insertBatchEos));
            DgPerformOrderItemChangeVo saleOrderItermChangeVo = new DgPerformOrderItemChangeVo();
            saleOrderItermChangeVo.setSaleOrderId(performOrderRespDto.getId());
            saleOrderItermChangeVo.setSaleOrderNo(performOrderRespDto.getSaleOrderNo());
            saleOrderItermChangeVo.setOriginOrderId(originOrderId);
            saleOrderItermChangeVo.setPerformOrderItemRespDtos((List)insertBatchEos);
            this.performOrderItemExtDomain.insertBatchItemVo(saleOrderItermChangeVo);
            mergeList.forEach(dto -> {
                DgPerformOrderItemRespDto mapEo = (DgPerformOrderItemRespDto)dtoEoMap.get(dto);
                if (mapEo != null) {
                    dto.setId(mapEo.getId());
                } else {
                    log.info("[\u624b\u52a8\u6dfb\u52a0\u5546\u54c1]mergeList\u5339\u914d\u4e0d\u5230mapEo\uff0cdto={}", (Object)JSON.toJSONString((Object)dto));
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrderItemSupplyPrice(List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList, Map<String, BigDecimal> skuSupplyPriceMap) {
        if (MapUtils.isEmpty(skuSupplyPriceMap)) {
            return;
        }
        List performOrderItemRespDtos = saleOrderItemRespDtoList.stream().filter(saleOrderItemRespDto -> saleOrderItemRespDto.getPayAmount().compareTo(BigDecimal.ZERO) > 0).map(saleOrderItemRespDto -> {
            DgPerformOrderItemReqDto performOrderItemRespDto = new DgPerformOrderItemReqDto();
            performOrderItemRespDto.setId(saleOrderItemRespDto.getId());
            performOrderItemRespDto.setSupplyPrice((BigDecimal)skuSupplyPriceMap.get(saleOrderItemRespDto.getSkuCode()));
            return performOrderItemRespDto;
        }).collect(Collectors.toList());
        Collections.sort(performOrderItemRespDtos, Comparator.comparing(BaseDto::getId));
        for (DgPerformOrderItemReqDto itemReqDto : performOrderItemRespDtos) {
            AssertUtils.notNull((Object)itemReqDto.getId(), (String)"\u5546\u54c1\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
            this.performOrderItemExtDomain.updateSelective(itemReqDto);
        }
    }

    @Override
    public PageInfo<DgPerformOrderItemExtRespDto> queryByPage(Long orderId, Integer pageNum, Integer pageSize) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        PageInfo dtoPageInfo = this.performOrderItemExtDomain.queryPageById(orderId, pageNum, pageSize);
        DgPerformOrderRespDto performOrderInfoEo = this.performOrderDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)performOrderInfoEo, (String)String.format("orderId=%s\u8ba2\u5355\u4e0d\u5b58\u5728", orderId));
        this.fillItemInfo(dtoPageInfo.getList(), performOrderInfoEo);
        return dtoPageInfo;
    }

    private void fillItemInfo(List<DgPerformOrderItemExtRespDto> dtoList, DgPerformOrderRespDto performOrderRespDto) {
        RestResponse deliveredOutResultInfoRespDto = this.inOutResultOrderApiProxy.queryDeliveredInfo(performOrderRespDto.getSaleOrderNo());
        DeliveredOutResultInfoRespDto outResultInfoRespDto = (DeliveredOutResultInfoRespDto)RestResponseHelper.extractData((RestResponse)deliveredOutResultInfoRespDto);
        List deliveredOutResultInfoDetailRespDtoList = outResultInfoRespDto.getDeliveredOutResultInfoDetailRespDtoList();
        log.info("[\u5206\u9875\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8d27\u54c1\u4fe1\u606f]\u8d27\u54c1\u51fa\u5e93\u8be6\u60c5\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)deliveredOutResultInfoDetailRespDtoList));
        Map detailRespDtoMap = Optional.ofNullable(deliveredOutResultInfoDetailRespDtoList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(DeliveredOutResultInfoDetailRespDto::getLongCode, Function.identity(), (v1, v2) -> v2));
        List itemCodeList = dtoList.stream().map(DgPerformOrderItemDto::getItemCode).collect(Collectors.toList());
        RestResponse listRestResponse = this.itemSkuDgQueryApiProxy.queryBySkuCode(itemCodeList);
        List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        Map itemRespDtoMap = Optional.ofNullable(itemRespDtos).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity(), (v1, v2) -> v2));
        log.info("[\u5206\u9875\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8d27\u54c1\u4fe1\u606f]\u8d27\u54c1\u7684\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(itemRespDtoMap));
        List longCodeList = dtoList.stream().map(DgPerformOrderItemDto::getSkuCode).collect(Collectors.toList());
        InventoryBasicsQueryReqDto inventoryBasicsQueryReqDto = new InventoryBasicsQueryReqDto();
        inventoryBasicsQueryReqDto.setWarehouseCodeList((List)Lists.newArrayList((Object[])new String[]{performOrderRespDto.getDefaultLogicalWarehouseCode()}));
        inventoryBasicsQueryReqDto.setLongCodeList(longCodeList);
        inventoryBasicsQueryReqDto.setInventoryStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        RestResponse commonInventory = this.inventoryExposedQueryApi.queryCommonInventory(inventoryBasicsQueryReqDto);
        List inventoryBasicsQueryRespDtos = (List)RestResponseHelper.extractData((RestResponse)commonInventory);
        Map longCodeInventoryCountMap = Optional.ofNullable(inventoryBasicsQueryRespDtos).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(InventoryBasicsQueryRespDto::getLongCode, Function.identity(), (v1, v2) -> v2));
        dtoList.forEach(saleOrderItemRespDto -> {
            InventoryBasicsQueryRespDto basicsQueryRespDto;
            DeliveredOutResultInfoDetailRespDto outResultInfoDetailRespDto = (DeliveredOutResultInfoDetailRespDto)detailRespDtoMap.get(saleOrderItemRespDto.getSkuCode());
            ItemSkuDgRespDto itemRespDto = (ItemSkuDgRespDto)itemRespDtoMap.get(saleOrderItemRespDto.getItemCode());
            if (outResultInfoDetailRespDto != null) {
                saleOrderItemRespDto.setOutItemNum(outResultInfoDetailRespDto.getQuantity());
            }
            if (itemRespDto != null) {
                BigDecimal totalVolume = Optional.ofNullable(itemRespDto.getVolume()).orElse(BigDecimal.ZERO).multiply(saleOrderItemRespDto.getItemNum());
                BigDecimal totalWeight = Optional.ofNullable(itemRespDto.getGrossWeight()).orElse(BigDecimal.ZERO).multiply(saleOrderItemRespDto.getItemNum());
                saleOrderItemRespDto.setVolume(totalVolume);
                saleOrderItemRespDto.setWeight(totalWeight);
                saleOrderItemRespDto.setWeightUnit(itemRespDto.getGrossWeightUnit());
            }
            if ((basicsQueryRespDto = (InventoryBasicsQueryRespDto)longCodeInventoryCountMap.get(saleOrderItemRespDto.getSkuCode())) != null) {
                saleOrderItemRespDto.setAvailableInventory(basicsQueryRespDto.getAvailable());
            }
        });
    }

    private void checkOrderItem(DgPerformOrderItemReqDto saleOrderItemReqDto) {
        AssertUtils.notNull((Object)saleOrderItemReqDto.getItemNum(), (String)"\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)saleOrderItemReqDto.getSalePrice(), (String)"\u5546\u54c1\u96f6\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)saleOrderItemReqDto.getSkuCode(), (String)"skucode\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

