/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.guard.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.entity.RelWarehouseShipmentParamQueryDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.inventory.proxy.other.IRelWarehouseShipmentQueryApiProxy;
import com.yunxi.dg.base.center.source.dto.extend.OrderItemResultRespDto;
import com.yunxi.dg.base.center.source.dto.extend.SourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.constants.DgConsignTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderSourceModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderBizTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemRefundStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyOrderRespDto;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.guard.IDgPerformOrderGuard;
import com.yunxi.dg.base.center.trade.service.order.strategy.IDgStrategyOrderService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgPerformOrderGuardImpl
implements IDgPerformOrderGuard {
    private static final Logger log = LoggerFactory.getLogger(DgPerformOrderGuardImpl.class);
    @Resource
    private IDgPerformOrderExtDomain performOrderDomain;
    @Resource
    private IDgPerformOrderItemExtDomain performOrderItemDomain;
    @Resource
    private IDgAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IOrderLabelRecordDomain orderLabelRecordDomain;
    @Resource
    private IRelWarehouseShipmentQueryApiProxy relWarehouseShipmentQueryApi;
    @Resource
    private IDgStrategyOrderService strategyOrderService;

    @Override
    public Boolean checkOrderOfDelegationDelivery(DgPerformOrderRespDto performOrderRespDto) {
        if (DgConsignTypeEnum.THIRD.getType().equals(performOrderRespDto.getConsignType())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkContainsExchangeFix(DgPerformOrderRespDto reqDto) {
        List saleOrderItemRespDtoList = this.performOrderItemDomain.queryOrderItemByOrderId(reqDto.getId());
        long count = saleOrderItemRespDtoList.stream().map(DgPerformOrderItemDto::getItemAttr).filter(Objects::nonNull).filter(itemAttr -> DgSaleOrderBizTypeEnum.YHDX.getCode().equals(itemAttr)).count();
        if (count > 0L) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkAllOfExchangeFix(DgPerformOrderRespDto respDto) {
        List saleOrderItemRespDtoList = this.performOrderItemDomain.queryOrderItemByOrderId(respDto.getId());
        if (CollectionUtils.isNotEmpty((Collection)saleOrderItemRespDtoList)) {
            for (DgPerformOrderItemRespDto saleOrderItemReqDto : saleOrderItemRespDtoList) {
                if (DgSaleOrderBizTypeEnum.YHDX.getCode().equals(saleOrderItemReqDto.getItemAttr())) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean checkOrderCanSplit(DgPerformOrderRespDto respDto, DgBizPerformOrderReqDto bizSaleOrderReqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"\u8ba2\u5355ID\u4e3a\u7a7a");
        List saleOrderItemRespDtoList = this.performOrderItemDomain.queryOrderItemByOrderId(respDto.getId());
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)saleOrderItemRespDtoList), (String)"\u8ba2\u5355\u5546\u54c1\u884c\u6570\u636e\u4e3a\u7a7a");
        if (saleOrderItemRespDtoList.size() == 1) {
            return Boolean.FALSE;
        }
        if (this.checkSplitOrderByMultiWarehouse(bizSaleOrderReqDto).booleanValue()) {
            return Boolean.TRUE;
        }
        List splitSaleOrderItemRespDtos = saleOrderItemRespDtoList.stream().filter(saleOrderItemRespDto -> DgSaleOrderBizTypeEnum.YHDX.getCode().equals(saleOrderItemRespDto.getItemAttr())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(splitSaleOrderItemRespDtos) && splitSaleOrderItemRespDtos.size() == saleOrderItemRespDtoList.size()) {
            return Boolean.FALSE;
        }
        List performOrderServiceItemDtos = saleOrderItemRespDtoList.stream().filter(e -> DgSaleOrderItemTypeEnum.SERVICE.getType().equals(e.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(performOrderServiceItemDtos) && performOrderServiceItemDtos.size() == saleOrderItemRespDtoList.size()) {
            return Boolean.FALSE;
        }
        List performOrderVirtualItemDtos = saleOrderItemRespDtoList.stream().filter(e -> DgSaleOrderItemTypeEnum.VIRTUAL.getType().equals(e.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(performOrderVirtualItemDtos) && performOrderVirtualItemDtos.size() == saleOrderItemRespDtoList.size()) {
            return Boolean.FALSE;
        }
        List performOrderDefaultItemDtos = saleOrderItemRespDtoList.stream().filter(e -> !DgSaleOrderItemTypeEnum.VIRTUAL.getType().equals(e.getType()) && !DgSaleOrderItemTypeEnum.SERVICE.getType().equals(e.getType()) && !DgSaleOrderBizTypeEnum.YHDX.getCode().equals(e.getItemAttr())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(performOrderDefaultItemDtos) && performOrderDefaultItemDtos.size() == saleOrderItemRespDtoList.size()) {
            return Boolean.FALSE;
        }
        ArrayList allItems = Lists.newArrayList((Object[])new List[]{splitSaleOrderItemRespDtos, performOrderServiceItemDtos, performOrderVirtualItemDtos, performOrderDefaultItemDtos});
        Integer splitSize = allItems.stream().filter(list -> CollectionUtils.isNotEmpty((Collection)list)).collect(Collectors.toList()).size();
        if (splitSize == 1) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean checkOrderCanManualSplit(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"\u8ba2\u5355ID\u4e3a\u7a7a");
        List saleOrderItemRespDtoList = this.performOrderItemDomain.queryOrderItemByOrderId(respDto.getId());
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)saleOrderItemRespDtoList), (String)"\u8ba2\u5355\u5546\u54c1\u884c\u6570\u636e\u4e3a\u7a7a");
        if (saleOrderItemRespDtoList.size() <= 1) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean checkSplitOrderReqDto(DgPerformOrderRespDto respDto, DgSplitOrderReqDto reqDto) {
        AssertUtils.isTrue((boolean)respDto.getId().equals(reqDto.getSaleOrderId()), (String)"\u8ba2\u5355id\u5165\u53c2\u4e0d\u4e00\u81f4");
        AssertUtils.notEmpty((Collection)reqDto.getOrderList(), (String)"\u62c6\u5206\u5b50\u5355\u5217\u8868\u5165\u53c2\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        reqDto.getOrderList().forEach(dgSplitChildOrderReqDto -> AssertUtils.notEmpty((Collection)dgSplitChildOrderReqDto.getGoodsList(), (String)"\u62c6\u5206\u5b50\u5355\u660e\u7ec6\u5217\u8868\u5165\u53c2\u4e0d\u5141\u8bb8\u4e3a\u7a7a"));
        return Boolean.TRUE;
    }

    @Override
    public Boolean checkSplitOrderByMultiWarehouse(DgBizPerformOrderReqDto bizSaleOrderReqDto) {
        Map<String, List<DgPerformOrderItemReqDto>> orderItemResultMap;
        AssertUtils.notNull((Object)bizSaleOrderReqDto, (String)"\u8ba2\u5355\u6570\u636e\u4e3a\u7a7a");
        ArrayList mergeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)bizSaleOrderReqDto.getItemList())) {
            mergeList.addAll(bizSaleOrderReqDto.getItemList());
        }
        if (CollectionUtils.isNotEmpty((Collection)bizSaleOrderReqDto.getGiftList())) {
            mergeList.addAll(bizSaleOrderReqDto.getGiftList());
        }
        if ((orderItemResultMap = mergeList.stream().filter(saleOrderItemReqDto -> StringUtils.isNotBlank((CharSequence)saleOrderItemReqDto.getLogicalWarehouseCode())).collect(Collectors.groupingBy(DgPerformOrderItemDto::getLogicalWarehouseCode))).size() > 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkOrderOfVirtual(DgPerformOrderRespDto request) {
        if (StringUtils.equals((CharSequence)request.getOrderType(), (CharSequence)DgSaleOrderTypeEnum.VIRTUAL_ORDER.getType()) && !DgOrderSourceModelEnum.THIRDPARTY.getCode().equals(request.getOrderSourceModel())) {
            log.info("[\u5b88\u536b\u6821\u9a8c\u865a\u62df\u8ba2\u5355]\u5f53\u524d\u8ba2\u5355\u5c5e\u4e8e\u5185\u90e8\u8ba2\u5355\u3001\u865a\u62df\u8ba2\u5355\uff0c\u5e73\u53f0\u5355\u53f7\u4e3a\uff1a{}", (Object)request.getPlatformOrderNo());
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkAppointDeliveryWarehouseExist(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        Long orderId = respDto.getId();
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(orderId);
        if (StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getLogicalWarehouseCode())) {
            log.info("[\u5b88\u536b\u6821\u9a8c\u662f\u5426\u6307\u5b9a\u4e86\u53d1\u8d27\u4ed3]\u8ba2\u5355\uff08{}\uff09\u6307\u5b9a\u4e86\u53d1\u8d27\u903b\u8f91\u4ed3", (Object)orderId);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkVirtualOrderGuard(DgPerformOrderRespDto through) {
        List saleOrderItemRespDtos = this.performOrderItemDomain.queryNormalItemByOrderId(through.getId());
        if (CollectionUtils.isEmpty((Collection)saleOrderItemRespDtos)) {
            return Boolean.FALSE;
        }
        long giftCount = saleOrderItemRespDtos.parallelStream().filter(saleOrderItemRespDto -> Objects.equals(saleOrderItemRespDto.getType(), DgSaleOrderItemTypeEnum.VIRTUAL.getType())).count();
        if (giftCount == (long)saleOrderItemRespDtos.size()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkServiceOrderGuard(DgPerformOrderRespDto through) {
        List saleOrderItemRespDtos = this.performOrderItemDomain.queryNormalItemByOrderId(through.getId());
        if (CollectionUtils.isEmpty((Collection)saleOrderItemRespDtos)) {
            return Boolean.FALSE;
        }
        long giftCount = saleOrderItemRespDtos.parallelStream().filter(saleOrderItemRespDto -> Objects.equals(saleOrderItemRespDto.getType(), DgSaleOrderItemTypeEnum.SERVICE.getType())).count();
        if (giftCount == (long)saleOrderItemRespDtos.size()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkGiftOrderGuard(DgPerformOrderRespDto through) {
        List saleOrderItemRespDtos = this.performOrderItemDomain.queryNormalItemByOrderId(through.getId());
        if (CollectionUtils.isEmpty((Collection)saleOrderItemRespDtos)) {
            return Boolean.FALSE;
        }
        long giftCount = saleOrderItemRespDtos.parallelStream().filter(saleOrderItemRespDto -> Objects.equals(DgGiftEnum.GIFT.getType(), saleOrderItemRespDto.getGift())).count();
        if (giftCount == (long)saleOrderItemRespDtos.size()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkPreemptFail(InventoryOperateRespDto respDto) {
        AssertUtils.notNull((Object)respDto, (String)"\u5360\u5355\u7ed3\u679c\u5f02\u5e38");
        if (respDto.getPortionSuccessFlag().booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean validationCreateOrder(DgBizPerformOrderReqDto reqDto) {
        this.validationOrder(reqDto);
        this.validationOrderItem(reqDto);
        return Boolean.TRUE;
    }

    private void validationOrder(DgBizPerformOrderReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto.getOrderType(), (String)"orderType\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto.getPerformOrderSnapshotDto().getShopCode(), (String)"shopCode\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void validationOrderItem(DgBizPerformOrderReqDto reqDto) {
        ArrayList mergeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getItemList())) {
            mergeList.addAll(reqDto.getItemList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getGiftList())) {
            mergeList.addAll(reqDto.getGiftList());
        }
        AssertUtils.notEmpty((Collection)mergeList, (String)"\u5546\u54c1/\u8d60\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        for (DgPerformOrderItemReqDto saleOrderItemReqDto : mergeList) {
            AssertUtils.notBlank((String)saleOrderItemReqDto.getSkuCode(), (String)"\u5546\u54c1skucode\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)saleOrderItemReqDto.getItemNum(), (String)"itemNum=%s\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{saleOrderItemReqDto.getItemNum()});
        }
    }

    @Override
    public Boolean checkOrderContainsGift(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        List saleOrderItemRespDtoList = this.performOrderItemDomain.queryNormalItemByOrderId(saleOrderId);
        return saleOrderItemRespDtoList.stream().filter(saleOrderItemRespDto -> DgGiftEnum.GIFT.getType().equals(saleOrderItemRespDto.getGift())).count() > 0L;
    }

    @Override
    public Boolean checkWarehouseCodeAndShippRela(String logicalWarehouseCode, String shippCode) {
        if (logicalWarehouseCode == null || shippCode == null) {
            return Boolean.FALSE;
        }
        log.info("[\u5224\u65ad\u4ed3\u5e93\u548c\u7269\u6d41\u5173\u7cfb]\u8c03\u7528\u5e93\u5b58\u5165\u53c2\uff1alogicalWarehouseCode={},shippCode={}", (Object)logicalWarehouseCode, (Object)shippCode);
        RelWarehouseShipmentParamQueryDto relWarehouseShipmentParamQueryDto = new RelWarehouseShipmentParamQueryDto();
        relWarehouseShipmentParamQueryDto.setWarehouseCode(logicalWarehouseCode);
        relWarehouseShipmentParamQueryDto.setShipmentEnterpriseCode(shippCode);
        List csRelWarehouseShipmentRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.relWarehouseShipmentQueryApi.queryByParam(relWarehouseShipmentParamQueryDto));
        log.info("[\u5224\u65ad\u4ed3\u5e93\u548c\u7269\u6d41\u5173\u7cfb]\u8c03\u7528\u5e93\u5b58\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)csRelWarehouseShipmentRespDtos));
        if (CollectionUtils.isEmpty((Collection)csRelWarehouseShipmentRespDtos)) {
            return Boolean.FALSE;
        }
        return csRelWarehouseShipmentRespDtos.stream().anyMatch(dto -> shippCode.equals(dto.getShipmentEnterpriseCode()));
    }

    @Override
    public Boolean chekOrderCanRemoveRefundLabel(DgAfterSaleOrderRespDto respDto) {
        if (respDto.getSaleOrderId() != null) {
            DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto = new DgBizAfterSaleOrderReqDto();
            bizAfterSaleOrderReqDto.setPlatformOrderNo(respDto.getPlatformOrderNo());
            bizAfterSaleOrderReqDto.setSaleOrderId(respDto.getSaleOrderId());
            List afterSaleOrderRespDtoList = this.afterSaleOrderDomain.queryByBizAfterSaleOrderReqDto(bizAfterSaleOrderReqDto);
            if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderRespDtoList)) {
                if (CollectionUtils.isNotEmpty(afterSaleOrderRespDtoList = afterSaleOrderRespDtoList.stream().filter(dto -> !dto.getId().equals(respDto.getId())).filter(dto -> dto.getStatus().equals(DgAfterSaleOrderStatusEnum.WAIT_AUDIT.getCode()) || dto.getStatus().equals(DgAfterSaleOrderStatusEnum.REFUNDING_SUCCESS.getCode()) || dto.getStatus().equals(DgAfterSaleOrderStatusEnum.CREATED.getCode())).collect(Collectors.toList()))) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean orderShipmentCheck(DgPerformOrderRespDto respDto) {
        return this.inventoryApiServcie.orderShipmentCheck(respDto);
    }

    @Override
    public Boolean checkResetCsGuard(DgPerformOrderRespDto through) {
        if (DgOrderSourceModelEnum.THIRDPARTY.getCode().equals(through.getOrderSourceModel())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkBusinessAudit(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(respDto.getId());
        if (saleOrderRespDto.getPlanDeliveryTime() != null && saleOrderRespDto.getPlanDeliveryTime().compareTo(new Date()) > 0) {
            log.info("[\u5b88\u536b\u6821\u9a8c\u5546\u5ba1]\u9884\u8ba1\u53d1\u8d27\u65f6\u95f4\u672a\u5230\uff0c\u65e0\u6cd5\u8fdb\u884c\u5546\u5ba1");
            throw DgPcpTradeExceptionCode.BUSINESS_AUDIT_BY_PLAN_TIME.builderException();
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean chekAllItemIsRefund(DgPerformOrderRespDto respDto) {
        return this.performOrderItemDomain.queryOrderItemByOrderId(respDto.getId()).stream().allMatch(dto -> DgGiftEnum.GIFT.getType().equals(dto.getGift()) || dto.getRefundStatus().equals(DgSaleOrderItemRefundStatusEnum.REFUNDED.getCode()) || dto.getStatus().equals(DgSaleOrderItemStatusEnum.CANCEL.getCode()));
    }

    @Override
    public Boolean checkCsAuditGuard(DgPerformOrderRespDto through) {
        DgPerformOrderRespDto performOrderRespDto = this.performOrderDomain.queryDtoById(through.getId());
        if (performOrderRespDto.getPlanDeliveryTime() != null && performOrderRespDto.getPlanDeliveryTime().compareTo(new Date()) > 0) {
            log.info("[\u5b88\u536b\u6821\u9a8c\u5ba2\u5ba1]\u9884\u8ba1\u53d1\u8d27\u65f6\u95f4\u672a\u5230\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba2\u5ba1");
            throw DgPcpTradeExceptionCode.BUSINESS_AUDIT_BY_PLAN_TIME.builderException();
        }
        List existLabelCode = this.orderLabelRecordDomain.queryExistLabelCode(through.getId(), Arrays.asList(DgOrderLabelEnum.REFUND_INTERCEPT, DgOrderLabelEnum.ORDER_RELAX_ACCOUNT_FAIL_INTERCEPT));
        if (CollectionUtils.isNotEmpty((Collection)existLabelCode)) {
            throw DgPcpTradeExceptionCode.CS_AUDIT_EXCEPTION_BY_REFUND_INTERCEPT.builderException();
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean checkAutoAuditGuard(DgPerformOrderRespDto through, String strategyType) {
        List<DgStrategyOrderRespDto> orderRespDtoList = this.strategyOrderService.queryValidStrategyOrderList(through.getId(), strategyType);
        if (CollectionUtils.isNotEmpty(orderRespDtoList)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkSourceResultSuccess(DgPerformOrderRespDto respDto, SourceOrderResultRespDto sourceOrderResultRespDto) {
        return SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceOrderResultRespDto.getSgStatus());
    }

    @Override
    public Boolean checkSourceResultNeedSpilt(DgPerformOrderRespDto respDto, SourceOrderResultRespDto sourceOrderResultRespDto) {
        if (Boolean.TRUE.equals(this.checkSourceResultSuccess(respDto, sourceOrderResultRespDto))) {
            return sourceOrderResultRespDto.getOrderItemResultRespDtoList().stream().collect(Collectors.groupingBy(OrderItemResultRespDto::getDeliveryLogicWarehouseCode)).size() > 1;
        }
        return false;
    }
}

