/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleRefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleRefundTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizSaleRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.enums.SaleRefundSourceTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.dao.das.IDgSaleRefundDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleRefundAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleRefundDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleRefundExtDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleRefundItemDomain;
import com.yunxi.dg.base.center.trade.eo.DgSaleRefundAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleRefundEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleRefundExtEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleRefundItemEo;
import com.yunxi.dg.base.center.trade.proxy.data.api.IPcpDictProxy;
import com.yunxi.dg.base.center.trade.proxy.data.entity.DictDto;
import com.yunxi.dg.base.center.trade.service.tc.ISaleRefundOptService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleRefundService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleRefundServiceImpl
implements ISaleRefundService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaleRefundServiceImpl.class);
    @Resource
    private IDgSaleRefundDomain dgSaleRefundDomain;
    @Resource
    private IDgSaleRefundDas dgSaleRefundDas;
    @Resource
    private IDgSaleRefundExtDomain dgSaleRefundExtDomain;
    @Resource
    private IDgSaleRefundItemDomain dgSaleRefundItemDomain;
    @Resource
    private IDgSaleRefundAddrDomain dgSaleRefundAddrDomain;
    @Resource
    private NoGreateUtil noGreateUtil;
    @Resource
    private IPcpDictProxy pcpDictProxy;
    @Resource
    private ISaleRefundOptService saleRefundOptService;
    @Value(value="${tcbj.maiyou.customerCode}")
    private String maiyouCustomerCode;

    @Override
    @DgRedisLock(lockName="saleRefund", key="#addReqDto.getPlatformRefundNo()")
    @Transactional(rollbackFor={Exception.class})
    public Long addSaleRefund(BizSaleRefundReqDto addReqDto) {
        this.checkSaleRefundParam(addReqDto);
        this.checkRepetitivePlatformRefundNo(addReqDto);
        DgSaleRefundEo saleRefundEo = new DgSaleRefundEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)saleRefundEo);
        saleRefundEo.setSaleRefundNo(this.noGreateUtil.generateRefundNo());
        saleRefundEo.setRefundStatus(SaleRefundStatusEnum.WAIT_CHECK.getCode());
        saleRefundEo.setExtension(JSON.toJSONString((Object)addReqDto.getExtFields()));
        saleRefundEo.setPlatformRefundApplyTime(new Date());
        saleRefundEo.setBizDate(saleRefundEo.getPlatformRefundCreateTime());
        this.dgSaleRefundDomain.insert((BaseEo)saleRefundEo);
        this.reCheckRepetitivePlatformRefundNo(addReqDto, saleRefundEo);
        DgSaleRefundExtEo saleRefundExtEo = new DgSaleRefundExtEo();
        saleRefundExtEo.setOrderId(saleRefundEo.getId());
        saleRefundExtEo.setSnapshot(addReqDto.getSnapshot());
        this.dgSaleRefundExtDomain.insert((BaseEo)saleRefundExtEo);
        ArrayList saleRefundItemEos = Lists.newArrayList();
        addReqDto.getSaleRefundOrderItemReqDtoList().forEach(bizSaleRefundItemReqDto -> {
            DgSaleRefundItemEo saleRefundItemEo = new DgSaleRefundItemEo();
            DtoHelper.dto2Eo((BaseVo)bizSaleRefundItemReqDto, (BaseEo)saleRefundItemEo);
            saleRefundItemEo.setOrderId(saleRefundEo.getId());
            if (!SaleRefundTypeEnum.SPECIAL.getCode().equals(addReqDto.getRefundType()) && !Objects.equals(addReqDto.getSourceType(), SaleRefundSourceTypeEnum.MANUAL.getCode()) || StringUtils.isBlank((CharSequence)saleRefundItemEo.getBatchNo())) {
                saleRefundItemEo.setBatchNo(this.getRefundItemBatch(saleRefundEo.getCustomerCode()));
            }
            if (Objects.isNull(saleRefundItemEo.getProduceTime())) {
                saleRefundItemEo.setProduceTime(this.getRefundItenBatchProduceTime());
            }
            if (Objects.isNull(saleRefundItemEo.getExpireTime())) {
                saleRefundItemEo.setExpireTime(this.getRefundItenBatchTime());
            }
            saleRefundItemEo.setRefundWarehouseCode(saleRefundItemEo.getApplyRefundWarehouseCode());
            saleRefundItemEo.setRefundWarehouseId(saleRefundItemEo.getApplyRefundWarehouseId());
            saleRefundItemEo.setRefundWarehouseName(saleRefundItemEo.getApplyRefundWarehouseName());
            saleRefundItemEos.add(saleRefundItemEo);
        });
        this.dgSaleRefundItemDomain.insertBatch((List)saleRefundItemEos);
        DgSaleRefundAddrEo saleRefundAddrEo = new DgSaleRefundAddrEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto.getSaleRefundAddrReqDto(), (BaseEo)saleRefundAddrEo);
        saleRefundAddrEo.setOrderId(saleRefundEo.getId());
        this.dgSaleRefundAddrDomain.insert((BaseEo)saleRefundAddrEo);
        return saleRefundEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void confirmOrder(BizSaleRefundReqDto addReqDto) {
        if (this.getSaleRefundAutoStatus(addReqDto.getRefundType(), addReqDto.getOrganizationCode())) {
            LOGGER.info("\u7b26\u5408\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u89c4\u5219");
            this.saleRefundOptService.confirmOrder(addReqDto.getId());
        }
    }

    private String getRefundItemBatch(String customerCode) {
        int year = DateUtil.getYear() - 1;
        String batch = year + "0101";
        if (Objects.nonNull(this.maiyouCustomerCode) && this.maiyouCustomerCode.contains(customerCode)) {
            batch = year + "0101-1";
        }
        return batch;
    }

    private Date getRefundItenBatchProduceTime() {
        String s = DateUtil.getYear() - 1 + "-01-01";
        Date date = DateUtil.parseDate((String)s, (String)"yyyy-MM-dd");
        return date;
    }

    private Date getRefundItenBatchTime() {
        String s = DateUtil.getYear() + "-12-31";
        Date date = DateUtil.parseDate((String)s, (String)"yyyy-MM-dd");
        return date;
    }

    private void reCheckRepetitivePlatformRefundNo(BizSaleRefundReqDto addReqDto, DgSaleRefundEo saleRefundEo) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleRefundEo::getPlatformRefundNo, (Object)addReqDto.getPlatformRefundNo());
        List list = this.dgSaleRefundDomain.getMapper().selectList((Wrapper)queryWrapper);
        list = list.stream().filter(e -> !Objects.equals(e.getRefundStatus(), SaleRefundStatusEnum.CANCEL.getCode()) && !Objects.equals(e.getRefundStatus(), SaleRefundStatusEnum.INVALID.getCode())).collect(Collectors.toList());
        if (list.size() > 1) {
            throw new BizException(PcpTradeExceptionCode.MUTIL_SALE_ORDER_EXCEPTION.getCode(), String.format("\u8be5\u5e73\u53f0\u9000\u8d27\u5355\uff08%s\uff09\u5df2\u751f\u6210\u5bf9\u5e94\u7684\u5185\u90e8\u9000\u8d27\u5355\uff08%s\uff09\uff0c\u4e0d\u53ef\u591a\u6b21\u751f\u6210\u9000\u8d27\u5355", addReqDto.getPlatformRefundNo(), ((DgSaleRefundEo)list.get(0)).getSaleRefundNo()));
        }
        DgSaleRefundEo insertedOrderEo = (DgSaleRefundEo)list.get(0);
        String hadSaleRefundNo = insertedOrderEo.getSaleRefundNo();
        if (!hadSaleRefundNo.equals(saleRefundEo.getSaleRefundNo())) {
            LOGGER.error("[\u65b0\u589e\u9500\u552e\u9000\u5355]\u5f53\u524d\u6570\u636e\u5e93\u65b0\u589e\u7684\u9500\u552e\u9000\u8d27\u8ba2\u5355\u975e\u672c\u7ebf\u7a0b\u521b\u5efa\u751f\u6210\uff0c\u5f53\u524d\u7ebf\u7a0b\u751f\u6210\u7684\u8ba2\u5355\u53f7\u4e3a\uff1a{}\uff0c\u6570\u636e\u5e93\u5df2\u5b58\u5728\u7684\u8ba2\u5355\u53f7\u4e3a\uff1a{}", (Object)saleRefundEo.getSaleRefundNo(), (Object)hadSaleRefundNo);
            throw new BizException(PcpTradeExceptionCode.MUTIL_SALE_ORDER_EXCEPTION.getCode(), String.format("\u8be5\u5e73\u53f0\u9000\u8d27\u5355\uff08%s\uff09\u5df2\u751f\u6210\u5bf9\u5e94\u7684\u9500\u552e\u8ba2\u5355\uff08%s\uff09\uff0c\u4e0d\u53ef\u591a\u6b21\u751f\u6210\u9500\u552e\u9000\u8d27\u5355", addReqDto.getPlatformRefundNo(), ((DgSaleRefundEo)list.get(0)).getSaleRefundNo()));
        }
    }

    private void checkRepetitivePlatformRefundNo(BizSaleRefundReqDto addReqDto) {
        String platformRefundNo = addReqDto.getPlatformRefundNo();
        ArrayList invalidStatus = Lists.newArrayList((Object[])new String[]{SaleRefundStatusEnum.CANCEL.getCode(), SaleRefundStatusEnum.INVALID.getCode()});
        List statusList = SaleRefundStatusEnum.CODE_DESC_MAP.entrySet().stream().map(Map.Entry::getKey).filter(item -> !invalidStatus.contains(item)).collect(Collectors.toList());
        LOGGER.info("[\u65b0\u589e\u9500\u552e\u9000\u5355]\u8fdb\u884c\u4e2d\u7684\u9500\u552e\u9000\u72b6\u6001\u4e3a\uff1a{}", (Object)JSON.toJSONString(statusList));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleRefundEo::getPlatformRefundNo, (Object)platformRefundNo)).in(DgSaleRefundEo::getRefundStatus, statusList);
        List saleRefundEos = this.dgSaleRefundDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)saleRefundEos)) {
            throw PcpTradeExceptionCode.MUTIL_REFUND_ORDER_EXCEPTION.builderException();
        }
    }

    private void checkSaleRefundParam(BizSaleRefundReqDto addReqDto) {
        AssertUtils.notEmpty((Collection)addReqDto.getSaleRefundOrderItemReqDtoList(), (String)"saleRefundOrderItemReqDtoList \u9000\u8d27\u5355\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto.getSaleRefundAddrReqDto(), (String)"saleRefundAddrReqDto \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto.getPlatformRefundNo(), (String)"platformRefundNo \u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    public void modifySaleRefund(SaleRefundReqDto modifyReqDto) {
        DgSaleRefundEo saleRefundEo = new DgSaleRefundEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)saleRefundEo);
        this.dgSaleRefundDomain.updateSelective((BaseEo)saleRefundEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSaleRefund(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.dgSaleRefundDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public BizSaleRefundRespDto queryDetail(Long id, String refundNo) {
        DgSaleRefundEo saleRefundEo = null;
        if (id != null) {
            saleRefundEo = (DgSaleRefundEo)this.dgSaleRefundDomain.selectByPrimaryKey(id);
        } else {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleRefundEo::getSaleRefundNo, (Object)refundNo);
            saleRefundEo = (DgSaleRefundEo)this.dgSaleRefundDomain.getMapper().selectOne((Wrapper)queryWrapper);
        }
        AssertUtils.notNull((Object)saleRefundEo, (String)"\u8be5\u9500\u552e\u9000\u5355\u4e0d\u5b58\u5728");
        BizSaleRefundRespDto saleRefundRespDto = new BizSaleRefundRespDto();
        DtoHelper.eo2Dto((BaseEo)saleRefundEo, (BaseVo)saleRefundRespDto);
        LambdaQueryWrapper queryAddrWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryAddrWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleRefundAddrEo::getOrderId, (Object)saleRefundEo.getId());
        DgSaleRefundAddrEo saleRefundAddrEo = (DgSaleRefundAddrEo)this.dgSaleRefundAddrDomain.getMapper().selectOne((Wrapper)queryAddrWrapper);
        SaleRefundAddrRespDto saleRefundAddrRespDto = new SaleRefundAddrRespDto();
        DtoHelper.eo2Dto((BaseEo)saleRefundAddrEo, (BaseVo)saleRefundAddrRespDto);
        saleRefundRespDto.setSaleRefundAddrRespDto(saleRefundAddrRespDto);
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleRefundItemEo::getOrderId, (Object)saleRefundEo.getId());
        List refundItemEos = this.dgSaleRefundItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        ArrayList saleRefundItemRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)refundItemEos, saleRefundItemRespDtoList, SaleRefundItemRespDto.class);
        saleRefundRespDto.setGoodsList(saleRefundItemRespDtoList);
        return saleRefundRespDto;
    }

    @Override
    public int optimisticModifySaleRefund(DgSaleRefundEo saleRefundEo, UpdateWrapper<DgSaleRefundEo> queryWrapper, int idealCount, boolean needThrow) {
        LOGGER.info("optimisticModifySaleRefund={}\uff0cqueryWrapper={}\uff0cidealCount={}\uff0cneedThrow={}", new Object[]{JSON.toJSONString((Object)saleRefundEo), JSON.toJSONString(queryWrapper), idealCount, needThrow});
        if (queryWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.dgSaleRefundDas.setUpdateSystemFields((BaseEo)saleRefundEo);
        int optCount = this.dgSaleRefundDas.getMapper().update((Object)saleRefundEo, queryWrapper);
        if (this.dgSaleRefundDas.isUseCache()) {
            DgSaleRefundEo entity = (DgSaleRefundEo)queryWrapper.getEntity();
            this.dgSaleRefundDas.removeLogicCache((BaseEo)entity);
            this.dgSaleRefundDas.removeCache((Object)entity.getId());
            this.dgSaleRefundDas.removeCacheByExample((BaseEo)entity);
        }
        if (needThrow && optCount != idealCount) {
            throw new BizException("-1", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
        }
        return optCount;
    }

    @Override
    public PageInfo<SaleRefundRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SaleRefundReqDto saleRefundReqDto = (SaleRefundReqDto)JSON.parseObject((String)filter, SaleRefundReqDto.class);
        DgSaleRefundEo saleRefundEo = new DgSaleRefundEo();
        DtoHelper.dto2Eo((BaseVo)saleRefundReqDto, (BaseEo)saleRefundEo);
        PageInfo eoPageInfo = this.dgSaleRefundDomain.selectPage((BaseEo)saleRefundEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SaleRefundRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<SaleRefundRespDto> queryByRefundIds(List<Long> saleRefundIdList) {
        AssertUtils.notEmpty(saleRefundIdList, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, saleRefundIdList);
        List saleRefundEos = this.dgSaleRefundDomain.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList saleRefundRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleRefundEos, (Collection)saleRefundRespDtos, SaleRefundRespDto.class);
        return saleRefundRespDtos;
    }

    @Override
    public List<SaleRefundRespDto> queryDetailByPlatformRefundNo(String platformRefundNo) {
        ArrayList refundRespDtos = Lists.newArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleRefundEo::getPlatformRefundNo, (Object)platformRefundNo);
        List list = this.dgSaleRefundDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return refundRespDtos;
        }
        DtoHelper.eoList2DtoList((Collection)list, (Collection)refundRespDtos, SaleRefundRespDto.class);
        return refundRespDtos;
    }

    private boolean getSaleRefundAutoStatus(String refundType, String organizationCode) {
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.pcpDictProxy.queryByGroupCodeAndCode("COMMON_CONFIG", "SALE_REFUND_AUTO_CONFIRM_ORG"));
        if (Objects.isNull(dictDto)) {
            return false;
        }
        Map map = (Map)JSON.parseObject((String)dictDto.getValue(), Map.class);
        LOGGER.info("\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u914d\u7f6e:{}", (Object)JSON.toJSONString((Object)dictDto));
        Object obj = map.get(refundType);
        if (Objects.isNull(obj)) {
            return false;
        }
        String refundConfig = String.valueOf(obj);
        return refundConfig.toLowerCase().equals("all") || refundConfig.contains(organizationCode);
    }
}

