/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.order.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.vo.BaseVo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyConfItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemSuitDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleSuitDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgBusinessAuditStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgBusinessAuditStrategyRuleRespDto;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleSuitEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemSuitEo;
import com.yunxi.dg.base.center.trade.service.order.strategy.IDgBusinessStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.order.strategy.impl.DgCustomerDgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.service.order.strategy.impl.DgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateInUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgBusinessDgStrategyRuleServiceImpl
extends DgStrategyRuleServiceImpl
implements IDgBusinessStrategyRuleService,
IResetRedisNoIndexCommon {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgCustomerDgStrategyRuleServiceImpl.class);
    private static final String ALL = "ALL";
    private static final String SELECT = "SELECT";
    private static final String CUSTOMER = "CUSTOMER";
    private static final String BUSINESS = "BUSINESS";
    private static final String SUITTYPE_SHOP = "SHOP";
    private static final String SUITTYPE_BIZ_TYPE = "BIZ_TYPE";
    @Resource
    private NoGreateInUtil noGreateInUtil;
    @Resource
    private IDgStrategyConfItemDomain strategyConfItemDas;
    @Resource
    private IDgStrategyConfItemSuitDomain strategyConfItemSuitDas;
    @Resource
    private IDgStrategyRuleSuitDomain strategyRuleSuitDas;
    @Resource
    private IDgPerformOrderExtDomain performOrderExtDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBusinessAuditStrategyRule(DgBusinessAuditStrategyRuleReqDto addReqDto) {
        DgStrategyRuleEo dgStrategyRuleEo = new DgStrategyRuleEo();
        CubeBeanUtils.copyProperties((Object)dgStrategyRuleEo, (Object)addReqDto, (String[])new String[0]);
        dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateBusinessRuleNo());
        dgStrategyRuleEo.setStrategyType(BUSINESS);
        this.strategyRuleDas.insert((BaseEo)dgStrategyRuleEo);
        this.popStrategyConfItems(addReqDto, dgStrategyRuleEo);
        this.saveStrategyRuleSuit(addReqDto, dgStrategyRuleEo);
        return dgStrategyRuleEo.getId();
    }

    private void saveStrategyRuleSuit(DgBusinessAuditStrategyRuleReqDto addReqDto, DgStrategyRuleEo dgStrategyRuleEo) {
        DgBusinessAuditStrategyRuleReqDto.ApplyShop applyShop = addReqDto.getApplyShop();
        ArrayList dgStrategyRuleSuitEoList = Lists.newArrayList();
        DgStrategyRuleSuitEo dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
        dgStrategyRuleSuitEo.setRuleId(dgStrategyRuleEo.getId());
        dgStrategyRuleSuitEo.setSuitType(SUITTYPE_SHOP);
        dgStrategyRuleSuitEo.setStrategyType(BUSINESS);
        dgStrategyRuleSuitEo.setMd5(MD5Util.getMd5ByString((String)applyShop.getMD5Content()));
        if (StringUtils.equals((CharSequence)applyShop.getApplicableType(), (CharSequence)ALL)) {
            dgStrategyRuleSuitEo.setSuitKey(ALL);
            dgStrategyRuleSuitEo.setSuitSelectType(ALL);
            dgStrategyRuleSuitEo.setSuitMatchCode(dgStrategyRuleSuitEo.getSuitType() + "_" + dgStrategyRuleSuitEo.getSuitSelectType() + "_" + dgStrategyRuleSuitEo.getSuitKey());
            dgStrategyRuleSuitEoList.add(dgStrategyRuleSuitEo);
        } else if (CollectionUtils.isNotEmpty((Collection)applyShop.getApplicableList())) {
            for (String shopCode : applyShop.getApplicableList()) {
                dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
                dgStrategyRuleSuitEo.setRuleId(dgStrategyRuleEo.getId());
                dgStrategyRuleSuitEo.setSuitType(SUITTYPE_SHOP);
                dgStrategyRuleSuitEo.setSuitKey(shopCode);
                dgStrategyRuleSuitEo.setSuitSelectType(SELECT);
                dgStrategyRuleSuitEo.setStrategyType(BUSINESS);
                dgStrategyRuleSuitEo.setSuitMatchCode(dgStrategyRuleSuitEo.getSuitType() + "_" + dgStrategyRuleSuitEo.getSuitSelectType() + "_" + shopCode);
                dgStrategyRuleSuitEo.setMd5(MD5Util.getMd5ByString((String)applyShop.getMD5Content()));
                dgStrategyRuleSuitEoList.add(dgStrategyRuleSuitEo);
            }
        }
        this.strategyRuleSuitDas.insertBatch((List)dgStrategyRuleSuitEoList);
    }

    private void popStrategyConfItems(DgBusinessAuditStrategyRuleReqDto addReqDto, DgStrategyRuleEo dgStrategyRuleEo) {
        StrategyConfItemSuitEo confItemSuitEo;
        ArrayList confItemEoList = Lists.newArrayList();
        StrategyConfItemEo delayAuditConfEo = new StrategyConfItemEo();
        CubeBeanUtils.copyProperties((Object)delayAuditConfEo, (Object)addReqDto.getDelayAudit(), (String[])new String[0]);
        delayAuditConfEo.setRuleId(dgStrategyRuleEo.getId());
        delayAuditConfEo.setContent(addReqDto.getDelayAudit().getContent());
        delayAuditConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getDelayAudit().getMD5Content()));
        confItemEoList.add(delayAuditConfEo);
        StrategyConfItemEo needPersonAuditConfEo = new StrategyConfItemEo();
        needPersonAuditConfEo.setRuleId(dgStrategyRuleEo.getId());
        needPersonAuditConfEo.setStrategyType(CisStrategyConfItemTypeEnum.MANUAL_ORDER_NEED_PERSON_AUDIT.getCode());
        needPersonAuditConfEo.setStrategyTypeName(CisStrategyConfItemTypeEnum.MANUAL_ORDER_NEED_PERSON_AUDIT.getDesc());
        needPersonAuditConfEo.setEnable(addReqDto.getNeedPersonAuditByManualOrder());
        needPersonAuditConfEo.setMd5(MD5Util.getMd5ByString((String)String.valueOf(addReqDto.getNeedPersonAuditByManualOrder())));
        confItemEoList.add(needPersonAuditConfEo);
        StrategyConfItemEo importOrderConfEo = new StrategyConfItemEo();
        importOrderConfEo.setRuleId(dgStrategyRuleEo.getId());
        importOrderConfEo.setStrategyType(CisStrategyConfItemTypeEnum.IMPORT_ORDER_NEED_PERSON_AUDIT.getCode());
        importOrderConfEo.setStrategyTypeName(CisStrategyConfItemTypeEnum.IMPORT_ORDER_NEED_PERSON_AUDIT.getDesc());
        importOrderConfEo.setEnable(addReqDto.getNeedPersonAuditByImport());
        importOrderConfEo.setMd5(MD5Util.getMd5ByString((String)String.valueOf(addReqDto.getNeedPersonAuditByImport())));
        confItemEoList.add(importOrderConfEo);
        StrategyConfItemEo modifyOrderItemConfEo = new StrategyConfItemEo();
        modifyOrderItemConfEo.setRuleId(dgStrategyRuleEo.getId());
        modifyOrderItemConfEo.setStrategyType(CisStrategyConfItemTypeEnum.MODIFY_ITEM_NEED_PERSON_AUDIT.getCode());
        modifyOrderItemConfEo.setStrategyTypeName(CisStrategyConfItemTypeEnum.MODIFY_ITEM_NEED_PERSON_AUDIT.getDesc());
        modifyOrderItemConfEo.setEnable(addReqDto.getNeedPersonAuditByModifyItem());
        modifyOrderItemConfEo.setMd5(MD5Util.getMd5ByString((String)String.valueOf(addReqDto.getNeedPersonAuditByModifyItem())));
        confItemEoList.add(modifyOrderItemConfEo);
        StrategyConfItemEo specialAmountConfEo = new StrategyConfItemEo();
        CubeBeanUtils.copyProperties((Object)specialAmountConfEo, (Object)addReqDto.getSpecialAmount(), (String[])new String[0]);
        specialAmountConfEo.setRuleId(dgStrategyRuleEo.getId());
        specialAmountConfEo.setContent(addReqDto.getSpecialAmount().getContent());
        specialAmountConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSpecialAmount().getMD5Content()));
        confItemEoList.add(specialAmountConfEo);
        StrategyConfItemEo modifyAddrConfEo = new StrategyConfItemEo();
        modifyAddrConfEo.setRuleId(dgStrategyRuleEo.getId());
        modifyAddrConfEo.setEnable(addReqDto.getNeedPersonAuditByModifyAddr());
        modifyAddrConfEo.setStrategyType(CisStrategyConfItemTypeEnum.MODIFY_ADDR_NEED_PERSON_AUDIT.getCode());
        modifyAddrConfEo.setStrategyTypeName(CisStrategyConfItemTypeEnum.MODIFY_ADDR_NEED_PERSON_AUDIT.getDesc());
        modifyAddrConfEo.setMd5(MD5Util.getMd5ByString((String)String.valueOf(addReqDto.getNeedPersonAuditByModifyAddr())));
        confItemEoList.add(modifyAddrConfEo);
        StrategyConfItemEo modifyShipmentConfEo = new StrategyConfItemEo();
        modifyShipmentConfEo.setRuleId(dgStrategyRuleEo.getId());
        modifyShipmentConfEo.setEnable(addReqDto.getNeedPersonAuditByModifyShipment());
        modifyShipmentConfEo.setStrategyType(CisStrategyConfItemTypeEnum.MODIFY_SHIPMENT_NEED_PERSON_AUDIT.getCode());
        modifyShipmentConfEo.setStrategyTypeName(CisStrategyConfItemTypeEnum.MODIFY_SHIPMENT_NEED_PERSON_AUDIT.getDesc());
        modifyShipmentConfEo.setMd5(MD5Util.getMd5ByString((String)String.valueOf(addReqDto.getNeedPersonAuditByModifyShipment())));
        confItemEoList.add(modifyShipmentConfEo);
        ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
        List orderTypeCodeList = addReqDto.getSpecialOrderType().getOrderTypeCodeList();
        StrategyConfItemEo orderTypeCodeConfEo = new StrategyConfItemEo();
        CubeBeanUtils.copyProperties((Object)orderTypeCodeConfEo, (Object)addReqDto.getSpecialOrderType(), (String[])new String[0]);
        orderTypeCodeConfEo.setRuleId(dgStrategyRuleEo.getId());
        orderTypeCodeConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSpecialOrderType().getMD5Content()));
        confItemEoList.add(orderTypeCodeConfEo);
        if (CollectionUtils.isNotEmpty((Collection)orderTypeCodeList)) {
            for (String orderTypeCode : orderTypeCodeList) {
                StrategyConfItemSuitEo confItemSuitEo2 = new StrategyConfItemSuitEo();
                confItemSuitEo2.setRuleId(dgStrategyRuleEo.getId());
                confItemSuitEo2.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode());
                confItemSuitEo2.setSuitValue(orderTypeCode);
                confItemSuitEo2.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode() + "_" + orderTypeCode);
                strategyConfItemSuitEoList.add(confItemSuitEo2);
            }
        }
        if (Objects.nonNull(addReqDto.getSpecialArea())) {
            List areaCodeList = addReqDto.getSpecialArea().getAreaCodeList();
            StrategyConfItemEo areaCodeConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)areaCodeConfEo, (Object)addReqDto.getSpecialArea(), (String[])new String[0]);
            areaCodeConfEo.setRuleId(dgStrategyRuleEo.getId());
            areaCodeConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSpecialArea().getMD5Content()));
            confItemEoList.add(areaCodeConfEo);
            if (CollectionUtils.isNotEmpty((Collection)areaCodeList)) {
                for (String areaCode : areaCodeList) {
                    confItemSuitEo = new StrategyConfItemSuitEo();
                    confItemSuitEo.setRuleId(dgStrategyRuleEo.getId());
                    confItemSuitEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_AREA.getCode());
                    confItemSuitEo.setSuitValue(areaCode);
                    confItemSuitEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_AREA.getCode() + "_" + areaCode);
                    strategyConfItemSuitEoList.add(confItemSuitEo);
                }
            }
        }
        List labelCodeList = addReqDto.getSpecialLabel().getLabelCodeList();
        StrategyConfItemEo labelConfEo = new StrategyConfItemEo();
        CubeBeanUtils.copyProperties((Object)labelConfEo, (Object)addReqDto.getSpecialLabel(), (String[])new String[0]);
        labelConfEo.setRuleId(dgStrategyRuleEo.getId());
        labelConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSpecialLabel().getMD5Content()));
        confItemEoList.add(labelConfEo);
        if (CollectionUtils.isNotEmpty((Collection)labelCodeList)) {
            for (String label : labelCodeList) {
                confItemSuitEo = new StrategyConfItemSuitEo();
                confItemSuitEo.setRuleId(dgStrategyRuleEo.getId());
                confItemSuitEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode());
                confItemSuitEo.setSuitValue(label);
                confItemSuitEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode() + "_" + label);
                strategyConfItemSuitEoList.add(confItemSuitEo);
            }
        }
        StrategyConfItemEo buyerRemarkConfEo = new StrategyConfItemEo();
        CubeBeanUtils.copyProperties((Object)buyerRemarkConfEo, (Object)addReqDto.getBuyerRemark(), (String[])new String[0]);
        buyerRemarkConfEo.setRuleId(dgStrategyRuleEo.getId());
        buyerRemarkConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getBuyerRemark().getMD5Content()));
        confItemEoList.add(buyerRemarkConfEo);
        StrategyConfItemEo sellerRemarkConfEo = new StrategyConfItemEo();
        CubeBeanUtils.copyProperties((Object)sellerRemarkConfEo, (Object)addReqDto.getSellerRemark(), (String[])new String[0]);
        sellerRemarkConfEo.setRuleId(dgStrategyRuleEo.getId());
        sellerRemarkConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSellerRemark().getMD5Content()));
        confItemEoList.add(sellerRemarkConfEo);
        StrategyConfItemEo internalRemarkConfEo = new StrategyConfItemEo();
        CubeBeanUtils.copyProperties((Object)internalRemarkConfEo, (Object)addReqDto.getInternalRemark(), (String[])new String[0]);
        internalRemarkConfEo.setRuleId(dgStrategyRuleEo.getId());
        internalRemarkConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getInternalRemark().getMD5Content()));
        confItemEoList.add(internalRemarkConfEo);
        StrategyConfItemEo specialPayTimeConfEo = new StrategyConfItemEo();
        CubeBeanUtils.copyProperties((Object)specialPayTimeConfEo, (Object)addReqDto.getSpecialPayTime(), (String[])new String[0]);
        specialPayTimeConfEo.setRuleId(dgStrategyRuleEo.getId());
        specialPayTimeConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSpecialPayTime().getMD5Content()));
        confItemEoList.add(specialPayTimeConfEo);
        this.strategyConfItemDas.insertBatch((List)confItemEoList);
        this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
    }

    @Override
    public void modifyBusinessAuditStrategyRule(DgBusinessAuditStrategyRuleReqDto modifyReqDto) {
        AssertUtils.notNull((Object)modifyReqDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        DgStrategyRuleEo newDgStrategyRuleEo = new DgStrategyRuleEo();
        CubeBeanUtils.copyProperties((Object)newDgStrategyRuleEo, (Object)modifyReqDto, (String[])new String[0]);
        this.strategyRuleDas.updateSelective((BaseEo)newDgStrategyRuleEo);
        this.modifyStrategyConfItems(modifyReqDto);
        this.modifyStrategyRuleSuit(modifyReqDto);
    }

    private void modifyStrategyRuleSuit(DgBusinessAuditStrategyRuleReqDto modifyReqDto) {
        DgBusinessAuditStrategyRuleReqDto.ApplyShop applyShop = modifyReqDto.getApplyShop();
        String applyShopMd5 = MD5Util.getMd5ByString((String)applyShop.getMD5Content());
        LambdaQueryWrapper queryStrategyRuleSuitEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyRuleSuitEo.eq(BaseEo::getDr, (Object)0)).eq(DgStrategyRuleSuitEo::getRuleId, (Object)modifyReqDto.getId());
        List dgStrategyRuleSuitEos = this.strategyRuleSuitDas.list(queryStrategyRuleSuitEo);
        List applyShopSuitList = Optional.ofNullable(dgStrategyRuleSuitEos).orElseGet(Collections::emptyList).stream().filter(strategyRuleSuitEo -> StringUtils.equals((CharSequence)strategyRuleSuitEo.getSuitType(), (CharSequence)SUITTYPE_SHOP)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(applyShopSuitList) && !StringUtils.equals((CharSequence)((DgStrategyRuleSuitEo)applyShopSuitList.get(0)).getMd5(), (CharSequence)applyShopMd5)) {
            DgStrategyRuleSuitEo deleteEo = new DgStrategyRuleSuitEo();
            deleteEo.setRuleId(modifyReqDto.getId());
            deleteEo.setSuitType(SUITTYPE_SHOP);
            this.strategyRuleSuitDas.logicDeleteByExample(deleteEo);
            ArrayList dgStrategyRuleSuitEoList = Lists.newArrayList();
            DgStrategyRuleSuitEo dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
            dgStrategyRuleSuitEo.setRuleId(modifyReqDto.getId());
            dgStrategyRuleSuitEo.setSuitType(SUITTYPE_SHOP);
            dgStrategyRuleSuitEo.setStrategyType(BUSINESS);
            dgStrategyRuleSuitEo.setMd5(MD5Util.getMd5ByString((String)applyShop.getMD5Content()));
            if (StringUtils.equals((CharSequence)applyShop.getApplicableType(), (CharSequence)ALL)) {
                dgStrategyRuleSuitEo.setSuitKey(ALL);
                dgStrategyRuleSuitEo.setSuitSelectType(ALL);
                dgStrategyRuleSuitEo.setSuitMatchCode(dgStrategyRuleSuitEo.getSuitType() + "_" + dgStrategyRuleSuitEo.getSuitSelectType() + "_" + dgStrategyRuleSuitEo.getSuitKey());
                dgStrategyRuleSuitEoList.add(dgStrategyRuleSuitEo);
            } else if (CollectionUtils.isNotEmpty((Collection)applyShop.getApplicableList())) {
                for (String shopCode : applyShop.getApplicableList()) {
                    dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
                    dgStrategyRuleSuitEo.setRuleId(modifyReqDto.getId());
                    dgStrategyRuleSuitEo.setSuitType(SUITTYPE_SHOP);
                    dgStrategyRuleSuitEo.setSuitKey(shopCode);
                    dgStrategyRuleSuitEo.setSuitSelectType(SELECT);
                    dgStrategyRuleSuitEo.setStrategyType(BUSINESS);
                    dgStrategyRuleSuitEo.setSuitMatchCode(dgStrategyRuleSuitEo.getSuitType() + "_" + dgStrategyRuleSuitEo.getSuitSelectType() + "_" + shopCode);
                    dgStrategyRuleSuitEo.setMd5(MD5Util.getMd5ByString((String)applyShop.getMD5Content()));
                    dgStrategyRuleSuitEoList.add(dgStrategyRuleSuitEo);
                }
            }
            this.strategyRuleSuitDas.insertBatch((List)dgStrategyRuleSuitEoList);
        }
    }

    private void modifyStrategyConfItems(DgBusinessAuditStrategyRuleReqDto modifyReqDto) {
        LambdaQueryWrapper queryStrategyConfItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getRuleId, (Object)modifyReqDto.getId());
        List strategyConfItemEoList = this.strategyConfItemDas.list(queryStrategyConfItemEo);
        Map groupStrategyMap = strategyConfItemEoList.stream().collect(Collectors.toMap(StrategyConfItemEo::getStrategyType, Function.identity(), (v1, v2) -> v2));
        String delayAuditMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getDelayAudit().getMD5Content());
        StrategyConfItemEo delayAudit = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.DELAY_AUDIT.getCode());
        if (delayAudit != null && !StringUtils.equals((CharSequence)delayAudit.getMd5(), (CharSequence)delayAuditMd5)) {
            LOGGER.info("[\u4fee\u6539\u5546\u5ba1\u7b56\u7565]\u5ef6\u65f6\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getDelayAudit()));
            StrategyConfItemEo updateDelayAuditConfEo = new StrategyConfItemEo();
            updateDelayAuditConfEo.setId(delayAudit.getId());
            updateDelayAuditConfEo.setEnable(modifyReqDto.getDelayAudit().getEnable());
            updateDelayAuditConfEo.setContent(StringUtils.isNotBlank((CharSequence)modifyReqDto.getDelayAudit().getContent()) ? modifyReqDto.getDelayAudit().getContent() : " ");
            updateDelayAuditConfEo.setMd5(delayAuditMd5);
            this.strategyConfItemDas.updateSelective((BaseEo)updateDelayAuditConfEo);
        }
        StrategyConfItemEo needPersonAuditByManualOrder = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.MANUAL_ORDER_NEED_PERSON_AUDIT.getCode());
        String needPersonAuditMd5 = MD5Util.getMd5ByString((String)String.valueOf(modifyReqDto.getNeedPersonAuditByManualOrder()));
        if (needPersonAuditByManualOrder != null && !StringUtils.equals((CharSequence)needPersonAuditByManualOrder.getMd5(), (CharSequence)needPersonAuditMd5)) {
            LOGGER.info("[\u4fee\u6539\u5546\u5ba1\u7b56\u7565]\u624b\u5de5\u8ba2\u5355\u505a\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)modifyReqDto.getNeedPersonAuditByManualOrder());
            StrategyConfItemEo needPersonAuditByManualOrderConfEo = new StrategyConfItemEo();
            needPersonAuditByManualOrderConfEo.setId(needPersonAuditByManualOrder.getId());
            needPersonAuditByManualOrderConfEo.setEnable(modifyReqDto.getNeedPersonAuditByManualOrder());
            needPersonAuditByManualOrderConfEo.setMd5(needPersonAuditMd5);
            this.strategyConfItemDas.updateSelective((BaseEo)needPersonAuditByManualOrderConfEo);
        }
        StrategyConfItemEo needPersonAuditByImport = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.IMPORT_ORDER_NEED_PERSON_AUDIT.getCode());
        String needPersonAuditByImportMd5 = MD5Util.getMd5ByString((String)String.valueOf(modifyReqDto.getNeedPersonAuditByImport()));
        if (needPersonAuditByImport != null && !StringUtils.equals((CharSequence)needPersonAuditByImport.getMd5(), (CharSequence)needPersonAuditByImportMd5)) {
            LOGGER.info("[\u4fee\u6539\u5546\u5ba1\u7b56\u7565]\u624b\u5de5\u8ba2\u5355\u505a\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)modifyReqDto.getNeedPersonAuditByImport());
            StrategyConfItemEo needPersonAuditByImportConfEo = new StrategyConfItemEo();
            needPersonAuditByImportConfEo.setId(needPersonAuditByImport.getId());
            needPersonAuditByImportConfEo.setEnable(modifyReqDto.getNeedPersonAuditByImport());
            needPersonAuditByImportConfEo.setMd5(needPersonAuditByImportMd5);
            this.strategyConfItemDas.updateSelective((BaseEo)needPersonAuditByImportConfEo);
        }
        if (Objects.nonNull(modifyReqDto.getSpecialLabel())) {
            String specialLabelMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getSpecialLabel().getMD5Content());
            LOGGER.info("\u3010\u4fee\u6539\u5ba2\u5ba1\u7b56\u7565\u3011\u6307\u5b9a\u6807\u7b7e\u7c7b\u578b\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSpecialLabel()));
            StrategyConfItemEo deleteLabelConfig = new StrategyConfItemEo();
            deleteLabelConfig.setRuleId(modifyReqDto.getId());
            deleteLabelConfig.setStrategyType(CisStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode());
            this.strategyConfItemDas.logicDeleteByExample(deleteLabelConfig);
            StrategyConfItemEo insertLabelConfig = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)insertLabelConfig, (Object)modifyReqDto.getSpecialLabel(), (String[])new String[0]);
            insertLabelConfig.setRuleId(modifyReqDto.getId());
            insertLabelConfig.setEnable(modifyReqDto.getSpecialLabel().getEnable());
            insertLabelConfig.setMd5(specialLabelMd5);
            this.strategyConfItemDas.insert((BaseEo)insertLabelConfig);
            StrategyConfItemSuitEo deleteEo = new StrategyConfItemSuitEo();
            deleteEo.setRuleId(modifyReqDto.getId());
            deleteEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode());
            this.strategyConfItemSuitDas.logicDeleteByExample(deleteEo);
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getSpecialLabel().getLabelCodeList())) {
                ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
                for (String labelCode : modifyReqDto.getSpecialLabel().getLabelCodeList()) {
                    StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
                    confItemSuitEo.setRuleId(modifyReqDto.getId());
                    confItemSuitEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode());
                    confItemSuitEo.setSuitValue(labelCode);
                    confItemSuitEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode() + "_" + labelCode);
                    strategyConfItemSuitEoList.add(confItemSuitEo);
                }
                this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
            }
        }
        StrategyConfItemEo needPersonAuditByModifyItem = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.MODIFY_ITEM_NEED_PERSON_AUDIT.getCode());
        String needPersonAuditByModifyItemMd5 = MD5Util.getMd5ByString((String)String.valueOf(modifyReqDto.getNeedPersonAuditByModifyItem()));
        if (needPersonAuditByModifyItem != null && !StringUtils.equals((CharSequence)needPersonAuditByModifyItem.getMd5(), (CharSequence)needPersonAuditByModifyItemMd5)) {
            LOGGER.info("[\u4fee\u6539\u5546\u5ba1\u7b56\u7565]\u624b\u5de5\u8ba2\u5355\u505a\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)modifyReqDto.getNeedPersonAuditByModifyItem());
            StrategyConfItemEo needPersonAuditByModifyItemConfEo = new StrategyConfItemEo();
            needPersonAuditByModifyItemConfEo.setId(needPersonAuditByModifyItem.getId());
            needPersonAuditByModifyItemConfEo.setEnable(modifyReqDto.getNeedPersonAuditByModifyItem());
            needPersonAuditByModifyItemConfEo.setMd5(needPersonAuditByModifyItemMd5);
            this.strategyConfItemDas.updateSelective((BaseEo)needPersonAuditByModifyItemConfEo);
        }
        StrategyConfItemEo needPersonAuditByModifyAddr = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.MODIFY_ADDR_NEED_PERSON_AUDIT.getCode());
        String needPersonAuditByModifyAddrMd5 = MD5Util.getMd5ByString((String)String.valueOf(modifyReqDto.getNeedPersonAuditByModifyAddr()));
        if (needPersonAuditByModifyAddr != null && !StringUtils.equals((CharSequence)needPersonAuditByModifyAddr.getMd5(), (CharSequence)needPersonAuditByModifyAddrMd5)) {
            LOGGER.info("[\u4fee\u6539\u5546\u5ba1\u7b56\u7565]\u4fee\u6539\u5730\u5740\u505a\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)modifyReqDto.getNeedPersonAuditByModifyAddr());
            StrategyConfItemEo needPersonAuditByModifyAddrConfEo = new StrategyConfItemEo();
            needPersonAuditByModifyAddrConfEo.setId(needPersonAuditByModifyAddr.getId());
            needPersonAuditByModifyAddrConfEo.setEnable(modifyReqDto.getNeedPersonAuditByModifyAddr());
            needPersonAuditByModifyAddrConfEo.setMd5(needPersonAuditByModifyAddrMd5);
            this.strategyConfItemDas.updateSelective((BaseEo)needPersonAuditByModifyAddrConfEo);
        }
        StrategyConfItemEo needPersonAuditByModifyShipment = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.MODIFY_SHIPMENT_NEED_PERSON_AUDIT.getCode());
        String needPersonAuditByModifyShipmentMd5 = MD5Util.getMd5ByString((String)String.valueOf(modifyReqDto.getNeedPersonAuditByModifyShipment()));
        if (needPersonAuditByModifyShipment != null && !StringUtils.equals((CharSequence)needPersonAuditByModifyShipment.getMd5(), (CharSequence)needPersonAuditByModifyShipmentMd5)) {
            LOGGER.info("[\u4fee\u6539\u5546\u5ba1\u7b56\u7565]\u4fee\u6539\u5730\u5740\u505a\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)modifyReqDto.getNeedPersonAuditByModifyShipment());
            StrategyConfItemEo needPersonAuditByModifyShipmentConfEo = new StrategyConfItemEo();
            needPersonAuditByModifyShipmentConfEo.setId(needPersonAuditByModifyShipment.getId());
            needPersonAuditByModifyShipmentConfEo.setEnable(modifyReqDto.getNeedPersonAuditByModifyShipment());
            needPersonAuditByModifyShipmentConfEo.setMd5(needPersonAuditByModifyShipmentMd5);
            this.strategyConfItemDas.updateSelective((BaseEo)needPersonAuditByModifyShipmentConfEo);
        }
        String specialAmountMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getSpecialAmount().getMD5Content());
        StrategyConfItemEo specialAmount = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.SPECIAL_AMOUNT.getCode());
        if (specialAmount != null && !StringUtils.equals((CharSequence)specialAmount.getMd5(), (CharSequence)specialAmountMd5)) {
            LOGGER.info("[\u4fee\u6539\u5546\u5ba1\u7b56\u7565]\u6307\u5b9a\u91d1\u989d\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSpecialAmount()));
            StrategyConfItemEo updateSpecialAmountConfEo = new StrategyConfItemEo();
            updateSpecialAmountConfEo.setId(specialAmount.getId());
            updateSpecialAmountConfEo.setEnable(modifyReqDto.getSpecialAmount().getEnable());
            updateSpecialAmountConfEo.setContent(modifyReqDto.getSpecialAmount().getContent());
            updateSpecialAmountConfEo.setMd5(specialAmountMd5);
            this.strategyConfItemDas.updateSelective((BaseEo)updateSpecialAmountConfEo);
        }
        String specialOrderTypeMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getSpecialOrderType().getMD5Content());
        StrategyConfItemEo specialOrderType = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode());
        if (specialOrderType != null && !StringUtils.equals((CharSequence)specialOrderType.getMd5(), (CharSequence)specialOrderTypeMd5)) {
            LOGGER.info("\u3010\u4fee\u6539\u5546\u5ba1\u7b56\u7565\u3011\u6307\u5b9a\u8ba2\u5355\u7c7b\u578b\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSpecialOrderType()));
            StrategyConfItemEo updateSpecialSkuConfEo = new StrategyConfItemEo();
            updateSpecialSkuConfEo.setId(specialOrderType.getId());
            updateSpecialSkuConfEo.setEnable(modifyReqDto.getSpecialOrderType().getEnable());
            updateSpecialSkuConfEo.setMd5(specialOrderTypeMd5);
            this.strategyConfItemDas.updateSelective((BaseEo)updateSpecialSkuConfEo);
            StrategyConfItemSuitEo deleteEo = new StrategyConfItemSuitEo();
            deleteEo.setRuleId(modifyReqDto.getId());
            deleteEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode());
            this.strategyConfItemSuitDas.logicDeleteByExample(deleteEo);
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getSpecialOrderType().getOrderTypeCodeList())) {
                ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
                for (String orderTypeCode : modifyReqDto.getSpecialOrderType().getOrderTypeCodeList()) {
                    StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
                    confItemSuitEo.setRuleId(modifyReqDto.getId());
                    confItemSuitEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode());
                    confItemSuitEo.setSuitValue(orderTypeCode);
                    confItemSuitEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode() + "_" + orderTypeCode);
                    strategyConfItemSuitEoList.add(confItemSuitEo);
                }
                this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
            }
        }
        if (Objects.nonNull(modifyReqDto.getSpecialArea())) {
            String specialAreaMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getSpecialArea().getMD5Content());
            StrategyConfItemEo specialArea = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.SPECIAL_AREA.getCode());
            if (specialArea != null && !StringUtils.equals((CharSequence)specialArea.getMd5(), (CharSequence)specialAreaMd5)) {
                LOGGER.info("\u3010\u4fee\u6539\u5ba2\u5ba1\u7b56\u7565\u3011\u6307\u5b9a\u533a\u57df\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSpecialArea()));
                StrategyConfItemEo updateSpecialAreaConfEo = new StrategyConfItemEo();
                updateSpecialAreaConfEo.setId(specialArea.getId());
                updateSpecialAreaConfEo.setEnable(modifyReqDto.getSpecialArea().getEnable());
                updateSpecialAreaConfEo.setMd5(specialAreaMd5);
                this.strategyConfItemDas.updateSelective((BaseEo)updateSpecialAreaConfEo);
                StrategyConfItemSuitEo deleteEo = new StrategyConfItemSuitEo();
                deleteEo.setRuleId(modifyReqDto.getId());
                deleteEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_AREA.getCode());
                this.strategyConfItemSuitDas.logicDeleteByExample(deleteEo);
                if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getSpecialArea().getAreaCodeList())) {
                    ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
                    for (String areaCode : modifyReqDto.getSpecialArea().getAreaCodeList()) {
                        StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
                        confItemSuitEo.setRuleId(modifyReqDto.getId());
                        confItemSuitEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_AREA.getCode());
                        confItemSuitEo.setSuitValue(areaCode);
                        confItemSuitEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_AREA.getCode() + "_" + areaCode);
                        strategyConfItemSuitEoList.add(confItemSuitEo);
                    }
                    this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
                }
            }
        }
        String buyerRemarkMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getBuyerRemark().getMD5Content());
        StrategyConfItemEo buyerRemark = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.BUYER_REMARK.getCode());
        if (buyerRemark != null && !StringUtils.equals((CharSequence)buyerRemark.getMd5(), (CharSequence)buyerRemarkMd5)) {
            LOGGER.info("[\u4fee\u6539\u5546\u5ba1\u7b56\u7565]\u4e70\u5bb6\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getBuyerRemark()));
            StrategyConfItemEo updateBuyerRemarkConfEo = new StrategyConfItemEo();
            updateBuyerRemarkConfEo.setId(buyerRemark.getId());
            updateBuyerRemarkConfEo.setEnable(modifyReqDto.getBuyerRemark().getEnable());
            updateBuyerRemarkConfEo.setContent(modifyReqDto.getBuyerRemark().getContent());
            updateBuyerRemarkConfEo.setMd5(buyerRemarkMd5);
            this.strategyConfItemDas.updateSelective((BaseEo)updateBuyerRemarkConfEo);
        }
        String sellerRemarkMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getSellerRemark().getMD5Content());
        StrategyConfItemEo sellerRemark = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.SELLER_REMARK.getCode());
        if (sellerRemark != null && !StringUtils.equals((CharSequence)sellerRemark.getMd5(), (CharSequence)sellerRemarkMd5)) {
            LOGGER.info("[\u4fee\u6539\u5546\u5ba1\u7b56\u7565]\u5356\u5bb6\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSellerRemark()));
            StrategyConfItemEo updateSellerRemarkConfEo = new StrategyConfItemEo();
            updateSellerRemarkConfEo.setId(sellerRemark.getId());
            updateSellerRemarkConfEo.setEnable(modifyReqDto.getSellerRemark().getEnable());
            updateSellerRemarkConfEo.setContent(modifyReqDto.getSellerRemark().getContent());
            updateSellerRemarkConfEo.setMd5(sellerRemarkMd5);
            this.strategyConfItemDas.updateSelective((BaseEo)updateSellerRemarkConfEo);
        }
        String internalRemarkMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getInternalRemark().getMD5Content());
        StrategyConfItemEo internalRemark = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.INTERNAL_REMARK.getCode());
        if (internalRemark != null && !StringUtils.equals((CharSequence)internalRemark.getMd5(), (CharSequence)internalRemarkMd5)) {
            LOGGER.info("[\u4fee\u6539\u5546\u5ba1\u7b56\u7565]\u5185\u90e8\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getInternalRemark()));
            StrategyConfItemEo updateInternalRemarkConfEo = new StrategyConfItemEo();
            updateInternalRemarkConfEo.setId(internalRemark.getId());
            updateInternalRemarkConfEo.setEnable(modifyReqDto.getInternalRemark().getEnable());
            updateInternalRemarkConfEo.setContent(modifyReqDto.getInternalRemark().getContent());
            updateInternalRemarkConfEo.setMd5(internalRemarkMd5);
            this.strategyConfItemDas.updateSelective((BaseEo)updateInternalRemarkConfEo);
        }
        String specialPayTimeMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getSpecialPayTime().getMD5Content());
        StrategyConfItemEo specialPayTime = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.SPECIAL_PAYTIME.getCode());
        if (specialPayTime != null && !StringUtils.equals((CharSequence)specialPayTime.getMd5(), (CharSequence)specialPayTimeMd5)) {
            LOGGER.info("[\u4fee\u6539\u5546\u5ba1\u7b56\u7565]\u5356\u5bb6\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSpecialPayTime()));
            StrategyConfItemEo updateInternalRemarkConfEo = new StrategyConfItemEo();
            updateInternalRemarkConfEo.setId(specialPayTime.getId());
            updateInternalRemarkConfEo.setEnable(modifyReqDto.getSpecialPayTime().getEnable());
            updateInternalRemarkConfEo.setContent(modifyReqDto.getSpecialPayTime().getContent());
            updateInternalRemarkConfEo.setMd5(specialPayTimeMd5);
            this.strategyConfItemDas.updateSelective((BaseEo)updateInternalRemarkConfEo);
        }
    }

    @Override
    public DgBusinessAuditStrategyRuleRespDto queryBusinessAuditStrategyById(Long id) {
        List applyBizTypeSuitEos;
        LambdaQueryWrapper queryStrategyRuleEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryStrategyRuleEo.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)id)).eq(DgStrategyRuleEo::getStrategyType, (Object)BUSINESS);
        DgStrategyRuleEo dgStrategyRuleEo = this.strategyRuleDas.getOne(queryStrategyRuleEo);
        AssertUtils.notNull((Object)dgStrategyRuleEo, (String)"\u5ba2\u5ba1\u7b56\u7565\u4e0d\u5b58\u5728");
        DgBusinessAuditStrategyRuleRespDto strategyRuleRespDto = new DgBusinessAuditStrategyRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)dgStrategyRuleEo, (BaseVo)strategyRuleRespDto);
        this.getStrategyConfItems(id, strategyRuleRespDto);
        LambdaQueryWrapper queryStrategyRuleSuitEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyRuleSuitEo.eq(BaseEo::getDr, (Object)0)).eq(DgStrategyRuleSuitEo::getRuleId, (Object)id);
        List strategyRuleSuitList = this.strategyRuleSuitDas.list(queryStrategyRuleSuitEo);
        List applyShopSuitEos = Optional.ofNullable(strategyRuleSuitList).orElseGet(Collections::emptyList).stream().filter(strategyRuleSuitEo -> StringUtils.equals((CharSequence)strategyRuleSuitEo.getSuitType(), (CharSequence)SUITTYPE_SHOP)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(applyShopSuitEos)) {
            DgBusinessAuditStrategyRuleRespDto.ApplyShop applyShop = new DgBusinessAuditStrategyRuleRespDto.ApplyShop();
            DgStrategyRuleSuitEo dgStrategyRuleSuitEo = (DgStrategyRuleSuitEo)applyShopSuitEos.get(0);
            applyShop.setApplicableType(dgStrategyRuleSuitEo.getSuitSelectType());
            if (StringUtils.equals((CharSequence)dgStrategyRuleSuitEo.getSuitSelectType(), (CharSequence)SELECT)) {
                List shopCodeList = applyShopSuitEos.stream().map(DgStrategyRuleSuitEo::getSuitKey).collect(Collectors.toList());
                applyShop.setApplicableList(shopCodeList);
            }
            strategyRuleRespDto.setApplyShop(applyShop);
        }
        if (CollectionUtils.isNotEmpty(applyBizTypeSuitEos = Optional.ofNullable(strategyRuleSuitList).orElseGet(Collections::emptyList).stream().filter(strategyRuleSuitEo -> StringUtils.equals((CharSequence)strategyRuleSuitEo.getSuitType(), (CharSequence)SUITTYPE_BIZ_TYPE)).collect(Collectors.toList()))) {
            DgBusinessAuditStrategyRuleRespDto.ApplyBizType applyBizType = new DgBusinessAuditStrategyRuleRespDto.ApplyBizType();
            DgStrategyRuleSuitEo dgStrategyRuleSuitEo = (DgStrategyRuleSuitEo)applyBizTypeSuitEos.get(0);
            applyBizType.setApplicableType(dgStrategyRuleSuitEo.getSuitSelectType());
            if (StringUtils.equals((CharSequence)dgStrategyRuleSuitEo.getSuitSelectType(), (CharSequence)SELECT)) {
                List shopCodeList = applyBizTypeSuitEos.stream().map(DgStrategyRuleSuitEo::getSuitKey).collect(Collectors.toList());
                applyBizType.setApplicableList(shopCodeList);
            }
            strategyRuleRespDto.setApplyBizType(applyBizType);
        }
        return strategyRuleRespDto;
    }

    private void getStrategyConfItems(Long id, DgBusinessAuditStrategyRuleRespDto strategyRuleRespDto) {
        LambdaQueryWrapper queryStrategyConfItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getRuleId, (Object)id);
        List strategyConfItemEoList = this.strategyConfItemDas.list(queryStrategyConfItemEo);
        AssertUtils.notEmpty((Collection)strategyConfItemEoList, (String)"\u7b56\u7565\u914d\u7f6e\u9879\u4e3a\u7a7a");
        LambdaQueryWrapper queryStrategyConfItemSuitEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemSuitEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemSuitEo::getRuleId, (Object)id);
        List strategyConfItemSuitEoList = this.strategyConfItemSuitDas.list(queryStrategyConfItemSuitEo);
        Map<String, List<StrategyConfItemSuitEo>> strategyConfItemSuitMap = Optional.ofNullable(strategyConfItemSuitEoList).orElseGet(Collections::emptyList).stream().collect(Collectors.groupingBy(StrategyConfItemSuitEo::getSuitType));
        strategyConfItemEoList.forEach(strategyConfItemEo -> {
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.MANUAL_ORDER_NEED_PERSON_AUDIT.getCode())) {
                strategyRuleRespDto.setNeedPersonAuditByManualOrder(strategyConfItemEo.getEnable());
            } else if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.DELAY_AUDIT.getCode())) {
                DgBusinessAuditStrategyRuleRespDto.DelayAudit delayAudit = new DgBusinessAuditStrategyRuleRespDto.DelayAudit();
                CubeBeanUtils.copyProperties((Object)delayAudit, (Object)strategyConfItemEo, (String[])new String[0]);
                delayAudit.setValue(Integer.valueOf(Optional.ofNullable(strategyConfItemEo.getContent()).orElse("0")));
                delayAudit.setContent(strategyConfItemEo.getContent());
                strategyRuleRespDto.setDelayAudit(delayAudit);
            } else if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode())) {
                DgBusinessAuditStrategyRuleRespDto.SpecialOrderType specialOrderType = new DgBusinessAuditStrategyRuleRespDto.SpecialOrderType();
                specialOrderType.setEnable(strategyConfItemEo.getEnable());
                List orderTypeCodeList = Optional.ofNullable(strategyConfItemSuitMap.get(CisStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialOrderType.setOrderTypeCodeList(orderTypeCodeList);
                strategyRuleRespDto.setSpecialOrderType(specialOrderType);
            } else if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.IMPORT_ORDER_NEED_PERSON_AUDIT.getCode())) {
                strategyRuleRespDto.setNeedPersonAuditByImport(strategyConfItemEo.getEnable());
            } else if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.MODIFY_ITEM_NEED_PERSON_AUDIT.getCode())) {
                strategyRuleRespDto.setNeedPersonAuditByModifyItem(strategyConfItemEo.getEnable());
            } else if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.MODIFY_ADDR_NEED_PERSON_AUDIT.getCode())) {
                strategyRuleRespDto.setNeedPersonAuditByModifyAddr(strategyConfItemEo.getEnable());
            } else if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.MODIFY_SHIPMENT_NEED_PERSON_AUDIT.getCode())) {
                strategyRuleRespDto.setNeedPersonAuditByModifyShipment(strategyConfItemEo.getEnable());
            } else if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.SPECIAL_AMOUNT.getCode())) {
                DgBusinessAuditStrategyRuleRespDto.SpecialAmount specialAmount = new DgBusinessAuditStrategyRuleRespDto.SpecialAmount();
                CubeBeanUtils.copyProperties((Object)specialAmount, (Object)strategyConfItemEo, (String[])new String[0]);
                Optional.ofNullable(strategyConfItemEo.getContent()).ifPresent(content -> {
                    Map map = (Map)JSON.parseObject((String)content, Map.class);
                    if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)map, (Object)"minAmount"))) {
                        specialAmount.setMinAmount(new BigDecimal(MapUtils.getString((Map)map, (Object)"minAmount")));
                    }
                    if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)map, (Object)"maxAmount"))) {
                        specialAmount.setMaxAmount(new BigDecimal(MapUtils.getString((Map)map, (Object)"maxAmount")));
                    }
                });
                strategyRuleRespDto.setSpecialAmount(specialAmount);
            } else if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.SPECIAL_AREA.getCode())) {
                DgBusinessAuditStrategyRuleRespDto.SpecialArea specialArea = new DgBusinessAuditStrategyRuleRespDto.SpecialArea();
                specialArea.setEnable(strategyConfItemEo.getEnable());
                List areaCodeList = Optional.ofNullable(strategyConfItemSuitMap.get(CisStrategyConfItemTypeEnum.SPECIAL_AREA.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialArea.setAreaCodeList(areaCodeList);
                strategyRuleRespDto.setSpecialArea(specialArea);
            } else if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.BUYER_REMARK.getCode())) {
                DgBusinessAuditStrategyRuleRespDto.BuyerRemark buyerRemark = new DgBusinessAuditStrategyRuleRespDto.BuyerRemark();
                CubeBeanUtils.copyProperties((Object)buyerRemark, (Object)strategyConfItemEo, (String[])new String[0]);
                String content2 = strategyConfItemEo.getContent();
                Map map = (Map)JSON.parseObject((String)content2, Map.class);
                buyerRemark.setRemarkType(MapUtils.getString((Map)map, (Object)"remarkType", (String)"0"));
                buyerRemark.setKeyWords(MapUtils.getString((Map)map, (Object)"keyWords"));
                strategyRuleRespDto.setBuyerRemark(buyerRemark);
            } else if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.SELLER_REMARK.getCode())) {
                DgBusinessAuditStrategyRuleRespDto.SellerRemark sellerRemark = new DgBusinessAuditStrategyRuleRespDto.SellerRemark();
                CubeBeanUtils.copyProperties((Object)sellerRemark, (Object)strategyConfItemEo, (String[])new String[0]);
                String content3 = strategyConfItemEo.getContent();
                Map map = (Map)JSON.parseObject((String)content3, Map.class);
                sellerRemark.setRemarkType(MapUtils.getString((Map)map, (Object)"remarkType", (String)"0"));
                sellerRemark.setKeyWords(MapUtils.getString((Map)map, (Object)"keyWords"));
                strategyRuleRespDto.setSellerRemark(sellerRemark);
            } else if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode())) {
                DgBusinessAuditStrategyRuleRespDto.SpecialLabel specialLabel = new DgBusinessAuditStrategyRuleRespDto.SpecialLabel();
                specialLabel.setEnable(strategyConfItemEo.getEnable());
                List specialLabelCodeList = Optional.ofNullable(strategyConfItemSuitMap.get(CisStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialLabel.setLabelCodeList(specialLabelCodeList);
                strategyRuleRespDto.setSpecialLabel(specialLabel);
            } else if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.INTERNAL_REMARK.getCode())) {
                DgBusinessAuditStrategyRuleRespDto.InternalRemark internalRemark = new DgBusinessAuditStrategyRuleRespDto.InternalRemark();
                CubeBeanUtils.copyProperties((Object)internalRemark, (Object)strategyConfItemEo, (String[])new String[0]);
                String content4 = strategyConfItemEo.getContent();
                Map map = (Map)JSON.parseObject((String)content4, Map.class);
                internalRemark.setRemarkType(MapUtils.getString((Map)map, (Object)"remarkType", (String)"0"));
                internalRemark.setKeyWords(MapUtils.getString((Map)map, (Object)"keyWords"));
                strategyRuleRespDto.setInternalRemark(internalRemark);
            } else if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.SPECIAL_PAYTIME.getCode())) {
                DgBusinessAuditStrategyRuleRespDto.SpecialPayTime specialPayTime = new DgBusinessAuditStrategyRuleRespDto.SpecialPayTime();
                specialPayTime.setEnable(strategyConfItemEo.getEnable());
                Optional.ofNullable(strategyConfItemEo.getContent()).ifPresent(content -> {
                    Map map = (Map)JSON.parseObject((String)content, Map.class);
                    if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)map, (Object)"startTime"))) {
                        specialPayTime.setStartTime(DateUtil.parse((String)MapUtils.getString((Map)map, (Object)"startTime"), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)map, (Object)"endTime"))) {
                        specialPayTime.setEndTime(DateUtil.parse((String)MapUtils.getString((Map)map, (Object)"endTime"), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                });
                strategyRuleRespDto.setSpecialPayTime(specialPayTime);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DgStrategyRuleServiceImpl.MatchStrategyResult matchOrderStrtegyOfBusiness(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto performOrderRespDto = this.performOrderExtDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)performOrderRespDto, (String)String.format("orderNo=%s\u7684\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728", orderId));
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\uff08orderId={}\uff09\u8ba2\u5355\u7684\u8be6\u60c5\u4e3a\uff1a{}", (Object)orderId, (Object)JSON.toJSONString((Object)performOrderRespDto));
        try {
            DgStrategyRuleServiceImpl.MatchStrategyResult matchStrategyResult = new DgStrategyRuleServiceImpl.MatchStrategyResult();
            DgStrategyRuleEo dgStrategyRuleEo = this.queryValidRule(performOrderRespDto, DgCisStrategyOrderTypeEnum.BUSINESS.getCode());
            if (dgStrategyRuleEo == null) {
                matchStrategyResult.setMatchStrategy(false);
                LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\uff08orderId={}\uff09\u8ba2\u5355\u6ca1\u6709\u5339\u914d\u4e0a\u7b56\u7565", (Object)orderId);
                DgStrategyRuleServiceImpl.MatchStrategyResult matchStrategyResult2 = matchStrategyResult;
                return matchStrategyResult2;
            }
            List<StrategyConfItemEo> strategyConfItemEoList = this.queryValidRuleConfItemList(dgStrategyRuleEo);
            Boolean checkResult = this.checkRule(strategyConfItemEoList, performOrderRespDto);
            if (!checkResult.booleanValue()) {
                this.saveHitConfItem();
                matchStrategyResult.setIntercepted(true);
                DgStrategyRuleServiceImpl.MatchStrategyResult matchStrategyResult3 = matchStrategyResult;
                return matchStrategyResult3;
            }
            Map strategyConfItemEoMap = strategyConfItemEoList.stream().collect(Collectors.toMap(StrategyConfItemEo::getStrategyType, Function.identity(), (v1, v2) -> v2));
            StrategyConfItemEo strategyConfItemEo = (StrategyConfItemEo)strategyConfItemEoMap.get(CisStrategyConfItemTypeEnum.DELAY_AUDIT.getCode());
            Date csAuditTime = this.getCsAuditTime(performOrderRespDto);
            if (strategyConfItemEo != null) {
                LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u5ef6\u8fdf\u5ba1\u6838\u65f6\u95f4\u4e3a\uff1a{}", (Object)strategyConfItemEo.getContent());
                this.handleDelayAuditByConf(strategyConfItemEo, performOrderRespDto, csAuditTime, DgCisStrategyOrderTypeEnum.BUSINESS);
            } else {
                LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u53f7={}\uff0c\u5ef6\u8fdf\u5ba1\u6838\u65f6\u95f4\u672a\u5339\u914d\u5230", (Object)performOrderRespDto.getSaleOrderNo());
                strategyConfItemEo = new StrategyConfItemEo();
                strategyConfItemEo.setRuleId(dgStrategyRuleEo.getId());
                strategyConfItemEo.setContent("0");
                this.handleDelayAuditByConf(strategyConfItemEo, performOrderRespDto, csAuditTime, DgCisStrategyOrderTypeEnum.BUSINESS);
            }
            DgStrategyRuleServiceImpl.MatchStrategyResult matchStrategyResult4 = matchStrategyResult;
            return matchStrategyResult4;
        }
        finally {
            this.cleanHitStrategyOrder();
        }
    }

    private Date getCsAuditTime(DgPerformOrderRespDto saleOrderRespDto) {
        String orderSteps = saleOrderRespDto.getOrderSteps();
        if (StringUtils.isNotBlank((CharSequence)orderSteps)) {
            List orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, DgOrderStatusLogRespDto.class);
            orderStatusLogRespDtos.sort(Comparator.comparing(DgOrderStatusLogRespDto::getOptDate).reversed());
            Map<String, List<DgOrderStatusLogRespDto>> orderStatusHistoryListMap = orderStatusLogRespDtos.stream().collect(Collectors.groupingBy(DgOrderStatusLogRespDto::getOrderStatus));
            List<DgOrderStatusLogRespDto> orderStatusLogRespList = orderStatusHistoryListMap.get(DgOmsSaleOrderStatus.WAIT_BUSINESS_AUDIT.getCode());
            if (CollectionUtils.isNotEmpty(orderStatusLogRespList)) {
                return orderStatusLogRespList.get(0).getOptDate();
            }
            return saleOrderRespDto.getSaleCreateTime();
        }
        return saleOrderRespDto.getSaleCreateTime();
    }

    public String getLatestNo() {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderWrapper.eq(DgStrategyRuleEo::getStrategyType, (Object)BUSINESS)).orderByDesc(BaseEo::getId)).orderByDesc(BaseEo::getCreateTime)).last(" limit 1");
        DgStrategyRuleEo dgStrategyRuleEo = this.strategyRuleDas.getOne(queryOrderWrapper);
        if (dgStrategyRuleEo == null) {
            return "";
        }
        return dgStrategyRuleEo.getRuleCode();
    }
}

