/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.order.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyConfItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyFitStatusEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgStrategyPoolReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgMatchStrategyResultDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyPoolRespDto;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemEo;
import com.yunxi.dg.base.center.trade.service.IDgStrategyPoolService;
import com.yunxi.dg.base.center.trade.service.order.strategy.IDgOrderAutoStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.order.strategy.impl.DgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgOrderAutoStrategyRuleServiceImpl
extends DgStrategyRuleServiceImpl
implements IDgOrderAutoStrategyRuleService {
    private static final Logger log = LoggerFactory.getLogger(DgOrderAutoStrategyRuleServiceImpl.class);
    @Resource
    private IDgPerformOrderExtDomain dgPerformOrderExtDomain;
    @Resource
    private IDgStrategyPoolService dgStrategyPoolService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DgMatchStrategyResultDto matchOrderStrategy(Long orderId, DgCisStrategyOrderTypeEnum dgCisStrategyOrderTypeEnum) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto performOrderRespDto = this.dgPerformOrderExtDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)performOrderRespDto, (String)String.format("orderNo=%s\u7684\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728", orderId));
        log.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\uff08orderId={}\uff09\u8ba2\u5355\u7684\u8be6\u60c5\u4e3a\uff1a{}", (Object)orderId, (Object)JSON.toJSONString((Object)performOrderRespDto));
        try {
            DgMatchStrategyResultDto matchStrategyResult = new DgMatchStrategyResultDto();
            DgStrategyRuleEo dgStrategyRuleEo = this.queryValidRule(performOrderRespDto, dgCisStrategyOrderTypeEnum.getCode());
            if (dgStrategyRuleEo == null) {
                matchStrategyResult.setMatchStrategy(Boolean.valueOf(false));
                log.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\uff08orderId={}\uff09\u8ba2\u5355\u6ca1\u6709\u5339\u914d\u4e0a\u7b56\u7565", (Object)orderId);
                DgMatchStrategyResultDto dgMatchStrategyResultDto = matchStrategyResult;
                return dgMatchStrategyResultDto;
            }
            List<StrategyConfItemEo> strategyConfItemEoList = this.queryValidRuleConfItemList(dgStrategyRuleEo);
            Boolean checkResult = this.checkRule(strategyConfItemEoList, performOrderRespDto);
            if (Boolean.FALSE.equals(checkResult)) {
                this.saveHitConfItem();
                matchStrategyResult.setIntercepted(Boolean.valueOf(true));
                DgMatchStrategyResultDto dgMatchStrategyResultDto = matchStrategyResult;
                return dgMatchStrategyResultDto;
            }
            Map strategyConfItemEoMap = strategyConfItemEoList.stream().collect(Collectors.toMap(StrategyConfItemEo::getStrategyType, Function.identity(), (v1, v2) -> v2));
            StrategyConfItemEo strategyConfItemEo = (StrategyConfItemEo)strategyConfItemEoMap.get(CisStrategyConfItemTypeEnum.DELAY_AUDIT.getCode());
            if (strategyConfItemEo != null) {
                log.info("\u3010\u81ea\u52a8\u7b56\u7565\u3011\u8ba2\u5355\u53f7={}\uff0c\u5ef6\u8fdf\u5ba1\u6838\u65f6\u95f4\u4e3a\uff1a{}", (Object)performOrderRespDto.getSaleOrderNo(), (Object)strategyConfItemEo.getContent());
                this.handleDelayAuditByConf(strategyConfItemEo, performOrderRespDto, performOrderRespDto.getSaleCreateTime(), dgCisStrategyOrderTypeEnum);
            } else {
                log.info("\u3010\u81ea\u52a8\u7b56\u7565\u3011\u8ba2\u5355\u53f7={}\uff0c\u5ef6\u8fdf\u5ba1\u6838\u65f6\u95f4\u672a\u5339\u914d\u5230", (Object)performOrderRespDto.getSaleOrderNo());
                strategyConfItemEo = new StrategyConfItemEo();
                strategyConfItemEo.setRuleId(dgStrategyRuleEo.getId());
                strategyConfItemEo.setContent("0");
                this.handleDelayAuditByConf(strategyConfItemEo, performOrderRespDto, performOrderRespDto.getSaleCreateTime(), dgCisStrategyOrderTypeEnum);
            }
            DgMatchStrategyResultDto dgMatchStrategyResultDto = matchStrategyResult;
            return dgMatchStrategyResultDto;
        }
        finally {
            this.cleanHitStrategyOrder();
        }
    }

    @Override
    public boolean modifyAndRemoveStrategyPool(DgStrategyPoolRespDto dgStrategyPoolRespDto) {
        DgStrategyPoolReqDto strategyPoolReqDto = new DgStrategyPoolReqDto();
        strategyPoolReqDto.setId(dgStrategyPoolRespDto.getId());
        strategyPoolReqDto.setFitStatus(CisStrategyFitStatusEnum.FITED.getCode());
        this.dgStrategyPoolService.modifyStrategyPool(strategyPoolReqDto);
        this.dgStrategyPoolService.removeStrategyPool(Arrays.asList(dgStrategyPoolRespDto.getId()));
        return true;
    }
}

