/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.yunxi.dg.base.center.trade.cache.CacheWrapper;
import com.yunxi.dg.base.center.trade.domain.order.event.SaleOrderInfoUpdateEvent;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.service.tc.impl.SaleOrderServiceImpl;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractSaleOrderService {
    public static final String EMPTY = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(SaleOrderServiceImpl.class);
    @Autowired
    private ApplicationEventPublisher publisher;

    protected abstract IBaseDomain<DgSaleOrderEo> baseDas();

    protected abstract CacheWrapper cacheWrapper();

    public SaleOrderRespDto querySaleOrderByNo(String orderNo) {
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoByNo(orderNo);
        SaleOrderRespDto saleOrderRespDto = new SaleOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)saleOrderEo, (BaseVo)saleOrderRespDto);
        return saleOrderRespDto;
    }

    public DgSaleOrderEo queryDgSaleOrderEoByNo(String orderNo) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notBlank((String)orderNo, (String)"orderNo \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo saleOrderEo = null;
        if (this.cacheWrapper() != null) {
            saleOrderEo = (DgSaleOrderEo)this.cacheWrapper().queryCache((Object)orderNo, DgSaleOrderEo.class, () -> {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getSaleOrderNo, (Object)orderNo);
                DgSaleOrderEo saleOrder = (DgSaleOrderEo)this.baseDas().getMapper().selectOne((Wrapper)queryWrapper);
                return saleOrder;
            }, new SFunction[]{BaseEo::getId, DgSaleOrderEo::getSaleOrderNo});
        } else {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getSaleOrderNo, (Object)orderNo);
            saleOrderEo = (DgSaleOrderEo)this.baseDas().getMapper().selectOne((Wrapper)queryWrapper);
        }
        AssertUtils.notNull((Object)saleOrderEo, (String)"%s \u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[]{orderNo});
        return saleOrderEo;
    }

    public SaleOrderRespDto querySaleOrderById(Long orderId) {
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoById(orderId);
        SaleOrderRespDto saleOrderRespDto = new SaleOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)saleOrderEo, (BaseVo)saleOrderRespDto);
        return saleOrderRespDto;
    }

    public DgSaleOrderEo queryDgSaleOrderEoById(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgSaleOrderEo saleOrderEo = null;
        saleOrderEo = this.cacheWrapper() != null ? (DgSaleOrderEo)this.cacheWrapper().queryCache((Object)orderId, DgSaleOrderEo.class, () -> {
            DgSaleOrderEo saleOrder = (DgSaleOrderEo)this.baseDas().selectByPrimaryKey(orderId);
            return saleOrder;
        }, new SFunction[]{BaseEo::getId, DgSaleOrderEo::getSaleOrderNo}) : (DgSaleOrderEo)this.baseDas().selectByPrimaryKey(orderId);
        AssertUtils.notNull((Object)saleOrderEo, (String)"%s \u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[]{orderId});
        return saleOrderEo;
    }

    public DgSaleOrderEo queryDgSaleOrderEoId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgSaleOrderEo saleOrderEo = new DgSaleOrderEo();
        saleOrderEo.setId(orderId);
        DgSaleOrderEo dgSaleOrderEo = (DgSaleOrderEo)this.baseDas().selectOne((BaseEo)saleOrderEo);
        AssertUtils.notNull((Object)dgSaleOrderEo, (String)"%s \u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[]{orderId});
        return dgSaleOrderEo;
    }

    public int updateSaleOrderById(Long orderId, DgSaleOrderEo updateEo) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.cacheWrapper() != null) {
            this.cacheWrapper().removeCache((Object)orderId);
        }
        updateEo.setId(orderId);
        int updateSelective = this.baseDas().updateSelective((BaseEo)updateEo);
        if (this.cacheWrapper() != null) {
            this.cacheWrapper().removeCache((Object)orderId);
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.publisher.publishEvent((Object)new SaleOrderInfoUpdateEvent(orderId));
        }
        return updateSelective;
    }

    public void removeCache(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.cacheWrapper() != null) {
            this.cacheWrapper().removeCache((Object)orderId);
        }
    }

    public int updateSelectiveSqlFilterById(Long orderId, DgSaleOrderEo updateEo) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.cacheWrapper() != null) {
            this.cacheWrapper().removeCache((Object)orderId);
        }
        updateEo.setId(orderId);
        int updateSelectiveSqlFilter = this.baseDas().updateSelectiveSqlFilter((BaseEo)updateEo);
        if (this.cacheWrapper() != null) {
            this.cacheWrapper().removeCache((Object)orderId);
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.publisher.publishEvent((Object)new SaleOrderInfoUpdateEvent(orderId));
        }
        return updateSelectiveSqlFilter;
    }

    public void cleanLogicalWarehouseInfo(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setId(orderId);
        updateEo.setLogicalWarehouseId(null);
        updateEo.setLogicalWarehouseCode(EMPTY);
        updateEo.setLogicalWarehouseName(EMPTY);
        updateEo.setPhysicsWarehouseId(null);
        updateEo.setPhysicsWarehouseCode(EMPTY);
        updateEo.setPhysicsWarehouseName(EMPTY);
        this.baseDas().updateSelective((BaseEo)updateEo);
        if (this.cacheWrapper() != null) {
            this.cacheWrapper().removeCache((Object)orderId);
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.publisher.publishEvent((Object)new SaleOrderInfoUpdateEvent(orderId));
        }
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMPLETION, classes={SaleOrderInfoUpdateEvent.class})
    public void handleAfterCompletionEvent(SaleOrderInfoUpdateEvent saleOrderInfoUpdateEvent) {
        try {
            LOGGER.debug("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u7ed3\u675f\u540e\u4e8b\u4ef6\u3011saleOrderInfoUpdateEvent\uff0cid={}", (Object)saleOrderInfoUpdateEvent.getSaleOrderId());
            if (this.cacheWrapper() != null) {
                this.cacheWrapper().removeCache((Object)saleOrderInfoUpdateEvent.getSaleOrderId());
                LOGGER.debug("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u7ed3\u675f\u540e\u4e8b\u4ef6\u3011\u79fb\u9664\u6210\u529f");
            } else {
                LOGGER.debug("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u7ed3\u675f\u540e\u4e8b\u4ef6\u3011\u65e0\u9700\u79fb\u9664");
            }
        }
        catch (Exception var3) {
            LOGGER.error("{},{}", (Object)var3.getMessage(), (Object)var3);
        }
        finally {
            LOGGER.info("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u7ed3\u675f\u540e\u4e8b\u4ef6\u3011saleOrderInfoUpdateEvent\u5220\u9664\u7ed3\u675f\uff0cid={}", (Object)saleOrderInfoUpdateEvent.getSaleOrderId());
        }
    }

    @TransactionalEventListener(phase=TransactionPhase.BEFORE_COMMIT, classes={SaleOrderInfoUpdateEvent.class})
    public void handleBeforeCommitEvent(SaleOrderInfoUpdateEvent saleOrderInfoUpdateEvent) {
        try {
            LOGGER.debug("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u63d0\u4ea4\u524d\u4e8b\u4ef6\u3011saleOrderInfoUpdateEvent\uff0cid={}", (Object)saleOrderInfoUpdateEvent.getSaleOrderId());
            if (this.cacheWrapper() != null) {
                this.cacheWrapper().removeCache((Object)saleOrderInfoUpdateEvent.getSaleOrderId());
                LOGGER.debug("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u63d0\u4ea4\u524d\u4e8b\u4ef6\u3011\u79fb\u9664\u6210\u529f");
            } else {
                LOGGER.info("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u63d0\u4ea4\u524d\u4e8b\u4ef6\u3011\u65e0\u9700\u79fb\u9664");
            }
        }
        catch (Exception var3) {
            LOGGER.error("{},{}", (Object)var3.getMessage(), (Object)var3);
        }
        finally {
            LOGGER.info("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u63d0\u4ea4\u524d\u4e8b\u4ef6\u3011saleOrderInfoUpdateEvent\u5220\u9664\u7ed3\u675f\uff0cid={}", (Object)saleOrderInfoUpdateEvent.getSaleOrderId());
        }
    }
}

