/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.DateUtil;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.constants.SecondSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.dao.base.QueryWrapBuilder;
import com.yunxi.dg.base.center.trade.dao.das.IDgSaleOrderDas;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyConfirmReceiptRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyConfirmReceiptRuleRespDto;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.service.IDgAutoReceivedOrderService;
import com.yunxi.dg.base.center.trade.service.IDgStrategyConfirmReceiptRuleService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgAutoReceivedOrderServiceImpl
implements IDgAutoReceivedOrderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgAutoReceivedOrderServiceImpl.class);
    private static final Integer ONE_QUERY_LIMIT = 500;
    @Resource
    private IDgSaleOrderDas saleOrderDas;
    @Resource
    private IDgStrategyConfirmReceiptRuleService strategyConfirmReceiptRuleService;

    @Override
    public void handleAutoReceiveTask() {
        DgStrategyConfirmReceiptRuleReqDto reqDto = new DgStrategyConfirmReceiptRuleReqDto();
        reqDto.setRuleStatus(Integer.valueOf(1));
        List<DgStrategyConfirmReceiptRuleRespDto> ruleRespDtos = this.strategyConfirmReceiptRuleService.queryByList(reqDto);
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(ruleRespDtos), (String)"\u786e\u8ba4\u6536\u8d27\u7b56\u7565\u5c1a\u672a\u914d\u7f6e");
        for (DgStrategyConfirmReceiptRuleRespDto respDto : ruleRespDtos) {
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7b7e\u6536]\u786e\u8ba4\u6536\u8d27\u7b56\u7565\u8bbe\u7f6e\u4e86\u8ba2\u5355\u6e20\u9053{}\u8ba2\u5355\u7c7b\u578b{}\u5b8c\u6210{}\u5929\u540e\uff0c\u8ba2\u5355\u81ea\u52a8\u7b7e\u6536", new Object[]{respDto.getOrderChannelName(), respDto.getOrderTypeName(), respDto.getConfirmReceiptDay()});
            Integer autoReceiveDateNum = respDto.getConfirmReceiptDay();
            Date receiveDate = DateUtil.addDay((Date)DateUtil.parse((String)DateUtil.getCurrenDate()), (int)(-autoReceiveDateNum.intValue()));
            DgSaleOrderEo queryEo = new DgSaleOrderEo();
            QueryWrapBuilder wrapper = new QueryWrapBuilder((BaseEo)queryEo);
            wrapper.eq("order_status", (Object)DgSaleOrderStatusEnum.COMPLETE.getCode()).eq("second_order_status", (Object)SecondSaleOrderStatusEnum.ALL_OUT_DELIVERY.getCode()).eq("channel_code", (Object)respDto.getOrderChannelCode()).in("order_type", (Collection)Arrays.asList(respDto.getOrderTypeCode().split(",")).stream().collect(Collectors.toList())).le("delivery_complete_date", (Object)receiveDate).builder();
            int count = this.saleOrderDas.getMapper().countCondition((BaseEo)queryEo);
            if (count == 0) {
                LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7b7e\u6536]\u6ca1\u6709\u9700\u8981\u81ea\u52a8\u7b7e\u6536\u7684\u8ba2\u5355");
                continue;
            }
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7b7e\u6536]\u9700\u8981\u8bbe\u7f6e\u81ea\u52a8\u7b7e\u6536\u7684\u4efb\u52a1\u6709{}\u6761", (Object)count);
            if (count > ONE_QUERY_LIMIT) {
                LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7b7e\u6536]\u5f00\u542f\u591a\u7ebf\u7a0b\u6267\u884c\u4efb\u52a1");
                this.doMutiTask(queryEo, count);
                continue;
            }
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7b7e\u6536]\u5355\u7ebf\u7a0b\u5faa\u73af\u6267\u884c({})\u4efb\u52a1", (Object)count);
            this.changeSaleOrderStatus(queryEo, 0, ONE_QUERY_LIMIT);
        }
    }

    private void doMutiTask(DgSaleOrderEo queryEo, Integer count) {
        int taskNum = (int)Math.ceil((double)count.intValue() * 1.0 / (double)ONE_QUERY_LIMIT.intValue());
        LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7b7e\u6536]\u5f00\u542f({})\u4e2a\u4efb\u52a1\u6267\u884c", (Object)taskNum);
        for (int i = 1; i < taskNum + 1; ++i) {
            Integer start = (i - 1) * ONE_QUERY_LIMIT;
            CompletableFuture.runAsync(() -> this.changeSaleOrderStatus(queryEo, start, ONE_QUERY_LIMIT));
        }
    }

    private void changeSaleOrderStatus(DgSaleOrderEo queryEo, Integer start, Integer limit) {
        List saleOrderEos = this.saleOrderDas.selectList((BaseEo)queryEo, start, limit);
        for (DgSaleOrderEo dgSaleOrderEo : saleOrderEos) {
        }
    }
}

