/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.OrderLabelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderLabelRecordReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderLabelBaseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderLabelRecordRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.eo.OrderLabelRecordEo;
import com.yunxi.dg.base.center.trade.service.tc.IOrderLabelRecordService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderLabelRecordServiceImpl
implements IOrderLabelRecordService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IOrderLabelRecordDomain orderLabelRecordDomain;

    @Override
    public Long addOrderLabelRecord(OrderLabelRecordReqDto addReqDto) {
        OrderLabelRecordEo orderLabelRecordEo = new OrderLabelRecordEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orderLabelRecordEo);
        this.orderLabelRecordDomain.insert((BaseEo)orderLabelRecordEo);
        return orderLabelRecordEo.getId();
    }

    @Override
    public Long addOrderLabelRecord(Long orderId, OrderLabelEnum addReqDto) {
        OrderLabelRecordEo orderLabelRecordEo = new OrderLabelRecordEo();
        orderLabelRecordEo.setLabelCode(addReqDto.getCode());
        orderLabelRecordEo.setOrderId(orderId);
        orderLabelRecordEo.setDisplay(addReqDto.getDisplay());
        this.orderLabelRecordDomain.insert((BaseEo)orderLabelRecordEo);
        return orderLabelRecordEo.getId();
    }

    @Override
    public void modifyOrderLabelRecord(OrderLabelRecordReqDto modifyReqDto) {
        OrderLabelRecordEo orderLabelRecordEo = new OrderLabelRecordEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)orderLabelRecordEo);
        this.orderLabelRecordDomain.updateSelective((BaseEo)orderLabelRecordEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderLabelRecord(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderLabelRecordDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void removeOrderLabelRecordById(Long id) {
        this.orderLabelRecordDomain.logicDeleteById(id);
    }

    @Override
    public void removeOrderLabelRecordById(Long orderId, OrderLabelEnum reqDto) {
        AssertUtils.notNull((Object)orderId, (String)"[\u5220\u9664\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u8ba2\u5355ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto, (String)"[\u5220\u9664\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u6807\u8bc6\u679a\u4e3e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        OrderLabelRecordEo record = new OrderLabelRecordEo();
        record.setOrderId(orderId);
        record.setLabelCode(reqDto.getCode());
        record.setDisplay(reqDto.getDisplay());
        OrderLabelRecordEo orderLabelRecordEo = (OrderLabelRecordEo)this.orderLabelRecordDomain.selectOne((BaseEo)record);
        if (Objects.isNull(orderLabelRecordEo)) {
            this.logger.warn(String.format("[\u5220\u9664\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]%s,%s,\u672a\u627e\u5230\u8be5\u6807\u8bc6", orderId, reqDto.getCode()));
            return;
        }
        this.orderLabelRecordDomain.logicDeleteById(orderLabelRecordEo.getId());
    }

    @Override
    public OrderLabelRecordRespDto queryById(Long id) {
        OrderLabelRecordEo orderLabelRecordEo = (OrderLabelRecordEo)this.orderLabelRecordDomain.selectByPrimaryKey(id);
        OrderLabelRecordRespDto orderLabelRecordRespDto = new OrderLabelRecordRespDto();
        DtoHelper.eo2Dto((BaseEo)orderLabelRecordEo, (BaseVo)orderLabelRecordRespDto);
        return orderLabelRecordRespDto;
    }

    @Override
    public PageInfo<OrderLabelRecordRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderLabelRecordReqDto orderLabelRecordReqDto = (OrderLabelRecordReqDto)JSON.parseObject((String)filter, OrderLabelRecordReqDto.class);
        OrderLabelRecordEo orderLabelRecordEo = new OrderLabelRecordEo();
        DtoHelper.dto2Eo((BaseVo)orderLabelRecordReqDto, (BaseEo)orderLabelRecordEo);
        PageInfo eoPageInfo = this.orderLabelRecordDomain.selectPage((BaseEo)orderLabelRecordEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrderLabelRecordRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<OrderLabelRecordRespDto> queryByParam(OrderLabelRecordReqDto orderLabelRecordReqDto) {
        List orderLabelRecordEos;
        AssertUtils.notNull((Object)orderLabelRecordReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        if (Objects.nonNull(orderLabelRecordReqDto.getLabelCode())) {
            queryWrapper.eq(OrderLabelRecordEo::getLabelCode, (Object)orderLabelRecordReqDto.getLabelCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)orderLabelRecordReqDto.getLabelCodes())) {
            queryWrapper.in(OrderLabelRecordEo::getLabelCode, (Collection)orderLabelRecordReqDto.getLabelCodes());
        }
        if (Objects.nonNull(orderLabelRecordReqDto.getOrderId())) {
            queryWrapper.eq(OrderLabelRecordEo::getOrderId, (Object)orderLabelRecordReqDto.getOrderId());
        }
        if (CollectionUtils.isNotEmpty((Collection)orderLabelRecordReqDto.getOrderIds())) {
            queryWrapper.in(OrderLabelRecordEo::getOrderId, (Collection)orderLabelRecordReqDto.getOrderIds());
        }
        if (CollectionUtils.isEmpty((Collection)(orderLabelRecordEos = this.orderLabelRecordDomain.getMapper().selectList((Wrapper)queryWrapper)))) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)orderLabelRecordEos, (Collection)resultList, OrderLabelRecordRespDto.class);
        return resultList;
    }

    @Override
    public OrderLabelRecordRespDto queryByRecord(OrderLabelRecordReqDto orderLabelRecordReqDto) {
        OrderLabelRecordEo orderLabelRecordEo;
        AssertUtils.notNull((Object)orderLabelRecordReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        if (Objects.nonNull(orderLabelRecordReqDto.getLabelCode())) {
            queryWrapper.eq(OrderLabelRecordEo::getLabelCode, (Object)orderLabelRecordReqDto.getLabelCode());
        }
        if (Objects.nonNull(orderLabelRecordReqDto.getOrderId())) {
            queryWrapper.eq(OrderLabelRecordEo::getOrderId, (Object)orderLabelRecordReqDto.getOrderId());
        }
        if (CollectionUtils.isNotEmpty((Collection)orderLabelRecordReqDto.getOrderIds())) {
            queryWrapper.in(OrderLabelRecordEo::getOrderId, (Collection)orderLabelRecordReqDto.getOrderIds());
        }
        if (Objects.isNull(orderLabelRecordEo = (OrderLabelRecordEo)this.orderLabelRecordDomain.getMapper().selectOne((Wrapper)queryWrapper))) {
            return null;
        }
        OrderLabelRecordRespDto orderLabelRecordRespDto = new OrderLabelRecordRespDto();
        DtoHelper.eo2Dto((BaseEo)orderLabelRecordEo, (BaseVo)orderLabelRecordRespDto);
        return orderLabelRecordRespDto;
    }

    @Override
    public List<OrderLabelRecordRespDto> queryByOrderIds(List<Long> orderIds) {
        AssertUtils.notEmpty(orderIds, (String)"orderId\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(OrderLabelRecordEo::getOrderId, orderIds);
        List orderLabelRecordEos = this.orderLabelRecordDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)orderLabelRecordEos)) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)orderLabelRecordEos, (Collection)resultList, OrderLabelRecordRespDto.class);
        return resultList;
    }

    @Override
    public List<String> queryExistLabelCode(Long orderId, List<OrderLabelEnum> orderLabelEnumList) {
        AssertUtils.notNull((Object)orderId, (String)"\u9500\u552e\u8ba2\u5355ID\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull(orderLabelEnumList, (String)"\u6807\u8bc6\u7f16\u7801\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        OrderLabelRecordReqDto orderLabelRecordReqDto = new OrderLabelRecordReqDto();
        orderLabelRecordReqDto.setOrderId(orderId);
        orderLabelRecordReqDto.setLabelCodes(orderLabelEnumList.stream().map(OrderLabelEnum::getCode).collect(Collectors.toList()));
        List<OrderLabelRecordRespDto> orderLabelRecordRespDtos = this.queryByParam(orderLabelRecordReqDto);
        if (CollectionUtils.isEmpty(orderLabelRecordRespDtos)) {
            return null;
        }
        return orderLabelRecordRespDtos.stream().map(OrderLabelBaseRespDto::getLabelCode).collect(Collectors.toList());
    }
}

