/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.tc.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.commons.aspect.annotation.TrackLogNode;
import com.dtyunxi.cube.component.track.commons.constant.TrackLogBizDefine;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SecondSaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ArrangeWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CspUpdateEasOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ModifyLogicalWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderTagRecordReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderCustomerAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SearchSourceReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitChildOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderByBatchReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderBySourceInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderCspRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTransferOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.api.inventory.ICsLogisticsInfoQueryApi;
import com.yunxi.dg.base.center.report.dto.request.CsLogisticsInfoReqDto;
import com.yunxi.dg.base.center.source.dto.extend.SourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.action.tc.IDgTcPerformOrderOptAction;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.service.tc.IOrderTagRecordService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderOptService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleTransferOrderService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.vo.StatemachineInvalidOrderDto;
import com.yunxi.dg.base.center.trade.vo.StatemachineRestOrderRespDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@TrackLogNode(nodeBizDefine=TrackLogBizDefine.BIZ_OPERATION_LOG, nodeBizCode="saleOrder", nodeBizParamsKeys={"saleOrderId"}, nodeBizParamsValues={"#orderId"})
public class DgTcPerformOrderOptActionImpl
implements IDgTcPerformOrderOptAction {
    private static final Logger log = LoggerFactory.getLogger(DgTcPerformOrderOptActionImpl.class);
    @Resource
    private ISaleOrderOptService saleOrderOptService;
    @Resource
    private ISaleOrderService saleOrderService;
    @Resource
    private IDgSaleOrderItemDomain dgSaleOrderItemDomain;
    @Resource
    private IOrderTagRecordService orderTagRecordService;
    @Resource
    private ISaleTransferOrderService saleTransferOrderService;
    @Resource
    private ICsLogisticsInfoQueryApi csLogisticsInfoApi;

    @Override
    public RestResponse<Void> checkOrder(Long orderId) {
        this.saleOrderOptService.checkOrder(orderId);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateOrderLogic(SplitOrderBySourceInfoReqDto reqDto) {
        this.saleOrderOptService.updateOrderLogic(reqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Boolean> arrangeWarehouseForDeliver(Long orderId, List<ArrangeWarehouseReqDto> reqDtoList) {
        AssertUtils.notEmpty(reqDtoList, (String)"\u6307\u5b9a\u5546\u54c1\u53d1\u8d27\u6570\u636e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(orderId);
        this.saleOrderOptService.checkSaleOrderStatus((SaleOrderStatus)SecondSaleOrderStatusEnum.forCode((String)saleOrderEo.getSecondOrderStatus()), new SaleOrderStatus[]{SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK});
        return new RestResponse((Object)this.saleOrderOptService.arrangeWarehouseForDeliver(orderId, reqDtoList, arrangeWarehouseReqDto -> {
            DgSaleOrderEo updateStatusEo = new DgSaleOrderEo();
            updateStatusEo.setLogicalWarehouseName(arrangeWarehouseReqDto.getLogicalWarehouseName());
            updateStatusEo.setLogicalWarehouseId(arrangeWarehouseReqDto.getLogicalWarehouseId());
            updateStatusEo.setLogicalWarehouseCode(arrangeWarehouseReqDto.getLogicalWarehouseCode());
            updateStatusEo.setInterceptInfo("");
            updateStatusEo.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
            this.saleOrderOptService.optimisticSaleOrderChildStatus(updateStatusEo, saleOrderEo.getId(), SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK);
        }));
    }

    @Override
    public RestResponse<Boolean> autoArrangeWarehouse(Long orderId) {
        return new RestResponse((Object)this.saleOrderOptService.autoArrangeWarehouseBySource(orderId));
    }

    @Override
    public RestResponse<Boolean> arrangeWarehouseByAppoint(Long orderId) {
        return new RestResponse((Object)this.saleOrderOptService.arrangeWarehouseByAppoint(orderId));
    }

    @Override
    public RestResponse<Void> cancelOrder(Long orderId, String cancelReason) {
        this.saleOrderOptService.cancelOrder(orderId, cancelReason);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cancelWmsOrder(Long orderId) {
        this.saleOrderOptService.cancelWmsOrder(orderId, "WMS\u53d6\u6d88\u5355\u636e");
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Boolean> checkEnableRest(Long orderId) {
        return new RestResponse((Object)this.saleOrderOptService.checkEnableRest(orderId));
    }

    @Override
    public RestResponse<Void> modifyAddress(Long orderId, SaleOrderAddrReqDto reqDto) {
        this.saleOrderOptService.modifyAddress(reqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyPlanDeliveryDate(Long orderId, String newDate) {
        this.saleOrderOptService.modifyPlanDeliveryDate(orderId, newDate);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cancelCspOrder(Long platformOrderId) {
        this.saleOrderOptService.cancelCspOrder(platformOrderId);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> resetOrder(Long orderId) {
        this.saleOrderOptService.resetOrder(orderId);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<StatemachineRestOrderRespDto> resetSplitOrder(Long orderId, String saleOrderNo) {
        return new RestResponse((Object)this.saleOrderOptService.resetSplitOrder(orderId, saleOrderNo));
    }

    @Override
    public RestResponse<Boolean> confirmReceiptGoods(Long orderId) {
        return new RestResponse((Object)this.saleOrderOptService.confirmReceiptGoods(orderId));
    }

    @Override
    public RestResponse<Void> continueDeliver(Long orderId) {
        this.saleOrderOptService.updateOrderDelivery(orderId);
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(orderId);
        if (saleOrderEo != null) {
            OrderTagRecordReqDto tagReqDto = new OrderTagRecordReqDto();
            tagReqDto.setOrderId(orderId);
            tagReqDto.setTagCode("GSDB");
            List<OrderTagRecordRespDto> tagRecords = this.orderTagRecordService.queryByParam(tagReqDto);
            if (CollectionUtils.isNotEmpty(tagRecords)) {
                SaleTransferOrderReqDto transferReqDto = new SaleTransferOrderReqDto();
                transferReqDto.setSaleOrderNo(saleOrderEo.getSaleOrderNo());
                List<SaleTransferOrderRespDto> transferOrders = this.saleTransferOrderService.queryByParam(transferReqDto);
                if (CollectionUtils.isNotEmpty(transferOrders)) {
                    SaleTransferOrderRespDto transferOrder = transferOrders.get(0);
                    String transferNo = transferOrder.getTransferOrderNo();
                    String consignmentNo = saleOrderEo.getInvoiceNo();
                    String remark = saleOrderEo.getTargetPhysicsWarehouseName() + "\u5df2\u53d1\u8d27";
                    this.syncLogistics(transferNo, consignmentNo, remark);
                }
            }
        }
        return RestResponse.VOID;
    }

    private void syncLogistics(String transferNo, String consignmentNo, String remark) {
        try {
            CsLogisticsInfoReqDto dataInfo = new CsLogisticsInfoReqDto();
            dataInfo.setType(Integer.valueOf(1));
            dataInfo.setCspNo(transferNo);
            dataInfo.setStatus("9");
            dataInfo.setConsignmentNo(consignmentNo);
            dataInfo.setShipTime(new Date());
            dataInfo.setDeliveStartTime(new Date());
            dataInfo.setOperTime(new Date());
            dataInfo.setRemark(remark);
            RestResponseHelper.extractData((RestResponse)this.csLogisticsInfoApi.addCsLogisticsInfo(dataInfo));
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u5931\u8d25\uff0ctransferNo: {}, consignmentNo: {}, error: {}", new Object[]{transferNo, consignmentNo, e.getMessage(), e});
        }
    }

    @Override
    public RestResponse<List<BizSaleOrderRespDto>> splitOrder(Long orderId, SplitOrderReqDto reqDto) {
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(orderId);
        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getSecondOrderStatus())) {
            this.saleOrderOptService.checkSaleOrderStatus((SaleOrderStatus)SecondSaleOrderStatusEnum.forCode((String)saleOrderEo.getSecondOrderStatus()), new SaleOrderStatus[]{SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK});
        }
        reqDto.setInitOrderStatus(saleOrderEo.getOrderStatus());
        if (!Objects.equals(reqDto.getInitOmsOrderStatus(), SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode())) {
            reqDto.setInitOmsOrderStatus(saleOrderEo.getSecondOrderStatus());
        }
        reqDto.setOriOrderStatus(SaleOrderStatusEnum.SPLIT.getCode());
        return new RestResponse(this.saleOrderOptService.splitOrderTcbj(reqDto));
    }

    @Override
    public RestResponse<List<BizSaleOrderRespDto>> splitOrderBySku(Long orderId, String splitSku) {
        return new RestResponse(this.saleOrderOptService.splitOrderBySkuTcbj(orderId, splitSku));
    }

    @Override
    public RestResponse<List<BizSaleOrderRespDto>> splitOrderByAppointBatch(Long orderId, SplitOrderByBatchReqDto reqDto) {
        return new RestResponse(this.saleOrderOptService.splitOrderByAppointBatch(reqDto));
    }

    @Override
    public RestResponse<Void> autoPickClaimOrderDelivery(SearchSourceReqDto reqDto, Long id) {
        this.saleOrderOptService.aotoPickClaimOrderDelivery(reqDto, id);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<SourceOrderResultRespDto> autoSearchSource(SearchSourceReqDto reqDto) {
        return new RestResponse((Object)this.saleOrderOptService.autoSearchSource(reqDto, reqDto.getSaleOrderNo()));
    }

    @Override
    public RestResponse<List<BizSaleOrderRespDto>> splitOrderForSource(SourceOrderResultRespDto reqDto) {
        List<BizSaleOrderRespDto> bizSaleOrderRespDtos = this.saleOrderOptService.splitOrderForSource(reqDto);
        return new RestResponse(bizSaleOrderRespDtos);
    }

    @Override
    public RestResponse<Void> searchSourceDeliveryOrder(SourceOrderResultRespDto reqDto) {
        this.saleOrderOptService.searchSourceDeliveryOrder(reqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> searchSourceForDeliver(Long orderId, SearchSourceReqDto reqDto) {
        this.saleOrderOptService.searchSourceForDeliver(reqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Boolean> autoArrangeWarehouseBySource(Long orderId) {
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(orderId);
        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getSecondOrderStatus())) {
            this.saleOrderOptService.checkSaleOrderStatus((SaleOrderStatus)SecondSaleOrderStatusEnum.forCode((String)saleOrderEo.getSecondOrderStatus()), new SaleOrderStatus[]{SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK});
        }
        return new RestResponse((Object)this.saleOrderOptService.autoArrangeWarehouseBySource(orderId));
    }

    @Override
    public RestResponse<Void> unlock(Long orderId) {
        this.saleOrderOptService.unlock(orderId);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cancelAppoint(Long orderId) {
        this.saleOrderOptService.cancelAppoint(orderId);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> codeCheck(Long orderId, String operationType) {
        return this.saleOrderOptService.codeCheck(orderId, operationType);
    }

    @Override
    public RestResponse<Void> batchConfirmReceiptGoods(List<Long> orderIdList) {
        if (orderIdList.size() == 1) {
            this.saleOrderOptService.confirmReceiptGoods(orderIdList.get(0));
            return RestResponse.VOID;
        }
        ArrayList orderIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long orderId : orderIdList) {
            try {
                this.saleOrderOptService.confirmReceiptGoods(orderId);
            }
            catch (Exception e) {
                orderIdOfexceptionList.add(orderId);
                errMessageMap.put(orderId, e.getMessage());
                log.error("[\u6279\u91cf\u786e\u8ba4\u6536\u8d27]\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)orderIdOfexceptionList)) {
            String message = "\u6279\u91cf\u64cd\u4f5c\u5931\u8d25\uff1a\n %s ";
            this.throwExceptoinMessage(orderIdOfexceptionList, message, errMessageMap);
        }
        return RestResponse.VOID;
    }

    private void throwExceptoinMessage(List<Long> orderIdOfexceptionList, String message, Map<Long, String> errMessageMap) {
        List<SaleOrderRespDto> saleOrderRespDtos = this.saleOrderService.queryByOrderIds(orderIdOfexceptionList);
        StringBuilder messageBuilder = new StringBuilder();
        if (CollectionUtils.isNotEmpty(saleOrderRespDtos)) {
            for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
                messageBuilder.append(saleOrderRespDto.getSaleOrderNo()).append(errMessageMap.get(saleOrderRespDto.getId())).append("; \n");
            }
        }
        throw new BizException(PcpTradeExceptionCode.BATCH_OPT_EXCEPTION.getCode(), String.format(message, messageBuilder.toString()));
    }

    @Override
    public RestResponse<SaleOrderCspRespDto> cspUpdateEasOrderNo(CspUpdateEasOrderReqDto updateEasOrderReqDto) {
        return new RestResponse((Object)this.saleOrderOptService.cspUpdateEasOrderNo(updateEasOrderReqDto));
    }

    @Override
    public RestResponse<StatemachineInvalidOrderDto> invalidOrder(Long orderId) {
        List<SaleOrderRespDto> saleOrderRespDtos = this.saleOrderOptService.invalidOrder(orderId);
        StatemachineInvalidOrderDto statemachineInvalidOrderDto = new StatemachineInvalidOrderDto();
        statemachineInvalidOrderDto.setOrderId(orderId);
        statemachineInvalidOrderDto.setChildSaleOrderNos(saleOrderRespDtos);
        return new RestResponse((Object)statemachineInvalidOrderDto);
    }

    @Override
    public RestResponse<StatemachineInvalidOrderDto> invalidChildOrder(Long orderId) {
        DgSaleOrderEo dgSaleOrderEo = this.saleOrderService.queryEoById(orderId);
        AssertUtils.notNull((Object)dgSaleOrderEo, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        List<SaleOrderRespDto> childSaleOrderNos = this.saleOrderOptService.invalidChildOrder(dgSaleOrderEo.getSaleOrderNo());
        StatemachineInvalidOrderDto statemachineInvalidOrderDto = new StatemachineInvalidOrderDto();
        statemachineInvalidOrderDto.setOrderId(orderId);
        statemachineInvalidOrderDto.setChildSaleOrderNos(childSaleOrderNos);
        return new RestResponse((Object)statemachineInvalidOrderDto);
    }

    @Override
    public RestResponse<Void> customerAudit(SaleOrderCustomerAuditReqDto reqDto) {
        this.saleOrderOptService.customerAudit(reqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateSaleOrderStringCodeResult(CspUpdateEasOrderReqDto updateEasOrderReqDto) {
        this.saleOrderOptService.updateSaleOrderStringCodeResult(updateEasOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> invalidOrderByPlatformOrderNo(String platformOrderNo) {
        this.saleOrderOptService.invalidOrderByPlatformOrderNo(platformOrderNo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> splitPick(Long orderId) {
        this.saleOrderOptService.splitPick(orderId);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> doPcpStatusLock(Long orderId) {
        this.saleOrderOptService.doPcpStatusLock(orderId);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> doPcpStatusUnLock(Long orderId) {
        this.saleOrderOptService.doPcpStatusUnLock(orderId);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateDefaultLogic(Long orderId) {
        this.saleOrderOptService.updateDefaultLogic(orderId);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> advancePick(Long orderId) {
        this.saleOrderOptService.advancePick(orderId);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> doPcpStatusLockAndSystem(String saleOrderNo) {
        this.saleOrderOptService.doPcpStatusLockAndSystem(saleOrderNo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> doPcpStatusUnLockAndSystem(String saleOrderNo) {
        this.saleOrderOptService.doPcpStatusUnLockAndSystem(saleOrderNo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<String> splitPartDelivery(Long orderId, SplitOrderBySourceInfoReqDto reqDto) {
        SplitOrderReqDto splitOrderReqDto = new SplitOrderReqDto();
        splitOrderReqDto.setSaleOrderId(reqDto.getSaleOrderId());
        splitOrderReqDto.setSaleOrderNo(reqDto.getSaleOrderNo());
        splitOrderReqDto.setInitOrderStatus(SaleOrderStatusEnum.WAIT_PICK.getCode());
        splitOrderReqDto.setInitOmsOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK.getCode());
        splitOrderReqDto.setOriOrderStatus(SaleOrderStatusEnum.SPLIT.getCode());
        splitOrderReqDto.setSplitPartDeliveryFlag(Boolean.TRUE.booleanValue());
        splitOrderReqDto.setAsync(reqDto.isAsync());
        ArrayList orderList = Lists.newArrayList();
        SplitChildOrderReqDto splitChildOrderReqDto = new SplitChildOrderReqDto();
        splitChildOrderReqDto.setGoodsList(reqDto.getGoodsList());
        SplitChildOrderReqDto.LogicWarehouse logicWarehouse = new SplitChildOrderReqDto.LogicWarehouse();
        logicWarehouse.setDeliveryLogicWarehouseCode(reqDto.getDeliveryLogicWarehouseCode());
        logicWarehouse.setDeliveryLogicWarehouseName(reqDto.getDeliveryLogicWarehouseName());
        logicWarehouse.setDeliveryLogicWarehouseId(reqDto.getDeliveryLogicWarehouseId());
        splitChildOrderReqDto.setLogicWarehouse(logicWarehouse);
        orderList.add(splitChildOrderReqDto);
        splitOrderReqDto.setOrderList((List)orderList);
        List<BizSaleOrderRespDto> saleOrderRespDtoList = this.saleOrderOptService.splitOrderTcbj(splitOrderReqDto);
        List childSaleOrderList = saleOrderRespDtoList.stream().filter(dto -> Objects.equals(dto.getSecondOrderStatus(), SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK.getCode())).collect(Collectors.toList());
        String saleOrderNo = "";
        if (CollectionUtils.isNotEmpty(childSaleOrderList)) {
            saleOrderNo = ((SaleOrderRespDto)childSaleOrderList.get(0)).getSaleOrderNo();
        }
        DgSaleOrderEo saleOrderEo = new DgSaleOrderEo();
        saleOrderEo.setOrderStatus(SaleOrderStatusEnum.SPLIT.getCode());
        saleOrderEo.setInterceptInfo("");
        this.saleOrderOptService.optimisticSaleOrderStatus(saleOrderEo, orderId, SaleOrderStatusEnum.WAIT_PICK);
        return new RestResponse((Object)saleOrderNo);
    }

    @Override
    public RestResponse<String> updateOrderLogic(Long orderId, SplitOrderBySourceInfoReqDto reqDto) {
        DgSaleOrderEo updateOrderEo = new DgSaleOrderEo();
        updateOrderEo.setId(reqDto.getSaleOrderId());
        updateOrderEo.setLogicalWarehouseCode(reqDto.getDeliveryLogicWarehouseCode());
        updateOrderEo.setLogicalWarehouseId(reqDto.getDeliveryLogicWarehouseId());
        updateOrderEo.setLogicalWarehouseName(reqDto.getDeliveryLogicWarehouseName());
        this.saleOrderService.updateSaleOrderById(reqDto.getSaleOrderId(), updateOrderEo);
        Collections.sort(reqDto.getGoodsList(), Comparator.comparing(SplitOrderItemReqDto::getOriginalOrderGoodsId));
        for (SplitOrderItemReqDto orderItemReqDto : reqDto.getGoodsList()) {
            DgSaleOrderItemEo updateItemEo = new DgSaleOrderItemEo();
            updateItemEo.setId(orderItemReqDto.getOriginalOrderGoodsId());
            updateItemEo.setLogicalWarehouseId(reqDto.getDeliveryLogicWarehouseId());
            updateItemEo.setLogicalWarehouseCode(reqDto.getDeliveryLogicWarehouseCode());
            updateItemEo.setLogicalWarehouseName(reqDto.getDeliveryLogicWarehouseName());
            this.dgSaleOrderItemDomain.updateSelective((BaseEo)updateItemEo);
        }
        this.saleOrderOptService.arrangeWarehouseByAppoint(orderId);
        return new RestResponse((Object)"");
    }

    @Override
    public RestResponse<Void> sourceDeliveryAndTransfer(Long orderId, List<SplitOrderBySourceInfoReqDto> list) {
        List<Long> deliveryOrderIdList = this.saleOrderOptService.sourceDeliveryAndTransfer(orderId, list);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateLogicalWarehouseAndDelivery(ModifyLogicalWarehouseReqDto reqDto) {
        this.saleOrderOptService.updateLogicalWarehouseAndDelivery(reqDto);
        return new RestResponse();
    }

    @Override
    public RestResponse<SaleOrderRespDto> backCheck(Long orderId) {
        return null;
    }

    @Override
    public RestResponse<Void> retractOrder(Long orderId) {
        this.saleOrderOptService.retractOrder(orderId);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> maiyouAllotDelivery(Long orderId, List<SplitOrderBySourceInfoReqDto> list) {
        this.saleOrderOptService.maiyouAllotDelivery(orderId, list);
        return RestResponse.VOID;
    }
}

