/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.order.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.MD5Util;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyContentTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyLabelTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleDomain;
import com.yunxi.dg.base.center.trade.dto.strategy.DgLabelStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgLabelStrategyRuleRestDto;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemSuitEo;
import com.yunxi.dg.base.center.trade.service.order.strategy.IDgLabelStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.order.strategy.impl.DgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateInUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IDgLabelStrategyRuleServiceImpl
extends DgStrategyRuleServiceImpl
implements IDgLabelStrategyRuleService {
    private static Logger logger = LoggerFactory.getLogger(IDgLabelStrategyRuleServiceImpl.class);
    @Resource
    private NoGreateInUtil noGreateInUtil;
    @Resource
    private IDgStrategyRuleDomain strategyRuleDas;

    @Override
    public Long addOrderLabelStrategyRule(DgLabelStrategyRuleReqDto addReqDto) {
        if (Objects.isNull(addReqDto.getPeriodicEnd()) || Objects.isNull(addReqDto.getPeriodicStart())) {
            throw new BizException("\u5468\u671f\u5f00\u59cb\u65f6\u95f4\u548c\u5468\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == addReqDto.getLabelCode() || null == addReqDto.getPlatForm()) {
            throw new BizException("\u6807\u7b7e\u7f16\u7801||\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.strategyRuleDas.filter().eq(StringUtils.isNotEmpty((CharSequence)addReqDto.getRuleName()), (Object)"rule_name", (Object)addReqDto.getRuleName())).eq(StringUtils.isNotEmpty((CharSequence)addReqDto.getPlatForm()), (Object)"plat_form", (Object)addReqDto.getPlatForm())).list();
        if (list.size() >= 1) {
            throw new BizException("\u8be5\u89c4\u5219\uff1a+" + addReqDto.getRuleName() + "+\u5df2\u7ecf\u5b9a\u4e49\u4e86\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e");
        }
        DgStrategyRuleEo dgStrategyRuleEo = new DgStrategyRuleEo();
        CubeBeanUtils.copyProperties((Object)dgStrategyRuleEo, (Object)addReqDto, (String[])new String[0]);
        dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateLabelNo());
        dgStrategyRuleEo.setStrategyType("LABEL");
        this.strategyRuleDas.insert((BaseEo)dgStrategyRuleEo);
        ArrayList confItemEoList = Lists.newArrayList();
        ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
        this.extractedDealInsertData(addReqDto, dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList);
        this.strategyConfItemDas.insertBatch((List)confItemEoList);
        this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
        return dgStrategyRuleEo.getId();
    }

    @Override
    public void modifyOrderLabelStrategyRule(DgLabelStrategyRuleReqDto modifyReqDto) {
        AssertUtils.notNull((Object)modifyReqDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        DgStrategyRuleEo newDgStrategyRuleEo = new DgStrategyRuleEo();
        CubeBeanUtils.copyProperties((Object)newDgStrategyRuleEo, (Object)modifyReqDto, (String[])new String[0]);
        this.strategyRuleDas.updateSelective((BaseEo)newDgStrategyRuleEo);
        this.modifyStrategyConfItems(modifyReqDto);
    }

    private void modifyStrategyConfItems(DgLabelStrategyRuleReqDto modifyReqDto) {
        LambdaQueryWrapper queryStrategyConfItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getRuleId, (Object)modifyReqDto.getId());
        List strategyConfItemEoList = this.strategyConfItemDas.list(queryStrategyConfItemEo);
        Map<String, StrategyConfItemEo> groupStrategyMap = strategyConfItemEoList.stream().collect(Collectors.toMap(StrategyConfItemEo::getStrategyType, Function.identity(), (v1, v2) -> v2));
        this.extractedDealModifyData(modifyReqDto, groupStrategyMap);
    }

    private void extractedDealModifyData(DgLabelStrategyRuleReqDto modifyReqDto, Map<String, StrategyConfItemEo> groupStrategyMap) {
        Map keyMap = CisStrategyLabelTypeEnum.NAME_LOOKUP;
        try {
            Field[] fields;
            Long id = modifyReqDto.getId();
            Class<DgLabelStrategyRuleReqDto> clazz = DgLabelStrategyRuleReqDto.class;
            for (Field field : fields = clazz.getDeclaredFields()) {
                DgLabelStrategyRuleReqDto.SpecialList specialList;
                String name = field.getName();
                field.setAccessible(true);
                CisStrategyLabelTypeEnum cisStrategyLabelTypeEnum = (CisStrategyLabelTypeEnum)keyMap.get(name);
                String code = cisStrategyLabelTypeEnum.getCode();
                String desc = cisStrategyLabelTypeEnum.getDesc();
                if (cisStrategyLabelTypeEnum.getType().equals("list")) {
                    specialList = (DgLabelStrategyRuleReqDto.SpecialList)field.get(modifyReqDto);
                    this.extractedModify(modifyReqDto.getId(), groupStrategyMap, cisStrategyLabelTypeEnum, code, desc, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, id);
                }
                if (cisStrategyLabelTypeEnum.getType().equals("time_range")) {
                    specialList = (DgLabelStrategyRuleReqDto.SpecialTimeRange)field.get(modifyReqDto);
                    this.extractedModify(modifyReqDto.getId(), groupStrategyMap, cisStrategyLabelTypeEnum, code, desc, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, id);
                }
                if (cisStrategyLabelTypeEnum.getType().equals("amount_range")) {
                    specialList = (DgLabelStrategyRuleReqDto.SpecialAmountRange)field.get(modifyReqDto);
                    this.extractedModify(modifyReqDto.getId(), groupStrategyMap, cisStrategyLabelTypeEnum, code, desc, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, id);
                }
                if (cisStrategyLabelTypeEnum.getType().equals("remark")) {
                    specialList = (DgLabelStrategyRuleReqDto.ActionRemark)field.get(modifyReqDto);
                    this.extractedModify(modifyReqDto.getId(), groupStrategyMap, cisStrategyLabelTypeEnum, code, desc, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, id);
                }
                if (!cisStrategyLabelTypeEnum.getType().equals("string")) continue;
                specialList = (DgLabelStrategyRuleReqDto.SpecialString)field.get(modifyReqDto);
                this.extractedModify(modifyReqDto.getId(), groupStrategyMap, cisStrategyLabelTypeEnum, code, desc, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, id);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void extractedModify(Long id, Map<String, StrategyConfItemEo> groupStrategyMap, CisStrategyLabelTypeEnum cisStrategyLabelTypeEnum, String code, String desc, DgLabelStrategyRuleReqDto.SpecialStrategy specialList, Long ids) {
        if (Objects.nonNull(specialList)) {
            StrategyConfItemEo orderType = groupStrategyMap.get(code);
            String orderMd5 = MD5Util.getMd5ByString((String)String.valueOf(specialList.getMd5()));
            if (orderType != null) {
                if (!StringUtils.equals((CharSequence)specialList.getMd5(), (CharSequence)orderMd5)) {
                    logger.info("\u3010\u4fee\u6539\u6807\u7b7e\u7b56\u7565\u3011+" + desc + "+\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)specialList);
                    StrategyConfItemEo confEo = new StrategyConfItemEo();
                    confEo.setId(orderType.getId());
                    confEo.setEnable(specialList.getEnable());
                    if (!cisStrategyLabelTypeEnum.getType().equals("list")) {
                        confEo.setContent(specialList.getContent());
                    }
                    confEo.setMd5(orderMd5);
                    this.strategyConfItemDas.updateSelective((BaseEo)confEo);
                    if (cisStrategyLabelTypeEnum.getType().equals("list")) {
                        StrategyConfItemSuitEo deleteEo = new StrategyConfItemSuitEo();
                        deleteEo.setRuleId(id);
                        deleteEo.setSuitType(code);
                        this.strategyConfItemSuitDas.logicDeleteByExample(deleteEo);
                        if (CollectionUtils.isNotEmpty((Collection)specialList.getCodeList())) {
                            ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
                            for (String code1 : specialList.getCodeList()) {
                                StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
                                confItemSuitEo.setRuleId(id);
                                confItemSuitEo.setSuitType(code);
                                confItemSuitEo.setSuitValue(code1);
                                confItemSuitEo.setSuitMatchCode(code + "_" + code1);
                                strategyConfItemSuitEoList.add(confItemSuitEo);
                            }
                            this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
                        }
                    }
                }
            } else {
                StrategyConfItemEo confEo = new StrategyConfItemEo();
                CubeBeanUtils.copyProperties((Object)confEo, (Object)specialList, (String[])new String[0]);
                confEo.setRuleId(ids);
                confEo.setEnable(specialList.getEnable());
                confEo.setStrategyType(code);
                confEo.setStrategyTypeName(desc);
                confEo.setContentType(cisStrategyLabelTypeEnum.getType());
                if (StringUtils.isNotBlank((CharSequence)specialList.getContent())) {
                    confEo.setContent(specialList.getContent());
                }
                confEo.setMd5(orderMd5);
                this.strategyConfItemDas.insert((BaseEo)confEo);
                if (CollectionUtils.isNotEmpty((Collection)specialList.getCodeList())) {
                    ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
                    for (String code1 : specialList.getCodeList()) {
                        StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
                        confItemSuitEo.setRuleId(ids);
                        confItemSuitEo.setSuitType(code);
                        confItemSuitEo.setSuitValue(code1);
                        confItemSuitEo.setSuitMatchCode(code + "_" + code1);
                        strategyConfItemSuitEoList.add(confItemSuitEo);
                    }
                    this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
                }
            }
        }
    }

    private void extractedDealInsertData(DgLabelStrategyRuleReqDto addReqDto, DgStrategyRuleEo dgStrategyRuleEo, List<StrategyConfItemEo> confItemEoList, List<StrategyConfItemSuitEo> strategyConfItemSuitEoList) {
        Map keyMap = CisStrategyLabelTypeEnum.NAME_LOOKUP;
        try {
            Field[] fields;
            Class<DgLabelStrategyRuleReqDto> clazz = DgLabelStrategyRuleReqDto.class;
            for (Field field : fields = clazz.getDeclaredFields()) {
                DgLabelStrategyRuleReqDto.SpecialList specialList;
                String name = field.getName();
                field.setAccessible(true);
                CisStrategyLabelTypeEnum cisStrategyLabelTypeEnum = (CisStrategyLabelTypeEnum)keyMap.get(name);
                if (!Objects.nonNull(cisStrategyLabelTypeEnum)) continue;
                String code = cisStrategyLabelTypeEnum.getCode();
                String desc = cisStrategyLabelTypeEnum.getDesc();
                if (cisStrategyLabelTypeEnum.getType().equals("list") && Objects.nonNull(specialList = (DgLabelStrategyRuleReqDto.SpecialList)field.get(addReqDto))) {
                    this.extractedConfigList(dgStrategyRuleEo, confItemEoList, strategyConfItemSuitEoList, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, code, desc);
                }
                if (cisStrategyLabelTypeEnum.getType().equals("time_range") && Objects.nonNull(specialList = (DgLabelStrategyRuleReqDto.SpecialTimeRange)field.get(addReqDto))) {
                    this.extractedInsertConfigContent(dgStrategyRuleEo, confItemEoList, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, code, desc);
                }
                if (cisStrategyLabelTypeEnum.getType().equals("amount_range") && Objects.nonNull(specialList = (DgLabelStrategyRuleReqDto.SpecialAmountRange)field.get(addReqDto))) {
                    this.extractedInsertConfigContent(dgStrategyRuleEo, confItemEoList, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, code, desc);
                }
                if (cisStrategyLabelTypeEnum.getType().equals("remark") && Objects.nonNull(specialList = (DgLabelStrategyRuleReqDto.ActionRemark)field.get(addReqDto))) {
                    this.extractedInsertConfigContent(dgStrategyRuleEo, confItemEoList, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, code, desc);
                }
                if (!cisStrategyLabelTypeEnum.getType().equals("string") || !Objects.nonNull(specialList = (DgLabelStrategyRuleReqDto.SpecialString)field.get(addReqDto))) continue;
                this.extractedInsertConfigContent(dgStrategyRuleEo, confItemEoList, (DgLabelStrategyRuleReqDto.SpecialStrategy)specialList, code, desc);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void extractedConfigList(DgStrategyRuleEo dgStrategyRuleEo, List<StrategyConfItemEo> confItemEoList, List<StrategyConfItemSuitEo> strategyConfItemSuitEoList, DgLabelStrategyRuleReqDto.SpecialStrategy specialChannel, String specialChannelCode, String specialChannelDesc) {
        if (Objects.nonNull(specialChannel)) {
            List codeList = specialChannel.getCodeList();
            StrategyConfItemEo specialWarehouseConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)specialWarehouseConfEo, (Object)specialChannel, (String[])new String[0]);
            specialWarehouseConfEo.setRuleId(dgStrategyRuleEo.getId());
            specialWarehouseConfEo.setStrategyType(specialChannelCode);
            specialWarehouseConfEo.setStrategyTypeName(specialChannelDesc);
            specialWarehouseConfEo.setMd5(MD5Util.getMd5ByString((String)specialChannel.getMD5Content()));
            confItemEoList.add(specialWarehouseConfEo);
            if (CollectionUtils.isNotEmpty((Collection)codeList)) {
                for (String warehouseCode : codeList) {
                    StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
                    confItemSuitEo.setRuleId(dgStrategyRuleEo.getId());
                    confItemSuitEo.setSuitType(specialChannelCode);
                    confItemSuitEo.setSuitValue(warehouseCode);
                    confItemSuitEo.setSuitMatchCode(specialChannelCode + "_" + warehouseCode);
                    strategyConfItemSuitEoList.add(confItemSuitEo);
                }
            }
        }
    }

    private void extractedInsertConfigContent(DgStrategyRuleEo dgStrategyRuleEo, List<StrategyConfItemEo> confItemEoList, DgLabelStrategyRuleReqDto.SpecialStrategy specialFreight, String code, String desc) {
        StrategyConfItemEo delayAuditConfEo = new StrategyConfItemEo();
        CubeBeanUtils.copyProperties((Object)delayAuditConfEo, (Object)specialFreight, (String[])new String[0]);
        delayAuditConfEo.setContent(specialFreight.getContent());
        delayAuditConfEo.setRuleId(dgStrategyRuleEo.getId());
        delayAuditConfEo.setMd5(MD5Util.getMd5ByString((String)specialFreight.getMD5Content()));
        delayAuditConfEo.setStrategyType(code);
        delayAuditConfEo.setStrategyTypeName(desc);
        confItemEoList.add(delayAuditConfEo);
    }

    @Override
    public DgLabelStrategyRuleRestDto queryLabelStrategyById(Long id) {
        LambdaQueryWrapper queryStrategyRuleEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyRuleEo.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)id);
        DgStrategyRuleEo dgStrategyRuleEo = this.strategyRuleDas.getOne(queryStrategyRuleEo);
        AssertUtils.notNull((Object)dgStrategyRuleEo, (String)"\u7b56\u7565\u4e0d\u5b58\u5728");
        DgLabelStrategyRuleRestDto labelRuleRespDto = new DgLabelStrategyRuleRestDto();
        CubeBeanUtils.copyProperties((Object)labelRuleRespDto, (Object)dgStrategyRuleEo, (String[])new String[0]);
        this.getStrategyConfItems(id, labelRuleRespDto);
        return labelRuleRespDto;
    }

    private void getStrategyConfItems(Long id, DgLabelStrategyRuleRestDto labelRuleRespDto) {
        LambdaQueryWrapper queryStrategyConfItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getRuleId, (Object)id);
        List strategyConfItemEoList = this.strategyConfItemDas.list(queryStrategyConfItemEo);
        AssertUtils.notEmpty((Collection)strategyConfItemEoList, (String)"\u7b56\u7565\u914d\u7f6e\u9879\u4e3a\u7a7a");
        LambdaQueryWrapper queryStrategyConfItemSuitEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemSuitEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemSuitEo::getRuleId, (Object)id);
        List strategyConfItemSuitEoList = this.strategyConfItemSuitDas.list(queryStrategyConfItemSuitEo);
        Map<String, List<StrategyConfItemSuitEo>> strategyConfItemSuitMap = Optional.ofNullable(strategyConfItemSuitEoList).orElseGet(Collections::emptyList).stream().collect(Collectors.groupingBy(StrategyConfItemSuitEo::getSuitType));
        Class<?> aClass = labelRuleRespDto.getClass();
        strategyConfItemEoList.forEach(strategyConfItemEo -> {
            switch (CisStrategyContentTypeEnum.forCode((String)strategyConfItemEo.getContentType())) {
                case LIST: {
                    DgLabelStrategyRuleRestDto.SpecialList specialList = new DgLabelStrategyRuleRestDto.SpecialList();
                    List collectItemSuitCode = Optional.ofNullable(strategyConfItemSuitMap.get(strategyConfItemEo.getStrategyType())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                    CubeBeanUtils.copyProperties((Object)specialList, (Object)strategyConfItemEo, (String[])new String[0]);
                    specialList.setCodeList(collectItemSuitCode);
                    String fieldName = CisStrategyLabelTypeEnum.forCode((String)strategyConfItemEo.getStrategyType()).getName();
                    try {
                        Field declaredField = aClass.getDeclaredField(fieldName);
                        declaredField.setAccessible(true);
                        declaredField.set(labelRuleRespDto, specialList);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                case RANGE: {
                    DgLabelStrategyRuleRestDto.SpecialAmountRange specialAmountRange = new DgLabelStrategyRuleRestDto.SpecialAmountRange();
                    CubeBeanUtils.copyProperties((Object)specialAmountRange, (Object)strategyConfItemEo, (String[])new String[0]);
                    String content = strategyConfItemEo.getContent();
                    if (StringUtils.isNotBlank((CharSequence)content)) {
                        HashMap map = (HashMap)JSON.parseObject((String)content, HashMap.class);
                        specialAmountRange.setMinAmount(new BigDecimal(map.get("minAmount").toString()));
                        specialAmountRange.setMaxAmount(new BigDecimal(map.get("maxAmount").toString()));
                    }
                    try {
                        String specialAmountRangeFieldName = CisStrategyLabelTypeEnum.forCode((String)strategyConfItemEo.getStrategyType()).getName();
                        Field declaredField = aClass.getDeclaredField(specialAmountRangeFieldName);
                        declaredField.setAccessible(true);
                        declaredField.set(labelRuleRespDto, specialAmountRange);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                case TIME_RANGE: {
                    DgLabelStrategyRuleRestDto.SpecialTimeRange specialTimeRange = new DgLabelStrategyRuleRestDto.SpecialTimeRange();
                    CubeBeanUtils.copyProperties((Object)specialTimeRange, (Object)strategyConfItemEo, (String[])new String[0]);
                    String specialTimeRangeContent = strategyConfItemEo.getContent();
                    if (StringUtils.isNotBlank((CharSequence)specialTimeRangeContent)) {
                        HashMap map = (HashMap)JSON.parseObject((String)specialTimeRangeContent, HashMap.class);
                        specialTimeRange.setStartTime(DateUtil.parse((String)MapUtils.getString((Map)map, (Object)"startTime"), (String)"yyyy-MM-dd HH:mm:ss"));
                        specialTimeRange.setEndTime(DateUtil.parse((String)MapUtils.getString((Map)map, (Object)"endTime"), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    try {
                        String specialTimeRangeFieldName = CisStrategyLabelTypeEnum.forCode((String)strategyConfItemEo.getStrategyType()).getName();
                        Field declaredField = aClass.getDeclaredField(specialTimeRangeFieldName);
                        declaredField.setAccessible(true);
                        declaredField.set(labelRuleRespDto, specialTimeRange);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                case REMARK: {
                    DgLabelStrategyRuleRestDto.ActionRemark actionRemark = new DgLabelStrategyRuleRestDto.ActionRemark();
                    CubeBeanUtils.copyProperties((Object)actionRemark, (Object)strategyConfItemEo, (String[])new String[0]);
                    String actionRemarkContent = strategyConfItemEo.getContent();
                    if (StringUtils.isNotBlank((CharSequence)actionRemarkContent)) {
                        HashMap map = (HashMap)JSON.parseObject((String)actionRemarkContent, HashMap.class);
                        actionRemark.setRemarkType(MapUtils.getString((Map)map, (Object)"remarkType", (String)"0"));
                        actionRemark.setKeyWords(MapUtils.getString((Map)map, (Object)"keyWords"));
                    }
                    try {
                        String actionRemarkFieldName = CisStrategyLabelTypeEnum.forCode((String)strategyConfItemEo.getStrategyType()).getName();
                        Field declaredField = aClass.getDeclaredField(actionRemarkFieldName);
                        declaredField.setAccessible(true);
                        declaredField.set(labelRuleRespDto, actionRemark);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                case STRING: {
                    DgLabelStrategyRuleRestDto.SpecialString specialString = new DgLabelStrategyRuleRestDto.SpecialString();
                    CubeBeanUtils.copyProperties((Object)specialString, (Object)strategyConfItemEo, (String[])new String[0]);
                    String content1 = strategyConfItemEo.getContent();
                    if (StringUtils.isNotBlank((CharSequence)content1)) {
                        specialString.setContent(content1);
                    }
                    try {
                        String actionRemarkFieldName = CisStrategyLabelTypeEnum.forCode((String)strategyConfItemEo.getStrategyType()).getName();
                        Field declaredField = aClass.getDeclaredField(actionRemarkFieldName);
                        declaredField.setAccessible(true);
                        declaredField.set(labelRuleRespDto, specialString);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }
}

