/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.data.api.enums.DictEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SecondSaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import com.yunxi.dg.base.center.trade.action.tc.IDgTcMqMessageAction;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderDomain;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.proxy.data.api.IPcpDictProxy;
import com.yunxi.dg.base.center.trade.proxy.data.entity.DictDto;
import com.yunxi.dg.base.center.trade.service.tc.IAutoReceivedOrderService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderOptService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AutoReceivedOrderServiceImpl
implements IAutoReceivedOrderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoReceivedOrderServiceImpl.class);
    private static final Integer ONE_QUERY_LIMIT = 500;
    @Resource
    private IDgSaleOrderDomain dgSaleOrderDomain;
    @Resource
    private ISaleOrderOptService saleOrderOptService;
    @Resource
    private IPcpDictProxy pcpDictProxy;
    @Resource
    private IDgTcMqMessageAction dgTcMqMessageAction;

    @Override
    public void handleAutoReceiveTask() {
        DictEnum dictEnum = DictEnum.CONFIRM_RECEIPT;
        RestResponse dictDtoRestResponse = this.pcpDictProxy.queryByGroupCodeAndCode(dictEnum.getGroupCode(), dictEnum.getCode());
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)dictDtoRestResponse);
        AssertUtils.notNull((Object)dictDto, (String)"\u786e\u8ba4\u6536\u8d27\u7b56\u7565\u5c1a\u672a\u914d\u7f6e");
        LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7b7e\u6536]\u786e\u8ba4\u6536\u8d27\u7b56\u7565\u8bbe\u7f6e\u4e86\u8ba2\u5355\u5b8c\u6210{}\u5929\u540e\uff0c\u8ba2\u5355\u81ea\u52a8\u7b7e\u6536", (Object)dictDto.getValue());
        Integer autoReceiveDateNum = Integer.valueOf(dictDto.getValue());
        Date receiveDate = DateUtil.addDay((Date)DateUtil.parse((String)DateUtil.getCurrenDate()), (int)(-autoReceiveDateNum.intValue()));
        DgSaleOrderEo queryEo = new DgSaleOrderEo();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper((Object)queryEo);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(DgSaleOrderEo::getOrderStatus, (Object)SaleOrderStatusEnum.COMPLETE.getCode())).eq(DgSaleOrderEo::getSecondOrderStatus, (Object)SecondSaleOrderStatusEnum.ALL_OUT_DELIVERY.getCode())).le(DgSaleOrderEo::getDeliveryCompleteDate, (Object)receiveDate);
        int count = this.dgSaleOrderDomain.getMapper().selectCount((Wrapper)wrapper);
        if (count == 0) {
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7b7e\u6536]\u6ca1\u6709\u9700\u8981\u81ea\u52a8\u7b7e\u6536\u7684\u8ba2\u5355");
            return;
        }
        LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7b7e\u6536]\u9700\u8981\u8bbe\u7f6e\u81ea\u52a8\u7b7e\u6536\u7684\u4efb\u52a1\u6709{}\u6761", (Object)count);
        if (count > ONE_QUERY_LIMIT) {
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7b7e\u6536]\u5f00\u542f\u591a\u7ebf\u7a0b\u6267\u884c\u4efb\u52a1");
            this.doMutiTask(queryEo, count);
        } else {
            LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7b7e\u6536]\u5355\u7ebf\u7a0b\u5faa\u73af\u6267\u884c({})\u4efb\u52a1", (Object)count);
            this.changeSaleOrderStatus(queryEo, 0, ONE_QUERY_LIMIT);
        }
    }

    private void doMutiTask(DgSaleOrderEo queryEo, Integer count) {
        int taskNum = (int)Math.ceil((double)count.intValue() * 1.0 / (double)ONE_QUERY_LIMIT.intValue());
        LOGGER.info("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7b7e\u6536]\u5f00\u542f({})\u4e2a\u4efb\u52a1\u6267\u884c", (Object)taskNum);
        for (int i = 1; i < taskNum + 1; ++i) {
            Integer start = (i - 1) * ONE_QUERY_LIMIT;
            Integer pageNo = i;
            CompletableFuture.runAsync(() -> this.changeSaleOrderStatus(queryEo, pageNo, ONE_QUERY_LIMIT));
        }
    }

    private void changeSaleOrderStatus(DgSaleOrderEo queryEo, Integer pageNo, Integer pageSize) {
        List saleOrderEos = this.dgSaleOrderDomain.selectList((BaseEo)queryEo, pageNo, pageSize);
        for (DgSaleOrderEo saleOrderEo : saleOrderEos) {
            try {
                this.saleOrderOptService.confirmReceiptGoods(saleOrderEo.getId());
                SaleOrderReqDto saleOrderReqDto = new SaleOrderReqDto();
                CubeBeanUtils.copyProperties((Object)saleOrderReqDto, (Object)saleOrderEo, (String[])new String[0]);
                this.dgTcMqMessageAction.sendSaleOrderSignBroadcast(saleOrderReqDto);
            }
            catch (Exception e) {
                LOGGER.warn("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7b7e\u6536]\u4fee\u6539\u8ba2\u5355({})\u72b6\u6001\u4e3a\u5df2\u7b7e\u6536\u5931\u8d25\uff01", (Object)saleOrderEo.getSaleOrderNo());
                LOGGER.error("[\u5b9a\u65f6\u5668\u5904\u7406\u81ea\u52a8\u7b7e\u6536]{}", (Throwable)e);
            }
        }
    }
}

