/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderTagItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagItemRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderTagItemDomain;
import com.yunxi.dg.base.center.trade.eo.OrderTagItemEo;
import com.yunxi.dg.base.center.trade.service.tc.IOrderTagItemService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderTagItemServiceImpl
implements IOrderTagItemService {
    @Resource
    private IOrderTagItemDomain orderTagItemDomain;

    @Override
    public Long addOrderTagItem(OrderTagItemReqDto addReqDto) {
        OrderTagItemEo orderTagItemEo = new OrderTagItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orderTagItemEo);
        this.orderTagItemDomain.insert((BaseEo)orderTagItemEo);
        return orderTagItemEo.getId();
    }

    @Override
    public void modifyOrderTagItem(OrderTagItemReqDto modifyReqDto) {
        OrderTagItemEo orderTagItemEo = new OrderTagItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)orderTagItemEo);
        this.orderTagItemDomain.updateSelective((BaseEo)orderTagItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderTagItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderTagItemDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void removeOrderTagItemById(Long id) {
        this.orderTagItemDomain.logicDeleteById(Long.valueOf(id));
    }

    @Override
    public OrderTagItemRespDto queryById(Long id) {
        OrderTagItemEo orderTagItemEo = (OrderTagItemEo)this.orderTagItemDomain.selectByPrimaryKey(id);
        OrderTagItemRespDto orderTagItemRespDto = new OrderTagItemRespDto();
        DtoHelper.eo2Dto((BaseEo)orderTagItemEo, (BaseVo)orderTagItemRespDto);
        return orderTagItemRespDto;
    }

    @Override
    public PageInfo<OrderTagItemRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderTagItemReqDto orderTagItemReqDto = (OrderTagItemReqDto)JSON.parseObject((String)filter, OrderTagItemReqDto.class);
        OrderTagItemEo orderTagItemEo = new OrderTagItemEo();
        DtoHelper.dto2Eo((BaseVo)orderTagItemReqDto, (BaseEo)orderTagItemEo);
        PageInfo eoPageInfo = this.orderTagItemDomain.selectPage((BaseEo)orderTagItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrderTagItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<OrderTagItemRespDto> queryByParam(OrderTagItemReqDto orderTagItemReqDto) {
        List saleOrderEos;
        AssertUtils.notNull((Object)orderTagItemReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        if (Objects.nonNull(orderTagItemReqDto.getTagCode())) {
            queryWrapper.eq(OrderTagItemEo::getTagCode, (Object)orderTagItemReqDto.getTagCode());
        }
        if (Objects.nonNull(orderTagItemReqDto.getOrderId())) {
            queryWrapper.eq(OrderTagItemEo::getOrderId, (Object)orderTagItemReqDto.getOrderId());
        }
        if (CollectionUtils.isNotEmpty((Collection)orderTagItemReqDto.getOrderIds())) {
            queryWrapper.in(OrderTagItemEo::getOrderId, (Collection)orderTagItemReqDto.getOrderIds());
        }
        if (CollectionUtils.isEmpty((Collection)(saleOrderEos = this.orderTagItemDomain.getMapper().selectList((Wrapper)queryWrapper)))) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleOrderEos, (Collection)resultList, OrderTagItemRespDto.class);
        return resultList;
    }

    @Override
    public List<OrderTagItemRespDto> queryByOrderIds(List<Long> orderIds) {
        AssertUtils.notEmpty(orderIds, (String)"orderId\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(OrderTagItemEo::getOrderId, orderIds);
        List saleOrderEos = this.orderTagItemDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleOrderEos, (Collection)resultList, OrderTagItemRespDto.class);
        return resultList;
    }
}

