/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsPhysicsInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.pcp.ICsPcpInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsRelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.WarehouseAreaMappingTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryResultOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsRelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AllotTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.CodesCheckEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.GiftEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.LockStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.LockTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.NextOptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.OrderLabelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.OrderOptLabelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleAuditResultEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleAuditTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderAssignStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderLevelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderSourceEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleTransferTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SecondSaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SplitStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ArrangeShipmentEnterpriseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ArrangeWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BatchSplitOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CodesCheckReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CspUpdateEasOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ModifyLogicalWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderTagRecordAddBatchReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderTagRecordReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderCustomerAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SearchSourceReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitBatchItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitChildOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderByBatchReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderBySourceInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderStatusLogRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderCspRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemExtRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTradeMessageVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTransferOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.enums.StringCodeResultEum;
import com.dtyunxi.yundt.cube.center.trade.api.enums.UpdateOrderInventoryEnum;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.dto.inventory.CsLogicPreemptInventoryOperateReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.CsPcpInventoryExposedRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.CsTransferOrderComboReqDto;
import com.yunxi.dg.base.center.inventory.emums.CsPcpBusinessTypeEnum;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutResultOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutResultOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.request.CsLogisticsInfoReqDto;
import com.yunxi.dg.base.center.report.dto.response.CsLogisticsInfoRespDto;
import com.yunxi.dg.base.center.report.proxy.inventory.ICsLogisticsInfoQueryApiProxy;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgOutResultOrderApiProxy;
import com.yunxi.dg.base.center.source.dto.dto.DistributionClueActRespDto;
import com.yunxi.dg.base.center.source.dto.dto.DistributionClueSuitActReqDto;
import com.yunxi.dg.base.center.source.dto.enmu.EnableEnum;
import com.yunxi.dg.base.center.source.dto.enmu.SourceLinkOrderTypeEnum;
import com.yunxi.dg.base.center.source.dto.enmu.SourceStatusEnum;
import com.yunxi.dg.base.center.source.dto.extend.OrderAddrReqDto;
import com.yunxi.dg.base.center.source.dto.extend.OrderItemReqDto;
import com.yunxi.dg.base.center.source.dto.extend.OrderItemResultRespDto;
import com.yunxi.dg.base.center.source.dto.extend.SaleOrderOldBatchMatchReqDto;
import com.yunxi.dg.base.center.source.dto.extend.SourceOrderResultReqDto;
import com.yunxi.dg.base.center.source.dto.extend.SourceOrderResultRespDto;
import com.yunxi.dg.base.center.source.proxy.option.IDistributionClueQueryApiProxy;
import com.yunxi.dg.base.center.source.proxy.option.IOrderOptApiProxy;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.baseservice.BInventoryApiServcie;
import com.yunxi.dg.base.center.trade.cache.CacheWrapper;
import com.yunxi.dg.base.center.trade.cache.SaleIntransitCache;
import com.yunxi.dg.base.center.trade.cache.SplitLevelRedisUtils;
import com.yunxi.dg.base.center.trade.dao.das.impl.SaleTransferOrderDasImpl;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.ISaleTransferExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.event.CreateOrderBySplitEvent;
import com.yunxi.dg.base.center.trade.domain.order.event.CreateOrderBySplitNewEvent;
import com.yunxi.dg.base.center.trade.domain.order.event.SaleOrderRemoveLogicalEvent;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.SaleTransferOrderEo;
import com.yunxi.dg.base.center.trade.service.tc.ICspService;
import com.yunxi.dg.base.center.trade.service.tc.IEasService;
import com.yunxi.dg.base.center.trade.service.tc.IExternalNoticeService;
import com.yunxi.dg.base.center.trade.service.tc.IOrderLabelRecordService;
import com.yunxi.dg.base.center.trade.service.tc.IOrderLabelService;
import com.yunxi.dg.base.center.trade.service.tc.IOrderTagRecordService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderAddrService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderAuditService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderOptService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleRefundService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleTransferOrderService;
import com.yunxi.dg.base.center.trade.service.tc.ISourceRecordService;
import com.yunxi.dg.base.center.trade.service.tc.ISplitSaleOrderService;
import com.yunxi.dg.base.center.trade.service.tc.IStrategyAutoCheckOrderService;
import com.yunxi.dg.base.center.trade.service.tc.impl.AbstractSaleOrderService;
import com.yunxi.dg.base.center.trade.track.enums.OrderOperationTypeEnum;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.OrderOptLabelUtils;
import com.yunxi.dg.base.center.trade.utils.TrackOptLogUtils;
import com.yunxi.dg.base.center.trade.vo.ModifyLogicalWarehouseContext;
import com.yunxi.dg.base.center.trade.vo.StatemachineRestOrderRespDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class SaleOrderOptServiceImpl
extends AbstractSaleOrderService
implements ISaleOrderOptService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String EMPTY = "";
    private static final List<String> deliveryStatusList = Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.COMPLETE.getCode(), SaleOrderStatusEnum.RECEIVED.getCode(), SaleOrderStatusEnum.WAIT_DELIVERY.getCode()});
    @Autowired
    private ApplicationEventPublisher publisher;
    @Resource
    private IDgSaleOrderDomain dgSaleOrderDomain;
    @Resource
    private IDgSaleOrderItemDomain dgSaleOrderItemDomain;
    @Resource
    private ISaleOrderService saleOrderService;
    @Resource
    private ICsPcpInventoryExposedApi inventoryExposedApi;
    @Resource
    private IDgSaleOrderAddrDomain dgSaleOrderAddrDomain;
    @Resource
    private ICsPhysicsInventoryExposedApi physicsInventoryExposedApi;
    @Resource
    private IStrategyAutoCheckOrderService strategyAutoCheckOrderService;
    @Resource
    private ISaleOrderItemService saleOrderItemService;
    @Resource
    private ISaleOrderAddrService saleOrderAddrService;
    @Resource
    private IOrderOptApiProxy orderOptApiProxy;
    @Resource
    private ICsInventoryExposedQueryApi inventoryExposedQueryApi;
    @Resource
    private ICsLogicWarehouseQueryApi logicWarehouseExposedQueryApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ISourceRecordService sourceRecordService;
    @Resource
    private ISaleOrderAuditService saleOrderAuditService;
    @Resource
    private BInventoryApiServcie inventoryApiServcie;
    @Resource
    private CacheWrapper cacheWrapper;
    @Resource
    private ISplitSaleOrderService splitSaleOrderService;
    @Resource
    private IOrderLabelService orderLabelService;
    @Resource
    private IOrderLabelRecordService orderLabelRecordService;
    @Resource
    private IEasService easService;
    @Resource
    private ICspService cspService;
    @Resource
    private IExternalNoticeService externalNoticeService;
    @Resource
    private IChannelInventoryExposedApi sharedChannelInventoryExposedApi;
    @Resource
    private ICsDeliveryResultOrderQueryApi csDeliveryResultOrderQueryApi;
    @Resource
    private IChannelWarehouseApi channelWarehouseQueryApi;
    @Resource
    private ICsRelWarehouseApi csRelWarehouseQueryApi;
    @Resource
    private BInventoryApiServcie bInventoryApiServcie;
    @Resource
    private IOrderTagRecordService orderTagRecordService;
    @Autowired
    private IVirtualWarehouseApi virtualWarehouseQueryApi;
    @Resource
    private ISaleTransferOrderService saleTransferOrderService;
    @Resource
    private SaleIntransitCache saleIntransitCache;
    @Resource
    private IDistributionClueQueryApiProxy distributionClueQueryApiProxy;
    @Resource
    private ISaleTransferExtDomain saleTransferExtDomain;
    @Resource
    private SplitLevelRedisUtils splitLevelRedisUtils;
    @Resource
    private ICsLogisticsInfoQueryApiProxy csLogisticsInfoQueryApiProxy;
    @Resource
    private IDgOutResultOrderApiProxy dgOutResultOrderApiProxy;
    @Resource
    private ISaleRefundService saleRefundService;
    private static final List<String> orderTypeList = Lists.newArrayList((Object[])new String[]{SaleOrderTypeEnum.REPLENISHMENT_ORDER.getType(), SaleOrderTypeEnum.ACTIVITY_ORDER.getType(), SaleOrderTypeEnum.NUTRITION_INTEGRAL.getType(), SaleOrderTypeEnum.CUSTOMER_REFUNDING_ORDER.getType(), SaleOrderTypeEnum.REPLENISH_ORDER.getType(), SaleOrderTypeEnum.OTHER_OUT_STOCK.getType(), SaleOrderTypeEnum.QUALITY_REFUNDING_ORDER.getType()});
    @Autowired
    private SaleTransferOrderDasImpl saleTransferOrderDasImpl;
    private static final ExecutorService executorService = new ThreadPoolExecutor(2, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    private static final ExecutorService executorYyjService = new ThreadPoolExecutor(2, 4, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    protected IBaseDomain<DgSaleOrderEo> baseDas() {
        return this.dgSaleOrderDomain;
    }

    @Override
    protected CacheWrapper cacheWrapper() {
        return this.cacheWrapper;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public Boolean checkOrder(Long orderId) {
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoId(orderId);
        this.checkSaleOrderStatus((SaleOrderStatus)SaleOrderStatusEnum.forCode((String)saleOrderEo.getOrderStatus()), new SaleOrderStatus[]{SaleOrderStatusEnum.WAIT_CHECK});
        if (Objects.equals(saleOrderEo.getOrderBizType(), SaleOrderBizTypeEnum.FINANCIAL_FRONT.getType())) {
            // empty if block
        }
        LambdaQueryWrapper queryItem = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItem.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId);
        List orderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItem);
        AssertUtils.notEmpty((Collection)orderItemEos, (String)String.format("[\u9500\u552e\u8ba2\u5355\u786e\u8ba4]orderId\u4e3a%s\u7684\u8ba2\u5355\u5b58\u5728\u5f02\u5e38\uff0c\u5546\u54c1\u8be6\u60c5\u6570\u636e\u4e3a\u7a7a\uff01", orderId));
        if (Objects.equals(saleOrderEo.getReleaseState(), YesOrNoEnum.YES.getType())) {
            this.logger.info("\u8ba2\u5355\u524d\u7f6e\u5df2\u9884\u5360\u5e93\u5b58\uff0c\u4e0d\u91cd\u590d\u9884\u5360\u6e20\u9053\u5e93\u5b58");
            this.strategyAutoCheckOrderService.updateStrategyAutoCheckOrderTime(orderId);
        }
        this.updateOrderWaitPick(orderId, saleOrderEo);
        return Boolean.TRUE;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public Boolean arrangeWarehouseForDeliver(Long orderId, List<ArrangeWarehouseReqDto> reqDtoList, Consumer<ArrangeWarehouseReqDto> complete) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty(reqDtoList, (String)"reqDtoList \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ArrangeWarehouseReqDto arrangeWarehouseReqDto = reqDtoList.get(0);
        Integer negativeValidate = arrangeWarehouseReqDto.getNegativeValidate();
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoById(orderId);
        AssertUtils.notNull((Object)arrangeWarehouseReqDto.getOrderItemId(), (String)"\u8ba2\u5355\u5546\u54c1\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        if (Objects.equals(negativeValidate, YesOrNoEnum.YES.getType())) {
            Collections.sort(reqDtoList, Comparator.comparing(ArrangeWarehouseReqDto::getOrderItemId));
            for (int i = 0; i < reqDtoList.size(); ++i) {
                ArrangeWarehouseReqDto orderItem = reqDtoList.get(i);
                DgSaleOrderItemEo updateItem = new DgSaleOrderItemEo();
                updateItem.setId(orderItem.getOrderItemId());
                updateItem.setBatchNo(orderItem.getBatchNo());
                updateItem.setLogicalWarehouseName(orderItem.getLogicalWarehouseName());
                updateItem.setLogicalWarehouseId(orderItem.getLogicalWarehouseId() != null ? orderItem.getLogicalWarehouseId() : null);
                updateItem.setLogicalWarehouseCode(orderItem.getLogicalWarehouseCode());
                int updateSelective = this.dgSaleOrderItemDomain.updateSelective((BaseEo)updateItem);
                if (updateSelective == 1) continue;
                this.logger.warn("[\u6307\u5b9a\u4ed3\u5e93\u53d1\u8d27]\u6307\u5b9a\u7684\u8ba2\u5355\u5546\u54c1\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5tr_order_item\u8868\u4e2did={}\u7684\u6570\u636e\u662f\u5426\u5b58\u5728\u5f02\u5e38\uff0c\u5f71\u54cd\u7684\u6570\u636e\u6761\u6570\u4e3a\uff1a{}", (Object)orderItem.getOrderItemId(), (Object)updateSelective);
                throw PcpTradeExceptionCode.ORDER_ITEM_EXCEPTION.builderException();
            }
        }
        this.logger.info("[\u6307\u5b9a\u4ed3\u5e93\u53d1\u8d27]\u9500\u552e\uff08orderId={}\uff09\u72b6\u6001\u4fee\u6539\u4e3a\u5df2\u9501\u5b9a\u5f85\u6307\u6d3e", (Object)saleOrderEo.getId());
        this.saleOrderService.removeLabel(saleOrderEo.getId(), saleOrderEo.getOptLabel(), OrderOptLabelEnum.APPOINT_BATCH.getCode(), OrderOptLabelEnum.MODIFY_LOGICAL_WAREHOUSE.getCode(), OrderOptLabelEnum.UN_LOCK.getCode());
        if (complete != null) {
            complete.accept(arrangeWarehouseReqDto);
        }
        this.processYphTagForSplitOrders(saleOrderEo.getSaleOrderNo(), new ArrayList<BizSaleOrderRespDto>());
        return Boolean.TRUE;
    }

    @Override
    public void arrangeWarehouse(Long orderId, ArrangeWarehouseReqDto reqDto) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto, (String)"reqDto \u4e0d\u80fd\u4e3a\u7a7a");
        List<SaleOrderItemRespDto> saleOrderItemRespDtos = this.saleOrderItemService.queryOrderItemByOrderId(orderId);
        AssertUtils.notEmpty(saleOrderItemRespDtos, (String)"\u8ba2\u5355\uff08%s\uff09\u5546\u54c1\u4e0d\u5b58\u5728", (Object[])new Object[]{orderId});
        Collections.sort(saleOrderItemRespDtos, Comparator.comparing(SaleOrderItemRespDto::getId));
        for (int i = 0; i < saleOrderItemRespDtos.size(); ++i) {
            SaleOrderItemRespDto orderItem = saleOrderItemRespDtos.get(i);
            DgSaleOrderItemEo updateItem = new DgSaleOrderItemEo();
            updateItem.setId(orderItem.getId());
            updateItem.setLogicalWarehouseName(reqDto.getLogicalWarehouseName());
            updateItem.setLogicalWarehouseId((Long)Optional.ofNullable(reqDto.getLogicalWarehouseId()).orElse(null));
            updateItem.setLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
            int updateSelective = this.dgSaleOrderItemDomain.updateSelective((BaseEo)updateItem);
            if (updateSelective == 1) continue;
            this.logger.warn("[\u6307\u5b9a\u53d1\u8d27\u4ed3\u5e93]\u6307\u5b9a\u7684\u8ba2\u5355\u5546\u54c1\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5tr_order_item\u8868\u4e2did={}\u7684\u6570\u636e\u662f\u5426\u5b58\u5728\u5f02\u5e38\uff0c\u5f71\u54cd\u7684\u6570\u636e\u6761\u6570\u4e3a\uff1a{}", (Object)reqDto.getOrderItemId(), (Object)updateSelective);
            throw PcpTradeExceptionCode.ORDER_ITEM_EXCEPTION.builderException();
        }
        SaleOrderReqDto saleOrderReqDto = new SaleOrderReqDto();
        saleOrderReqDto.setId(orderId);
        saleOrderReqDto.setLogicalWarehouseId(reqDto.getLogicalWarehouseId());
        saleOrderReqDto.setLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
        saleOrderReqDto.setLogicalWarehouseName(reqDto.getLogicalWarehouseName());
        saleOrderReqDto.setDeliveryLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
        this.saleOrderService.modifySaleOrder(saleOrderReqDto);
        this.logger.info("[\u4fee\u6539\u6307\u5b9a\u53d1\u8d27\u4ed3]\u8ba2\u5355={}\u4fee\u6539\u6307\u5b9a\u53d1\u8d27\u4ed3\u6210\u529f\uff0c\u4fee\u6539\u7684\u4ed3\u5e93\u4fe1\u606f\u4e3a\uff1a{}", (Object)orderId, (Object)JSON.toJSONString((Object)reqDto));
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public Boolean arrangeWarehouseByAppoint(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId);
        List saleOrderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        AssertUtils.notEmpty((Collection)saleOrderItemEos, (String)String.format("orderId=%s\u7684\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01", orderId));
        ArrayList reqDtoList = Lists.newArrayList();
        saleOrderItemEos.forEach(saleOrderItemEo -> {
            ArrangeWarehouseReqDto arrangeWarehouseReqDto = new ArrangeWarehouseReqDto();
            arrangeWarehouseReqDto.setLogicalWarehouseId(saleOrderItemEo.getLogicalWarehouseId());
            arrangeWarehouseReqDto.setLogicalWarehouseCode(saleOrderItemEo.getLogicalWarehouseCode());
            arrangeWarehouseReqDto.setLogicalWarehouseName(saleOrderItemEo.getLogicalWarehouseName());
            arrangeWarehouseReqDto.setBatchNo(saleOrderItemEo.getDeliveryItemBatchNo());
            arrangeWarehouseReqDto.setOrderId(saleOrderItemEo.getOrderId());
            arrangeWarehouseReqDto.setOrderItemId(saleOrderItemEo.getId());
            reqDtoList.add(arrangeWarehouseReqDto);
        });
        this.logger.info("[\u6307\u5b9a\u6279\u6b21\u53d1\u8d27]\u6307\u5b9a\u6279\u6b21\u53d1\u8d27\u914d\u8d27\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqDtoList));
        return this.arrangeWarehouseForDeliver(orderId, reqDtoList, arrangeWarehouseReqDto -> {
            DgSaleOrderEo updateStatusEo = new DgSaleOrderEo();
            updateStatusEo.setLogicalWarehouseName(arrangeWarehouseReqDto.getLogicalWarehouseName());
            updateStatusEo.setLogicalWarehouseId(arrangeWarehouseReqDto.getLogicalWarehouseId());
            updateStatusEo.setLogicalWarehouseCode(arrangeWarehouseReqDto.getLogicalWarehouseCode());
            updateStatusEo.setInterceptInfo(EMPTY);
            updateStatusEo.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
            CsRelWarehouseRespDto physicsWarehouseByLogic = this.getPhysicsWarehouseByLogic(arrangeWarehouseReqDto.getLogicalWarehouseCode());
            if (Objects.nonNull(physicsWarehouseByLogic)) {
                updateStatusEo.setPhysicsWarehouseCode(physicsWarehouseByLogic.getRefWarehouseCode());
                updateStatusEo.setPhysicsWarehouseId(Long.valueOf(physicsWarehouseByLogic.getRefWarehouseId()));
                updateStatusEo.setPhysicsWarehouseName(physicsWarehouseByLogic.getRefWarehouseName());
            }
            this.optimisticSaleOrderChildStatus(updateStatusEo, orderId, SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK);
            this.orderTagRecordService.delLjddTagByOrder(orderId);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public Boolean autoArrangeWarehouseBySource(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)((ExtQueryChainWrapper)this.dgSaleOrderDomain.filter().eq((Object)"id", (Object)orderId)).one();
        if (!Objects.equals(SaleOrderStatusEnum.WAIT_PICK.getCode(), saleOrderEo.getOrderStatus())) {
            this.logger.info("\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5f85\u914d\u8d27\uff0c\u4e0d\u53ef\u64cd\u4f5c");
            return Boolean.FALSE;
        }
        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getSecondOrderStatus()) && !Objects.equals(SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK.getCode(), saleOrderEo.getSecondOrderStatus())) {
            this.logger.info("\u8ba2\u5355\u5b50\u72b6\u6001\u4e0d\u662f\u5f85\u914d\u8d27\u672a\u9501\u5b9a\uff0c\u4e0d\u53ef\u64cd\u4f5c");
            return Boolean.FALSE;
        }
        SearchSourceReqDto searchSourceReqDto = new SearchSourceReqDto();
        searchSourceReqDto.setSaleOrderNo(saleOrderEo.getSaleOrderNo());
        this.searchSourceForDeliver(searchSourceReqDto);
        return Boolean.TRUE;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public Boolean confirmReceiptGoods(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoById(orderId);
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId);
        List saleOrderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        AssertUtils.notEmpty((Collection)saleOrderItemEos, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        Date actualArrivalTime = new Date();
        if (!Objects.equals(saleOrderEo.getOrderType(), SaleOrderTypeEnum.MAIYOU_ALLOT.getType())) {
            DgOutResultOrderPageReqDto csOutResultOrderQueryDto = new DgOutResultOrderPageReqDto();
            csOutResultOrderQueryDto.setRelevanceNo(saleOrderEo.getSaleOrderNo());
            csOutResultOrderQueryDto.setPageNum(Integer.valueOf(1));
            csOutResultOrderQueryDto.setPageSize(Integer.valueOf(10));
            PageInfo dgOutResultOrderDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgOutResultOrderApiProxy.page(csOutResultOrderQueryDto));
            AssertUtils.notEmpty((Collection)dgOutResultOrderDtoPageInfo.getList(), (String)"\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u7ed3\u679c\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            String consignmentNo = ((DgOutResultOrderDto)dgOutResultOrderDtoPageInfo.getList().get(0)).getConsignmentNo();
            AssertUtils.notEmpty((String)consignmentNo, (String)"\u9500\u552e\u8ba2\u5355\u6258\u8fd0\u5355\u53f7\u4fe1\u606f\u4e0d\u5b58\u5728");
            CsLogisticsInfoReqDto csLogisticsInfoReqDto = new CsLogisticsInfoReqDto();
            csLogisticsInfoReqDto.setConsignmentNo(consignmentNo);
            csLogisticsInfoReqDto.setStatus("4");
            PageInfo csLogisticsInfoRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLogisticsInfoQueryApiProxy.queryByPage(csLogisticsInfoReqDto));
            this.logger.info("\u9500\u552e\u5355\u7b7e\u6536\u6839\u636e\u6258\u8fd0\u5355\u53f7\u67e5\u8be2\u7269\u6d41\u4fe1\u606f={}", JSON.toJSON((Object)csLogisticsInfoRespDtoPageInfo));
            AssertUtils.notEmpty((Collection)csLogisticsInfoRespDtoPageInfo.getList(), (String)"\u6258\u8fd0\u5355\u672a\u7b7e\u6536");
            List csLogisticsInfoRespDtos = csLogisticsInfoRespDtoPageInfo.getList().stream().filter(dto -> Objects.nonNull(dto.getActualArrivalTime())).collect(Collectors.toList());
            AssertUtils.notEmpty(csLogisticsInfoRespDtos, (String)("\u6258\u8fd0\u5355[" + consignmentNo + "]\u7b7e\u6536\u65f6\u95f4\u4e3a\u7a7a"));
            actualArrivalTime = ((CsLogisticsInfoRespDto)csLogisticsInfoRespDtos.get(0)).getActualArrivalTime();
            AssertUtils.notNull((Object)actualArrivalTime, (String)("\u6258\u8fd0\u5355[" + consignmentNo + "]\u7b7e\u6536\u65f6\u95f4\u4e3a\u7a7a"));
        }
        BigDecimal totalOutDeliveryCount = saleOrderItemEos.stream().filter(Objects::nonNull).filter(eo -> Objects.nonNull(eo.getOutItemNum())).map(DgSaleOrderItemEo::getOutItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.logger.info("\u786e\u8ba4\u6536\u8d27");
        if (!(SaleOrderStatusEnum.COMPLETE.getCode().equals(saleOrderEo.getOrderStatus()) && SecondSaleOrderStatusEnum.ALL_OUT_DELIVERY.getCode().equals(saleOrderEo.getSecondOrderStatus()) && saleOrderEo.getGoodsTotalNum().equals(totalOutDeliveryCount))) {
            this.logger.info("[\u786e\u8ba4\u6536\u8d27]\u5546\u54c1\u51fa\u5e93\u603b\u6570\u4e3a\uff1a{}, \u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)totalOutDeliveryCount, (Object)JSON.toJSONString((Object)saleOrderEo));
            throw PcpTradeExceptionCode.CANNOT_CONFIRM_RECEIPT.builderException();
        }
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setOrderStatus(SaleOrderStatusEnum.RECEIVED.getCode());
        updateEo.setConfirmReceiveTime(actualArrivalTime);
        updateEo.setInterceptInfo(EMPTY);
        this.optimisticSaleOrderStatus(updateEo, orderId, SaleOrderStatusEnum.COMPLETE);
        this.logger.info("[\u786e\u8ba4\u6536\u8d27][\u786e\u8ba4\u6536\u8d27]\u8ba2\u5355{}\u7b7e\u6536\u6210\u529f", (Object)saleOrderEo.getSaleOrderNo());
        return Boolean.TRUE;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public Boolean confirmSignGoods(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoById(orderId);
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId);
        List saleOrderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        AssertUtils.notEmpty((Collection)saleOrderItemEos, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        BigDecimal totalOutDeliveryCount = saleOrderItemEos.stream().map(DgSaleOrderItemEo::getOutItemNum).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (saleOrderEo.getGoodsTotalNum().compareTo(totalOutDeliveryCount) == 0) {
            DgSaleOrderEo updateEo = new DgSaleOrderEo();
            updateEo.setConfirmReceiveTime(new Date());
            this.updateSaleOrderById(orderId, updateEo);
            this.logger.info("[\u786e\u8ba4\u6536\u8d27][\u786e\u8ba4\u6536\u8d27]\u8ba2\u5355({})\u7b7e\u6536\u6210\u529f", (Object)saleOrderEo.getSaleOrderNo());
            return Boolean.TRUE;
        }
        this.logger.info("[\u786e\u8ba4\u6536\u8d27]\u5546\u54c1\u51fa\u5e93\u603b\u6570\u4e3a\uff1a{}, \u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)totalOutDeliveryCount, (Object)JSON.toJSONString((Object)saleOrderEo));
        throw PcpTradeExceptionCode.CANNOT_CONFIRM_RECEIPT.builderException();
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public Boolean continueDeliver(Long orderId) {
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoById(orderId);
        RestResponse restResponse = this.physicsInventoryExposedApi.continueDelivery(saleOrderEo.getSaleOrderNo());
        Boolean result = (Boolean)RestResponseHelper.extractData((RestResponse)restResponse);
        this.logger.info("\u6839\u636e\u8ba2\u5355\u53f7\u8fdb\u884c\u7ee7\u7eed\u53d1\u8d27,\u751f\u6210\u51fa\u5e93\u901a\u77e5\u5355={}", (Object)result);
        if (result.booleanValue()) {
            this.saleOrderService.removeLabel(saleOrderEo.getId(), saleOrderEo.getOptLabel(), OrderOptLabelEnum.CANCEL_APPOINT.getCode());
            this.saleOrderService.updateSaleOrderAssignStatus(saleOrderEo.getId(), SaleOrderAssignStatusEnum.ASSIGN_STATUS_1);
            return Boolean.TRUE;
        }
        this.saleOrderService.updateSaleOrderAssignStatus(saleOrderEo.getId(), SaleOrderAssignStatusEnum.ASSIGN_STATUS_2);
        return Boolean.FALSE;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#saleOrderEo.id")
    @Transactional(rollbackFor={Exception.class})
    public void updateOrderDelivery(Long orderId) {
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(orderId);
        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getSecondOrderStatus())) {
            this.checkSaleOrderStatus((SaleOrderStatus)SecondSaleOrderStatusEnum.forCode((String)saleOrderEo.getSecondOrderStatus()), new SaleOrderStatus[]{SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT});
        }
        DgSaleOrderEo updateStatusEo = new DgSaleOrderEo();
        updateStatusEo.setSecondOrderStatus(EMPTY);
        updateStatusEo.setPushOrderTime(new Date());
        updateStatusEo.setInterceptInfo(EMPTY);
        updateStatusEo.setAssignStatus(SaleOrderAssignStatusEnum.ASSIGN_STATUS_1.getCode());
        String newLabel = OrderOptLabelUtils.removeLabel(saleOrderEo.getOptLabel(), OrderOptLabelEnum.CANCEL_APPOINT.getCode());
        updateStatusEo.setOptLabel(newLabel);
        this.saleOrderService.updateSaleOrderById(saleOrderEo.getId(), updateStatusEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeLogicalWarehouse(ModifyLogicalWarehouseContext reqDto) {
        AssertUtils.notEmpty((Collection)reqDto.getOrderIdList(), (String)"orderIdList\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((String)reqDto.getLogicalWarehouseCode(), (String)"logicalWarehouseCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List orderIdList = reqDto.getOrderIdList();
        List<DgSaleOrderEo> saleOrderEoList = reqDto.getDgSaleOrderEos();
        this.checkChangeLogicalWarehouseStatus(saleOrderEoList);
        Map<String, CsLogicWarehouseRespDto> warehouseMap = reqDto.getLogicWarehouseWarehouseMap();
        if (!warehouseMap.containsKey(reqDto.getLogicalWarehouseCode())) {
            throw PcpTradeExceptionCode.WAREHOUSE_NOT_EXIT.buildBizException(new Object[]{"\u6240\u9009\u903b\u8f91\u4ed3\u5e93\u4e0d\u5b58\u5728"});
        }
        CsLogicWarehouseRespDto logicWarehousePageRespDto = warehouseMap.get(reqDto.getLogicalWarehouseCode());
        if (Objects.equals(logicWarehousePageRespDto.getWarehouseStatus(), CsValidFlagEnum.DISABLE.getCode())) {
            throw PcpTradeExceptionCode.WAREHOUSE_STATUS_DISABLE.buildBizException(new Object[]{logicWarehousePageRespDto.getWarehouseCode()});
        }
        Map<String, ChannelWarehouseRespDto> channelWarehouseMap = reqDto.getChannelWarehouseRespDtoMap();
        for (DgSaleOrderEo saleOrderEo : saleOrderEoList) {
            Object errorMsg;
            String defaultLogicalWarehouseCode;
            if (this.saleOrderService.isClaimOrder(saleOrderEo.getOrderType())) {
                this.logger.info("[\u7d22\u8d54\u8ba2\u5355]\uff0c\u4e0d\u6821\u9a8c");
                continue;
            }
            if (channelWarehouseMap.isEmpty() || !channelWarehouseMap.containsKey(saleOrderEo.getChannelWarehouseCode())) {
                String errorMsg2 = "\u8ba2\u5355:" + saleOrderEo.getSaleOrderNo() + "\u6e20\u9053\u4ed3\u4fe1\u606f\u4e3a\u7a7a";
                throw PcpTradeExceptionCode.WAREHOUSE_NOT_EXIT.buildBizException(new Object[]{errorMsg2});
            }
            if (StringUtils.isNotEmpty((CharSequence)saleOrderEo.getDefaultLogicalWarehouseCode()) && !warehouseMap.containsKey(defaultLogicalWarehouseCode = saleOrderEo.getDefaultLogicalWarehouseCode())) {
                errorMsg = "\u8ba2\u5355:" + saleOrderEo.getSaleOrderNo() + "\u9ed8\u8ba4\u76ee\u6807\u4ed3\u5e93:" + saleOrderEo.getDefaultLogicalWarehouseName() + "\u4e0d\u5b58\u5728";
                throw PcpTradeExceptionCode.WAREHOUSE_NOT_EXIT.buildBizException(new Object[]{errorMsg});
            }
            ChannelWarehouseRespDto csChannelWarehouseRespDto = channelWarehouseMap.get(saleOrderEo.getChannelWarehouseCode());
            errorMsg = Optional.ofNullable(csChannelWarehouseRespDto.getLogicWarehouseList()).orElse(Lists.newArrayList());
        }
        CsRelWarehouseRespDto physicsWarehouseByLogic = reqDto.getPhysicsWarehouseByLogic();
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setLogicalWarehouseId(reqDto.getLogicalWarehouseId());
        updateEo.setLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
        updateEo.setLogicalWarehouseName(logicWarehousePageRespDto.getWarehouseName());
        if (Objects.nonNull(physicsWarehouseByLogic)) {
            updateEo.setPhysicsWarehouseId(Long.valueOf(physicsWarehouseByLogic.getRefWarehouseId()));
            updateEo.setPhysicsWarehouseCode(physicsWarehouseByLogic.getRefWarehouseCode());
            updateEo.setPhysicsWarehouseName(physicsWarehouseByLogic.getRefWarehouseName());
        }
        reqDto.getOrderIdList().forEach(id -> this.updateSaleOrderById((Long)id, updateEo));
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).in(DgSaleOrderItemEo::getOrderId, (Collection)orderIdList);
        List saleOrderItemEoList = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        AssertUtils.notEmpty((Collection)saleOrderItemEoList, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        Collections.sort(saleOrderItemEoList, Comparator.comparing(BaseEo::getId));
        saleOrderItemEoList.forEach(saleOrderItemEo -> {
            DgSaleOrderItemEo updateItemEo = new DgSaleOrderItemEo();
            updateItemEo.setId(saleOrderItemEo.getId());
            updateItemEo.setLogicalWarehouseId(logicWarehousePageRespDto.getId());
            updateItemEo.setLogicalWarehouseCode(logicWarehousePageRespDto.getWarehouseCode());
            updateItemEo.setLogicalWarehouseName(logicWarehousePageRespDto.getWarehouseName());
            this.dgSaleOrderItemDomain.updateSelective((BaseEo)updateItemEo);
        });
        saleOrderEoList.forEach(e -> TrackOptLogUtils.addOrderTrackOptLog((Long)e.getId(), (String)("\u4fee\u6539\u6307\u5b9a\u7684\u903b\u8f91\u4ed3\uff1a\u3010" + e.getLogicalWarehouseName() + "\u3011\u4fee\u6539\u4e3a\u3010" + updateEo.getLogicalWarehouseName() + "\u3011")));
        this.markLabel(saleOrderEoList, OrderOptLabelEnum.MODIFY_LOGICAL_WAREHOUSE.getCode());
    }

    private void markLabel(List<DgSaleOrderEo> saleOrderEoList, String optLabel) {
        for (DgSaleOrderEo saleOrderEo : saleOrderEoList) {
            this.saleOrderService.markLabel(saleOrderEo.getId(), saleOrderEo.getOptLabel(), optLabel);
        }
    }

    private CsRelWarehouseRespDto getPhysicsWarehouseByLogic(String logicalWarehouseCode) {
        CsRelWarehouseQueryDto queryDto = new CsRelWarehouseQueryDto();
        queryDto.setWarehouseCode(logicalWarehouseCode);
        queryDto.setWarehouseClassify("logic");
        queryDto.setRefWarehouseClassify("physics");
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(1));
        this.logger.info("\u6307\u5b9a\u7684\u903b\u8f91\u4ed3\u67e5\u7269\u7406\u4ed3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDto));
        PageInfo csRelWarehouseRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csRelWarehouseQueryApi.queryByPage(queryDto));
        this.logger.info("\u6307\u5b9a\u7684\u903b\u8f91\u4ed3\u67e5\u7269\u7406\u4ed3\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)csRelWarehouseRespDtoPageInfo));
        if (CollectionUtils.isNotEmpty((Collection)csRelWarehouseRespDtoPageInfo.getList())) {
            return (CsRelWarehouseRespDto)csRelWarehouseRespDtoPageInfo.getList().get(0);
        }
        return null;
    }

    private void checkChangeLogicalWarehouseStatus(List<DgSaleOrderEo> saleOrderEoList) {
        for (DgSaleOrderEo saleOrderEo : saleOrderEoList) {
            this.checkSaleOrderStatus((SaleOrderStatus)SaleOrderStatusEnum.forCode((String)saleOrderEo.getOrderStatus()), new SaleOrderStatus[]{SaleOrderStatusEnum.WAIT_CHECK, SaleOrderStatusEnum.WAIT_PICK});
            if (!StringUtils.isNotBlank((CharSequence)saleOrderEo.getSecondOrderStatus())) continue;
            this.checkSaleOrderStatus((SaleOrderStatus)SecondSaleOrderStatusEnum.forCode((String)saleOrderEo.getSecondOrderStatus()), new SaleOrderStatus[]{SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK});
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#reqDto.getSaleOrderId()")
    @Transactional(rollbackFor={Exception.class})
    public List<SaleOrderRespDto> splitOrder(SplitOrderReqDto reqDto) {
        List<SaleOrderRespDto> saleOrderRespDtoList = this.splitSaleOrderService.splitOrder(reqDto);
        saleOrderRespDtoList.forEach(childSaleOrder -> this.publisher.publishEvent((Object)new CreateOrderBySplitEvent(childSaleOrder)));
        return saleOrderRespDtoList;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#reqDto.getSaleOrderId()")
    @Transactional(rollbackFor={Exception.class})
    public List<BizSaleOrderRespDto> splitOrderTcbj(SplitOrderReqDto reqDto) {
        DgSaleOrderEo saleOrderEo = this.checkSplitOrder(reqDto);
        this.logger.info("[\u62c6\u5355]\u8ba2\u5355({})\u8bf7\u6c42\u62c6\u5355\u53c2\u6570\u4e3a\uff1a{}", (Object)saleOrderEo.getSaleOrderNo(), (Object)JSON.toJSONString((Object)reqDto));
        ArrayList splitChildOrderList = Lists.newArrayList();
        reqDto.getOrderList().forEach(splitChildOrderReqDto -> {
            String initOmsOrderStatus = reqDto.getInitOmsOrderStatus();
            if (reqDto.isSplitPartDeliveryFlag()) {
                initOmsOrderStatus = SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode();
            }
            DgSaleOrderEo childOrder = this.createChildOrder(saleOrderEo, splitChildOrderReqDto.getGoodsList(), splitChildOrderReqDto.getLogicWarehouse(), reqDto.getInitOrderStatus(), initOmsOrderStatus, reqDto.isSplitNotDeliveryFlag());
            splitChildOrderList.add(childOrder);
            this.createChildOrderItem(saleOrderEo, childOrder, (SplitChildOrderReqDto)splitChildOrderReqDto);
            this.copyOrderAddress(saleOrderEo.getId(), childOrder.getId());
        });
        this.copyOrderTag(saleOrderEo.getId(), splitChildOrderList.stream().map(BaseEo::getId).collect(Collectors.toList()));
        List<SplitOrderItemReqDto> splitOrderItemReqDtos = reqDto.getOrderList().stream().map(SplitChildOrderReqDto::getGoodsList).flatMap(Collection::stream).collect(Collectors.toList());
        DgSaleOrderEo childOrderForRemain = this.createChildOrderForRemain(saleOrderEo, splitOrderItemReqDtos, reqDto.getInitOrderStatus(), reqDto.getInitOmsOrderStatus(), reqDto.isSplitNotDeliveryFlag());
        if (childOrderForRemain != null) {
            splitChildOrderList.add(childOrderForRemain);
        }
        this.saleOrderItemService.recalculateChildOrderPayAmount(saleOrderEo, splitChildOrderList);
        this.changeOrignalOrder(saleOrderEo);
        ArrayList saleOrderRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)splitChildOrderList, (Collection)saleOrderRespDtoList, SaleOrderRespDto.class);
        Boolean saleIntranst = this.saleIntransitCache.getSaleIntranst(saleOrderEo.getSaleOrderNo());
        List<BizSaleOrderRespDto> childOrderRespDtos = this.getBizSaleOrderRespDtos(splitChildOrderList, saleIntranst);
        if (reqDto.isSplitBatchDeliveryFlag()) {
            this.logger.info("\u62c6\u5355-\u90e8\u5206\u6279\u91cf\u53d1\u8d27-\u5728\u521b\u5efa\u8c03\u62e8\u5355\u548c\u53d1\u8d27\u5355\u6210\u529f\u540e\u518d\u91ca\u653e\u4e3b\u5355\u9884\u5360\u5b50\u5355");
            return childOrderRespDtos;
        }
        return childOrderRespDtos;
    }

    private void updateOrderInventory(DgSaleOrderEo saleOrderEo, List<BizSaleOrderRespDto> childOrderRespDtos, SplitOrderReqDto reqDto, List<Long> deliveryOrderIdList) {
        this.logger.info("\u66f4\u65b0\u5e93\u5b58\u5165\u53c2:isSourceDeliveryFlag={},isSplitBatchDeliveryFlag={},isSplitBatchDeliveryFlag={}", new Object[]{reqDto.isSourceDeliveryFlag(), reqDto.isSplitPartDeliveryFlag(), reqDto.isSplitBatchDeliveryFlag()});
        try {
            List<BizSaleOrderRespDto> deliveryBizOrderDtoList;
            this.logger.info("\u62c6\u5355\u6210\u529f\u91ca\u653e\u4e3b\u5355\u9884\u5360\uff0c\u91cd\u65b0\u6309\u5b50\u5355\u9884\u5360\u5f00\u59cb:{}", (Object)saleOrderEo.getSaleOrderNo());
            this.bInventoryApiServcie.updateOrderInventory(UpdateOrderInventoryEnum.PARENT_CHILD, saleOrderEo, null, childOrderRespDtos);
            this.logger.info("\u62c6\u5355\u6210\u529f\u91ca\u653e\u4e3b\u5355\u9884\u5360\uff0c\u91cd\u65b0\u6309\u5b50\u5355\u9884\u5360\u6210\u529f:{}", (Object)saleOrderEo.getSaleOrderNo());
            if (reqDto.isSourceDeliveryFlag()) {
                this.bInventoryApiServcie.sendChildOrderPreemptLogic(childOrderRespDtos);
            }
            if (reqDto.isSplitPartDeliveryFlag()) {
                deliveryBizOrderDtoList = childOrderRespDtos.stream().filter(dto -> SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode().equals(dto.getSecondOrderStatus())).collect(Collectors.toList());
                this.logger.info("\u9700\u8981\u53cd\u5411\u66f4\u65b0\u5e93\u5b58\u8ba2\u5355\u6570\u91cf:{}", (Object)deliveryBizOrderDtoList.size());
                this.bInventoryApiServcie.sendChildOrderPreemptLogic(deliveryBizOrderDtoList);
            }
            if (reqDto.isSplitBatchDeliveryFlag()) {
                this.logger.info("\u9700\u8981\u53cd\u5411\u66f4\u65b0\u5e93\u5b58\u8ba2\u5355id:{}", (Object)JSON.toJSONString(deliveryOrderIdList));
                deliveryBizOrderDtoList = childOrderRespDtos.stream().filter(dto -> deliveryOrderIdList.contains(dto.getId())).collect(Collectors.toList());
                this.logger.info("\u9700\u8981\u53cd\u5411\u66f4\u65b0\u5e93\u5b58\u8ba2\u5355\u6570\u91cf:{}", (Object)deliveryBizOrderDtoList.size());
                this.bInventoryApiServcie.sendChildOrderPreemptLogic(deliveryBizOrderDtoList);
            }
        }
        catch (Exception e) {
            this.logger.error("\u62c6\u5355\u6210\u529f\u91ca\u653e\u4e3b\u5355\u9884\u5360\uff0c\u91cd\u65b0\u6309\u5b50\u5355\u9884\u5360\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderEo.getId(), (String)("\u62c6\u5355\u66f4\u65b0\u5e93\u5b58\u5931\u8d25:" + e.getMessage()));
        }
    }

    private void processYphTagForSplitOrders(String originalOrderNo, List<BizSaleOrderRespDto> newSplitOrders) {
        DgSaleOrderEo bizSaleOrderRespDto = this.saleOrderService.queryEoByOrderNo(originalOrderNo);
        ArrayList statusList = Lists.newArrayList((Object[])new String[]{"CANCEL", "SPLIT", "OBSOLETE"});
        List allRelatedOrders = this.saleOrderService.queryChildByMainOrderNo(Optional.ofNullable(bizSaleOrderRespDto.getMainOrderNo()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElse(originalOrderNo)).stream().filter(r -> !statusList.contains(r.getOrderStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(allRelatedOrders)) {
            this.logger.info("\u672a\u627e\u5230\u539f\u8ba2\u5355\u53f7\u4e3a{}\u7684\u5173\u8054\u8ba2\u5355\uff0c\u53ea\u5904\u7406\u5f53\u524d\u62c6\u5206\u8ba2\u5355", (Object)originalOrderNo);
            allRelatedOrders = newSplitOrders.stream().map(order -> {
                SaleOrderRespDto dto = new SaleOrderRespDto();
                dto.setId(order.getId());
                dto.setLogicalWarehouseCode(order.getLogicalWarehouseCode());
                dto.setPhysicsWarehouseCode(order.getPhysicsWarehouseCode());
                return dto;
            }).collect(Collectors.toList());
        }
        Set filterOrderNo = ((ExtQueryChainWrapper)this.saleTransferOrderDasImpl.filter().in((Object)"sale_order_no", (Collection)allRelatedOrders.stream().map(SaleOrderRespDto::getSaleOrderNo).distinct().collect(Collectors.toList()))).list().stream().map(SaleTransferOrderEo::getSaleOrderNo).collect(Collectors.toSet());
        if ((allRelatedOrders = allRelatedOrders.stream().filter(r -> !filterOrderNo.contains(r.getSaleOrderNo())).collect(Collectors.toList())).size() < 2) {
            this.logger.info("\u672a\u627e\u5230\u539f\u8ba2\u5355\u53f7\u7684\u5173\u8054\u8ba2\u5355,\u4e0d\u5904\u7406:{}", (Object)originalOrderNo);
            return;
        }
        List warehouseCodes = allRelatedOrders.stream().map(SaleOrderRespDto::getLogicalWarehouseCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(warehouseCodes)) {
            this.logger.info("\u8ba2\u5355{}\u7684\u5173\u8054\u8ba2\u5355\u4e2d\u6ca1\u6709\u6709\u6548\u7684\u903b\u8f91\u4ed3\u5e93\u4ee3\u7801\uff0c\u8df3\u8fc7YPH\u6253\u6807", (Object)originalOrderNo);
            return;
        }
        List warehouseRespDtos = (List)this.logicWarehouseExposedQueryApi.queryList(warehouseCodes).getData();
        if (CollectionUtils.isEmpty((Collection)warehouseRespDtos)) {
            this.logger.info("\u672a\u67e5\u8be2\u5230\u903b\u8f91\u4ed3\u5e93\u4fe1\u606f\uff0c\u8df3\u8fc7YPH\u6253\u6807");
            return;
        }
        boolean hasCN01Organization = warehouseRespDtos.stream().anyMatch(warehouse -> "CN01".equals(warehouse.getOrganizationCode()));
        if (!hasCN01Organization) {
            this.logger.info("\u8ba2\u5355{}\u7684\u5173\u8054\u8ba2\u5355\u4e2d\u6ca1\u6709CN01\u7ec4\u7ec7\u7684\u4ed3\u5e93\uff0c\u8df3\u8fc7YPH\u6253\u6807", (Object)originalOrderNo);
            return;
        }
        Set cn01WarehouseCodeSet = warehouseRespDtos.stream().filter(warehouse -> "CN01".equals(warehouse.getOrganizationCode())).map(CsLogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toSet());
        Map<String, List<SaleOrderRespDto>> physicsToLogicWarehouseMap = allRelatedOrders.stream().filter(order -> StringUtils.isNotEmpty((CharSequence)order.getPhysicsWarehouseCode()) && StringUtils.isNotEmpty((CharSequence)order.getLogicalWarehouseCode())).collect(Collectors.groupingBy(SaleOrderRespDto::getPhysicsWarehouseCode));
        physicsToLogicWarehouseMap.forEach((physicsWarehouseCode, logicWarehouseCodes) -> {
            if (logicWarehouseCodes.stream().anyMatch(r -> cn01WarehouseCodeSet.contains(r.getLogicalWarehouseCode()))) {
                if (logicWarehouseCodes.size() < 2) {
                    this.logger.info("\u672a\u627e\u5230\u539f\u8ba2\u5355\u53f7\u7684\u5173\u8054\u8ba2\u5355,\u4e0d\u5904\u7406:{}", (Object)originalOrderNo);
                    return;
                }
                logicWarehouseCodes.forEach(order -> {
                    try {
                        this.orderTagRecordService.processYphRemoveTag(order.getId());
                        OrderTagRecordReqDto addReqDto = new OrderTagRecordReqDto();
                        addReqDto.setOrderId(order.getId());
                        addReqDto.setTagCode("YPH");
                        this.orderTagRecordService.addOrderTagRecord(addReqDto);
                        this.logger.info("\u4e3a\u8ba2\u5355{}\u6dfb\u52a0YPH\u6807\u7b7e\u6210\u529f", (Object)order.getId());
                    }
                    catch (Exception e) {
                        this.logger.error("\u4e3a\u8ba2\u5355{}\u6dfb\u52a0YPH\u6807\u7b7e\u5931\u8d25", (Object)order.getId(), (Object)e);
                    }
                });
            }
        });
        this.logger.info("\u8ba2\u5355\u7684YPH\u6253\u6807\u5904\u7406\u5b8c\u6210,\u5171\u5904\u7406\u4e2a\u5173\u8054\u8ba2\u5355,{},{}", (Object)originalOrderNo, (Object)allRelatedOrders.size());
    }

    private void deliveryAndRelease(DgSaleOrderEo saleOrderEo, final List<BizSaleOrderRespDto> childorderRespDtos) {
        try {
            this.logger.info("\u5bfb\u6e90\u62c6\u5355\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355");
            this.bInventoryApiServcie.preemptOrderInventoryBatch(childorderRespDtos);
            this.logger.info("\u5bfb\u6e90\u62c6\u5355\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.info("\u5bfb\u6e90\u62c6\u5355\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\u5f02\u5e38:{}", (Object)e.getMessage());
            this.logger.warn("{},{}", (Object)e.getMessage(), (Object)e);
            TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderEo.getId(), (String)PcpTradeExceptionCode.SALE_ORDER_DELIVERY_INVENTORY.buildBizException(new Object[]{e.getMessage()}).toString());
            throw PcpTradeExceptionCode.SALE_ORDER_DELIVERY_INVENTORY.buildBizException(new Object[]{e.getMessage()});
        }
        try {
            for (BizSaleOrderRespDto childorderRespDto : childorderRespDtos) {
                this.logger.info("[\u5bfb\u6e90\u53d1\u8d27\u62c6\u5355]\u9500\u552e\uff08orderId={}\uff09\u72b6\u6001\u4fee\u6539\u4e3a\u5df2\u9501\u5b9a\u5f85\u6307\u6d3e", (Object)saleOrderEo.getId());
                this.saleOrderService.removeLabel(childorderRespDto.getId(), childorderRespDto.getOptLabel(), OrderOptLabelEnum.APPOINT_BATCH.getCode(), OrderOptLabelEnum.MODIFY_LOGICAL_WAREHOUSE.getCode(), OrderOptLabelEnum.UN_LOCK.getCode());
            }
        }
        catch (Exception e) {
            this.logger.info("\u5bfb\u6e90\u62c6\u5355\u79fb\u9664\u6807\u7b7e\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                SaleOrderOptServiceImpl.this.logger.info("\u5bfb\u6e90\u62c6\u5355\u6210\u529f\u81ea\u52a8\u8ba2\u5355\u6307\u6d3e");
                for (BizSaleOrderRespDto childorderRespDto : childorderRespDtos) {
                    MessageVo messageVo = new MessageVo();
                    messageVo.setData((Object)childorderRespDto.getId());
                    SaleOrderOptServiceImpl.this.commonsMqService.sendDelaySingleMessage("ORDER_AUTO_SYNC", (Object)messageVo, Long.valueOf(10L));
                }
            }
        });
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
    }

    private void splitPartDeliveryAndRelease(BizSaleOrderRespDto bizSaleOrderRespDto) {
        CsPcpInventoryExposedRespDto inventoryExposedRespDto = new CsPcpInventoryExposedRespDto();
        ArrayList orderItemEos = Lists.newArrayList();
        DtoHelper.dtoList2EoList((Collection)bizSaleOrderRespDto.getItemList(), (Collection)orderItemEos, DgSaleOrderItemEo.class);
        DgSaleOrderAddrEo orderAddrEo = new DgSaleOrderAddrEo();
        CubeBeanUtils.copyProperties((Object)orderAddrEo, (Object)bizSaleOrderRespDto.getOrderAddrRespDto(), (String[])new String[0]);
        DgSaleOrderEo childDgSaleOrderEo = new DgSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)childDgSaleOrderEo, (Object)bizSaleOrderRespDto, (String[])new String[0]);
        try {
            inventoryExposedRespDto = this.inventoryApiServcie.preemptOrderInventory(childDgSaleOrderEo, orderItemEos, orderAddrEo, 1);
        }
        catch (Exception e) {
            this.logger.info("\u9884\u5360\u903b\u8f91\u4ed3\u5e93\u5b58\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\u5931\u8d25:{}", (Object)e.getMessage());
            throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{e.getMessage()});
        }
    }

    private List<BizSaleOrderRespDto> getBizSaleOrderRespDtos(List<DgSaleOrderEo> splitChildOrderList, Boolean saleIntranst) {
        this.logger.debug("[\u62c6\u5355]\u5c01\u88c5\u9884\u5360\u5e93\u5b58dto");
        ArrayList childorderRespDtos = Lists.newArrayList();
        List childOrderIds = splitChildOrderList.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(DgSaleOrderItemEo::getOrderId, childOrderIds);
        List childOrderItems = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryWrapper);
        Map<Long, List<DgSaleOrderItemEo>> orderItemMap = childOrderItems.stream().collect(Collectors.groupingBy(DgSaleOrderItemEo::getOrderId));
        LambdaQueryWrapper queryAddrWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryAddrWrapper.eq(BaseEo::getDr, (Object)0)).in(DgSaleOrderAddrEo::getOrderId, childOrderIds);
        List orderAddrEos = this.dgSaleOrderAddrDomain.getMapper().selectList((Wrapper)queryAddrWrapper);
        Map orderAddrEoMap = orderAddrEos.stream().collect(Collectors.toMap(DgSaleOrderAddrEo::getOrderId, Function.identity(), (k1, k2) -> k1));
        for (DgSaleOrderEo orderEo : splitChildOrderList) {
            ArrayList itemList = Lists.newArrayList();
            List<DgSaleOrderItemEo> saleOrderItemEos = orderItemMap.get(orderEo.getId());
            DtoHelper.eoList2DtoList(saleOrderItemEos, (Collection)itemList, SaleOrderItemExtRespDto.class);
            BizSaleOrderRespDto bizSaleOrderRespDto = new BizSaleOrderRespDto();
            CubeBeanUtils.copyProperties((Object)bizSaleOrderRespDto, (Object)orderEo, (String[])new String[0]);
            bizSaleOrderRespDto.setItemList((List)itemList);
            SaleOrderAddrRespDto saleOrderAddrRespDto = new SaleOrderAddrRespDto();
            DgSaleOrderAddrEo saleOrderAddrEo = (DgSaleOrderAddrEo)orderAddrEoMap.get(orderEo.getId());
            CubeBeanUtils.copyProperties((Object)saleOrderAddrRespDto, (Object)saleOrderAddrEo, (String[])new String[0]);
            bizSaleOrderRespDto.setOrderAddrRespDto(saleOrderAddrRespDto);
            childorderRespDtos.add(bizSaleOrderRespDto);
            this.saleIntransitCache.setSaleIntranst(orderEo.getSaleOrderNo(), saleIntranst);
            Map saleItemIntranstMap = this.saleIntransitCache.getSaleItemIntranst(orderEo.getOriginalOrderNo());
            HashMap saleItemChildIntranstMap = new HashMap();
            for (SaleOrderItemExtRespDto saleOrderItemExtRespDto : itemList) {
                String key = saleOrderItemExtRespDto.getOriginalOrderItemId() + "_" + saleOrderItemExtRespDto.getLogicalWarehouseCode();
                if (!Objects.nonNull(saleItemIntranstMap) || !saleItemIntranstMap.containsKey(key)) continue;
                saleItemChildIntranstMap.put(saleOrderItemExtRespDto.getId() + "_" + saleOrderItemExtRespDto.getLogicalWarehouseCode(), saleItemIntranstMap.get(key));
            }
            this.saleIntransitCache.setSaleItemIntranst(orderEo.getSaleOrderNo(), saleItemChildIntranstMap);
        }
        return childorderRespDtos;
    }

    private void changeOrignalOrder(DgSaleOrderEo saleOrderEo) {
        int update;
        this.logger.debug("[\u62c6\u5355]\u5f00\u59cb\u4fee\u6539\u539f\u8ba2\u5355\u7684\u72b6\u6001");
        DgSaleOrderEo updateDgSaleOrderEo = new DgSaleOrderEo();
        if (SaleOrderLevelEnum.ORIGINAL.getType().equals(saleOrderEo.getOrderLevel())) {
            updateDgSaleOrderEo.setOrderLevel(SaleOrderLevelEnum.MAIN.getType());
        }
        updateDgSaleOrderEo.setSplitStatus(SplitStatusEnum.SPLIT.getType());
        updateDgSaleOrderEo.setId(saleOrderEo.getId());
        updateDgSaleOrderEo.setInterceptInfo(EMPTY);
        this.logger.info("[\u62c6\u5355]\u4fee\u6539\u539f\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u62c6\u5206\uff0c\u4fee\u6539\u8bf7\u6c42\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)updateDgSaleOrderEo));
        this.orderTagRecordService.delLjddTagByOrder(saleOrderEo.getId());
        this.splitLevelRedisUtils.delSplitLevel(saleOrderEo.getSaleOrderNo());
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEo::getId, (Object)saleOrderEo.getId());
        updateWrapper.eq(DgSaleOrderEo::getSplitStatus, (Object)SplitStatusEnum.NOT_SPLIT.getType());
        updateWrapper.in(DgSaleOrderEo::getOrderStatus, Arrays.asList(SaleOrderStatusEnum.WAIT_CHECK.getCode(), SaleOrderStatusEnum.WAIT_PICK.getCode()));
        if (saleOrderEo.getOrderStatus().equals(SaleOrderStatusEnum.WAIT_PICK.getCode())) {
            updateWrapper.eq(DgSaleOrderEo::getSecondOrderStatus, (Object)SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK.getCode());
        }
        if ((update = this.dgSaleOrderDomain.getMapper().update((Object)updateDgSaleOrderEo, (Wrapper)updateWrapper)) != 1) {
            throw PcpTradeExceptionCode.SPLIT_ORDER_FAIL.builderException();
        }
        if (this.cacheWrapper() != null) {
            this.cacheWrapper().removeCache((Object)saleOrderEo.getId());
        }
    }

    private void checkOrigOrderAndChildOrderItemNum(DgSaleOrderEo saleOrderEo) {
        this.logger.info("\u6821\u9a8c\u539f\u5355\u6570\u91cf\u548c\u62c6\u5355\u540e\u7684\u6570\u91cf");
        SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
        saleOrderQueryReqDto.setMainOrderNo(saleOrderEo.getSaleOrderNo());
        ArrayList notOrderStatusList = Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode()});
        saleOrderQueryReqDto.setNotOrderStatusList((List)notOrderStatusList);
        List<SaleOrderRespDto> childSaleOrderList = this.saleOrderService.queryByParamList(saleOrderQueryReqDto);
        this.logger.info("\u67e5\u8be2\u539f\u5355\u62c6\u5355\u540e\u7684\u6709\u6548\u5b50\u8ba2\u5355==>{}", (Object)JSON.toJSONString(childSaleOrderList));
        BigDecimal goodsTotalNum = BigDecimal.ZERO;
        for (SaleOrderRespDto childOrder : childSaleOrderList) {
            if (!Objects.nonNull(childOrder.getGoodsTotalNum())) continue;
            goodsTotalNum = goodsTotalNum.add(childOrder.getGoodsTotalNum());
        }
        if (goodsTotalNum.compareTo(saleOrderEo.getGoodsTotalNum()) != 0) {
            throw PcpTradeExceptionCode.SPLIT_ORDER_GOOD_COUNT_ILLEGAL.builderException();
        }
    }

    @Override
    public void batchCheckOrderSkus(BatchSplitOrderReqDto reqDto) {
        List orderIdList = reqDto.getOrderIdList();
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getSkuCode, (Object)reqDto.getSplitSku())).in(DgSaleOrderItemEo::getOrderId, (Collection)orderIdList);
        List orderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        this.logger.info("[\u6279\u91cf\u62c6\u5355]\u6821\u9a8c\u53c2\u6570\u4e2d\uff0c\u6ee1\u8db3\u6709\u8be5sku={}\u7684\u8ba2\u5355\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)reqDto.getSplitSku(), (Object)JSON.toJSONString((Object)orderItemEos));
        if (CollectionUtils.isEmpty((Collection)orderItemEos) || orderItemEos.size() != orderIdList.size()) {
            List orderIdsOfContainsSku = Optional.ofNullable(orderItemEos).orElseGet(Collections::emptyList).stream().map(DgSaleOrderItemEo::getOrderId).collect(Collectors.toList());
            List exceptionOrderId = orderIdList.stream().filter(orderId -> !orderIdsOfContainsSku.contains(orderId)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(exceptionOrderId)) {
                this.logger.info("[\u6279\u91cf\u62c6\u5355]\u6821\u9a8c\u53c2\u6570\u4e2d\uff0c\u9009\u4e2d\u7684\u8ba2\u5355\u5747\u6709\u8be5sku");
                return;
            }
            LambdaQueryWrapper querySaleOrderWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)querySaleOrderWrapper.eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, exceptionOrderId);
            List saleOrderEoList = this.dgSaleOrderDomain.getMapper().selectList((Wrapper)querySaleOrderWrapper);
            List exceptionOrderNos = saleOrderEoList.stream().map(DgSaleOrderEo::getSaleOrderNo).collect(Collectors.toList());
            throw new BizException(PcpTradeExceptionCode.SPLIT_ORDER_SKU_NOT_EXIT.getCode(), String.format("\u8ba2\u5355\uff1a%s \u4e0d\u5b58\u5728\u957f\u7f16\u7801\u4e3a%s\u7684\u5546\u54c1", StringUtils.joinWith((String)",", (Object[])new Object[]{exceptionOrderNos}), reqDto.getSplitSku()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void splitOrderBySku(Long orderId, String splitSku) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)splitSku, (String)"\u62c6\u5355\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.logger.info("[\u62c6\u5355]\u8ba2\u5355\uff08{}\uff09\u901a\u8fc7sku\u8fdb\u884c\u62c6\u5355\u64cd\u4f5c\uff0cskucode={}", (Object)orderId, (Object)splitSku);
        List<SaleOrderRespDto> saleOrderRespDtoList = this.splitSaleOrderService.splitOrderBySku(orderId, splitSku);
        saleOrderRespDtoList.forEach(childSaleOrder -> this.publisher.publishEvent((Object)new CreateOrderBySplitEvent(childSaleOrder)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public List<BizSaleOrderRespDto> splitOrderBySkuTcbj(Long orderId, String splitSku) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)splitSku, (String)"\u62c6\u5355\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.logger.info("[\u62c6\u5355]\u8ba2\u5355\uff08{}\uff09\u901a\u8fc7sku\u8fdb\u884c\u62c6\u5355\u64cd\u4f5c\uff0cskucode={}", (Object)orderId, (Object)splitSku);
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoById(orderId);
        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getSecondOrderStatus())) {
            this.checkSaleOrderStatus((SaleOrderStatus)SecondSaleOrderStatusEnum.forCode((String)saleOrderEo.getSecondOrderStatus()), new SaleOrderStatus[]{SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK});
        }
        this.checkSplitOrderBySkuParams(splitSku, saleOrderEo);
        LambdaQueryWrapper querySplitOrderItem = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)querySplitOrderItem.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId)).eq(DgSaleOrderItemEo::getSkuCode, (Object)splitSku);
        List orderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)querySplitOrderItem);
        List<SplitOrderItemReqDto> splitOrderItemReqDtos = orderItemEos.stream().map(saleOrderItemEo -> {
            SplitOrderItemReqDto splitOrderItemReqDto = new SplitOrderItemReqDto();
            splitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemEo.getId());
            splitOrderItemReqDto.setGoodsNum(saleOrderItemEo.getItemNum());
            splitOrderItemReqDto.setGoodsSku(saleOrderItemEo.getSkuCode());
            splitOrderItemReqDto.setIsGiftFlag(saleOrderItemEo.getGift());
            return splitOrderItemReqDto;
        }).collect(Collectors.toList());
        ArrayList childOrderEos = Lists.newArrayList();
        DgSaleOrderEo childOrder = this.createChildOrder(saleOrderEo, splitOrderItemReqDtos);
        childOrderEos.add(childOrder);
        this.saleOrderItemService.createSplitOrderItem(saleOrderEo, childOrder, splitOrderItemReqDtos);
        this.copyOrderAddress(saleOrderEo.getId(), childOrder.getId());
        this.copyOrderTag(saleOrderEo.getId(), Lists.newArrayList((Object[])new Long[]{childOrder.getId()}));
        DgSaleOrderEo childOrderForRemain = this.createChildOrderForRemain(saleOrderEo, splitOrderItemReqDtos, saleOrderEo.getOrderStatus(), saleOrderEo.getSecondOrderStatus(), Boolean.FALSE);
        if (childOrderForRemain != null) {
            childOrderEos.add(childOrderForRemain);
        }
        this.saleOrderItemService.recalculateChildOrderPayAmount(saleOrderEo, childOrderEos);
        this.changeOrignalOrder(saleOrderEo);
        Boolean saleIntranst = this.saleIntransitCache.getSaleIntranst(saleOrderEo.getSaleOrderNo());
        List<BizSaleOrderRespDto> childorderRespDtos = this.getBizSaleOrderRespDtos(childOrderEos, saleIntranst);
        this.processYphTagForSplitOrders(saleOrderEo.getSaleOrderNo(), childorderRespDtos);
        return childorderRespDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Deprecated
    public void searchSourceForDeliver(SearchSourceReqDto reqDto) {
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoByNo(reqDto.getSaleOrderNo());
        if (this.saleOrderService.isClaimOrder(saleOrderEo.getOrderType())) {
            this.aotoPickClaimOrderDelivery(reqDto, saleOrderEo.getId());
        } else {
            SourceOrderResultRespDto sourceOrderResultRespDto = this.autoSearchSource(reqDto, reqDto.getSaleOrderNo());
            if (SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
                this.logger.info("[\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355\uff08{}\uff09\u5bfb\u6e90\u6210\u529f", (Object)reqDto.getSaleOrderNo());
                AssertUtils.notEmpty((Collection)sourceOrderResultRespDto.getOrderItemResultRespDtoList(), (String)"\u5bfb\u6e90\u7ed3\u679c\u5b58\u5728\u5f02\u5e38");
                List orderItemResultRespDtoList = sourceOrderResultRespDto.getOrderItemResultRespDtoList();
                AssertUtils.notEmpty((Collection)orderItemResultRespDtoList, (String)"\u5bfb\u6e90\u7ed3\u679c\u6570\u636e\u5f02\u5e38\uff01");
                Map<String, List<OrderItemResultRespDto>> orderItemResultMap = orderItemResultRespDtoList.stream().collect(Collectors.groupingBy(OrderItemResultRespDto::getDeliveryLogicWarehouseCode));
                if (orderItemResultMap.size() > 1) {
                    this.logger.info("[\u5bfb\u6e90]\u8ba2\u5355({})\u5bfb\u6e90\u7ed3\u679c\u6709\u591a\u4e2a\u903b\u8f91\u4ed3\uff0c\u9700\u8981\u8fdb\u884c\u62c6\u5355\u5904\u7406", (Object)reqDto.getSaleOrderNo());
                    boolean flag = this.checkOrderSplitWaitFlag(saleOrderEo);
                    this.logger.info("[\u5bfb\u6e90]\u8ba2\u5355({})\u5bfb\u6e90\u7ed3\u679c\u6709\u591a\u4e2a\u903b\u8f91\u4ed3\uff0c\u62e6\u622a\u5224\u65ad={}", (Object)reqDto.getSaleOrderNo(), (Object)flag);
                    if (flag) {
                        this.splitOrderForSource(orderItemResultMap, sourceOrderResultRespDto.getLinkOrderNo());
                    } else {
                        this.orderTagRecordService.saveLjddTagByOrder(saleOrderEo.getId());
                    }
                } else {
                    this.deliveryOrderBySource(reqDto, saleOrderEo, sourceOrderResultRespDto);
                }
            } else if (SourceStatusEnum.SOURCE_FAIL.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
                throw PcpTradeExceptionCode.PICK_FAIL.builderException();
            }
        }
    }

    private boolean checkOrderSplitWaitFlag(DgSaleOrderEo saleOrderEo) {
        Boolean saleSplitIntercepFlag = this.saleIntransitCache.getSaleSplitIntercep(saleOrderEo.getSaleOrderNo());
        if (!saleSplitIntercepFlag.booleanValue()) {
            this.saleIntransitCache.delSaleSplitIntercep(saleOrderEo.getSaleOrderNo());
            return true;
        }
        DistributionClueSuitActReqDto suitActReqDto = new DistributionClueSuitActReqDto();
        suitActReqDto.setCustomerId(saleOrderEo.getCustomerId());
        suitActReqDto.setOrderType(saleOrderEo.getOrderType());
        suitActReqDto.setOrganizationId(saleOrderEo.getOrganizationId());
        DistributionClueActRespDto clueActRespDto = null;
        try {
            clueActRespDto = (DistributionClueActRespDto)RestResponseHelper.extractData((RestResponse)this.distributionClueQueryApiProxy.querySuitClueByOrder(suitActReqDto));
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u81ea\u52a8\u914d\u8d27\u7b56\u7565\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        if (Objects.isNull(clueActRespDto)) {
            return true;
        }
        if (Objects.equals(clueActRespDto.getClueSettings(), 0)) {
            return true;
        }
        if (Objects.equals(clueActRespDto.getClueSplitEnable(), EnableEnum.DISABLE.getCode())) {
            return true;
        }
        String orderSteps = saleOrderEo.getOrderSteps();
        if (StringUtils.isNotBlank((CharSequence)orderSteps)) {
            List orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, OrderStatusLogRespDto.class);
            orderStatusLogRespDtos.sort(Comparator.comparing(OrderStatusLogRespDto::getOptDate).reversed());
            Map<String, List<OrderStatusLogRespDto>> listMap = orderStatusLogRespDtos.stream().collect(Collectors.groupingBy(OrderStatusLogRespDto::getOrderStatus));
            List<OrderStatusLogRespDto> saleOrderWaitPickList = listMap.get(SaleOrderStatusEnum.WAIT_PICK.getCode());
            Date optDate = saleOrderWaitPickList.get(0).getOptDate();
            Date toDayTime = new Date();
            Integer waitPickTotalTime = clueActRespDto.getWaitPickTotalTime();
            Date addtime = DateUtil.addMinutes((Date)optDate, (int)waitPickTotalTime);
            this.logger.info("\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u65f6\u95f4={},addtime={},toDayTime={}", new Object[]{DateUtil.format((Date)optDate, (String)"yyyy-MM-dd HH:mm:ss"), DateUtil.format((Date)addtime, (String)"yyyy-MM-dd HH:mm:ss"), DateUtil.format((Date)toDayTime, (String)"yyyy-MM-dd HH:mm:ss")});
            if (toDayTime.compareTo(addtime) > 0) {
                return true;
            }
        }
        return false;
    }

    private void deliveryOrderBySource(SearchSourceReqDto reqDto, DgSaleOrderEo saleOrderEo, SourceOrderResultRespDto sourceOrderResultRespDto) {
        this.deliveryOrder(reqDto, saleOrderEo, sourceOrderResultRespDto);
    }

    @Override
    public List<BizSaleOrderRespDto> splitOrderForSource(SourceOrderResultRespDto sourceOrderResultRespDto) {
        this.logger.info("[\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355\uff08{}\uff09\u5bfb\u6e90\u6210\u529f", (Object)sourceOrderResultRespDto.getLinkOrderNo());
        AssertUtils.notEmpty((Collection)sourceOrderResultRespDto.getOrderItemResultRespDtoList(), (String)"\u5bfb\u6e90\u7ed3\u679c\u5b58\u5728\u5f02\u5e38");
        List orderItemResultRespDtoList = sourceOrderResultRespDto.getOrderItemResultRespDtoList();
        AssertUtils.notEmpty((Collection)orderItemResultRespDtoList, (String)"\u5bfb\u6e90\u7ed3\u679c\u6570\u636e\u5f02\u5e38\uff01");
        Map<String, List<OrderItemResultRespDto>> orderItemResultMap = orderItemResultRespDtoList.stream().collect(Collectors.groupingBy(OrderItemResultRespDto::getDeliveryLogicWarehouseCode));
        this.logger.info("[\u5bfb\u6e90]\u8ba2\u5355({})\u5bfb\u6e90\u7ed3\u679c\u6709\u591a\u4e2a\u903b\u8f91\u4ed3\uff0c\u9700\u8981\u8fdb\u884c\u62c6\u5355\u5904\u7406", (Object)sourceOrderResultRespDto.getLinkOrderNo());
        return this.splitOrderForSource(orderItemResultMap, sourceOrderResultRespDto.getLinkOrderNo());
    }

    @Override
    public void searchSourceDeliveryOrder(SourceOrderResultRespDto sourceOrderResultRespDto) {
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoByNo(sourceOrderResultRespDto.getLinkOrderNo());
        SearchSourceReqDto reqDto = new SearchSourceReqDto();
        reqDto.setSaleOrderNo(saleOrderEo.getSaleOrderNo());
        this.deliveryOrderBySource(reqDto, saleOrderEo, sourceOrderResultRespDto);
    }

    @Override
    public SourceOrderResultRespDto autoSearchSource(SearchSourceReqDto reqDto, String saleOrderNo) {
        this.saleOrderService.removeLogicalWarehouseInfo(saleOrderNo);
        return this.searchSource(reqDto);
    }

    @Override
    public void aotoPickClaimOrderDelivery(SearchSourceReqDto reqDto, Long id) {
        this.deliverClaimOrderForLogicWarehouse(reqDto.getSaleOrderNo(), arrangeWarehouseReqDto -> {
            DgSaleOrderEo updateStatusEo = new DgSaleOrderEo();
            updateStatusEo.setLogicalWarehouseName(arrangeWarehouseReqDto.getLogicalWarehouseName());
            updateStatusEo.setLogicalWarehouseId(arrangeWarehouseReqDto.getLogicalWarehouseId());
            updateStatusEo.setLogicalWarehouseCode(arrangeWarehouseReqDto.getLogicalWarehouseCode());
            CsRelWarehouseRespDto physicsWarehouseByLogic = this.getPhysicsWarehouseByLogic(arrangeWarehouseReqDto.getLogicalWarehouseCode());
            if (Objects.nonNull(physicsWarehouseByLogic)) {
                updateStatusEo.setPhysicsWarehouseCode(physicsWarehouseByLogic.getRefWarehouseCode());
                updateStatusEo.setPhysicsWarehouseId(Long.valueOf(physicsWarehouseByLogic.getRefWarehouseId()));
                updateStatusEo.setPhysicsWarehouseName(physicsWarehouseByLogic.getRefWarehouseName());
            }
            updateStatusEo.setInterceptInfo(EMPTY);
            updateStatusEo.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
            this.optimisticSaleOrderChildStatus(updateStatusEo, id, SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK);
            this.orderTagRecordService.delLjddTagByOrder(id);
        });
    }

    private void deliveryOrder(SearchSourceReqDto reqDto, DgSaleOrderEo saleOrderEo, SourceOrderResultRespDto sourceOrderResultRespDto) {
        this.deliverOrderForSource(reqDto.getSaleOrderNo(), sourceOrderResultRespDto, arrangeWarehouseReqDto -> {
            DgSaleOrderEo updateStatusEo = new DgSaleOrderEo();
            updateStatusEo.setLogicalWarehouseName(arrangeWarehouseReqDto.getLogicalWarehouseName());
            updateStatusEo.setLogicalWarehouseId(arrangeWarehouseReqDto.getLogicalWarehouseId());
            updateStatusEo.setLogicalWarehouseCode(arrangeWarehouseReqDto.getLogicalWarehouseCode());
            CsRelWarehouseRespDto physicsWarehouseByLogic = this.getPhysicsWarehouseByLogic(arrangeWarehouseReqDto.getLogicalWarehouseCode());
            if (Objects.nonNull(physicsWarehouseByLogic)) {
                updateStatusEo.setPhysicsWarehouseCode(physicsWarehouseByLogic.getRefWarehouseCode());
                updateStatusEo.setPhysicsWarehouseId(Long.valueOf(physicsWarehouseByLogic.getRefWarehouseId()));
                updateStatusEo.setPhysicsWarehouseName(physicsWarehouseByLogic.getRefWarehouseName());
            }
            updateStatusEo.setInterceptInfo(EMPTY);
            updateStatusEo.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
            this.optimisticSaleOrderChildStatus(updateStatusEo, saleOrderEo.getId(), SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK);
            this.orderTagRecordService.delLjddTagByOrder(saleOrderEo.getId());
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deliverOrSplitBySource(final SearchSourceReqDto reqDto) {
        this.saleOrderService.removeLogicalWarehouseInfo(reqDto.getSaleOrderNo());
        final DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoByNo(reqDto.getSaleOrderNo());
        if (this.saleOrderService.isClaimOrder(saleOrderEo.getOrderType())) {
            this.aotoPickClaimOrderDelivery(reqDto, saleOrderEo.getId());
        } else {
            final SourceOrderResultRespDto sourceOrderResultRespDto = this.searchSource(reqDto);
            if (SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
                this.logger.info("[\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355\uff08{}\uff09\u5bfb\u6e90\u6210\u529f", (Object)reqDto.getSaleOrderNo());
                AssertUtils.notEmpty((Collection)sourceOrderResultRespDto.getOrderItemResultRespDtoList(), (String)"\u5bfb\u6e90\u7ed3\u679c\u5b58\u5728\u5f02\u5e38");
                List orderItemResultRespDtoList = sourceOrderResultRespDto.getOrderItemResultRespDtoList();
                AssertUtils.notEmpty((Collection)orderItemResultRespDtoList, (String)"\u5bfb\u6e90\u7ed3\u679c\u6570\u636e\u5f02\u5e38\uff01");
                Map<String, List<OrderItemResultRespDto>> orderItemResultMap = orderItemResultRespDtoList.stream().collect(Collectors.groupingBy(OrderItemResultRespDto::getDeliveryLogicWarehouseCode));
                if (orderItemResultMap.size() > 1) {
                    this.logger.info("[\u5bfb\u6e90]\u8ba2\u5355({})\u5bfb\u6e90\u7ed3\u679c\u6709\u591a\u4e2a\u903b\u8f91\u4ed3\uff0c\u9700\u8981\u8fdb\u884c\u62c6\u5355\u5904\u7406", (Object)reqDto.getSaleOrderNo());
                    this.splitOrderForSource(orderItemResultMap, sourceOrderResultRespDto.getLinkOrderNo());
                } else if (this.saleOrderService.isYyJOrder(saleOrderEo.getOrderType())) {
                    final String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
                    executorYyjService.execute(new Runnable(){

                        @Override
                        public void run() {
                            MDC.put((String)"yes.req.requestId", (String)reqId);
                            SaleOrderOptServiceImpl.this.logger.info("\u62c6\u5355\u5bfb\u6e90\u6210\u529f\u540e\u5f02\u6b65\u81ea\u52a8\u914d\u8d27");
                            ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
                            SaleOrderOptServiceImpl.this.deliveryOrderFromSplit(reqDto, saleOrderEo, sourceOrderResultRespDto);
                        }
                    });
                    TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderEo.getId(), (String)"\u5f02\u6b65\u914d\u8d27");
                } else {
                    this.deliveryOrderFromSplit(reqDto, saleOrderEo, sourceOrderResultRespDto);
                }
            } else if (SourceStatusEnum.SOURCE_FAIL.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
                throw PcpTradeExceptionCode.PICK_FAIL.builderException();
            }
        }
    }

    private void deliveryOrderFromSplit(SearchSourceReqDto reqDto, DgSaleOrderEo saleOrderEo, SourceOrderResultRespDto sourceOrderResultRespDto) {
        this.deliverOrderForSource(reqDto.getSaleOrderNo(), sourceOrderResultRespDto, arrangeWarehouseReqDto -> {
            DgSaleOrderEo updateEo = new DgSaleOrderEo();
            updateEo.setLogicalWarehouseName(arrangeWarehouseReqDto.getLogicalWarehouseName());
            updateEo.setLogicalWarehouseId(arrangeWarehouseReqDto.getLogicalWarehouseId());
            updateEo.setLogicalWarehouseCode(arrangeWarehouseReqDto.getLogicalWarehouseCode());
            CsRelWarehouseRespDto physicsWarehouseByLogic = this.getPhysicsWarehouseByLogic(arrangeWarehouseReqDto.getLogicalWarehouseCode());
            if (Objects.nonNull(physicsWarehouseByLogic)) {
                updateEo.setPhysicsWarehouseCode(physicsWarehouseByLogic.getRefWarehouseCode());
                updateEo.setPhysicsWarehouseId(Long.valueOf(physicsWarehouseByLogic.getRefWarehouseId()));
                updateEo.setPhysicsWarehouseName(physicsWarehouseByLogic.getRefWarehouseName());
            }
            this.updateSaleOrderById(saleOrderEo.getId(), updateEo);
        });
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public void cancelAppoint(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoById(orderId);
        this.saleOrderService.markLabel(saleOrderEo.getId(), saleOrderEo.getOptLabel(), OrderOptLabelEnum.CANCEL_APPOINT.getCode());
        this.saleOrderService.updateSaleOrderAssignStatus(saleOrderEo.getId(), SaleOrderAssignStatusEnum.ASSIGN_STATUS_0);
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
        updateEo.setInterceptInfo(EMPTY);
        this.saleOrderService.updateSaleOrderById(orderId, updateEo);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public RestResponse<Void> codeCheck(Long orderId, String operationType) {
        CodesCheckEnum codesCheckEnum = CodesCheckEnum.enumOf((String)operationType);
        return null;
    }

    @Override
    public Boolean checkEnableRest(Long orderId) {
        SaleOrderRespDto saleOrderRespDto = this.querySaleOrderById(orderId);
        if (SaleOrderLevelEnum.CHILD.getType().equals(saleOrderRespDto.getOrderLevel())) {
            this.logger.info("[\u8ba2\u5355\u91cd\u7f6e\u6821\u9a8c]\u5f53\u524d\u91cd\u7f6e\u7684\u8ba2\u5355\u4e3a\u5b50\u8ba2\u5355\uff0c\u5355\u53f7\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo());
            String originalOrderNo = saleOrderRespDto.getOriginalOrderNo();
            DgSaleOrderEo oriOrderEo = this.queryDgSaleOrderEoByNo(originalOrderNo);
            if (SaleOrderStatusEnum.SPLIT.equals((Object)SaleOrderStatusEnum.forCode((String)oriOrderEo.getOrderStatus()))) {
                return Boolean.TRUE;
            }
        } else if (SaleOrderStatusEnum.CANCEL.equals((Object)SaleOrderStatusEnum.forCode((String)saleOrderRespDto.getOrderStatus()))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyAddress(SaleOrderAddrReqDto reqDto) {
        this.saleOrderAddrService.modifySaleOrderAddr(reqDto);
        TrackOptLogUtils.addOrderTrackOptLog((Long)reqDto.getOrderId(), (String)"\u4fee\u6539\u5730\u5740\u4fe1\u606f");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPlanDeliveryDate(Long orderId, String newDate) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        SaleOrderReqDto modifyOrder = new SaleOrderReqDto();
        modifyOrder.setId(orderId);
        modifyOrder.setPlanDeliveryTime(DateUtil.parse((String)newDate));
        this.logger.info("[\u4fee\u6539\u8ba2\u5355\u9884\u8ba1\u53d1\u8d27\u65e5\u671f]\u4fee\u6539\u8ba2\u5355\uff08{}\uff09\u9884\u8ba1\u53d1\u8d27\u65e5\u5fd7\u4e3a\uff1a{}", (Object)orderId, (Object)newDate);
        this.saleOrderService.modifySaleOrder(modifyOrder);
    }

    @Override
    public Boolean checkEnabelBackCheck(Long id) {
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoById(id);
        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getMainOrderNo()) && !saleOrderEo.getMainOrderNo().equals(saleOrderEo.getSaleOrderNo())) {
            this.logger.error("[\u53cd\u5ba1]\u5f53\u524d\u8ba2\u5355\u4e0d\u662f\u4e3b\u5355\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u64cd\u4f5c\uff0c\u8ba2\u5355\u7684\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderEo));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public void doStatusLock(Long orderId) {
        List<String> labelCodes = Optional.ofNullable(this.orderLabelRecordService.queryExistLabelCode(orderId, Arrays.asList(OrderLabelEnum.LOCK, OrderLabelEnum.UNLOCK))).orElse(Lists.newArrayList());
        if (labelCodes.contains(OrderLabelEnum.LOCK.getCode())) {
            throw PcpTradeExceptionCode.LOCK_EXIST.builderException();
        }
        Boolean resultFlag = Boolean.FALSE;
        if (!resultFlag.booleanValue()) {
            throw PcpTradeExceptionCode.LOCK_FAIL.builderException();
        }
        this.orderLabelRecordService.removeOrderLabelRecordById(orderId, OrderLabelEnum.UNLOCK);
        this.orderLabelRecordService.addOrderLabelRecord(orderId, OrderLabelEnum.LOCK);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public void doStatusUnLock(Long orderId) {
        List<String> labelCodes = Optional.ofNullable(this.orderLabelRecordService.queryExistLabelCode(orderId, Arrays.asList(OrderLabelEnum.LOCK, OrderLabelEnum.UNLOCK))).orElse(Lists.newArrayList());
        if (labelCodes.contains(OrderLabelEnum.UNLOCK.getCode())) {
            throw PcpTradeExceptionCode.UNLOCK_EXIST.builderException();
        }
        Boolean resultFlag = Boolean.FALSE;
        if (!resultFlag.booleanValue()) {
            throw PcpTradeExceptionCode.UNLOCK_FAIL.builderException();
        }
        this.orderLabelRecordService.removeOrderLabelRecordById(orderId, OrderLabelEnum.LOCK);
        this.orderLabelRecordService.addOrderLabelRecord(orderId, OrderLabelEnum.UNLOCK);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#reqDto.getSaleOrderId()")
    @Transactional(rollbackFor={Exception.class})
    public List<BizSaleOrderRespDto> splitOrderByAppointBatch(SplitOrderByBatchReqDto reqDto) {
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoById(reqDto.getSaleOrderId());
        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getSecondOrderStatus())) {
            this.checkSaleOrderStatus((SaleOrderStatus)SecondSaleOrderStatusEnum.forCode((String)saleOrderEo.getSecondOrderStatus()), new SaleOrderStatus[]{SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK});
        }
        reqDto.setInitOrderStatus(SaleOrderStatusEnum.WAIT_CHECK.getCode());
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderEo.getId());
        List saleOrderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        AssertUtils.notEmpty((Collection)saleOrderItemEos, (String)"\u8ba2\u5355\uff08saleOrderNo=%s\uff09\u5546\u54c1\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{saleOrderEo.getSaleOrderNo()});
        Map<String, List<SplitOrderItemReqDto>> warehouseCodeAndItemsMap = this.mergeBatchAndGroupbyWarehouse(reqDto);
        this.checkEnoughForInventory(reqDto);
        ArrayList list = null;
        if (warehouseCodeAndItemsMap.size() == 1) {
            List<SplitOrderItemReqDto> orderItemReqDtos = warehouseCodeAndItemsMap.entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
            Boolean canSplit = this.checkSplitLegal(orderItemReqDtos, saleOrderEo, saleOrderItemEos, warehouseCodeAndItemsMap.size());
            if (!canSplit.booleanValue()) {
                this.appointBatch(reqDto, warehouseCodeAndItemsMap);
                list = Lists.newArrayList();
                this.saleOrderService.markLabel(saleOrderEo.getId(), saleOrderEo.getOptLabel(), OrderOptLabelEnum.APPOINT_BATCH.getCode());
            } else {
                list = this.splitAndAppointBatch(reqDto, warehouseCodeAndItemsMap);
            }
        } else {
            list = this.splitAndAppointBatch(reqDto, warehouseCodeAndItemsMap);
        }
        return list;
    }

    private void appointBatch(SplitOrderByBatchReqDto reqDto, Map<String, List<SplitOrderItemReqDto>> warehouseCodeAndItemsMap) {
        this.logger.info("[\u6307\u5b9a\u6279\u6b21]\u8ba2\u5355\u65e0\u9700\u62c6\u5355\uff0c\u76f4\u63a5\u6307\u5b9a\u6279\u6b21\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(warehouseCodeAndItemsMap));
        warehouseCodeAndItemsMap.forEach((deliveryLogicalWarehouseCode, orderItemList) -> {
            RestResponse listRestResponse = this.logicWarehouseExposedQueryApi.queryList((List)Lists.newArrayList((Object[])new String[]{deliveryLogicalWarehouseCode}));
            List logicWarehousePageRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
            this.logger.info("[\u6307\u5b9a\u6279\u6b21]\u67e5\u8be2\u5230\u903b\u8f91\u4ed3\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)logicWarehousePageRespDtos));
            AssertUtils.notEmpty((Collection)logicWarehousePageRespDtos, (String)"\u903b\u8f91\u4ed3(code=%s\u4e0d\u5b58\u5728", (Object[])new Object[]{deliveryLogicalWarehouseCode});
            CsLogicWarehouseRespDto logicWarehousePageRespDto = (CsLogicWarehouseRespDto)logicWarehousePageRespDtos.get(0);
            DgSaleOrderEo updateOrderEo = new DgSaleOrderEo();
            updateOrderEo.setId(reqDto.getSaleOrderId());
            updateOrderEo.setLogicalWarehouseCode(logicWarehousePageRespDto.getWarehouseCode());
            updateOrderEo.setLogicalWarehouseId(logicWarehousePageRespDto.getId());
            updateOrderEo.setLogicalWarehouseName(logicWarehousePageRespDto.getWarehouseName());
            this.updateSaleOrderById(reqDto.getSaleOrderId(), updateOrderEo);
            Collections.sort(orderItemList, Comparator.comparing(SplitOrderItemReqDto::getOriginalOrderGoodsId));
            for (SplitOrderItemReqDto orderItemReqDto : orderItemList) {
                DgSaleOrderItemEo updateItemEo = new DgSaleOrderItemEo();
                updateItemEo.setId(orderItemReqDto.getOriginalOrderGoodsId());
                updateItemEo.setDeliveryItemBatchNo(orderItemReqDto.getBatch());
                updateItemEo.setLogicalWarehouseId(logicWarehousePageRespDto.getId());
                updateItemEo.setLogicalWarehouseCode(logicWarehousePageRespDto.getWarehouseCode());
                updateItemEo.setLogicalWarehouseName(logicWarehousePageRespDto.getWarehouseName());
                this.dgSaleOrderItemDomain.updateSelective((BaseEo)updateItemEo);
            }
        });
    }

    private void checkEnoughForInventory(SplitOrderByBatchReqDto reqDto) {
        this.logger.info("[\u6307\u5b9a\u6279\u6b21]\u5f00\u59cb\u6821\u9a8c\u6279\u6b21\u5e93\u5b58\u662f\u5426\u5145\u8db3\uff0c\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List batchItemReqDtos = reqDto.getGoodsList().stream().map(SplitOrderItemReqDto::getBatchList).flatMap(Collection::stream).collect(Collectors.toList());
        List skuCodeList = reqDto.getGoodsList().stream().map(SplitOrderItemReqDto::getGoodsSku).collect(Collectors.toList());
        List batchNoList = batchItemReqDtos.stream().map(SplitBatchItemReqDto::getBatchNo).collect(Collectors.toList());
        List logicalWarehouseCodeList = batchItemReqDtos.stream().map(SplitBatchItemReqDto::getDeliveryLogicalWarehouseCode).collect(Collectors.toList());
        CsInventoryBasicsQueryReqDto inventoryBasicsQueryReqDto = new CsInventoryBasicsQueryReqDto();
        inventoryBasicsQueryReqDto.setInventoryStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        inventoryBasicsQueryReqDto.setLongCodeList(skuCodeList);
        inventoryBasicsQueryReqDto.setWarehouseCodeList(logicalWarehouseCodeList);
        inventoryBasicsQueryReqDto.setBatchList(batchNoList);
        this.logger.info("[\u6307\u5b9a\u6279\u6b21]\u67e5\u8be2\u6307\u5b9a\u6279\u6b21\u7684\u5e93\u5b58\u7684\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)inventoryBasicsQueryReqDto));
        RestResponse listRestResponse = this.inventoryExposedQueryApi.queryCommonInventory(inventoryBasicsQueryReqDto);
        List csInventoryBasicsQueryRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        this.logger.info("[\u6307\u5b9a\u6279\u6b21]\u4ed3\u5e93\u6279\u6b21\u5e93\u5b58\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)csInventoryBasicsQueryRespDtos));
        if (CollectionUtils.isEmpty((Collection)csInventoryBasicsQueryRespDtos)) {
            this.logger.warn("[\u6307\u5b9a\u6279\u6b21]\u6279\u6b21\u5e93\u5b58\u4e0d\u8db3\uff0c\u6307\u5b9a\u7684\u6279\u6b21\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(batchNoList));
            throw PcpTradeExceptionCode.SPLIT_ORDER_BATCH_NOT_ENOUGH.builderException();
        }
        Map<String, BigDecimal> availableMap = csInventoryBasicsQueryRespDtos.stream().collect(Collectors.groupingBy(g -> g.getWarehouseCode() + g.getLongCode() + g.getBatch(), Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(CsInventoryBasicsQueryRespDto::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add))));
        this.logger.info("[\u6307\u5b9a\u6279\u6b21]\u5404\u4e2a\u4ed3\u5e93\u6279\u6b21\u5e93\u5b58\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(availableMap));
        for (SplitOrderItemReqDto itemReqDto : reqDto.getGoodsList()) {
            itemReqDto.getBatchList().forEach(b -> {
                BigDecimal available = (BigDecimal)availableMap.get(b.getDeliveryLogicalWarehouseCode() + itemReqDto.getGoodsSku() + b.getBatchNo());
                if (b.getGoodsNum().compareTo(available) > 0) {
                    this.logger.warn("[\u6307\u5b9a\u6279\u6b21]\u4ed3\u5e93code={}\uff0c\u5546\u54c1longCode={}\uff0c\u6279\u6b21batchNo={} \u5e93\u5b58\u4e0d\u8db3", new Object[]{b.getDeliveryLogicalWarehouseCode(), itemReqDto.getGoodsSku(), b.getBatchNo()});
                    throw PcpTradeExceptionCode.SPLIT_ORDER_BATCH_NOT_ENOUGH.builderException();
                }
            });
        }
    }

    private List<BizSaleOrderRespDto> splitAndAppointBatch(SplitOrderByBatchReqDto reqDto, Map<String, List<SplitOrderItemReqDto>> warehouseCodeAndItemsMap) {
        AssertUtils.notEmpty((Collection)reqDto.getGoodsList(), (String)"\u62c6\u5355\u5546\u54c1\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.logger.trace("[\u6307\u5b9a\u6279\u6b21]\u8fdb\u5165\u62c6\u5355\u64cd\u4f5c\u6d41\u7a0b");
        List deliveryLogicalWarehouseCodeList = warehouseCodeAndItemsMap.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
        RestResponse listRestResponse = this.logicWarehouseExposedQueryApi.queryList(deliveryLogicalWarehouseCodeList);
        List logicWarehousePageRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        this.logger.info("[\u6307\u5b9a\u6279\u6b21]\u67e5\u8be2\u5230\u903b\u8f91\u4ed3\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)logicWarehousePageRespDtos));
        Map warehouseRespDtoMap = Optional.ofNullable(logicWarehousePageRespDtos).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(CsLogicWarehouseRespDto::getWarehouseCode, Function.identity(), (v1, v2) -> v2));
        SplitOrderReqDto splitOrderReqDto = new SplitOrderReqDto();
        splitOrderReqDto.setSaleOrderId(reqDto.getSaleOrderId());
        splitOrderReqDto.setSaleOrderNo(reqDto.getSaleOrderNo());
        splitOrderReqDto.setInitOrderStatus(reqDto.getInitOrderStatus());
        splitOrderReqDto.setOriOrderStatus(SaleOrderStatusEnum.SPLIT.getCode());
        ArrayList orderList = Lists.newArrayList();
        warehouseCodeAndItemsMap.forEach((deliveryLogicalWarehouseCode, goodsList) -> {
            SplitChildOrderReqDto splitChildOrderReqDto = new SplitChildOrderReqDto();
            splitChildOrderReqDto.setGoodsList(goodsList);
            SplitChildOrderReqDto.LogicWarehouse logicWarehouse = new SplitChildOrderReqDto.LogicWarehouse();
            logicWarehouse.setDeliveryLogicWarehouseCode(deliveryLogicalWarehouseCode);
            CsLogicWarehouseRespDto warehousePageRespDto = (CsLogicWarehouseRespDto)warehouseRespDtoMap.get(deliveryLogicalWarehouseCode);
            if (warehousePageRespDto != null) {
                logicWarehouse.setDeliveryLogicWarehouseName(warehousePageRespDto.getWarehouseName());
                logicWarehouse.setDeliveryLogicWarehouseId(warehousePageRespDto.getId());
            }
            splitChildOrderReqDto.setLogicWarehouse(logicWarehouse);
            orderList.add(splitChildOrderReqDto);
        });
        splitOrderReqDto.setOrderList((List)orderList);
        this.logger.info("[\u6307\u5b9a\u6279\u6b21]\u62c6\u5355\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
        List<BizSaleOrderRespDto> saleOrderRespDtoList = this.splitOrderTcbj(splitOrderReqDto);
        this.processYphTagForSplitOrders(splitOrderReqDto.getSaleOrderNo(), saleOrderRespDtoList);
        if (CollectionUtils.isNotEmpty(saleOrderRespDtoList)) {
            for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtoList) {
                if (saleOrderRespDto == null || StringUtils.isEmpty((CharSequence)saleOrderRespDto.getLogicalWarehouseCode())) continue;
                this.saleOrderService.markLabel(saleOrderRespDto.getId(), saleOrderRespDto.getOptLabel(), OrderOptLabelEnum.APPOINT_BATCH.getCode());
            }
        }
        return saleOrderRespDtoList;
    }

    @Override
    public Map<String, List<SplitOrderItemReqDto>> mergeBatchAndGroupbyWarehouse(SplitOrderByBatchReqDto reqDto) {
        HashMap warehouseCodeAndItemsMap = Maps.newHashMap();
        AssertUtils.notEmpty((Collection)reqDto.getGoodsList(), (String)"\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        reqDto.getGoodsList().forEach(orderGoods -> {
            if (CollectionUtils.isNotEmpty((Collection)orderGoods.getBatchList())) {
                List<SplitBatchItemReqDto> mergeList = orderGoods.getBatchList().stream().collect(Collectors.toMap(SplitBatchItemReqDto::uniKey, o -> o, (o1, o2) -> {
                    o1.setGoodsNum(o1.getGoodsNum().add(o2.getGoodsNum()));
                    return o1;
                })).values().stream().collect(Collectors.toList());
                mergeList.forEach(splitBatchItemReqDto -> warehouseCodeAndItemsMap.compute(splitBatchItemReqDto.getDeliveryLogicalWarehouseCode(), (k, v) -> {
                    if (v == null) {
                        v = Lists.newArrayList();
                    }
                    SplitOrderItemReqDto splitOrderItemReqDto = new SplitOrderItemReqDto();
                    splitOrderItemReqDto.setBatch(splitBatchItemReqDto.getBatchNo());
                    splitOrderItemReqDto.setOriginalOrderGoodsId(orderGoods.getOriginalOrderGoodsId());
                    splitOrderItemReqDto.setGoodsNum(splitBatchItemReqDto.getGoodsNum());
                    splitOrderItemReqDto.setIsGiftFlag(orderGoods.getIsGiftFlag());
                    splitOrderItemReqDto.setGoodsId(orderGoods.getGoodsId());
                    splitOrderItemReqDto.setGoodsCode(orderGoods.getGoodsCode());
                    splitOrderItemReqDto.setGoodsSku(orderGoods.getGoodsSku());
                    v.add(splitOrderItemReqDto);
                    return v;
                }));
                orderGoods.setBatchList(mergeList);
            }
        });
        this.logger.info("[\u6307\u5b9a\u6279\u6b21]\u5408\u5e76\u6307\u5b9a\u6279\u6b21\u7684\u62c6\u5355\u53c2\u6570\u540e\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return warehouseCodeAndItemsMap;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public void unlock(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.logger.info("[\u624b\u5de5\u89e3\u9501]\u89e3\u9501\u8ba2\u5355\uff0corderId={}", (Object)orderId);
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoById(orderId);
        if (Objects.isNull(saleOrderEo.getSecondOrderStatus())) {
            throw PcpTradeExceptionCode.CHECK_STATUS_STATUS_NOT_ALLOW.buildBizException(new Object[]{SaleOrderStatusEnum.forCode((String)saleOrderEo.getOrderStatus()).getDesc()});
        }
        this.checkOrderTransfer(saleOrderEo.getSaleOrderNo());
        this.saleOrderService.markAndRemoveLabel(saleOrderEo.getId(), saleOrderEo.getOptLabel(), Lists.newArrayList((Object[])new String[]{OrderOptLabelEnum.UN_LOCK.getCode()}), Lists.newArrayList((Object[])new String[]{OrderOptLabelEnum.CANCEL_APPOINT.getCode()}));
        if (!SaleOrderTypeEnum.BB_TRANSFER_CLAIM_NOT_REISSUE.getType().equals(saleOrderEo.getOrderType()) && !SaleOrderTypeEnum.DS_TRANSFER_CLAIMS_NOT_REISSUE.getType().equals(saleOrderEo.getOrderType())) {
            this.logger.info("\u8ba2\u5355\u7c7b\u578b\u4e3a\uff1a{},\u975e\u7535\u5546\u7d22\u8d54\u5355\u624d\u9700\u8981\u6e05\u7a7a\u53d1\u8d27\u4ed3\u4fe1\u606f", (Object)saleOrderEo.getOrderType());
            saleOrderEo.setLogicalWarehouseCode(null);
            saleOrderEo.setLogicalWarehouseId(null);
            saleOrderEo.setLogicalWarehouseName(null);
            saleOrderEo.setPhysicsWarehouseName(null);
            saleOrderEo.setPhysicsWarehouseId(null);
            saleOrderEo.setPhysicsWarehouseCode(null);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(DgSaleOrderEo::getLogicalWarehouseCode, null)).set(DgSaleOrderEo::getLogicalWarehouseId, null)).set(DgSaleOrderEo::getLogicalWarehouseName, null)).set(DgSaleOrderEo::getPhysicsWarehouseCode, null)).set(DgSaleOrderEo::getPhysicsWarehouseId, null)).set(DgSaleOrderEo::getPhysicsWarehouseName, null)).eq(BaseEo::getId, (Object)saleOrderEo.getId());
            this.dgSaleOrderDomain.getMapper().update(null, (Wrapper)updateWrapper);
            try {
                this.saleTransferExtDomain.delByOrderId(orderId);
            }
            catch (Exception e) {
                this.logger.info("\u5220\u9664\u8ba2\u5355\u5173\u8054\u7684\u8c03\u62e8\u5355\u62a5\u9519:{}", (Object)e.getMessage());
            }
        }
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK.getCode());
        this.optimisticSaleOrderChildStatus(updateEo, orderId, SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT);
    }

    @Override
    public void batchCodesCheck(CodesCheckReqDto reqDto) {
        CodesCheckEnum codesCheckEnum = CodesCheckEnum.enumOf((String)reqDto.getOperationType());
    }

    private void deliverOrderForSource(String orderNo, SourceOrderResultRespDto sourceOrderResultRespDto, Consumer<ArrangeWarehouseReqDto> complete) {
        this.logger.info("[\u5bfb\u6e90]\u8ba2\u5355({})\u76f4\u63a5\u8fdb\u884c\u53d1\u8d27\u64cd\u4f5c", (Object)orderNo);
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoByNo(orderNo);
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderEo.getId());
        List orderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        AssertUtils.notEmpty((Collection)orderItemEos, (String)String.format("\u8ba2\u5355(%s)\u6570\u636e\u5b58\u5728\u5f02\u5e38", orderNo));
        OrderItemResultRespDto orderItemResultRespDto = (OrderItemResultRespDto)sourceOrderResultRespDto.getOrderItemResultRespDtoList().get(0);
        List<ArrangeWarehouseReqDto> arrangeWarehouseReqDtos = orderItemEos.stream().map(saleOrderItemEo -> {
            ArrangeWarehouseReqDto arrangeWarehouseReqDto = new ArrangeWarehouseReqDto();
            arrangeWarehouseReqDto.setOrderId(saleOrderItemEo.getOrderId());
            arrangeWarehouseReqDto.setLogicalWarehouseId(orderItemResultRespDto.getDeliveryLogicWarehouseId());
            arrangeWarehouseReqDto.setLogicalWarehouseCode(orderItemResultRespDto.getDeliveryLogicWarehouseCode());
            arrangeWarehouseReqDto.setLogicalWarehouseName(orderItemResultRespDto.getDeliveryLogicWarehouseName());
            arrangeWarehouseReqDto.setOrderItemId(saleOrderItemEo.getId());
            if (StringUtils.isNotBlank((CharSequence)saleOrderItemEo.getDeliveryItemBatchNo())) {
                String batchNo = saleOrderItemEo.getDeliveryItemBatchNo();
                arrangeWarehouseReqDto.setBatchNo(batchNo);
            }
            return arrangeWarehouseReqDto;
        }).collect(Collectors.toList());
        this.logger.info("[\u5bfb\u6e90]\u5bfb\u6e90\u83b7\u53d6\u5230\u6307\u5b9a\u903b\u8f91\u4ed3\u53d1\u8d27\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(arrangeWarehouseReqDtos));
        this.arrangeWarehouseForDeliver(saleOrderEo.getId(), arrangeWarehouseReqDtos, complete);
    }

    private void deliverClaimOrderForLogicWarehouse(String orderNo, Consumer<ArrangeWarehouseReqDto> complete) {
        this.logger.info("[\u7d22\u8d54\u8ba2\u5355\u53d1\u8d27]\u8ba2\u5355({})\u76f4\u63a5\u8fdb\u884c\u53d1\u8d27\u64cd\u4f5c", (Object)orderNo);
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoByNo(orderNo);
        if (StringUtils.isEmpty((CharSequence)saleOrderEo.getLogicalWarehouseCode())) {
            throw PcpTradeExceptionCode.CLAIM_ORDER_PICK.buildBizException(new Object[0]);
        }
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderEo.getId());
        List orderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        AssertUtils.notEmpty((Collection)orderItemEos, (String)String.format("\u8ba2\u5355(%s)\u6570\u636e\u5b58\u5728\u5f02\u5e38", orderNo));
        List<ArrangeWarehouseReqDto> arrangeWarehouseReqDtos = orderItemEos.stream().map(saleOrderItemEo -> {
            ArrangeWarehouseReqDto arrangeWarehouseReqDto = new ArrangeWarehouseReqDto();
            arrangeWarehouseReqDto.setOrderId(saleOrderItemEo.getOrderId());
            arrangeWarehouseReqDto.setLogicalWarehouseId(saleOrderEo.getLogicalWarehouseId());
            arrangeWarehouseReqDto.setLogicalWarehouseCode(saleOrderEo.getLogicalWarehouseCode());
            arrangeWarehouseReqDto.setLogicalWarehouseName(saleOrderEo.getLogicalWarehouseName());
            arrangeWarehouseReqDto.setOrderItemId(saleOrderItemEo.getId());
            if (StringUtils.isNotBlank((CharSequence)saleOrderItemEo.getDeliveryItemBatchNo())) {
                String batchNo = saleOrderItemEo.getDeliveryItemBatchNo();
                arrangeWarehouseReqDto.setBatchNo(batchNo);
            }
            return arrangeWarehouseReqDto;
        }).collect(Collectors.toList());
        this.logger.info("[\u7d22\u8d54\u8ba2\u5355\u53d1\u8d27]\u6307\u5b9a\u903b\u8f91\u4ed3\u53d1\u8d27\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(arrangeWarehouseReqDtos));
        this.arrangeWarehouseForDeliver(saleOrderEo.getId(), arrangeWarehouseReqDtos, complete);
    }

    private List<BizSaleOrderRespDto> splitOrderForSource(Map<String, List<OrderItemResultRespDto>> sourceOrderResultRespDto, String linkOrderNo) {
        SplitOrderReqDto splitOrderReqDto = new SplitOrderReqDto();
        ArrayList orderList = Lists.newArrayList();
        splitOrderReqDto.setSaleOrderNo(linkOrderNo);
        splitOrderReqDto.setInitOrderStatus(SaleOrderStatusEnum.WAIT_PICK.getCode());
        splitOrderReqDto.setInitOmsOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
        splitOrderReqDto.setSourceDeliveryFlag(Boolean.TRUE.booleanValue());
        sourceOrderResultRespDto.forEach((deliveryLogicWarehouseCode, orderItemResultList) -> {
            OrderItemResultRespDto orderItemResultRespDto = (OrderItemResultRespDto)orderItemResultList.get(0);
            SplitChildOrderReqDto splitChildOrderReqDto = new SplitChildOrderReqDto();
            SplitChildOrderReqDto.LogicWarehouse logicWarehouse = new SplitChildOrderReqDto.LogicWarehouse();
            logicWarehouse.setDeliveryLogicWarehouseId(orderItemResultRespDto.getDeliveryLogicWarehouseId());
            logicWarehouse.setDeliveryLogicWarehouseCode(orderItemResultRespDto.getDeliveryLogicWarehouseCode());
            logicWarehouse.setDeliveryLogicWarehouseName(orderItemResultRespDto.getDeliveryLogicWarehouseName());
            splitChildOrderReqDto.setLogicWarehouse(logicWarehouse);
            splitChildOrderReqDto.setOrderStatus(SaleOrderStatusEnum.WAIT_PICK.getCode());
            Map sgOrderItemMap = orderItemResultList.stream().collect(Collectors.toMap(OrderItemResultRespDto::getLinkOrderItemId, Function.identity(), (v1, v2) -> {
                v1.setDeliveryItemNum(v1.getDeliveryItemNum().add(v2.getDeliveryItemNum()));
                return v1;
            }));
            List splitOrderItemReqDtos = sgOrderItemMap.values().stream().map(orderItemResult -> {
                SplitOrderItemReqDto splitOrderItemReqDto = new SplitOrderItemReqDto();
                splitOrderItemReqDto.setOriginalOrderGoodsId(orderItemResult.getLinkOrderItemId());
                splitOrderItemReqDto.setGoodsNum(orderItemResult.getDeliveryItemNum());
                splitOrderItemReqDto.setLinkSourceResultItemId(orderItemResult.getLinkOrderItemId());
                splitOrderItemReqDto.setDeliveryItemBatchNo(orderItemResult.getDeliveryItemBatchNo());
                return splitOrderItemReqDto;
            }).collect(Collectors.toList());
            splitChildOrderReqDto.setGoodsList(splitOrderItemReqDtos);
            orderList.add(splitChildOrderReqDto);
        });
        splitOrderReqDto.setOrderList((List)orderList);
        this.logger.info("[\u62c6\u5355]\u5bfb\u6e90\u540e\u8bf7\u6c42\u62c6\u5355\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
        List<BizSaleOrderRespDto> bizSaleOrderRespDtos = this.splitOrderTcbj(splitOrderReqDto);
        this.processYphTagForSplitOrders(linkOrderNo, bizSaleOrderRespDtos);
        return bizSaleOrderRespDtos;
    }

    private SourceOrderResultRespDto searchSource(SearchSourceReqDto reqDto) {
        this.logger.info("[\u5bfb\u6e90]\u5f00\u59cb\u5bfb\u6e90");
        String saleOrderNo = reqDto.getSaleOrderNo();
        BizSaleOrderRespDto bizSaleOrderRespDto = this.saleOrderService.queryByOrderNo(saleOrderNo);
        AssertUtils.notNull((Object)bizSaleOrderRespDto, (String)"\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        SourceOrderResultReqDto sourceOrderResultReqDto = new SourceOrderResultReqDto();
        CubeBeanUtils.copyProperties((Object)sourceOrderResultReqDto, (Object)reqDto, (String[])new String[0]);
        sourceOrderResultReqDto.setLinkOrderNo(bizSaleOrderRespDto.getSaleOrderNo());
        sourceOrderResultReqDto.setLinkOrderType(bizSaleOrderRespDto.getOrderType());
        sourceOrderResultReqDto.setLinkOrderTotalItemNum(bizSaleOrderRespDto.getGoodsTotalNum());
        sourceOrderResultReqDto.setLinkOrderChannelCode(bizSaleOrderRespDto.getChannelCode());
        sourceOrderResultReqDto.setLinkOrderChannelId(bizSaleOrderRespDto.getChannelId());
        sourceOrderResultReqDto.setLinkOrderCustomerId(bizSaleOrderRespDto.getCustomerId());
        sourceOrderResultReqDto.setLinkOrderCustomerName(bizSaleOrderRespDto.getCustomerName());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseId(bizSaleOrderRespDto.getDefaultLogicalWarehouseId());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseCode(bizSaleOrderRespDto.getDefaultLogicalWarehouseCode());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseName(bizSaleOrderRespDto.getDefaultLogicalWarehouseName());
        sourceOrderResultReqDto.setLinkOrderTotalItemNum(bizSaleOrderRespDto.getGoodsTotalNum());
        sourceOrderResultReqDto.setLinkPlatformOrderNo(bizSaleOrderRespDto.getPlatformOrderNo());
        sourceOrderResultReqDto.setLinkOrderChannelName(bizSaleOrderRespDto.getChannelName());
        if (Objects.isNull(reqDto.getSgSourceCanSplit())) {
            sourceOrderResultReqDto.setSgSourceCanSplit(bizSaleOrderRespDto.getAllowSplitFlag());
        }
        sourceOrderResultReqDto.setLinkOrderChannelWarehouseId(bizSaleOrderRespDto.getChannelWarehouseId());
        sourceOrderResultReqDto.setLinkOrderChannelWarehouseCode(bizSaleOrderRespDto.getChannelWarehouseCode());
        sourceOrderResultReqDto.setLinkOrderChannelWarehouseName(bizSaleOrderRespDto.getChannelWarehouseName());
        sourceOrderResultReqDto.setStoragePlace(bizSaleOrderRespDto.getStoragePlace());
        if (com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum.MAIYOU_ALLOT.getCode().equalsIgnoreCase(bizSaleOrderRespDto.getOrderType())) {
            List csLogicWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseExposedQueryApi.queryList((List)Lists.newArrayList((Object[])new String[]{bizSaleOrderRespDto.getAllotInWarehouseCode()})));
            CsLogicWarehouseRespDto csLogicWarehouseRespDto = (CsLogicWarehouseRespDto)csLogicWarehouseRespDtos.get(0);
            sourceOrderResultReqDto.setOrganizationId(csLogicWarehouseRespDto.getOrganizationId());
            sourceOrderResultReqDto.setOrganizationCode(csLogicWarehouseRespDto.getOrganizationCode());
            sourceOrderResultReqDto.setOrganizationName(csLogicWarehouseRespDto.getOrganizationName());
        } else {
            sourceOrderResultReqDto.setOrganizationId(bizSaleOrderRespDto.getOrganizationId());
            sourceOrderResultReqDto.setOrganizationCode(bizSaleOrderRespDto.getOrganizationCode());
            sourceOrderResultReqDto.setOrganizationName(bizSaleOrderRespDto.getOrganizationName());
        }
        sourceOrderResultReqDto.setIsOnline(bizSaleOrderRespDto.getIsOnline());
        OrderAddrReqDto orderAddrReqDto = new OrderAddrReqDto();
        CubeBeanUtils.copyProperties((Object)orderAddrReqDto, (Object)bizSaleOrderRespDto.getOrderAddrRespDto(), (String[])new String[0]);
        sourceOrderResultReqDto.setOrderAddrReqDto(orderAddrReqDto);
        sourceOrderResultReqDto.setLinkOrderSnapshot(JSON.toJSONString((Object)bizSaleOrderRespDto));
        List orderItemReqDtoList = bizSaleOrderRespDto.getItemList().stream().map(saleOrderItemExtRespDto -> {
            OrderItemReqDto orderItemReqDto = new OrderItemReqDto();
            CubeBeanUtils.copyProperties((Object)orderItemReqDto, (Object)saleOrderItemExtRespDto, (String[])new String[0]);
            orderItemReqDto.setLinkOrderItemId(saleOrderItemExtRespDto.getId());
            orderItemReqDto.setLinkOrderType(SourceLinkOrderTypeEnum.SALE_ORDER.getCode());
            orderItemReqDto.setItemSkuCode(saleOrderItemExtRespDto.getSkuCode());
            orderItemReqDto.setItemBatchNo(saleOrderItemExtRespDto.getBatchNo());
            orderItemReqDto.setItemGiftType(saleOrderItemExtRespDto.getGift());
            orderItemReqDto.setLinkOrderNo(bizSaleOrderRespDto.getSaleOrderNo());
            return orderItemReqDto;
        }).collect(Collectors.toList());
        sourceOrderResultReqDto.setOrderItemReqDtoList(orderItemReqDtoList);
        this.logger.info("[\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u5bfb\u6e90\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)saleOrderNo, (Object)JSON.toJSONString((Object)sourceOrderResultReqDto));
        RestResponse sourceOrderResultRespDtoRestResp = this.orderOptApiProxy.addSourceOrder(sourceOrderResultReqDto);
        SourceOrderResultRespDto sourceOrderResultRespDto = (SourceOrderResultRespDto)RestResponseHelper.extractData((RestResponse)sourceOrderResultRespDtoRestResp);
        this.logger.info("[\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355({})\u5bfb\u6e90\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)saleOrderNo, (Object)JSON.toJSONString((Object)sourceOrderResultRespDto));
        if (SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
            this.saleIntransitCache.setSaleIntranst(saleOrderNo, sourceOrderResultRespDto.getIntransitPreemptFlag());
            Map<String, Boolean> saleItemInMap = sourceOrderResultRespDto.getOrderItemResultRespDtoList().stream().collect(Collectors.toMap(i -> i.getLinkOrderItemId() + "_" + i.getDeliveryLogicWarehouseCode(), result -> Objects.nonNull(result.getZtDeliveryWarehouseItemNum()) && result.getZtDeliveryWarehouseItemNum().compareTo(BigDecimal.ZERO) > 0, (k1, k2) -> k1 != false ? k1 : k2));
            this.saleIntransitCache.setSaleItemIntranst(saleOrderNo, saleItemInMap);
        }
        this.sourceRecordService.saveSourceRecord(sourceOrderResultRespDto);
        this.buildSourceExceptionMsg(sourceOrderResultRespDto, bizSaleOrderRespDto.getId());
        return sourceOrderResultRespDto;
    }

    private void buildSourceExceptionMsg(SourceOrderResultRespDto sourceOrderResultRespDto, Long saleOrderId) {
        if (StringUtils.equals((CharSequence)SourceStatusEnum.SOURCE_FAIL.getCode(), (CharSequence)sourceOrderResultRespDto.getSgStatus())) {
            throw new BizException(PcpTradeExceptionCode.PICK_FAIL.getCode(), String.format("\u5bfb\u6e90\u5931\u8d25\uff1a%s", sourceOrderResultRespDto.getSgFailResultDesc()));
        }
    }

    private void checkSplitOrderBySkuParams(String splitSku, DgSaleOrderEo saleOrderEo) {
        this.logger.info("[\u6279\u91cf\u62c6\u5355]\u5f00\u59cb\u6821\u9a8c\u53c2\u6570\uff0c\u5f53\u524d\u8ba2\u5355({})\u80fd\u5426\u62c6skucode={}", (Object)saleOrderEo.getSaleOrderNo(), (Object)splitSku);
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderEo.getId());
        List saleOrderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        queryOrderItemWrapper.eq(DgSaleOrderItemEo::getSkuCode, (Object)splitSku);
        List splitSaleOrderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        if (CollectionUtils.isEmpty((Collection)splitSaleOrderItemEos)) {
            this.logger.error("[\u6279\u91cf\u62c6\u5355]\u5f53\u524d\u8ba2\u5355({})\u4e0d\u5b58\u5728\u8be5sku({})", (Object)saleOrderEo.getSaleOrderNo(), (Object)splitSku);
            throw PcpTradeExceptionCode.SPLIT_ORDER_SKU_NOT_EXIT.builderException();
        }
        List<SplitOrderItemReqDto> splitOrderItemReqDtos = splitSaleOrderItemEos.stream().map(saleOrderItemEo -> {
            SplitOrderItemReqDto splitOrderItemReqDto = new SplitOrderItemReqDto();
            splitOrderItemReqDto.setBatch(saleOrderItemEo.getBatchNo());
            splitOrderItemReqDto.setGoodsSku(saleOrderItemEo.getSkuCode());
            splitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemEo.getId());
            splitOrderItemReqDto.setIsGiftFlag(saleOrderItemEo.getGift());
            splitOrderItemReqDto.setGoodsNum(saleOrderItemEo.getItemNum());
            return splitOrderItemReqDto;
        }).collect(Collectors.toList());
        Boolean canSplit = this.checkSplitLegal(splitOrderItemReqDtos, saleOrderEo, saleOrderItemEos, 1);
        if (!canSplit.booleanValue()) {
            throw new BizException(PcpTradeExceptionCode.SPLIT_ORDER_NUM_EXCEPTION.getCode(), String.format("\u5f53\u524d\u8ba2\u5355(%s)\u62c6\u5355\u89c4\u5219\u4e0d\u5408\u6cd5\uff01", saleOrderEo.getSaleOrderNo()));
        }
    }

    private void copyOrderAddress(Long oriSaleOrderId, Long childSaleOrderId) {
        AssertUtils.notNull((Object)oriSaleOrderId, (String)"oriSaleOrderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)childSaleOrderId, (String)"childSaleOrderId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.saleOrderAddrService.copyOrderAddress(oriSaleOrderId, childSaleOrderId);
    }

    private void copyOrderTag(Long oriSaleOrderId, List<Long> childSaleOrderIds) {
        AssertUtils.notNull((Object)oriSaleOrderId, (String)"oriSaleOrderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notEmpty(childSaleOrderIds, (String)"childSaleOrderId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.orderTagRecordService.copyOrderTag(oriSaleOrderId, childSaleOrderIds);
    }

    private DgSaleOrderEo createChildOrderForRemain(DgSaleOrderEo saleOrderEo, List<SplitOrderItemReqDto> splitOrderItemReqDtos, String initOrderStatus, String secondOrderStatus, boolean splitNotDeliveryFlag) {
        this.logger.debug("[\u624b\u52a8\u62c6\u5355]\u8ba2\u5355({})\u5269\u4f59\u5546\u54c1\u8fdb\u884c\u5408\u5355\uff0c\u5408\u6210\u4e00\u5f20\u5b50\u5355", (Object)saleOrderEo.getSaleOrderNo());
        Map<Long, List<SplitOrderItemReqDto>> skuSplitMap = splitOrderItemReqDtos.stream().collect(Collectors.groupingBy(SplitOrderItemReqDto::getOriginalOrderGoodsId));
        HashMap splitOrderItemIdCountMap = new HashMap();
        skuSplitMap.forEach((orderItemId, splitOrderList) -> {
            BigDecimal orderItemIdCount = splitOrderList.stream().map(SplitOrderItemReqDto::getGoodsNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            splitOrderItemIdCountMap.put(orderItemId, orderItemIdCount);
        });
        this.logger.info("[\u624b\u52a8\u62c6\u5355]\u6c47\u603b\u5404\u4e2a\u5546\u54c1\u62c6\u5355\u7684\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString(splitOrderItemIdCountMap));
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderEo.getId());
        List oriSaleOrderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        AssertUtils.notEmpty((Collection)oriSaleOrderItemEos, (String)"\u539f\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
        ArrayList remainFoodsList = Lists.newArrayList();
        oriSaleOrderItemEos.forEach(saleOrderItemEo -> {
            BigDecimal splitCount = (BigDecimal)splitOrderItemIdCountMap.get(saleOrderItemEo.getId());
            SplitOrderItemReqDto splitOrderItemReqDto = new SplitOrderItemReqDto();
            splitOrderItemReqDto.setGoodsSku(saleOrderItemEo.getSkuCode());
            splitOrderItemReqDto.setIsGiftFlag(saleOrderItemEo.getGift());
            splitOrderItemReqDto.setBatch(saleOrderItemEo.getBatchNo());
            splitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemEo.getId());
            if (splitCount != null) {
                if (saleOrderItemEo.getItemNum().compareTo(splitCount) > 0) {
                    BigDecimal remainItemCount = saleOrderItemEo.getItemNum().subtract(splitCount);
                    splitOrderItemReqDto.setGoodsNum(remainItemCount);
                    remainFoodsList.add(splitOrderItemReqDto);
                }
            } else {
                BigDecimal remainItemCount = saleOrderItemEo.getItemNum();
                splitOrderItemReqDto.setGoodsNum(remainItemCount);
                remainFoodsList.add(splitOrderItemReqDto);
            }
        });
        this.logger.info("[\u624b\u52a8\u62c6\u5355]\u5269\u4f59\u7684\u8ba2\u5355\u5546\u54c1\u7684\u62c6\u5355\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)remainFoodsList));
        if (CollectionUtils.isEmpty((Collection)remainFoodsList)) {
            this.logger.info("[\u624b\u52a8\u62c6\u5355]\u8ba2\u5355\u5546\u54c1\u5df2\u88ab\u5168\u90e8\u62c6\u5206\u5b8c\uff0c\u6ca1\u6709\u5269\u4f59\u5546\u54c1\uff0c\u65e0\u9700\u518d\u6784\u9020\u5b50\u5355");
            return null;
        }
        DgSaleOrderEo childOrder = this.createChildOrder(saleOrderEo, remainFoodsList, null, initOrderStatus, secondOrderStatus, splitNotDeliveryFlag);
        this.saleOrderItemService.createSplitOrderItem(saleOrderEo, childOrder, remainFoodsList);
        this.copyOrderAddress(saleOrderEo.getId(), childOrder.getId());
        this.copyOrderTag(saleOrderEo.getId(), Lists.newArrayList((Object[])new Long[]{childOrder.getId()}));
        return childOrder;
    }

    private void createChildOrderItem(DgSaleOrderEo saleOrderEo, DgSaleOrderEo childOrder, SplitChildOrderReqDto splitChildOrderReqDto) {
        this.saleOrderItemService.createSplitOrderItem(saleOrderEo, childOrder, splitChildOrderReqDto.getGoodsList());
    }

    private DgSaleOrderEo createChildOrder(DgSaleOrderEo saleOrderEo, List<SplitOrderItemReqDto> splitGoodsList) {
        return this.createChildOrder(saleOrderEo, splitGoodsList, null, saleOrderEo.getOrderStatus(), saleOrderEo.getSecondOrderStatus(), Boolean.FALSE);
    }

    private DgSaleOrderEo createChildOrder(DgSaleOrderEo saleOrderEo, List<SplitOrderItemReqDto> splitGoodsList, SplitChildOrderReqDto.LogicWarehouse logicWarehouse, String childOrderStatus, String secondOrderStatus, boolean splitNotDeliveryFlag) {
        AssertUtils.notEmpty(splitGoodsList, (String)"\u62c6\u5206\u5546\u54c1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List orderItemIdList = splitGoodsList.stream().map(SplitOrderItemReqDto::getOriginalOrderGoodsId).collect(Collectors.toList());
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, orderItemIdList);
        List saleOrderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        Map skusMap = saleOrderItemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        DgSaleOrderEo childOrderEo = new DgSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)childOrderEo, (Object)saleOrderEo, (String[])new String[]{"id", "createTime", "updateTime", "orderStatus", "optLabel", "secondOrderStatus", "interceptInfo"});
        childOrderEo.setOriginalOrderNo(saleOrderEo.getSaleOrderNo());
        childOrderEo.setOrderSource(SaleOrderSourceEnum.SPLIT.getType());
        childOrderEo.setSaleCreateTime(new Date());
        if (StringUtils.isBlank((CharSequence)saleOrderEo.getMainOrderNo())) {
            childOrderEo.setMainOrderNo(saleOrderEo.getSaleOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)childOrderStatus)) {
            childOrderEo.setOrderStatus(childOrderStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)secondOrderStatus)) {
            childOrderEo.setSecondOrderStatus(secondOrderStatus);
        }
        String splitLevel = this.splitLevelRedisUtils.getSplitLevel(saleOrderEo.getSplitLevel(), saleOrderEo.getSaleOrderNo());
        childOrderEo.setSplitLevel(splitLevel);
        String splitPlatformNo = saleOrderEo.getSplitPlatformNo();
        if (StringUtils.isEmpty((CharSequence)splitPlatformNo)) {
            splitPlatformNo = StringUtils.isNotEmpty((CharSequence)saleOrderEo.getEasOrderNo()) ? saleOrderEo.getEasOrderNo() : saleOrderEo.getPlatformOrderNo();
        }
        String leve = splitLevel.substring(splitLevel.indexOf("-"), splitLevel.length());
        childOrderEo.setSplitPlatformNo(splitPlatformNo + leve);
        if (logicWarehouse != null) {
            childOrderEo.setLogicalWarehouseId(logicWarehouse.getDeliveryLogicWarehouseId());
            childOrderEo.setLogicalWarehouseCode(logicWarehouse.getDeliveryLogicWarehouseCode());
            childOrderEo.setLogicalWarehouseName(logicWarehouse.getDeliveryLogicWarehouseName());
            CsRelWarehouseRespDto physicsWarehouseByLogic = this.getPhysicsWarehouseByLogic(childOrderEo.getLogicalWarehouseCode());
            if (Objects.nonNull(physicsWarehouseByLogic)) {
                childOrderEo.setPhysicsWarehouseCode(physicsWarehouseByLogic.getRefWarehouseCode());
                childOrderEo.setPhysicsWarehouseId(Long.valueOf(physicsWarehouseByLogic.getRefWarehouseId()));
                childOrderEo.setPhysicsWarehouseName(physicsWarehouseByLogic.getRefWarehouseName());
            }
            if (!splitNotDeliveryFlag) {
                childOrderEo.setOptLabel(OrderOptLabelEnum.MODIFY_LOGICAL_WAREHOUSE.getCode());
            }
        }
        BigDecimal totalItemCount = splitGoodsList.stream().map(SplitOrderItemReqDto::getGoodsNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal goodsTotalAmount = BigDecimal.ZERO;
        BigDecimal orderTotalAmount = BigDecimal.ZERO;
        BigDecimal payTotalAmount = BigDecimal.ZERO;
        for (SplitOrderItemReqDto splitOrderItemReqDto : splitGoodsList) {
            DgSaleOrderItemEo orderItemEo = (DgSaleOrderItemEo)skusMap.get(splitOrderItemReqDto.getOriginalOrderGoodsId());
            if (Objects.isNull(orderItemEo)) {
                this.logger.warn("[\u624b\u52a8\u62c6\u5355]\u539f\u8ba2\u5355\u4e2d\uff08saleOrderId={}\uff09\u4e0d\u5b58\u5728skuCode={}\u7684\u5546\u54c1", (Object)saleOrderEo.getId(), (Object)splitOrderItemReqDto.getGoodsSku());
                AssertUtils.notNull((Object)orderItemEo, (String)"\u539f\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
            }
            BigDecimal price = Objects.isNull(orderItemEo.getPrice()) ? BigDecimal.ZERO : orderItemEo.getPrice();
            BigDecimal itemNum = Objects.isNull(splitOrderItemReqDto.getGoodsNum()) ? BigDecimal.ZERO : splitOrderItemReqDto.getGoodsNum();
            BigDecimal totalAmount = price.multiply(itemNum).setScale(2);
            goodsTotalAmount = goodsTotalAmount.add(totalAmount);
            orderTotalAmount = orderTotalAmount.add(totalAmount);
            if (!Objects.equals(orderItemEo.getGift(), GiftEnum.NOT_GIFT.getType())) continue;
            payTotalAmount = payTotalAmount.add(totalAmount);
        }
        childOrderEo.setGoodsTotalAmount(goodsTotalAmount);
        childOrderEo.setOrderTotalAmount(payTotalAmount);
        childOrderEo.setPayAmount(payTotalAmount);
        childOrderEo.setGoodsTotalNum(totalItemCount);
        this.logger.info("[\u62c6\u5355]\u521b\u5efa\u5b50\u8ba2\u5355\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)childOrderEo));
        return this.saleOrderService.createChildOrder(childOrderEo);
    }

    private DgSaleOrderEo checkSplitOrder(SplitOrderReqDto reqDto) {
        if (StringUtils.isBlank((CharSequence)reqDto.getSaleOrderNo()) && reqDto.getSaleOrderId() == null) {
            throw new BizException(PcpTradeExceptionCode.ARGS_NOT_EMPTY.getCode(), "\u8ba2\u5355id\u548c\u8ba2\u5355code\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (reqDto.getSaleOrderId() != null) {
            queryWrapper.eq(BaseEo::getId, (Object)reqDto.getSaleOrderId());
        } else if (StringUtils.isNotBlank((CharSequence)reqDto.getSaleOrderNo())) {
            queryWrapper.eq(DgSaleOrderEo::getSaleOrderNo, (Object)reqDto.getSaleOrderNo());
        }
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)this.dgSaleOrderDomain.getMapper().selectOne((Wrapper)queryWrapper);
        AssertUtils.notNull((Object)saleOrderEo, (String)"\u8be5\u9500\u552e\u5355\u4e0d\u5b58\u5728\uff01");
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderEo.getId());
        List saleOrderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        AssertUtils.notEmpty((Collection)saleOrderItemEos, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
        List<SplitOrderItemReqDto> splitOrderItemReqDtos = reqDto.getOrderList().stream().map(SplitChildOrderReqDto::getGoodsList).flatMap(Collection::stream).collect(Collectors.toList());
        Boolean canSplit = this.checkSplitLegal(splitOrderItemReqDtos, saleOrderEo, saleOrderItemEos, reqDto.getOrderList().size());
        if (!canSplit.booleanValue()) {
            throw new BizException(PcpTradeExceptionCode.SPLIT_ORDER_NUM_EXCEPTION.getCode(), String.format("\u5f53\u524d\u8ba2\u5355(%s)\u62c6\u5355\u6709\u8bef\uff01", saleOrderEo.getSaleOrderNo()));
        }
        Map<Long, BigDecimal> splitOrderItemCountMap = reqDto.getOrderList().stream().map(SplitChildOrderReqDto::getGoodsList).flatMap(Collection::stream).collect(Collectors.groupingBy(SplitOrderItemReqDto::getOriginalOrderGoodsId, Collectors.collectingAndThen(Collectors.toList(), item -> item.parallelStream().map(SplitOrderItemReqDto::getGoodsNum).reduce(BigDecimal.ZERO, BigDecimal::add))));
        this.logger.info("[\u624b\u5de5\u62c6\u5355]\u7edf\u8ba1\u6bcf\u4e2a\u5546\u54c1sku\u7684\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString(splitOrderItemCountMap));
        saleOrderItemEos.forEach(saleOrderItemEo -> {
            BigDecimal splitOrderItemCount = (BigDecimal)splitOrderItemCountMap.get(saleOrderItemEo.getId());
            if (splitOrderItemCount != null && splitOrderItemCount.compareTo(saleOrderItemEo.getItemNum()) > 0) {
                this.logger.error("[\u624b\u5de5\u62c6\u5355]\u62c6\u5355\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5546\u54c1saleOrderItemId={}\u8bf7\u6c42\u62c6\u5206\u7684\u6570\u91cf\u4e3a\uff1a{}\uff0c\u539f\u8ba2\u5355\u7684\u6570\u91cf\u4e3a\uff1a{}", new Object[]{saleOrderItemEo.getId(), splitOrderItemCount, saleOrderItemEo.getItemNum()});
                throw PcpTradeExceptionCode.SPLIT_ORDER_GOOD_COUNT_ILLEGAL.builderException();
            }
        });
        return saleOrderEo;
    }

    public Boolean checkSplitLegal(List<SplitOrderItemReqDto> splitOrderItemReqDtos, DgSaleOrderEo saleOrderEo, List<DgSaleOrderItemEo> saleOrderItemEos, int splitOrderCount) {
        BigDecimal splitTotalItemCount = splitOrderItemReqDtos.stream().map(SplitOrderItemReqDto::getGoodsNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal oriOrderItemCount = saleOrderItemEos.stream().map(DgSaleOrderItemEo::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (saleOrderItemEos.size() == splitOrderItemReqDtos.size() && splitTotalItemCount.compareTo(oriOrderItemCount) == 0 && splitOrderCount == 1) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public void cancelOrder(Long orderId, String cancelReason) {
        SaleOrderRespDto saleOrderRespDto = this.saleOrderService.querySaleOrderById(orderId);
        this.checkOrderTransfer(saleOrderRespDto.getSaleOrderNo());
        DgSaleOrderEo saleOrderEo = new DgSaleOrderEo();
        saleOrderEo.setCancelReason(cancelReason);
        saleOrderEo.setSecondOrderStatus(EMPTY);
        saleOrderEo.setId(orderId);
        saleOrderEo.setInterceptInfo(EMPTY);
        this.dgSaleOrderDomain.updateSelective((BaseEo)saleOrderEo);
        this.saleOrderService.removeAllLabel(orderId);
        this.orderTagRecordService.delLjddTagByOrder(orderId);
        this.processRemoveYphTag(orderId);
    }

    private void processRemoveYphTag(Long orderId) {
        List<OrderTagRecordRespDto> orderTagRecordVos = this.orderTagRecordService.queryByOrderIds(Lists.newArrayList((Object[])new Long[]{orderId}));
        if (CollectionUtils.isEmpty(orderTagRecordVos)) {
            return;
        }
        if (orderTagRecordVos.stream().anyMatch(r -> "YPH".equals(r.getTagCode()))) {
            DgSaleOrderEo dgSaleOrderEo = this.dgSaleOrderDomain.queryEoById(orderId);
            List saleOrderRespDtos = this.dgSaleOrderDomain.queryChildByOriOrderNo(dgSaleOrderEo.getMainOrderNo());
            ArrayList statusList = Lists.newArrayList((Object[])new String[]{"WAIT_PICK", "WAIT_DELIVERY"});
            List<SaleOrderRespDto> orderRespDtos = saleOrderRespDtos.stream().filter(r -> !r.getId().equals(orderId)).filter(r -> statusList.contains(r.getOrderStatus())).collect(Collectors.toList());
            if (orderRespDtos.size() < 2) {
                if (orderRespDtos.size() == 1) {
                    this.orderTagRecordService.processYphRemoveTag(((SaleOrderRespDto)orderRespDtos.get(0)).getId());
                }
            } else {
                List warehouseCodes = orderRespDtos.stream().map(SaleOrderRespDto::getLogicalWarehouseCode).distinct().collect(Collectors.toList());
                List warehouseRespDtos = (List)this.logicWarehouseExposedQueryApi.queryList(warehouseCodes).getData();
                boolean anyMatch = warehouseRespDtos.stream().anyMatch(r -> "CN01".equals(r.getOrganizationCode()));
                if (!anyMatch) {
                    orderRespDtos.forEach(r -> this.orderTagRecordService.processYphRemoveTag(r.getId()));
                }
            }
        }
        this.orderTagRecordService.processYphRemoveTag(orderId);
    }

    private void checkOrderTransfer(String saleOrderNo) {
        SaleTransferOrderReqDto saleTransferOrderReqDto = new SaleTransferOrderReqDto();
        saleTransferOrderReqDto.setSaleOrderNo(saleOrderNo);
        saleTransferOrderReqDto.setTransferTypeList((List)Lists.newArrayList((Object[])new String[]{SaleTransferTypeEnum.SALE.getCode(), AllotTypeEnum.MAIYOU_CC_ALLOT.getType(), AllotTypeEnum.MAIYOU_CC_ALLOT_OUT.getType(), AllotTypeEnum.MAIYOU_BC_ALLOT.getType()}));
        List<SaleTransferOrderRespDto> saleTransferOrderRespDtos = this.saleTransferOrderService.queryByParam(saleTransferOrderReqDto);
        if (CollectionUtils.isNotEmpty(saleTransferOrderRespDtos)) {
            throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u5f53\u524d\u8ba2\u5355\u5df2\u5173\u8054\u8c03\u62e8\u5355,\u4e0d\u53ef\u64cd\u4f5c"});
        }
    }

    private void cancelOrderReleaseInventory(SaleOrderRespDto saleOrderRespDto) {
    }

    private Boolean shoutLogicWarehouseInventory(SaleOrderRespDto saleOrderRespDto) {
        if (Objects.equals(saleOrderRespDto.getAllowSplitFlag(), YesOrNoEnum.NO.getType()) && StringUtils.isNotEmpty((CharSequence)saleOrderRespDto.getStoragePlace())) {
            this.logger.info("===>\u5927\u5ba2\u6237\u7c7b\u578b\u9700\u8981\u9884\u5360\u4f9b\u8d27\u4ed3");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public void cancelWmsOrder(Long orderId, String cancelReason) {
        SaleOrderRespDto saleOrderRespDto = this.saleOrderService.querySaleOrderById(orderId);
        this.checkSaleOrderStatus((SaleOrderStatus)SaleOrderStatusEnum.forCode((String)saleOrderRespDto.getOrderStatus()), new SaleOrderStatus[]{SaleOrderStatusEnum.WAIT_DELIVERY});
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setOrderStatus(SaleOrderStatusEnum.CANCEL.getCode());
        updateEo.setCancelReason(cancelReason);
        updateEo.setSecondOrderStatus(EMPTY);
        updateEo.setInterceptInfo(EMPTY);
        this.optimisticSaleOrderStatus(updateEo, orderId, SaleOrderStatusEnum.WAIT_DELIVERY);
        this.saleOrderService.removeAllLabel(orderId);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public void cancelSaleOrder(Long orderId, String cancelReason) {
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setId(orderId);
        updateEo.setCancelReason(cancelReason);
        this.baseDas().updateSelective((BaseEo)updateEo);
        TrackOptLogUtils.addOrderTrackOptLog((Long)orderId, (String)"\u53d6\u6d88\u8ba2\u5355");
    }

    private void changeMainOrderStatus(SaleOrderRespDto saleOrderRespDto) {
        if (StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getOriginalOrderNo())) {
            LambdaQueryWrapper queryOriOrderWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOriOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getPlatformOrderNo, (Object)saleOrderRespDto.getPlatformOrderNo())).eq(DgSaleOrderEo::getSaleOrderNo, (Object)saleOrderRespDto.getOriginalOrderNo());
            DgSaleOrderEo originalOrderEo = (DgSaleOrderEo)this.dgSaleOrderDomain.getMapper().selectOne((Wrapper)queryOriOrderWrapper);
            if (!SaleOrderStatusEnum.SPLIT.getCode().equals(originalOrderEo.getOrderStatus())) {
                this.logger.warn("[\u53d6\u6d88\u8ba2\u5355]\u6e90\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5df2\u62c6\u5206\uff0c\u65e0\u9700\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff01,\u8be5\u8ba2\u5355\u4fe1\u606f\u53ef\u80fd\u6709\u8bef\uff0c\u6e90\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)originalOrderEo));
                return;
            }
            if (LockStatusEnum.LOCK.getType().equals(originalOrderEo.getLockStatus())) {
                this.logger.warn("[\u53d6\u6d88\u8ba2\u5355]\u6e90\u8ba2\u5355\u6302\u8d77\u72b6\u6001\uff0c\u65e0\u9700\u53d6\u6d88\u6e90\u5355\uff0c\u6e90\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)originalOrderEo));
                return;
            }
            LambdaQueryWrapper queryChildOrderWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryChildOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getPlatformOrderNo, (Object)saleOrderRespDto.getPlatformOrderNo())).eq(DgSaleOrderEo::getOriginalOrderNo, (Object)saleOrderRespDto.getOriginalOrderNo());
            List saleOrderEoList = this.dgSaleOrderDomain.getMapper().selectList((Wrapper)queryChildOrderWrapper);
            this.logger.info("[\u53d6\u6d88\u8ba2\u5355]\u5f53\u524d\u8ba2\u5355({})\u7684\u5144\u5f1f\u8ba2\u5355\u5217\u8868\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)saleOrderEoList));
            List cencelOrderList = saleOrderEoList.stream().filter(dto -> !Objects.equals(saleOrderRespDto.getId(), dto.getId()) && !Objects.equals(dto.getOrderStatus(), SaleOrderStatusEnum.OBSOLETE.getCode())).collect(Collectors.toList());
            List cancelOrderList = saleOrderEoList.stream().filter(saleOrderItem -> !Objects.equals(saleOrderRespDto.getId(), saleOrderItem.getId()) && SaleOrderStatusEnum.CANCEL.getCode().equals(saleOrderItem.getOrderStatus())).collect(Collectors.toList());
            if (cencelOrderList.size() > cancelOrderList.size()) {
                this.logger.info("[\u53d6\u6d88\u8ba2\u5355]\u5b50\u8ba2\u5355\u5c1a\u672a\u5168\u90e8\u53d6\u6d88\uff0c\u65e0\u9700\u4fee\u6539\u7236\u8ba2\u5355\u72b6\u6001");
                return;
            }
            DgSaleOrderEo updateEo = new DgSaleOrderEo();
            updateEo.setOrderStatus(SaleOrderStatusEnum.CANCEL.getCode());
            updateEo.setSecondOrderStatus(EMPTY);
            this.optimisticSaleOrderStatus(updateEo, originalOrderEo.getId(), SaleOrderStatusEnum.SPLIT);
            this.logger.info("[\u53d6\u6d88\u8ba2\u5355]\u6e90\u8ba2\u5355({})\u5df2\u4fee\u6539\u4e3a'\u5df2\u53d6\u6d88'\u72b6\u6001", (Object)originalOrderEo.getSaleOrderNo());
            TrackOptLogUtils.addOrderTrackOptLog((Long)originalOrderEo.getId(), (String)"\u5b50\u5355\u5168\u90e8\u53d6\u6d88\u4e3b\u5355\u53d6\u6d88");
            this.saleOrderService.removeAllLabel(originalOrderEo.getId());
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public void resetOrder(Long orderId) {
        SaleOrderRespDto saleOrderRespDto = this.saleOrderService.querySaleOrderById(orderId);
        LambdaQueryWrapper queryItem = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItem.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId);
        List orderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItem);
        AssertUtils.notEmpty((Collection)orderItemEos, (String)String.format("[\u9500\u552e\u8ba2\u5355\u91cd\u7f6e]orderId\u4e3a%s\u7684\u8ba2\u5355\u5b58\u5728\u5f02\u5e38\uff0c\u5546\u54c1\u8be6\u60c5\u6570\u636e\u4e3a\u7a7a\uff01", orderId));
        this.checkRestOrderLegal(saleOrderRespDto);
        DgSaleOrderEo saleOrderEo = new DgSaleOrderEo();
        saleOrderEo.setReleaseState(YesOrNoEnum.NO.getType());
        saleOrderEo.setSplitStatus(SplitStatusEnum.NOT_SPLIT.getType());
        saleOrderEo.setOptLabel(EMPTY);
        saleOrderEo.setLogicalWarehouseCode(EMPTY);
        saleOrderEo.setLogicalWarehouseId(null);
        saleOrderEo.setLogicalWarehouseName(EMPTY);
        saleOrderEo.setInterceptInfo(EMPTY);
        this.saleOrderService.updateSaleOrderById(orderId, saleOrderEo);
        this.saleOrderItemService.removeSaleOrderItemBatchNo(orderId);
    }

    @Override
    public StatemachineRestOrderRespDto resetSplitOrder(Long orderId, String saleOrderNo) {
        List<SaleOrderRespDto> childOrderList = this.saleOrderService.queryChildByOriOrderNo(saleOrderNo);
        ArrayList logicChildOrderList = Lists.newArrayList();
        ArrayList releaseChildOrderList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(childOrderList)) {
            for (SaleOrderRespDto childOrder : childOrderList) {
                if (Objects.equals(childOrder.getOrderStatus(), SaleOrderStatusEnum.OBSOLETE.getCode())) continue;
                this.checkOrderTransfer(childOrder.getSaleOrderNo());
                if (Objects.equals(childOrder.getOrderStatus(), SaleOrderStatusEnum.WAIT_CHECK.getCode()) || Objects.equals(childOrder.getOrderStatus(), SaleOrderStatusEnum.CANCEL.getCode()) || Objects.equals(childOrder.getOrderStatus(), SaleOrderStatusEnum.WAIT_PICK.getCode()) && Objects.equals(childOrder.getSecondOrderStatus(), SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK.getCode())) {
                    releaseChildOrderList.add(childOrder);
                    continue;
                }
                if (Objects.equals(childOrder.getOrderStatus(), SaleOrderStatusEnum.WAIT_PICK.getCode()) && Objects.equals(childOrder.getSecondOrderStatus(), SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode())) {
                    logicChildOrderList.add(childOrder);
                    continue;
                }
                throw PcpTradeExceptionCode.SALE_ORDER_CHILD_DELIVERY.buildBizException(new Object[]{childOrder.getSaleOrderNo(), SaleOrderStatusEnum.forCode((String)childOrder.getOrderStatus()).getDesc()});
            }
        }
        DgSaleOrderEo saleOrderEo = new DgSaleOrderEo();
        saleOrderEo.setReleaseState(YesOrNoEnum.NO.getType());
        saleOrderEo.setSplitStatus(SplitStatusEnum.NOT_SPLIT.getType());
        saleOrderEo.setOptLabel(EMPTY);
        saleOrderEo.setLogicalWarehouseCode(EMPTY);
        saleOrderEo.setLogicalWarehouseId(null);
        saleOrderEo.setLogicalWarehouseName(EMPTY);
        saleOrderEo.setInterceptInfo(EMPTY);
        this.saleOrderService.updateSaleOrderById(orderId, saleOrderEo);
        this.saleOrderItemService.removeSaleOrderItemBatchNo(orderId);
        ArrayList obsoleteChildOrderList = Lists.newArrayList();
        String releaseChildOrderNo = releaseChildOrderList.stream().map(SaleOrderRespDto::getSaleOrderNo).collect(Collectors.joining(","));
        this.logger.info("\u9700\u8981\u91ca\u653e\u6e20\u9053\u4ed3\u5e93\u5b58\u5b50\u8ba2\u5355\u53f7:{}", (Object)releaseChildOrderNo);
        if (CollectionUtils.isNotEmpty((Collection)releaseChildOrderList)) {
            obsoleteChildOrderList.addAll(releaseChildOrderList);
        }
        String logicChildOrderNo = logicChildOrderList.stream().map(SaleOrderRespDto::getSaleOrderNo).collect(Collectors.joining(","));
        this.logger.info("\u9700\u8981\u91ca\u653e\u903b\u8f91\u4ed3\u5e93\u5b58\u5b50\u8ba2\u5355\u53f7:{}", (Object)logicChildOrderNo);
        if (CollectionUtils.isNotEmpty((Collection)logicChildOrderList)) {
            obsoleteChildOrderList.addAll(logicChildOrderList);
        }
        if (CollectionUtils.isEmpty((Collection)obsoleteChildOrderList)) {
            this.logger.info("\u91cd\u7f6e\u88ab\u62c6\u5206\u8ba2\u5355\u4e0b\u672a\u627e\u5230\u9700\u4f5c\u5e9f\u7684\u5b50\u8ba2\u5355");
            return StatemachineRestOrderRespDto.empty();
        }
        this.logger.info("\u4f5c\u5e9f\u5b50\u5355\u4fe1\u606f:{}", (Object)obsoleteChildOrderList.size());
        for (SaleOrderRespDto orderRespDto : obsoleteChildOrderList) {
            DgSaleOrderEo updateSaleOrder = new DgSaleOrderEo();
            updateSaleOrder.setSecondOrderStatus(EMPTY);
            updateSaleOrder.setInterceptInfo(EMPTY);
            this.saleOrderService.updateSaleOrderById(orderRespDto.getId(), updateSaleOrder);
        }
        return StatemachineRestOrderRespDto.build(logicChildOrderList, obsoleteChildOrderList);
    }

    @Override
    public List<SaleOrderRespDto> invalidChildOrder(String saleOrderNo) {
        ArrayList orderRespDtos = Lists.newArrayList();
        List<SaleOrderRespDto> saleOrderRespDtos = this.saleOrderService.queryChildByOriOrderNo(saleOrderNo);
        this.logger.info("\u9500\u552e\u4e3b\u5355:{}\u5bf9\u5e94\u7684\u5b50\u5355\u4fe1\u606f\uff1a{}", (Object)saleOrderNo, JSON.toJSON(saleOrderRespDtos));
        if (CollectionUtils.isEmpty(saleOrderRespDtos)) {
            return orderRespDtos;
        }
        ArrayList cancelChildOrderIdList = Lists.newArrayList();
        for (SaleOrderRespDto orderRespDto : saleOrderRespDtos) {
            this.logger.info("\u9500\u552e\u4e3b\u5355:{}\u5bf9\u5e94\u7684\u5b50\u5355:{}\u72b6\u6001:{}", new Object[]{saleOrderNo, orderRespDto.getSaleOrderNo(), orderRespDto.getOrderStatus()});
            if (Objects.equals(orderRespDto.getOrderStatus(), SaleOrderStatusEnum.OBSOLETE.getCode())) continue;
            if (!Objects.equals(orderRespDto.getOrderStatus(), SaleOrderStatusEnum.CANCEL.getCode())) {
                throw PcpTradeExceptionCode.SALE_ORDER_CHILD_OBSOLETE.buildBizException(new Object[]{orderRespDto.getSaleOrderNo()});
            }
            cancelChildOrderIdList.add(orderRespDto.getId());
            orderRespDtos.add(orderRespDto);
        }
        if (CollectionUtils.isEmpty((Collection)cancelChildOrderIdList)) {
            return orderRespDtos;
        }
        for (Long id : cancelChildOrderIdList) {
            List<SaleOrderRespDto> childSaleOrderNos = this.invalidOrder(id);
            Optional.ofNullable(childSaleOrderNos).ifPresent(e -> orderRespDtos.addAll(e));
        }
        return orderRespDtos;
    }

    private void checkRestOrderLegal(SaleOrderRespDto saleOrderRespDto) {
        this.checkOrderTransfer(saleOrderRespDto.getSaleOrderNo());
        if (SaleOrderLevelEnum.CHILD.getType().equals(saleOrderRespDto.getOrderLevel())) {
            this.logger.info("[\u8ba2\u5355\u91cd\u7f6e]\u5f53\u524d\u91cd\u7f6e\u7684\u8ba2\u5355\u4e3a\u5b50\u8ba2\u5355\uff0c\u5355\u53f7\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo());
            String originalOrderNo = saleOrderRespDto.getOriginalOrderNo();
            LambdaQueryWrapper queryOriOrderEo = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryOriOrderEo.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getSaleOrderNo, (Object)originalOrderNo);
            DgSaleOrderEo oriOrderEo = (DgSaleOrderEo)this.dgSaleOrderDomain.getMapper().selectOne((Wrapper)queryOriOrderEo);
            this.checkSaleOrderStatus((SaleOrderStatus)SaleOrderStatusEnum.forCode((String)oriOrderEo.getOrderStatus()), new SaleOrderStatus[]{SaleOrderStatusEnum.SPLIT});
        } else {
            this.checkSaleOrderStatus((SaleOrderStatus)SaleOrderStatusEnum.forCode((String)saleOrderRespDto.getOrderStatus()), new SaleOrderStatus[]{SaleOrderStatusEnum.CANCEL});
        }
    }

    @Override
    public void checkSaleOrderStatus(SaleOrderStatus nowStatus, SaleOrderStatus ... allowStatus) {
        SaleOrderStatus status;
        if (allowStatus == null) {
            throw PcpTradeExceptionCode.CHECK_STATUS_STATUS_NOT_ALLOW.buildBizException(new Object[]{nowStatus.getDesc()});
        }
        boolean inAllow = false;
        SaleOrderStatus[] saleOrderStatusArray = allowStatus;
        int n = saleOrderStatusArray.length;
        for (int i = 0; i < n && !(inAllow = (status = saleOrderStatusArray[i]) == nowStatus); ++i) {
        }
        if (!inAllow) {
            throw PcpTradeExceptionCode.CHECK_STATUS_STATUS_NOT_ALLOW.buildBizException(new Object[]{nowStatus.getDesc()});
        }
    }

    @Override
    public void optimisticSaleOrderStatus(DgSaleOrderEo saleOrderEo, Long orderId, SaleOrderStatusEnum ... beforeStatus) {
        DgSaleOrderEo queryEo = new DgSaleOrderEo();
        queryEo.setId(orderId);
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.in((Object)"order_status", (Collection)Stream.of(beforeStatus).map(String::valueOf).collect(Collectors.toList()));
        this.saleOrderService.optimisticModifySaleOrder(saleOrderEo, (UpdateWrapper<DgSaleOrderEo>)updateWrapper, 1, true);
    }

    @Override
    public void optimisticSaleOrderChildStatus(DgSaleOrderEo saleOrderEo, Long orderId, SecondSaleOrderStatusEnum ... beforeStatus) {
        DgSaleOrderEo queryEo = new DgSaleOrderEo();
        queryEo.setId(orderId);
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.in((Object)"second_order_status", (Collection)Stream.of(beforeStatus).map(String::valueOf).collect(Collectors.toList()));
        this.saleOrderService.optimisticModifySaleOrder(saleOrderEo, (UpdateWrapper<DgSaleOrderEo>)updateWrapper, 1, true);
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={CreateOrderBySplitEvent.class})
    public void handleAddSaleOrderEvent(CreateOrderBySplitEvent addSaleOrderEvent) {
        SaleOrderRespDto saleOrder = addSaleOrderEvent.getSaleOrder();
        this.logger.info("[mq\u53d1\u9001\u81ea\u52a8\u5ba1\u6838\u786e\u8ba4\u6821\u9a8c]\u53d1\u8d77\u81ea\u52a8\u5ba1\u6838\u6821\u9a8c\u8bf7\u6c42\uff0c\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)saleOrder));
        SaleTradeMessageVo saleTradeMessageVo = new SaleTradeMessageVo();
        saleTradeMessageVo.setOrderId(saleOrder.getId());
        saleTradeMessageVo.setOrderNo(saleOrder.getSaleOrderNo());
        saleTradeMessageVo.setNextOptType(NextOptTypeEnum.AUTO_CHECK.getType());
        saleTradeMessageVo.setOrderStatus(saleOrder.getOrderStatus());
        saleTradeMessageVo.setSecondOrderStatus(saleOrder.getSecondOrderStatus());
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)saleTradeMessageVo);
        this.commonsMqService.sendSingleMessage("DELAY_AUTO_CHECK", (Object)messageVo);
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMPLETION, classes={SaleOrderRemoveLogicalEvent.class})
    public void handleAfterRollbackEvent(SaleOrderRemoveLogicalEvent saleOrderRemoveLogicalEvent) {
        try {
            this.logger.debug("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u56de\u6eda\u4e8b\u4ef6\u3011saleOrderRemoveLogicalEvent\uff0cid={}", (Object)saleOrderRemoveLogicalEvent.getSaleOrderId());
            this.saleOrderService.removeLogicalWarehouseInfo(saleOrderRemoveLogicalEvent.getSaleOrderNo());
            this.saleOrderService.removeAllLabel(saleOrderRemoveLogicalEvent.getSaleOrderId());
        }
        catch (Exception var3) {
            this.logger.error("{},{}", (Object)var3.getMessage(), (Object)var3);
        }
        finally {
            this.logger.info("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u56de\u6eda\u4e8b\u4ef6\u3011saleOrderRemoveLogicalEvent\u7ed3\u675f\uff0cid={}", (Object)saleOrderRemoveLogicalEvent.getSaleOrderId());
        }
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={CreateOrderBySplitNewEvent.class})
    public void handleSaleOrderSplitDisplacePreempt(CreateOrderBySplitNewEvent addSaleOrderEvent) {
        SaleOrderRespDto saleOrder = addSaleOrderEvent.getSaleOrder();
        this.logger.info("[mq\u53d1\u9001\u81ea\u52a8\u5ba1\u6838\u786e\u8ba4\u6821\u9a8c]\u53d1\u8d77\u81ea\u52a8\u5ba1\u6838\u6821\u9a8c\u8bf7\u6c42\uff0c\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)saleOrder));
        SaleTradeMessageVo saleTradeMessageVo = new SaleTradeMessageVo();
        saleTradeMessageVo.setOrderId(saleOrder.getId());
        saleTradeMessageVo.setOrderNo(saleOrder.getSaleOrderNo());
        saleTradeMessageVo.setNextOptType(NextOptTypeEnum.AUTO_CHECK.getType());
        saleTradeMessageVo.setOrderStatus(saleOrder.getOrderStatus());
        saleTradeMessageVo.setSecondOrderStatus(saleOrder.getSecondOrderStatus());
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)saleTradeMessageVo);
        this.commonsMqService.sendSingleMessage("SPLIT_DISPLACE_PREEMPT", (Object)messageVo);
    }

    @Override
    public void optimisticSplitSaleOrderStatus(DgSaleOrderEo saleOrderEo, String saleOrderNo, SaleOrderStatusEnum ... beforeStatus) {
        List<SaleOrderRespDto> saleOrderRespDtos = this.saleOrderService.queryChildByOriOrderNo(saleOrderNo);
        this.logger.info("\u9500\u552e\u4e3b\u5355:{}\u5bf9\u5e94\u7684\u5b50\u5355\u4fe1\u606f\uff1a{}", (Object)saleOrderNo, JSON.toJSON(saleOrderRespDtos));
        for (SaleOrderRespDto orderRespDto : saleOrderRespDtos) {
            if (!Objects.equals(orderRespDto.getOrderStatus(), SaleOrderStatusEnum.CANCEL.getCode())) {
                this.logger.info("\u9500\u552e\u4e3b\u5355:{}\u5bf9\u5e94\u7684\u5b50\u5355:{}\u72b6\u6001:{}", new Object[]{saleOrderNo, orderRespDto.getSaleOrderNo(), orderRespDto.getOrderStatus()});
                return;
            }
            DgSaleOrderEo updateEo = new DgSaleOrderEo();
            CubeBeanUtils.copyProperties((Object)updateEo, (Object)saleOrderEo, (String[])new String[0]);
            DgSaleOrderEo queryEo = new DgSaleOrderEo();
            queryEo.setId(orderRespDto.getId());
            UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
            updateWrapper.in((Object)"order_status", (Collection)Stream.of(beforeStatus).map(String::valueOf).collect(Collectors.toList()));
            this.saleOrderService.optimisticModifySaleOrder(updateEo, (UpdateWrapper<DgSaleOrderEo>)updateWrapper, 1, true);
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#platformOrderId")
    @Transactional(rollbackFor={Exception.class})
    public void cancelCspOrder(Long platformOrderId) {
        List<SaleOrderRespDto> saleOrderRespDtos = this.saleOrderService.queryByPlatformOrderId(platformOrderId);
        if (CollectionUtils.isEmpty(saleOrderRespDtos)) {
            this.logger.info("\u5e73\u53f0\u5355ID\u672a\u627e\u5230\u9500\u552e\u8ba2\u5355");
            return;
        }
        for (SaleOrderRespDto orderRespDto : saleOrderRespDtos) {
            if (Objects.equals(orderRespDto.getOrderStatus(), SaleOrderStatusEnum.SPLIT.getCode())) {
                this.logger.info("\u8ba2\u5355\u72b6\u6001\u4e3a\u88ab\u62c6\u5206\uff0c\u4e0d\u505a\u6821\u9a8c");
                continue;
            }
            this.checkSaleOrderStatus((SaleOrderStatus)SaleOrderStatusEnum.forCode((String)orderRespDto.getOrderStatus()), new SaleOrderStatus[]{SaleOrderStatusEnum.OBSOLETE});
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SaleOrderCspRespDto cspUpdateEasOrderNo(CspUpdateEasOrderReqDto updateEasOrderReqDto) {
        this.logger.info("csp\u66f4\u65b0\u9500\u552e\u8ba2\u5355eas\u8ba2\u5355\u53f7\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)updateEasOrderReqDto));
        AssertUtils.notNull((Object)updateEasOrderReqDto.getDocumentNo(), (String)"documentNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CsDeliveryResultOrderRespDto deliveryResultOrder = (CsDeliveryResultOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csDeliveryResultOrderQueryApi.queryByDocumentNo(updateEasOrderReqDto.getDocumentNo()));
        AssertUtils.notNull((Object)deliveryResultOrder, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ed3\u679c\u5355\u4fe1\u606f");
        if (deliveryResultOrder.getBusinessType().equals(CsPcpBusinessTypeEnum.ORDER_SALES_REFUND.getCode())) {
            BizSaleRefundRespDto respDto = this.saleRefundService.queryDetail(null, deliveryResultOrder.getRelevanceNo());
            AssertUtils.notNull((Object)respDto, (String)"pcpOrderNo\u5355\u53f7\u6709\u8bef\uff0c\u627e\u4e0d\u5230\u9500\u552e\u5355");
            SaleRefundReqDto modifyReqDto = new SaleRefundReqDto();
            modifyReqDto.setId(respDto.getId());
            modifyReqDto.setSapOutOrderNo(updateEasOrderReqDto.getEasOrderNo());
            this.saleRefundService.modifySaleRefund(modifyReqDto);
        } else {
            BizSaleOrderRespDto bizSaleOrderRespDto = this.saleOrderService.queryByOrderNo(deliveryResultOrder.getRelevanceNo());
            AssertUtils.notNull((Object)bizSaleOrderRespDto, (String)"pcpOrderNo\u5355\u53f7\u6709\u8bef\uff0c\u627e\u4e0d\u5230\u9500\u552e\u5355");
            AssertUtils.notNull((Object)bizSaleOrderRespDto.getId(), (String)"\u9500\u552e\u5355\u4fe1\u606f\u5f02\u5e38\uff0cID\u4e3a\u7a7a");
            DgSaleOrderEo updateEo = new DgSaleOrderEo();
            updateEo.setId(bizSaleOrderRespDto.getId());
            updateEo.setIfPullFinance(updateEasOrderReqDto.getIfPullFinance());
            updateEo.setEasOutOrderNo(updateEasOrderReqDto.getEasOrderNo());
            if (bizSaleOrderRespDto.getOrderType().equals(SaleOrderTypeEnum.BB_TRANSFER_CLAIM_NOT_REISSUE.getType()) || bizSaleOrderRespDto.getOrderType().equals(SaleOrderTypeEnum.DS_TRANSFER_CLAIMS_NOT_REISSUE.getType())) {
                updateEo.setOrderStatus(SaleOrderStatusEnum.RECEIVED.getCode());
                updateEo.setConfirmReceiveTime(new Date());
            }
            this.dgSaleOrderDomain.updateSelective((BaseEo)updateEo);
            if (updateEasOrderReqDto.getIfPullFinance() == 1) {
                SaleOrderReqDto saleOrderReqDto = new SaleOrderReqDto();
                CubeBeanUtils.copyProperties((Object)saleOrderReqDto, (Object)bizSaleOrderRespDto, (String[])new String[0]);
                this.externalNoticeService.sendSaleOrderCarryToBroadcast(saleOrderReqDto);
            }
        }
        return null;
    }

    @Override
    public void arrangeShipmentEnterprise(ArrangeShipmentEnterpriseReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto.getOrderId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto.getShipmentEnterpriseId(), (String)"shipmentEnterpriseId\u4e0d\u80fd\u4e3a\u7a7a");
        SaleOrderReqDto modifyReqDto = new SaleOrderReqDto();
        modifyReqDto.setId(reqDto.getOrderId());
        modifyReqDto.setShipmentEnterpriseId(reqDto.getShipmentEnterpriseId());
        modifyReqDto.setShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
        modifyReqDto.setShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
        this.saleOrderService.modifySaleOrder(modifyReqDto);
        this.logger.info("[\u6307\u5b9a\u7269\u6d41\u5546]\u8ba2\u5355\uff08{}\uff09\u6307\u5b9a\u7269\u6d41\u5546\u4fe1\u606f\u4e3a\uff1a{}", (Object)reqDto.getOrderId(), (Object)JSON.toJSONString((Object)reqDto));
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#reqDto.orderId")
    @Transactional(rollbackFor={Exception.class})
    public void customerAudit(SaleOrderCustomerAuditReqDto reqDto) {
        this.logger.info("\u5ba2\u5546\u5ba1\u6838\u64cd\u4f5c\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtils.notNull((Object)reqDto.getOrderId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)reqDto.getAuditResult(), (String)"auditResult\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Long orderId = reqDto.getOrderId();
        SaleAuditResultEnum auditResultEnum = SaleAuditResultEnum.enumOf((String)reqDto.getAuditResult());
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoById(orderId);
        AssertUtils.notNull((Object)saleOrderEo, (String)"%s \u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[]{orderId});
        this.saleOrderAuditService.saveSaleOrderAudit(orderId, SaleAuditTypeEnum.CUSTOMER_AUDIT, auditResultEnum);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSaleOrderStringCodeResult(CspUpdateEasOrderReqDto updateEasOrderReqDto) {
        this.logger.info("\u66f4\u65b0\u9500\u552e\u5355\u4e32\u7801\u6821\u9a8c\u8fd4\u56de\u7ed3\u679c\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)updateEasOrderReqDto));
        String platformOrderNo = updateEasOrderReqDto.getPlatformOrderNo();
        AssertUtils.notNull((Object)platformOrderNo, (String)"platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<SaleOrderRespDto> saleOrderRespDtos = this.getSaleOrderListByNo(platformOrderNo);
        this.logger.info("\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f:{}", (Object)saleOrderRespDtos.size());
        for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
            DgSaleOrderEo updateEo = new DgSaleOrderEo();
            updateEo.setId(saleOrderRespDto.getId());
            updateEo.setStringCodeResult(Integer.valueOf(updateEasOrderReqDto.isCheckResult() ? StringCodeResultEum.READ_SUCCESS.getCode() : StringCodeResultEum.READ_FAIL.getCode()));
            updateEo.setStringCodeTime(new Date());
            String flag = YesOrNoEnum.YES.getDesc();
            flag = updateEasOrderReqDto.isCheckResult() ? YesOrNoEnum.YES.getDesc() : YesOrNoEnum.NO.getDesc();
            this.dgSaleOrderDomain.updateSelective((BaseEo)updateEo);
            TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderRespDto.getId(), (String)("\u66f4\u65b0\u4e32\u7801\u6821\u9a8c\u7ed3\u679c:" + flag));
        }
    }

    private List<SaleOrderRespDto> getSaleOrderListByNo(String platformOrderNo) {
        SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
        saleOrderQueryReqDto.setNotOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode()}));
        saleOrderQueryReqDto.setSaleOrderNo(platformOrderNo);
        List<SaleOrderRespDto> saleOrderRespDtos = this.saleOrderService.queryByParamList(saleOrderQueryReqDto);
        if (CollectionUtils.isEmpty(saleOrderRespDtos)) {
            this.logger.info("\u6839\u636eEasOrderNo\u67e5\u8be2\u9500\u552e\u5355");
            saleOrderQueryReqDto = new SaleOrderQueryReqDto();
            saleOrderQueryReqDto.setNotOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode()}));
            saleOrderQueryReqDto.setEasOrderNo(platformOrderNo);
            saleOrderRespDtos = this.saleOrderService.queryByParamList(saleOrderQueryReqDto);
        }
        if (CollectionUtils.isEmpty(saleOrderRespDtos)) {
            this.logger.info("\u6839\u636ePlatformOrderNo\u67e5\u8be2\u9500\u552e\u5355");
            saleOrderQueryReqDto = new SaleOrderQueryReqDto();
            saleOrderQueryReqDto.setNotOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode()}));
            saleOrderQueryReqDto.setPlatformOrderNo(platformOrderNo);
            saleOrderRespDtos = this.saleOrderService.queryByParamList(saleOrderQueryReqDto);
        }
        if (CollectionUtils.isEmpty(saleOrderRespDtos)) {
            this.logger.info("\u6839\u636eSplitPlatformNo\u67e5\u8be2\u9500\u552e\u5355");
            saleOrderQueryReqDto = new SaleOrderQueryReqDto();
            saleOrderQueryReqDto.setNotOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode()}));
            saleOrderQueryReqDto.setSplitPlatformNo(platformOrderNo);
            saleOrderRespDtos = this.saleOrderService.queryByParamList(saleOrderQueryReqDto);
        }
        return saleOrderRespDtos;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public List<SaleOrderRespDto> invalidOrder(Long orderId) {
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(orderId);
        if (StringUtils.isNotEmpty((CharSequence)saleOrderEo.getOriginalOrderNo())) {
            throw PcpTradeExceptionCode.SALE_ORDER_CHILD_NOT_INVALID.builderException();
        }
        if (SaleOrderTypeEnum.saleOutOrderTypeList.contains(saleOrderEo.getOrderType()) && Objects.equals(saleOrderEo.getChannelCode(), "CSP") && Objects.nonNull(saleOrderEo.getPlatformOrderId()) && Objects.equals(saleOrderEo.getIfButtThirdParty(), YesOrNoEnum.YES.getType())) {
            throw PcpTradeExceptionCode.SALE_ORDER_CSP_NOT_INVALID.builderException();
        }
        if (SaleOrderTypeEnum.otherOutOrderTypeList.contains(saleOrderEo.getOrderType()) && Objects.equals(saleOrderEo.getChannelCode(), "CSP") && Objects.nonNull(saleOrderEo.getPlatformOrderId())) {
            throw PcpTradeExceptionCode.SALE_ORDER_CSP_NOT_INVALID.builderException();
        }
        if (SaleOrderTypeEnum.saleOutOrderTypeList.contains(saleOrderEo.getOrderType()) && Objects.isNull(saleOrderEo.getPlatformOrderId()) && Objects.equals(saleOrderEo.getIfButtThirdParty(), YesOrNoEnum.YES.getType())) {
            throw PcpTradeExceptionCode.SALE_ORDER_EAS_NOT_INVALID.builderException();
        }
        DgSaleOrderEo updateSaleOrder = new DgSaleOrderEo();
        updateSaleOrder.setSecondOrderStatus(EMPTY);
        updateSaleOrder.setInterceptInfo(EMPTY);
        this.saleOrderService.updateSaleOrderById(orderId, updateSaleOrder);
        return this.invalidChildOrder(saleOrderEo.getSaleOrderNo());
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public void updateOrderWaitPick(Long orderId, DgSaleOrderEo saleOrderEo) {
        DgSaleOrderEo updateStatusEo = new DgSaleOrderEo();
        updateStatusEo.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK.getCode());
        updateStatusEo.setInterceptInfo(EMPTY);
        this.saleOrderService.updateSaleOrderById(orderId, updateStatusEo);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#platformOrderNo")
    @Transactional(rollbackFor={Exception.class})
    public void invalidOrderByPlatformOrderNo(String platformOrderNo) {
        this.logger.info("invalidOrderByPlatformOrderNo==>{}", (Object)platformOrderNo);
        SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
        saleOrderQueryReqDto.setPlatformOrderNo(platformOrderNo);
        saleOrderQueryReqDto.setNotOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode()}));
        List<SaleOrderRespDto> saleOrderRespDtos = this.saleOrderService.queryByParamList(saleOrderQueryReqDto);
        if (CollectionUtils.isEmpty(saleOrderRespDtos)) {
            this.logger.info("\u6839\u636e\u5e73\u53f0\u5355\u4f5c\u5e9f\u8ba2\u5355\u672a\u67e5\u8be2\u5230\u6709\u6548\u9500\u552e\u5355\u4fe1\u606f");
            return;
        }
        StringBuffer errorMsg = new StringBuffer();
        ArrayList orderRespDtos = Lists.newArrayList();
        ArrayList cancelLogicOrderList = Lists.newArrayList();
        for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
            boolean pickStatus = Objects.equals(saleOrderRespDto.getOrderStatus(), SaleOrderStatusEnum.WAIT_PICK.getCode()) && Objects.equals(saleOrderRespDto.getSecondOrderStatus(), SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
            this.logger.info("orderStatus==>{},pickStatus==>{}", (Object)saleOrderRespDto.getOrderStatus(), (Object)pickStatus);
            if (deliveryStatusList.contains(saleOrderRespDto.getOrderStatus())) {
                errorMsg = errorMsg.append("\u5355\u53f7[").append(saleOrderRespDto.getSaleOrderNo()).append("]\u72b6\u6001[").append(SaleOrderStatusEnum.forCode((String)saleOrderRespDto.getOrderStatus()).getDesc()).append("]\u4e0d\u53ef\u4f5c\u5e9f;");
                continue;
            }
            if (pickStatus) {
                cancelLogicOrderList.add(saleOrderRespDto.getSaleOrderNo());
                try {
                    this.saleTransferExtDomain.delByOrderId(saleOrderRespDto.getId());
                }
                catch (Exception e) {
                    this.logger.info("\u5220\u9664\u8ba2\u5355\u5173\u8054\u7684\u8c03\u62e8\u5355\u62a5\u9519:{}", (Object)e.getMessage());
                }
            }
            orderRespDtos.add(saleOrderRespDto);
        }
        if (StringUtils.isNotEmpty((CharSequence)errorMsg.toString())) {
            throw PcpTradeExceptionCode.SALE_ORDER_PLATFORM_OBSOLETE.buildBizException(new Object[]{errorMsg.toString()});
        }
        for (SaleOrderRespDto orderRespDto : orderRespDtos) {
            DgSaleOrderEo updateSaleOrder = new DgSaleOrderEo();
            if (LockStatusEnum.LOCK.getType().equals(orderRespDto.getLockStatus())) {
                updateSaleOrder.setLockStatus(LockStatusEnum.UNLOCK.getType());
                updateSaleOrder.setLockType(LockTypeEnum.MANUAL.getType());
            }
            updateSaleOrder.setOrderStatus(SaleOrderStatusEnum.OBSOLETE.getCode());
            updateSaleOrder.setSecondOrderStatus(EMPTY);
            this.optimisticSaleOrderStatus(updateSaleOrder, orderRespDto.getId(), SaleOrderStatusEnum.forCode((String)orderRespDto.getOrderStatus()));
        }
        if (CollectionUtils.isNotEmpty((Collection)cancelLogicOrderList)) {
            this.bInventoryApiServcie.batchCancelLogicAndPhysicsOrder(cancelLogicOrderList, new ArrayList<String>());
        }
        this.bInventoryApiServcie.batchReleaseInventory(orderRespDtos);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public void splitPick(Long orderId) {
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(orderId);
        if (this.saleOrderService.isClaimOrder(saleOrderEo.getOrderType())) {
            String orderTypeDesc = SaleOrderTypeEnum.enumOf((String)saleOrderEo.getOrderType()).getDesc();
            throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{orderTypeDesc + "\u7c7b\u578b\u4e0d\u53ef\u64cd\u4f5c"});
        }
        SearchSourceReqDto reqDto = new SearchSourceReqDto();
        reqDto.setSaleOrderNo(saleOrderEo.getSaleOrderNo());
        reqDto.setSgSourceCanSplit(YesOrNoEnum.YES.getType());
        SourceOrderResultRespDto sourceOrderResultRespDto = this.autoSearchSource(reqDto, saleOrderEo.getSaleOrderNo());
        if (SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
            this.logger.info("[\u5bfb\u6e90]\u9500\u552e\u8ba2\u5355\uff08{}\uff09\u5bfb\u6e90\u6210\u529f", (Object)reqDto.getSaleOrderNo());
            AssertUtils.notEmpty((Collection)sourceOrderResultRespDto.getOrderItemResultRespDtoList(), (String)"\u5bfb\u6e90\u7ed3\u679c\u5b58\u5728\u5f02\u5e38");
            List orderItemResultRespDtoList = sourceOrderResultRespDto.getOrderItemResultRespDtoList();
            AssertUtils.notEmpty((Collection)orderItemResultRespDtoList, (String)"\u5bfb\u6e90\u7ed3\u679c\u6570\u636e\u5f02\u5e38\uff01");
            Map<String, List<OrderItemResultRespDto>> orderItemResultMap = orderItemResultRespDtoList.stream().collect(Collectors.groupingBy(OrderItemResultRespDto::getDeliveryLogicWarehouseCode));
            if (orderItemResultMap.size() > 1) {
                this.logger.info("[\u5bfb\u6e90]\u8ba2\u5355({})\u5bfb\u6e90\u7ed3\u679c\u6709\u591a\u4e2a\u903b\u8f91\u4ed3\uff0c\u9700\u8981\u8fdb\u884c\u62c6\u5355\u5904\u7406", (Object)reqDto.getSaleOrderNo());
                this.splitOrderForSource(orderItemResultMap, sourceOrderResultRespDto.getLinkOrderNo());
            } else {
                this.deliveryOrderBySource(reqDto, saleOrderEo, sourceOrderResultRespDto);
            }
        } else if (SourceStatusEnum.SOURCE_FAIL.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
            throw PcpTradeExceptionCode.PICK_FAIL.builderException();
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public void doPcpStatusLock(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(orderId);
        DgSaleOrderEo updateSaleOrder = new DgSaleOrderEo();
        updateSaleOrder.setLockStatus(LockStatusEnum.LOCK.getType());
        updateSaleOrder.setInterceptInfo(EMPTY);
        if (Objects.equals(saleOrderEo.getOrderStatus(), SaleOrderStatusEnum.WAIT_DELIVERY.getCode())) {
            updateSaleOrder.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
        }
        this.optimisticSaleOrderStatus(updateSaleOrder, orderId, SaleOrderStatusEnum.forCode((String)saleOrderEo.getOrderStatus()));
        this.orderTagRecordService.delLjddTagByOrder(saleOrderEo.getId());
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public void doPcpStatusUnLock(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(orderId);
        DgSaleOrderEo updateSaleOrder = new DgSaleOrderEo();
        updateSaleOrder.setLockStatus(LockStatusEnum.UNLOCK.getType());
        updateSaleOrder.setInterceptInfo(EMPTY);
        this.optimisticSaleOrderStatus(updateSaleOrder, orderId, SaleOrderStatusEnum.forCode((String)saleOrderEo.getOrderStatus()));
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public void updateDefaultLogic(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(orderId);
        if (StringUtils.isEmpty((CharSequence)saleOrderEo.getStoragePlace())) {
            this.logger.info("\u6307\u5b9a\u4f9b\u8d27\u4ed3\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        String storagePlace = saleOrderEo.getStoragePlace();
        List csLogicWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.virtualWarehouseQueryApi.queryLogicWarehouse(storagePlace));
        if (CollectionUtils.isEmpty((Collection)csLogicWarehouseRespDtos)) {
            this.logger.info("\u4f9b\u8d27\u4ed3\u3010{}\u3011\u672a\u5173\u8054\u903b\u8f91\u4ed3", (Object)storagePlace);
            return;
        }
        List logicWarehouseRespDtos = csLogicWarehouseRespDtos.stream().filter(dto -> Objects.equals(dto.getCargoEscheatageId(), saleOrderEo.getOrganizationCode()) && Objects.equals(dto.getWarehouseQuality(), CsLogicWarehouseQualityEnum.QUALIFIED.getCode()) && Objects.equals(dto.getWarehouseClassify(), CsWarehouseClassifyEnum.LOGIC.getCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(logicWarehouseRespDtos)) {
            this.logger.info("\u672a\u7b5b\u9009\u51fa\u5408\u683c\u4e14\u5339\u914d\u5e93\u5b58\u7ec4\u7ec7\u903b\u8f91\u4ed3");
            return;
        }
        CsLogicWarehouseRespDto csLogicWarehouseRespDto = (CsLogicWarehouseRespDto)logicWarehouseRespDtos.get(0);
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setLogicalWarehouseId(csLogicWarehouseRespDto.getId());
        updateEo.setLogicalWarehouseCode(csLogicWarehouseRespDto.getWarehouseCode());
        updateEo.setLogicalWarehouseName(csLogicWarehouseRespDto.getWarehouseName());
        CsRelWarehouseRespDto physicsWarehouseByLogic = this.getPhysicsWarehouseByLogic(updateEo.getLogicalWarehouseCode());
        if (Objects.nonNull(physicsWarehouseByLogic)) {
            updateEo.setPhysicsWarehouseId(Long.valueOf(physicsWarehouseByLogic.getRefWarehouseId()));
            updateEo.setPhysicsWarehouseCode(physicsWarehouseByLogic.getRefWarehouseCode());
            updateEo.setPhysicsWarehouseName(physicsWarehouseByLogic.getRefWarehouseName());
        }
        this.saleOrderService.updateSaleOrderById(orderId, updateEo);
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId);
        List saleOrderItemEoList = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        AssertUtils.notEmpty((Collection)saleOrderItemEoList, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        Collections.sort(saleOrderItemEoList, Comparator.comparing(BaseEo::getId));
        saleOrderItemEoList.forEach(saleOrderItemEo -> {
            DgSaleOrderItemEo updateItemEo = new DgSaleOrderItemEo();
            updateItemEo.setId(saleOrderItemEo.getId());
            updateItemEo.setLogicalWarehouseId(csLogicWarehouseRespDto.getId());
            updateItemEo.setLogicalWarehouseCode(csLogicWarehouseRespDto.getWarehouseCode());
            updateItemEo.setLogicalWarehouseName(csLogicWarehouseRespDto.getWarehouseName());
            this.dgSaleOrderItemDomain.updateSelective((BaseEo)updateItemEo);
        });
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public void advancePick(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(orderId);
        if (StringUtils.isEmpty((CharSequence)saleOrderEo.getLogicalWarehouseCode())) {
            throw PcpTradeExceptionCode.WAREHOUSE_NOT_EXIT.buildBizException(new Object[]{"\u672a\u6307\u5b9a\u53d1\u8d27\u4ed3"});
        }
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId);
        List saleOrderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        AssertUtils.notEmpty((Collection)saleOrderItemEos, (String)String.format("orderId=%s\u7684\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01", orderId));
        ArrayList reqDtoList = Lists.newArrayList();
        saleOrderItemEos.forEach(saleOrderItemEo -> {
            ArrangeWarehouseReqDto arrangeWarehouseReqDto = new ArrangeWarehouseReqDto();
            arrangeWarehouseReqDto.setLogicalWarehouseId(saleOrderItemEo.getLogicalWarehouseId());
            arrangeWarehouseReqDto.setLogicalWarehouseCode(saleOrderItemEo.getLogicalWarehouseCode());
            arrangeWarehouseReqDto.setLogicalWarehouseName(saleOrderItemEo.getLogicalWarehouseName());
            arrangeWarehouseReqDto.setBatchNo(saleOrderItemEo.getDeliveryItemBatchNo());
            arrangeWarehouseReqDto.setOrderId(saleOrderItemEo.getOrderId());
            arrangeWarehouseReqDto.setOrderItemId(saleOrderItemEo.getId());
            arrangeWarehouseReqDto.setNegativeValidate(YesOrNoEnum.NO.getType());
            reqDtoList.add(arrangeWarehouseReqDto);
        });
        this.logger.info("[\u9884\u6536\u914d\u8d27]\u53d1\u8d27\u914d\u8d27\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqDtoList));
        this.arrangeWarehouseForDeliver(orderId, reqDtoList, arrangeWarehouseReqDto -> {
            DgSaleOrderEo updateStatusEo = new DgSaleOrderEo();
            updateStatusEo.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
            updateStatusEo.setInterceptInfo(EMPTY);
            this.saleOrderService.updateSaleOrderById(orderId, updateStatusEo);
            this.orderTagRecordService.delLjddTagByOrder(saleOrderEo.getId());
        });
        TrackOptLogUtils.addOrderTrackOptLog((Long)orderId, (String)OrderOperationTypeEnum.ADVANCEPICK.getDesc());
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#saleOrderNo")
    @Transactional(rollbackFor={Exception.class})
    public void doPcpStatusLockAndSystem(String saleOrderNo) {
        AssertUtils.notNull((Object)saleOrderNo, (String)"saleOrderNo \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoByOrderNo(saleOrderNo);
        if (!Objects.equals(saleOrderEo.getLockStatus(), LockStatusEnum.UNLOCK.getType())) {
            throw PcpTradeExceptionCode.LOCK_EXIST.builderException();
        }
        DgSaleOrderEo updateSaleOrder = new DgSaleOrderEo();
        updateSaleOrder.setLockStatus(LockStatusEnum.LOCK.getType());
        updateSaleOrder.setLockType(LockTypeEnum.SYSTEM.getType());
        updateSaleOrder.setInterceptInfo(EMPTY);
        this.saleOrderService.updateSaleOrderById(saleOrderEo.getId(), updateSaleOrder);
        TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderEo.getId(), (String)"\u7cfb\u7edf\u6302\u8d77");
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#saleOrderNo")
    @Transactional(rollbackFor={Exception.class})
    public void doPcpStatusUnLockAndSystem(String saleOrderNo) {
        AssertUtils.notNull((Object)saleOrderNo, (String)"saleOrderNo \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoByOrderNo(saleOrderNo);
        if (!Objects.equals(saleOrderEo.getLockStatus(), LockStatusEnum.LOCK.getType())) {
            throw PcpTradeExceptionCode.UNLOCK_EXIST.builderException();
        }
        if (!Objects.equals(saleOrderEo.getLockType(), LockTypeEnum.SYSTEM.getType())) {
            throw PcpTradeExceptionCode.LOCK_TYPE_FAIL.buildBizException(new Object[]{LockTypeEnum.MANUAL.getDesc()});
        }
        DgSaleOrderEo updateSaleOrder = new DgSaleOrderEo();
        updateSaleOrder.setLockStatus(LockStatusEnum.UNLOCK.getType());
        updateSaleOrder.setLockType(LockTypeEnum.MANUAL.getType());
        updateSaleOrder.setInterceptInfo(EMPTY);
        this.saleOrderService.updateSaleOrderById(saleOrderEo.getId(), updateSaleOrder);
        TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderEo.getId(), (String)"\u7cfb\u7edf\u89e3\u6302");
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#reqDto.saleOrderNo")
    @Transactional(rollbackFor={Exception.class})
    public void updateLogicalWarehouseAndDelivery(ModifyLogicalWarehouseReqDto reqDto) {
        AssertUtils.notEmpty((String)reqDto.getSaleOrderNo(), (String)"saleOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((String)reqDto.getLogicalWarehouseCode(), (String)"logicalWarehouseCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoByOrderNo(reqDto.getSaleOrderNo());
        if (saleOrderEo.getLogicalWarehouseCode().equals(reqDto.getLogicalWarehouseCode())) {
            this.logger.info("\u4fee\u6539\u53d1\u8d27\u4ed3\u548c\u9500\u552e\u5355\u53d1\u8d27\u4ed3\u4e00\u81f4");
            return;
        }
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setLogicalWarehouseId(reqDto.getLogicalWarehouseId());
        updateEo.setLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
        updateEo.setLogicalWarehouseName(reqDto.getLogicalWarehouseName());
        updateEo.setPhysicsWarehouseId(reqDto.getPhysicsWarehouseId());
        updateEo.setPhysicsWarehouseCode(reqDto.getPhysicsWarehouseCode());
        updateEo.setPhysicsWarehouseName(reqDto.getPhysicsWarehouseName());
        updateEo.setLockStatus(LockStatusEnum.LOCK.getType());
        updateEo.setLockType(LockTypeEnum.SYSTEM.getType());
        updateEo.setInterceptInfo(EMPTY);
        this.updateSaleOrderById(saleOrderEo.getId(), updateEo);
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderEo.getId());
        List saleOrderItemEoList = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        AssertUtils.notEmpty((Collection)saleOrderItemEoList, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        Collections.sort(saleOrderItemEoList, Comparator.comparing(BaseEo::getId));
        saleOrderItemEoList.forEach(saleOrderItemEo -> {
            DgSaleOrderItemEo updateItemEo = new DgSaleOrderItemEo();
            updateItemEo.setId(saleOrderItemEo.getId());
            updateItemEo.setLogicalWarehouseId(reqDto.getLogicalWarehouseId());
            updateItemEo.setLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
            updateItemEo.setLogicalWarehouseName(reqDto.getLogicalWarehouseName());
            saleOrderItemEo.setLogicalWarehouseId(reqDto.getLogicalWarehouseId());
            saleOrderItemEo.setLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
            saleOrderItemEo.setLogicalWarehouseName(reqDto.getLogicalWarehouseName());
            this.dgSaleOrderItemDomain.updateSelective((BaseEo)updateItemEo);
        });
        DgSaleOrderAddrEo orderAddrEo = this.saleOrderAddrService.queryEoAddressByOrderId(saleOrderEo.getId());
        RestResponseHelper.extractData(this.inventoryApiServcie.preemptOrderInventory(saleOrderEo, saleOrderItemEoList, orderAddrEo, 0, 0));
        TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderEo.getId(), (String)"\u7cfb\u7edf\u6302\u8d77");
        TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderEo.getId(), (String)("\u4fee\u6539\u6307\u5b9a\u7684\u903b\u8f91\u4ed3\uff1a\u3010" + saleOrderEo.getLogicalWarehouseName() + "\u3011\u4fee\u6539\u4e3a\u3010" + updateEo.getLogicalWarehouseName() + "\u3011\u5e76\u91cd\u65b0\u53d1\u8d27"));
    }

    @Override
    public void updateOrderLogic(SplitOrderBySourceInfoReqDto reqDto) {
        DgSaleOrderEo updateOrderEo = new DgSaleOrderEo();
        updateOrderEo.setId(reqDto.getSaleOrderId());
        updateOrderEo.setLogicalWarehouseCode(reqDto.getDeliveryLogicWarehouseCode());
        updateOrderEo.setLogicalWarehouseId(reqDto.getDeliveryLogicWarehouseId());
        updateOrderEo.setLogicalWarehouseName(reqDto.getDeliveryLogicWarehouseName());
        this.dgSaleOrderDomain.updateSaleOrderById(reqDto.getSaleOrderId(), updateOrderEo);
        Collections.sort(reqDto.getGoodsList(), Comparator.comparing(SplitOrderItemReqDto::getOriginalOrderGoodsId));
        for (SplitOrderItemReqDto orderItemReqDto : reqDto.getGoodsList()) {
            DgSaleOrderItemEo updateItemEo = new DgSaleOrderItemEo();
            updateItemEo.setId(orderItemReqDto.getOriginalOrderGoodsId());
            updateItemEo.setLogicalWarehouseId(reqDto.getDeliveryLogicWarehouseId());
            updateItemEo.setLogicalWarehouseCode(reqDto.getDeliveryLogicWarehouseCode());
            updateItemEo.setLogicalWarehouseName(reqDto.getDeliveryLogicWarehouseName());
            this.dgSaleOrderItemDomain.updateSelective((BaseEo)updateItemEo);
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public List<Long> sourceDeliveryAndTransfer(Long orderId, List<SplitOrderBySourceInfoReqDto> splitOrderReqList) {
        this.logger.info("\u6839\u636e\u9700\u8981\u7ed3\u679c\u6279\u91cf\u53d1\u8d27\u548c\u8c03\u62e8\u5165\u53c2:{}", (Object)JSON.toJSONString(splitOrderReqList));
        AssertUtils.notNull((Object)orderId, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(orderId);
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderEo.getId());
        List saleOrderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        AssertUtils.notEmpty((Collection)saleOrderItemEos, (String)"\u8ba2\u5355\uff08saleOrderNo=%s\uff09\u5546\u54c1\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{saleOrderEo.getSaleOrderNo()});
        DgSaleOrderAddrEo orderAddrEo = this.saleOrderAddrService.queryEoAddressByOrderId(saleOrderEo.getId());
        HashSet<String> logicWarehouseCodeSet = new HashSet<String>();
        Boolean intransitPreemptFlag = false;
        HashMap<String, Boolean> saleItemAllMap = new HashMap<String, Boolean>();
        for (SplitOrderBySourceInfoReqDto splitOrderBySourceInfoReqDto : splitOrderReqList) {
            logicWarehouseCodeSet.add(splitOrderBySourceInfoReqDto.getDeliveryLogicWarehouseCode());
            if (StringUtils.isNotEmpty((CharSequence)splitOrderBySourceInfoReqDto.getTransferLogicWarehouseCode())) {
                logicWarehouseCodeSet.add(splitOrderBySourceInfoReqDto.getTransferLogicWarehouseCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)splitOrderBySourceInfoReqDto.getInLogicWarehouseCode())) {
                logicWarehouseCodeSet.add(splitOrderBySourceInfoReqDto.getInLogicWarehouseCode());
            }
            intransitPreemptFlag = splitOrderBySourceInfoReqDto.getIntransitPreemptFlag();
            Map<String, Boolean> saleItemInMap = splitOrderBySourceInfoReqDto.getGoodsList().stream().collect(Collectors.toMap(i -> i.getOriginalOrderGoodsId() + "_" + splitOrderBySourceInfoReqDto.getDeliveryLogicWarehouseCode(), result -> Objects.nonNull(result.getZtDeliveryWarehouseItemNum()) && result.getZtDeliveryWarehouseItemNum().compareTo(BigDecimal.ZERO) > 0, (k1, k2) -> k1 != false ? k1 : k2));
            saleItemAllMap.putAll(saleItemInMap);
        }
        this.saleIntransitCache.setSaleIntranst(saleOrderEo.getSaleOrderNo(), intransitPreemptFlag);
        this.saleIntransitCache.setSaleItemIntranst(saleOrderEo.getSaleOrderNo(), saleItemAllMap);
        List<CsLogicWarehouseRespDto> csLogicWarehousePageRespDtos = this.bInventoryApiServcie.queryCsLogicWarehousePageRespDtoListByCodeList(new ArrayList<String>(logicWarehouseCodeSet));
        if (CollectionUtils.isEmpty(csLogicWarehousePageRespDtos)) {
            throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u903b\u8f91\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728"});
        }
        Map<String, CsLogicWarehouseRespDto> logicInfoMap = csLogicWarehousePageRespDtos.stream().collect(Collectors.toMap(CsLogicWarehouseRespDto::getWarehouseCode, Function.identity(), (v1, v2) -> v1));
        Map logicWarehouseGroupMap = splitOrderReqList.stream().collect(Collectors.toMap(SplitOrderBySourceInfoReqDto::getDeliveryLogicWarehouseCode, Function.identity()));
        final List<Long> deliveryOrderIdList = Collections.synchronizedList(Lists.newArrayList());
        List<Long> saleTransferOrderIdList = Collections.synchronizedList(Lists.newArrayList());
        List<SaleTransferOrderReqDto> addSaleTransferOrderReqDtoList = Collections.synchronizedList(Lists.newArrayList());
        List<CsLogicPreemptInventoryOperateReqDto> csLogicPreemptInventoryOperateReqDtos = Collections.synchronizedList(Lists.newArrayList());
        List<CsTransferOrderComboReqDto> csTransferOrderComboReqDtos = Collections.synchronizedList(Lists.newArrayList());
        ServiceContext context = ServiceContext.getContext();
        List<Object> childOrderList = Lists.newArrayList();
        String saleOrderNo = saleOrderEo.getSaleOrderNo();
        if (logicWarehouseGroupMap.size() == 1) {
            for (String logcicWarehouseCode : logicWarehouseGroupMap.keySet()) {
                SplitOrderBySourceInfoReqDto splitOrderBySourceInfoReqDto = (SplitOrderBySourceInfoReqDto)logicWarehouseGroupMap.get(logcicWarehouseCode);
                this.allotSaleAndDeliveryDto(saleOrderEo, saleOrderItemEos, orderAddrEo, logicInfoMap, deliveryOrderIdList, saleTransferOrderIdList, addSaleTransferOrderReqDtoList, csLogicPreemptInventoryOperateReqDtos, csTransferOrderComboReqDtos, splitOrderBySourceInfoReqDto);
                this.updateOrderLogicInfo(saleOrderEo, saleOrderItemEos);
                DgSaleOrderEo updateStatusEo = new DgSaleOrderEo();
                updateStatusEo.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
                updateStatusEo.setInterceptInfo(EMPTY);
                this.saleOrderService.updateSaleOrderById(orderId, updateStatusEo);
                this.orderTagRecordService.delLjddTagByOrder(saleOrderEo.getId());
            }
        } else {
            childOrderList = this.splitOrderForSourceTransfer(splitOrderReqList);
            this.logger.info("\u62c6\u5355\u540e\u7684\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)childOrderList));
            Map splitChildGroupMap = childOrderList.stream().collect(Collectors.toMap(SaleOrderRespDto::getLogicalWarehouseCode, Function.identity()));
            ExecutorService executorService = Executors.newWorkStealingPool(12);
            ArrayList<CompletableFuture<Consumer>> futureList = new ArrayList<CompletableFuture<Consumer>>(logicWarehouseGroupMap.keySet().size());
            for (String logcicWarehouseCode : logicWarehouseGroupMap.keySet()) {
                futureList.add(CompletableFuture.supplyAsync(() -> {
                    context.getAttachments().forEach((k, v) -> ServiceContext.getContext().setAttachment(k, v));
                    try {
                        BizSaleOrderRespDto childBizSaleOrderDto = (BizSaleOrderRespDto)splitChildGroupMap.get(logcicWarehouseCode);
                        SplitOrderBySourceInfoReqDto splitOrderBySourceInfoReqDto = (SplitOrderBySourceInfoReqDto)logicWarehouseGroupMap.get(logcicWarehouseCode);
                        DgSaleOrderEo childDgSaleOrderEo = new DgSaleOrderEo();
                        CubeBeanUtils.copyProperties((Object)childDgSaleOrderEo, (Object)childBizSaleOrderDto, (String[])new String[0]);
                        ArrayList childSaleOrderItemEos = Lists.newArrayList();
                        CubeBeanUtils.copyCollection((Collection)childSaleOrderItemEos, (Collection)childBizSaleOrderDto.getItemList(), DgSaleOrderItemEo.class);
                        this.allotSaleAndDeliveryDto(childDgSaleOrderEo, childSaleOrderItemEos, orderAddrEo, logicInfoMap, deliveryOrderIdList, saleTransferOrderIdList, addSaleTransferOrderReqDtoList, csLogicPreemptInventoryOperateReqDtos, csTransferOrderComboReqDtos, splitOrderBySourceInfoReqDto);
                        DgSaleOrderEo updateStatusEo = new DgSaleOrderEo();
                        updateStatusEo.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
                        updateStatusEo.setInterceptInfo(EMPTY);
                        childBizSaleOrderDto.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
                        return f -> {
                            this.updateOrderLogicInfo(childDgSaleOrderEo, childSaleOrderItemEos);
                            this.saleOrderService.updateSaleOrderById(childDgSaleOrderEo.getId(), updateStatusEo);
                            this.orderTagRecordService.delLjddTagByOrder(saleOrderEo.getId());
                        };
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new BizException("\u5bfb\u6e90\u914d\u8d27\u5f02\u5e38:{}", e.getMessage());
                    }
                }, executorService));
            }
            CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
            futureList.forEach(r -> {
                try {
                    ((Consumer)r.get()).accept(true);
                }
                catch (Exception e) {
                    throw new BizException(e.getMessage());
                }
            });
            DgSaleOrderEo updateDgSaleOrderEo = new DgSaleOrderEo();
            updateDgSaleOrderEo.setOrderStatus(SaleOrderStatusEnum.SPLIT.getCode());
            this.optimisticSaleOrderStatus(updateDgSaleOrderEo, orderId, SaleOrderStatusEnum.WAIT_PICK);
        }
        this.saleTransferOrderService.addBatchSaleTransferOrder(addSaleTransferOrderReqDtoList);
        for (SaleTransferOrderReqDto saleTransferOrderReqDto : addSaleTransferOrderReqDtoList) {
            this.doPcpStatusLockAndSystem(saleTransferOrderReqDto.getSaleOrderNo());
        }
        this.logger.info("\u9500\u552e\u8c03\u62e8\u6253\u6807\u8ba2\u5355id:{}", (Object)JSON.toJSONString(saleTransferOrderIdList));
        if (CollectionUtils.isNotEmpty(saleTransferOrderIdList)) {
            this.addSaleTransferTag(saleTransferOrderIdList, "GSDB");
        }
        this.bInventoryApiServcie.preemptOrderInventoryAndAddSaleTransfer(csLogicPreemptInventoryOperateReqDtos, csTransferOrderComboReqDtos);
        this.updateInventryStock(saleOrderEo, deliveryOrderIdList, context, childOrderList);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                for (Long deliveryId : deliveryOrderIdList) {
                    MessageVo messageVo = new MessageVo();
                    messageVo.setData((Object)deliveryId);
                    SaleOrderOptServiceImpl.this.logger.info("\u7ee7\u7eed\u53d1\u8d27\u8ba2\u5355id:{}", (Object)deliveryId);
                    SaleOrderOptServiceImpl.this.commonsMqService.sendSingleMessage("ORDER_CONTINUE_DELIVERY", (Object)messageVo);
                }
            }
        });
        return deliveryOrderIdList;
    }

    private void updateInventryStock(final DgSaleOrderEo saleOrderEo, final List<Long> deliveryOrderIdList, final ServiceContext context, List<BizSaleOrderRespDto> childOrderList) {
        final String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        final List<BizSaleOrderRespDto> finalChildOrderList = childOrderList;
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                if (CollectionUtils.isNotEmpty((Collection)finalChildOrderList)) {
                    CompletableFuture.runAsync(() -> {
                        context.getAttachments().forEach((k, v) -> ServiceContext.getContext().setAttachment(k, v));
                        MDC.put((String)"yes.req.requestId", (String)reqId);
                        SplitOrderReqDto splitOrderReqDto = new SplitOrderReqDto();
                        splitOrderReqDto.setSplitBatchDeliveryFlag(Boolean.TRUE.booleanValue());
                        SaleOrderOptServiceImpl.this.logger.info("\u62c6\u5355\u91ca\u653e\u4e3b\u5355\u9884\u5360\u5b50\u5355\u5e93\u5b58");
                        SaleOrderOptServiceImpl.this.updateOrderInventory(saleOrderEo, finalChildOrderList, splitOrderReqDto, deliveryOrderIdList);
                    });
                } else if (CollectionUtils.isNotEmpty((Collection)deliveryOrderIdList)) {
                    SaleOrderOptServiceImpl.this.logger.info("\u4e0d\u62c6\u5355\u4f46\u662f\u53d1\u8d27\u53cd\u5411\u9884\u5360\u4f9b\u8d27\u4ed3\u5e93\u5b58");
                    BizSaleOrderRespDto bizSaleOrderRespDto = SaleOrderOptServiceImpl.this.saleOrderService.queryByOrderNo(saleOrderEo.getSaleOrderNo());
                    SaleOrderOptServiceImpl.this.bInventoryApiServcie.sendChildOrderPreemptLogic(Lists.newArrayList((Object[])new BizSaleOrderRespDto[]{bizSaleOrderRespDto}));
                }
            }
        });
    }

    private void allotSaleAndDeliveryDto(DgSaleOrderEo saleOrderEo, List<DgSaleOrderItemEo> saleOrderItemEos, DgSaleOrderAddrEo orderAddrEo, Map<String, CsLogicWarehouseRespDto> logicInfoMap, List<Long> deliveryOrderIdList, List<Long> saleTransferOrderIdList, List<SaleTransferOrderReqDto> addSaleTransferOrderReqDtoList, List<CsLogicPreemptInventoryOperateReqDto> csLogicPreemptInventoryOperateReqDtos, List<CsTransferOrderComboReqDto> csTransferOrderComboReqDtos, SplitOrderBySourceInfoReqDto splitOrderBySourceInfoReqDto) {
        if (Objects.equals(splitOrderBySourceInfoReqDto.getDeliveryType(), WarehouseAreaMappingTypeEnum.ALLOT_SALE.getCode()) || Objects.equals(splitOrderBySourceInfoReqDto.getDeliveryType(), AllotTypeEnum.MAIYOU_BC_ALLOT.getType()) || Objects.equals(splitOrderBySourceInfoReqDto.getDeliveryType(), AllotTypeEnum.MAIYOU_CC_ALLOT.getType()) || Objects.equals(splitOrderBySourceInfoReqDto.getDeliveryType(), AllotTypeEnum.MAIYOU_BC_SAME_ORG_ALLOT.getType()) || Objects.equals(splitOrderBySourceInfoReqDto.getDeliveryType(), AllotTypeEnum.MAIYOU_CB_SAME_ORG_ALLOT.getType()) || Objects.equals(splitOrderBySourceInfoReqDto.getDeliveryType(), AllotTypeEnum.MAIYOU_CC_ALLOT_OUT.getType())) {
            String logicWarehouseCode = splitOrderBySourceInfoReqDto.getInLogicWarehouseCode();
            if (StringUtils.isNotEmpty((CharSequence)splitOrderBySourceInfoReqDto.getTransferLogicWarehouseCode())) {
                logicWarehouseCode = splitOrderBySourceInfoReqDto.getTransferLogicWarehouseCode();
            }
            if (Objects.equals(splitOrderBySourceInfoReqDto.getDeliveryType(), AllotTypeEnum.MAIYOU_CB_SAME_ORG_ALLOT.getType())) {
                logicWarehouseCode = splitOrderBySourceInfoReqDto.getDeliveryLogicWarehouseCode();
            }
            CsLogicWarehouseRespDto logicInfoDto = logicInfoMap.get(logicWarehouseCode);
            this.setSaleOrderLogicInfo(saleOrderEo, saleOrderItemEos, logicInfoDto);
            saleTransferOrderIdList.add(saleOrderEo.getId());
            String inLogicWarehouseCode = splitOrderBySourceInfoReqDto.getInLogicWarehouseCode();
            CsLogicWarehouseRespDto inLogicWarehouseDto = logicInfoMap.get(inLogicWarehouseCode);
            String transferLogicWarehouseCode = splitOrderBySourceInfoReqDto.getTransferLogicWarehouseCode();
            CsLogicWarehouseRespDto centerLogicWarehouseDto = logicInfoMap.get(transferLogicWarehouseCode);
            String outLogicWarehouseCode = splitOrderBySourceInfoReqDto.getDeliveryLogicWarehouseCode();
            CsLogicWarehouseRespDto outLogicWarehouseDto = logicInfoMap.get(outLogicWarehouseCode);
            CsTransferOrderComboReqDto saleOrderToTransferOrder = this.bInventoryApiServcie.getSaleOrderToTransferOrder(saleOrderEo, saleOrderItemEos, outLogicWarehouseDto, inLogicWarehouseDto, centerLogicWarehouseDto, splitOrderBySourceInfoReqDto);
            csTransferOrderComboReqDtos.add(saleOrderToTransferOrder);
            SaleTransferOrderReqDto saleTransfer = this.createSaleTransfer(saleOrderEo, saleOrderToTransferOrder);
            addSaleTransferOrderReqDtoList.add(saleTransfer);
            CsLogicPreemptInventoryOperateReqDto saleOrderToLogicPreempt = this.bInventoryApiServcie.getSaleOrderToLogicPreempt(saleOrderEo, saleOrderItemEos, orderAddrEo, 0);
            csLogicPreemptInventoryOperateReqDtos.add(saleOrderToLogicPreempt);
        } else if (Objects.equals(splitOrderBySourceInfoReqDto.getDeliveryType(), WarehouseAreaMappingTypeEnum.SALE_ORDER_OUT.getCode())) {
            String logicWarehouseCode = splitOrderBySourceInfoReqDto.getDeliveryLogicWarehouseCode();
            CsLogicWarehouseRespDto logicInfoDto = logicInfoMap.get(logicWarehouseCode);
            this.setSaleOrderLogicInfo(saleOrderEo, saleOrderItemEos, logicInfoDto);
            deliveryOrderIdList.add(saleOrderEo.getId());
            CsLogicPreemptInventoryOperateReqDto saleOrderToLogicPreempt = this.bInventoryApiServcie.getSaleOrderToLogicPreempt(saleOrderEo, saleOrderItemEos, orderAddrEo, 1);
            csLogicPreemptInventoryOperateReqDtos.add(saleOrderToLogicPreempt);
        }
    }

    private void setSaleOrderLogicInfo(DgSaleOrderEo saleOrderEo, List<DgSaleOrderItemEo> saleOrderItemEos, CsLogicWarehouseRespDto logicInfoDto) {
        saleOrderEo.setLogicalWarehouseCode(logicInfoDto.getWarehouseCode());
        saleOrderEo.setLogicalWarehouseId(logicInfoDto.getId());
        saleOrderEo.setLogicalWarehouseName(logicInfoDto.getWarehouseName());
        saleOrderEo.setPhysicsWarehouseId(logicInfoDto.getPhysicsWarehouseId());
        saleOrderEo.setPhysicsWarehouseCode(logicInfoDto.getPhysicsWarehouseCode());
        saleOrderEo.setPhysicsWarehouseName(logicInfoDto.getPhysicsWarehouseName());
        for (DgSaleOrderItemEo saleOrderItemEo : saleOrderItemEos) {
            saleOrderItemEo.setLogicalWarehouseId(saleOrderEo.getLogicalWarehouseId());
            saleOrderItemEo.setLogicalWarehouseCode(saleOrderEo.getLogicalWarehouseCode());
            saleOrderItemEo.setLogicalWarehouseName(saleOrderEo.getLogicalWarehouseName());
        }
    }

    private void updateOrderLogicInfo(DgSaleOrderEo saleOrderEo, List<DgSaleOrderItemEo> saleOrderItemEos) {
        DgSaleOrderEo updateOrderEo = new DgSaleOrderEo();
        updateOrderEo.setId(saleOrderEo.getId());
        updateOrderEo.setLogicalWarehouseCode(saleOrderEo.getLogicalWarehouseCode());
        updateOrderEo.setLogicalWarehouseId(saleOrderEo.getLogicalWarehouseId());
        updateOrderEo.setLogicalWarehouseName(saleOrderEo.getLogicalWarehouseName());
        updateOrderEo.setPhysicsWarehouseId(saleOrderEo.getPhysicsWarehouseId());
        updateOrderEo.setPhysicsWarehouseCode(saleOrderEo.getPhysicsWarehouseCode());
        updateOrderEo.setPhysicsWarehouseName(saleOrderEo.getPhysicsWarehouseName());
        this.updateSaleOrderById(saleOrderEo.getId(), updateOrderEo);
        for (DgSaleOrderItemEo saleOrderItemEo : saleOrderItemEos) {
            DgSaleOrderItemEo updateItemEo = new DgSaleOrderItemEo();
            updateItemEo.setId(saleOrderItemEo.getId());
            updateItemEo.setLogicalWarehouseId(saleOrderItemEo.getLogicalWarehouseId());
            updateItemEo.setLogicalWarehouseCode(saleOrderItemEo.getLogicalWarehouseCode());
            updateItemEo.setLogicalWarehouseName(saleOrderItemEo.getLogicalWarehouseName());
            this.dgSaleOrderItemDomain.updateSelective((BaseEo)updateItemEo);
        }
    }

    private SaleTransferOrderReqDto createSaleTransfer(DgSaleOrderEo saleOrderEo, CsTransferOrderComboReqDto reqDto) {
        this.logger.info("\u521b\u5efa\u9500\u552e\u8c03\u62e8\u5173\u8054\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        SaleTransferOrderReqDto saleTransferOrderReqDto = new SaleTransferOrderReqDto();
        String type = Objects.nonNull(saleOrderEo.getAllotType()) ? saleOrderEo.getAllotType() : SaleTransferTypeEnum.SALE.getCode();
        saleTransferOrderReqDto.setTransferType(type);
        saleTransferOrderReqDto.setSaleOrderNo(saleOrderEo.getSaleOrderNo());
        saleTransferOrderReqDto.setPlatformOrderNo(saleOrderEo.getPlatformOrderNo());
        saleTransferOrderReqDto.setTransferOrderNo(reqDto.getCsOtherStorageOrderReqDto().getTransferOrderNo());
        saleTransferOrderReqDto.setTransferQuantity(reqDto.getCsOtherStorageOrderReqDto().getTotalQuantity());
        List collect = reqDto.getDetailList().stream().map(detail -> {
            SaleTransferOrderDetailReqDto detailReqDto = new SaleTransferOrderDetailReqDto();
            detailReqDto.setSaleOrderNo(saleTransferOrderReqDto.getSaleOrderNo());
            detailReqDto.setTransferOrderNo(detailReqDto.getTransferOrderNo());
            detailReqDto.setQuantity(detail.getQuantity());
            detailReqDto.setSkuCode(detail.getLongCode());
            return detailReqDto;
        }).collect(Collectors.toList());
        saleTransferOrderReqDto.setSaleTransferOrderDetailReqDtoList(collect);
        return saleTransferOrderReqDto;
    }

    private void addSaleTransferTag(List<Long> ids, String tagCode) {
        OrderTagRecordAddBatchReqDto recordReqDto = new OrderTagRecordAddBatchReqDto();
        recordReqDto.setSaleOrderIds(ids);
        recordReqDto.setTagCodes((List)Lists.newArrayList((Object[])new String[]{tagCode}));
        recordReqDto.setModel(OrderTagRecordAddBatchReqDto.ActionModel.APPEND);
        this.orderTagRecordService.addBatchOrderTagRecord(recordReqDto);
    }

    private List<BizSaleOrderRespDto> splitOrderForSourceTransfer(List<SplitOrderBySourceInfoReqDto> list) {
        SplitOrderBySourceInfoReqDto splitOrderBySourceInfoReqDto = list.get(0);
        SplitOrderReqDto splitOrderReqDto = new SplitOrderReqDto();
        ArrayList orderList = Lists.newArrayList();
        splitOrderReqDto.setSaleOrderId(splitOrderBySourceInfoReqDto.getSaleOrderId());
        splitOrderReqDto.setSaleOrderNo(splitOrderBySourceInfoReqDto.getSaleOrderNo());
        splitOrderReqDto.setOriOrderStatus(SaleOrderStatusEnum.SPLIT.getCode());
        splitOrderReqDto.setAsync(true);
        splitOrderReqDto.setSplitBatchDeliveryFlag(Boolean.TRUE.booleanValue());
        splitOrderReqDto.setInitOrderStatus(SaleOrderStatusEnum.WAIT_PICK.getCode());
        splitOrderReqDto.setInitOmsOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK.getCode());
        for (SplitOrderBySourceInfoReqDto orderBySourceInfoReqDto : list) {
            SplitChildOrderReqDto splitChildOrderReqDto = new SplitChildOrderReqDto();
            SplitChildOrderReqDto.LogicWarehouse logicWarehouse = new SplitChildOrderReqDto.LogicWarehouse();
            logicWarehouse.setDeliveryLogicWarehouseId(orderBySourceInfoReqDto.getDeliveryLogicWarehouseId());
            logicWarehouse.setDeliveryLogicWarehouseCode(orderBySourceInfoReqDto.getDeliveryLogicWarehouseCode());
            logicWarehouse.setDeliveryLogicWarehouseName(orderBySourceInfoReqDto.getDeliveryLogicWarehouseName());
            splitChildOrderReqDto.setLogicWarehouse(logicWarehouse);
            splitChildOrderReqDto.setOrderStatus(SaleOrderStatusEnum.WAIT_PICK.getCode());
            splitChildOrderReqDto.setGoodsList(orderBySourceInfoReqDto.getGoodsList());
            orderList.add(splitChildOrderReqDto);
        }
        splitOrderReqDto.setOrderList((List)orderList);
        this.logger.info("\u9ad8\u7ea7\u5bfb\u6e90\u62c6\u5355\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
        List<BizSaleOrderRespDto> bizSaleOrderRespDtos = this.splitOrderTcbj(splitOrderReqDto);
        this.processYphTagForSplitOrders(splitOrderReqDto.getSaleOrderNo(), bizSaleOrderRespDtos);
        return bizSaleOrderRespDtos;
    }

    @Override
    public Boolean checkSplitLegalDg(List<SplitOrderItemReqDto> splitOrderItemReqDtos, DgSaleOrderRespDto saleOrderRespDto, List<DgSaleOrderItemRespDto> saleOrderItemRespDtos, int splitOrderCount) {
        DgSaleOrderEo dgSaleOrderEo = new DgSaleOrderEo();
        if (Objects.nonNull(saleOrderRespDto)) {
            DtoHelper.dto2Eo((BaseVo)saleOrderRespDto, (BaseEo)dgSaleOrderEo);
        }
        ArrayList saleOrderItemEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)saleOrderItemEos, saleOrderItemRespDtos, DgSaleOrderItemEo.class);
        return this.checkSplitLegal(splitOrderItemReqDtos, dgSaleOrderEo, saleOrderItemEos, splitOrderCount);
    }

    @Override
    public boolean checkOrderSplitWaitFlagByOrderNo(String orderNo) {
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoByNo(orderNo);
        return this.checkOrderSplitWaitFlag(saleOrderEo);
    }

    @Override
    public void saleSourceZtNum(SaleOrderOldBatchMatchReqDto reqDto) {
        Map saleItemIntranst = this.saleIntransitCache.getSaleItemIntranst(reqDto.getLinkOrderNo());
        String sourceDeliveryKey = "sourceDeliveryFlag_" + reqDto.getLinkOrderNo();
        if (Objects.nonNull(saleItemIntranst) && saleItemIntranst.containsKey(sourceDeliveryKey) && ((Boolean)saleItemIntranst.get(sourceDeliveryKey)).booleanValue()) {
            this.logger.info("\u9884\u5bfb\u6e90\u6574\u5355\u53d1\u8d27\u8d70\u6307\u5b9a\u53d1\u8d27\u4ed3\u64cd\u4f5c\u4e0d\u518d\u5355\u72ec\u8fdb\u884c\u9500\u552e\u5728\u9014\u6570\u5e93\u5b58\u5224\u65ad");
            return;
        }
        this.logger.info("\u9500\u552e\u5355\u5bfb\u6e90\u5728\u9014\u6570\u5165\u53c2={}", JSON.toJSON((Object)reqDto));
        List orderItemResultRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.orderOptApiProxy.saleOrderOldBatchMatch(reqDto));
        this.logger.info("\u9500\u552e\u5355\u5bfb\u6e90\u5728\u9014\u6570\u7ed3\u679c={}", JSON.toJSON((Object)orderItemResultRespDtos));
        if (CollectionUtils.isNotEmpty((Collection)orderItemResultRespDtos)) {
            Map<String, Boolean> saleItemInMap = orderItemResultRespDtos.stream().collect(Collectors.toMap(i -> i.getLinkOrderItemId() + "_" + reqDto.getLogicWarehouseCode(), result -> Objects.nonNull(result.getZtDeliveryWarehouseItemNum()) && result.getZtDeliveryWarehouseItemNum().compareTo(BigDecimal.ZERO) > 0, (k1, k2) -> k1 != false ? k1 : k2));
            this.saleIntransitCache.setSaleItemIntranst(reqDto.getLinkOrderNo(), saleItemInMap);
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public void retractOrder(Long orderId) {
        this.logger.info("\u56de\u64a4\u8ba2\u5355-->{}", (Object)orderId);
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoById(orderId);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(DgSaleOrderEo::getLogicalWarehouseCode, null)).set(DgSaleOrderEo::getLogicalWarehouseId, null)).set(DgSaleOrderEo::getLogicalWarehouseName, null)).set(DgSaleOrderEo::getPhysicsWarehouseCode, null)).set(DgSaleOrderEo::getPhysicsWarehouseId, null)).set(DgSaleOrderEo::getPhysicsWarehouseName, null)).set(DgSaleOrderEo::getSecondOrderStatus, (Object)SecondSaleOrderStatusEnum.WAIT_PICK_UNLOCK.getCode())).eq(BaseEo::getId, (Object)saleOrderEo.getId());
        this.dgSaleOrderDomain.getMapper().update(null, (Wrapper)updateWrapper);
        this.doPcpStatusUnLockAndSystem(saleOrderEo.getSaleOrderNo());
        try {
            this.saleTransferExtDomain.delByOrderId(orderId);
        }
        catch (Exception e) {
            this.logger.info("\u5220\u9664\u8ba2\u5355\u5173\u8054\u7684\u8c03\u62e8\u5355\u62a5\u9519:{}", (Object)e.getMessage());
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    @Transactional(rollbackFor={Exception.class})
    public void maiyouAllotDelivery(Long orderId, List<SplitOrderBySourceInfoReqDto> splitOrderReqList) {
        this.logger.info("\u9ea6\u4f18\u8de8\u7ec4\u7ec7\u8c03\u62e8\u7c7b\u578b\u914d\u8d27\u5165\u53c2:{}", JSON.toJSON(splitOrderReqList));
        AssertUtils.notNull((Object)orderId, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(orderId);
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderEo.getId());
        List saleOrderItemEos = this.dgSaleOrderItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        AssertUtils.notEmpty((Collection)saleOrderItemEos, (String)"\u8ba2\u5355\uff08saleOrderNo=%s\uff09\u5546\u54c1\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{saleOrderEo.getSaleOrderNo()});
        DgSaleOrderAddrEo orderAddrEo = this.saleOrderAddrService.queryEoAddressByOrderId(saleOrderEo.getId());
        HashSet<String> logicWarehouseCodeSet = new HashSet<String>();
        Boolean intransitPreemptFlag = false;
        HashMap saleItemAllMap = new HashMap();
        for (SplitOrderBySourceInfoReqDto splitOrderBySourceInfoReqDto : splitOrderReqList) {
            logicWarehouseCodeSet.add(splitOrderBySourceInfoReqDto.getDeliveryLogicWarehouseCode());
            if (StringUtils.isNotEmpty((CharSequence)splitOrderBySourceInfoReqDto.getTransferLogicWarehouseCode())) {
                logicWarehouseCodeSet.add(splitOrderBySourceInfoReqDto.getTransferLogicWarehouseCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)splitOrderBySourceInfoReqDto.getInLogicWarehouseCode())) {
                logicWarehouseCodeSet.add(splitOrderBySourceInfoReqDto.getInLogicWarehouseCode());
            }
            intransitPreemptFlag = splitOrderBySourceInfoReqDto.getIntransitPreemptFlag();
            if (!CollectionUtils.isNotEmpty((Collection)splitOrderBySourceInfoReqDto.getGoodsList())) continue;
            Map<String, Boolean> saleItemInMap = splitOrderBySourceInfoReqDto.getGoodsList().stream().collect(Collectors.toMap(i -> i.getOriginalOrderGoodsId() + "_" + splitOrderBySourceInfoReqDto.getDeliveryLogicWarehouseCode(), result -> Objects.nonNull(result.getZtDeliveryWarehouseItemNum()) && result.getZtDeliveryWarehouseItemNum().compareTo(BigDecimal.ZERO) > 0, (k1, k2) -> k1 != false ? k1 : k2));
            saleItemAllMap.putAll(saleItemInMap);
        }
        this.saleIntransitCache.setSaleIntranst(saleOrderEo.getSaleOrderNo(), intransitPreemptFlag);
        this.saleIntransitCache.setSaleItemIntranst(saleOrderEo.getSaleOrderNo(), saleItemAllMap);
        List<CsLogicWarehouseRespDto> csLogicWarehousePageRespDtos = this.bInventoryApiServcie.queryCsLogicWarehousePageRespDtoListByCodeList(new ArrayList<String>(logicWarehouseCodeSet));
        if (CollectionUtils.isEmpty(csLogicWarehousePageRespDtos)) {
            throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u903b\u8f91\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728"});
        }
        Map<String, CsLogicWarehouseRespDto> logicInfoMap = csLogicWarehousePageRespDtos.stream().collect(Collectors.toMap(CsLogicWarehouseRespDto::getWarehouseCode, Function.identity(), (v1, v2) -> v1));
        for (SplitOrderBySourceInfoReqDto splitOrderBySourceInfoReqDto : splitOrderReqList) {
            CsLogicWarehouseRespDto inLogicWarehousePageRespDto = (CsLogicWarehouseRespDto)logicInfoMap.get(splitOrderBySourceInfoReqDto.getInLogicWarehouseCode());
            if (Objects.isNull(inLogicWarehousePageRespDto)) {
                throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u8c03\u5165\u903b\u8f91\u4ed3[" + splitOrderBySourceInfoReqDto.getInLogicWarehouseCode() + "]\u4fe1\u606f\u4e0d\u5b58\u5728"});
            }
            if (Objects.equals(inLogicWarehousePageRespDto.getWarehouseStatus(), CsValidFlagEnum.DISABLE.getCode())) {
                throw PcpTradeExceptionCode.WAREHOUSE_STATUS_DISABLE.buildBizException(new Object[]{inLogicWarehousePageRespDto.getWarehouseCode()});
            }
            CsLogicWarehouseRespDto outLogicWarehousePageRespDto = (CsLogicWarehouseRespDto)logicInfoMap.get(splitOrderBySourceInfoReqDto.getDeliveryLogicWarehouseCode());
            if (Objects.isNull(outLogicWarehousePageRespDto)) {
                throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u8c03\u51fa\u903b\u8f91\u4ed3[" + splitOrderBySourceInfoReqDto.getDeliveryLogicWarehouseCode() + "]\u4fe1\u606f\u4e0d\u5b58\u5728"});
            }
            if (!Objects.equals(outLogicWarehousePageRespDto.getWarehouseStatus(), CsValidFlagEnum.DISABLE.getCode())) continue;
            throw PcpTradeExceptionCode.WAREHOUSE_STATUS_DISABLE.buildBizException(new Object[]{outLogicWarehousePageRespDto.getWarehouseCode()});
        }
        Map logicWarehouseGroupMap = splitOrderReqList.stream().collect(Collectors.toMap(SplitOrderBySourceInfoReqDto::getDeliveryLogicWarehouseCode, Function.identity()));
        List<Long> deliveryOrderIdList = Collections.synchronizedList(Lists.newArrayList());
        List<Long> saleTransferOrderIdList = Collections.synchronizedList(Lists.newArrayList());
        List<SaleTransferOrderReqDto> addSaleTransferOrderReqDtoList = Collections.synchronizedList(Lists.newArrayList());
        List<CsLogicPreemptInventoryOperateReqDto> csLogicPreemptInventoryOperateReqDtos = Collections.synchronizedList(Lists.newArrayList());
        List<CsTransferOrderComboReqDto> csTransferOrderComboReqDtos = Collections.synchronizedList(Lists.newArrayList());
        ServiceContext context = ServiceContext.getContext();
        List<Object> childOrderList = Lists.newArrayList();
        if (logicWarehouseGroupMap.size() == 1) {
            for (String logcicWarehouseCode : logicWarehouseGroupMap.keySet()) {
                SplitOrderBySourceInfoReqDto splitOrderBySourceInfoReqDto = (SplitOrderBySourceInfoReqDto)logicWarehouseGroupMap.get(logcicWarehouseCode);
                this.allotSaleAndDeliveryDto(saleOrderEo, saleOrderItemEos, orderAddrEo, logicInfoMap, deliveryOrderIdList, saleTransferOrderIdList, addSaleTransferOrderReqDtoList, csLogicPreemptInventoryOperateReqDtos, csTransferOrderComboReqDtos, splitOrderBySourceInfoReqDto);
                this.updateOrderLogicInfo(saleOrderEo, saleOrderItemEos);
                this.processYphTagForSplitOrders(saleOrderEo.getSaleOrderNo(), Lists.newArrayList());
                DgSaleOrderEo updateStatusEo = new DgSaleOrderEo();
                updateStatusEo.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
                updateStatusEo.setInterceptInfo(EMPTY);
                this.saleOrderService.updateSaleOrderById(orderId, updateStatusEo);
                this.orderTagRecordService.delLjddTagByOrder(saleOrderEo.getId());
            }
        } else {
            childOrderList = this.splitOrderForSourceTransfer(splitOrderReqList);
            this.logger.info("\u62c6\u5355\u540e\u7684\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)childOrderList));
            Map splitChildGroupMap = childOrderList.stream().collect(Collectors.toMap(SaleOrderRespDto::getLogicalWarehouseCode, Function.identity()));
            ExecutorService executorService = Executors.newWorkStealingPool(12);
            ArrayList<CompletableFuture<Consumer>> futureList = new ArrayList<CompletableFuture<Consumer>>(logicWarehouseGroupMap.keySet().size());
            for (String logcicWarehouseCode : logicWarehouseGroupMap.keySet()) {
                futureList.add(CompletableFuture.supplyAsync(() -> {
                    context.getAttachments().forEach((k, v) -> ServiceContext.getContext().setAttachment(k, v));
                    try {
                        BizSaleOrderRespDto childBizSaleOrderDto = (BizSaleOrderRespDto)splitChildGroupMap.get(logcicWarehouseCode);
                        SplitOrderBySourceInfoReqDto splitOrderBySourceInfoReqDto = (SplitOrderBySourceInfoReqDto)logicWarehouseGroupMap.get(logcicWarehouseCode);
                        DgSaleOrderEo childDgSaleOrderEo = new DgSaleOrderEo();
                        CubeBeanUtils.copyProperties((Object)childDgSaleOrderEo, (Object)childBizSaleOrderDto, (String[])new String[0]);
                        ArrayList childSaleOrderItemEos = Lists.newArrayList();
                        CubeBeanUtils.copyCollection((Collection)childSaleOrderItemEos, (Collection)childBizSaleOrderDto.getItemList(), DgSaleOrderItemEo.class);
                        this.allotSaleAndDeliveryDto(childDgSaleOrderEo, childSaleOrderItemEos, orderAddrEo, logicInfoMap, deliveryOrderIdList, saleTransferOrderIdList, addSaleTransferOrderReqDtoList, csLogicPreemptInventoryOperateReqDtos, csTransferOrderComboReqDtos, splitOrderBySourceInfoReqDto);
                        DgSaleOrderEo updateStatusEo = new DgSaleOrderEo();
                        updateStatusEo.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
                        updateStatusEo.setInterceptInfo(EMPTY);
                        childBizSaleOrderDto.setSecondOrderStatus(SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
                        return f -> {
                            this.updateOrderLogicInfo(childDgSaleOrderEo, childSaleOrderItemEos);
                            this.saleOrderService.updateSaleOrderById(childDgSaleOrderEo.getId(), updateStatusEo);
                            this.orderTagRecordService.delLjddTagByOrder(saleOrderEo.getId());
                        };
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new BizException("\u5bfb\u6e90\u914d\u8d27\u5f02\u5e38:{}", e.getMessage());
                    }
                }, executorService));
            }
            CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
            futureList.forEach(r -> {
                try {
                    ((Consumer)r.get()).accept(true);
                }
                catch (Exception e) {
                    throw new BizException(e.getMessage());
                }
            });
            DgSaleOrderEo updateDgSaleOrderEo = new DgSaleOrderEo();
            updateDgSaleOrderEo.setOrderStatus(SaleOrderStatusEnum.SPLIT.getCode());
            this.optimisticSaleOrderStatus(updateDgSaleOrderEo, orderId, SaleOrderStatusEnum.WAIT_PICK);
        }
        this.saleTransferOrderService.addBatchSaleTransferOrder(addSaleTransferOrderReqDtoList);
        for (SaleTransferOrderReqDto saleTransferOrderReqDto : addSaleTransferOrderReqDtoList) {
            this.doPcpStatusLockAndSystem(saleTransferOrderReqDto.getSaleOrderNo());
        }
        this.bInventoryApiServcie.preemptOrderInventoryAndAddSaleTransfer(csLogicPreemptInventoryOperateReqDtos, csTransferOrderComboReqDtos);
        this.updateInventryStock(saleOrderEo, deliveryOrderIdList, context, childOrderList);
    }
}

