/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.mark.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.dao.das.IDgOrderTagDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderTagDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderTagRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderTagReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderTagItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderTagRelationRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderTagRelationsRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderTagRespDto;
import com.yunxi.dg.base.center.trade.eo.DgOrderTagEo;
import com.yunxi.dg.base.center.trade.service.IDgResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.service.mark.IDgOrderTagItemService;
import com.yunxi.dg.base.center.trade.service.mark.IDgOrderTagRecordService;
import com.yunxi.dg.base.center.trade.service.mark.IDgOrderTagService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.DgNoGreateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgOrderTagServiceImpl
implements IDgOrderTagService,
IDgResetRedisNoIndexCommon {
    @Resource
    private IDgOrderTagDas orderTagDas;
    @Resource
    private DgNoGreateUtil dgNoGreateUtil;
    @Resource
    private IDgOrderTagItemService orderTagItemService;
    @Resource
    private IDgOrderTagRecordService orderTagRecordService;
    @Resource
    private IDgOrderTagDomain orderTagDomain;

    @Override
    public Long addOrderTag(DgOrderTagReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto.getTagName(), (String)"\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderTagEo orderTagEo = new DgOrderTagEo();
        CubeBeanUtils.copyProperties((Object)orderTagEo, (Object)addReqDto, (String[])new String[0]);
        orderTagEo.setTagCode(this.dgNoGreateUtil.generateTagNo());
        this.orderTagDas.insert((BaseEo)orderTagEo);
        return orderTagEo.getId();
    }

    @Override
    public void modifyOrderTag(DgOrderTagReqDto modifyReqDto) {
        AssertUtils.notNull((Object)modifyReqDto.getId(), (String)"\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderTagEo orderTagEo = new DgOrderTagEo();
        CubeBeanUtils.copyProperties((Object)orderTagEo, (Object)modifyReqDto, (String[])new String[0]);
        this.orderTagDas.updateSelective((BaseEo)orderTagEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderTag(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderTagDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public DgOrderTagRespDto queryById(Long id) {
        DgOrderTagEo orderTagEo = (DgOrderTagEo)this.orderTagDas.selectByPrimaryKey(id);
        DgOrderTagRespDto orderTagRespDto = new DgOrderTagRespDto();
        CubeBeanUtils.copyProperties((Object)orderTagRespDto, (Object)orderTagEo, (String[])new String[0]);
        return orderTagRespDto;
    }

    @Override
    public PageInfo<DgOrderTagRespDto> queryByPage(DgOrderTagReqDto orderTagReqDto, Integer pageNum, Integer pageSize) {
        DgOrderTagEo orderTagEo = new DgOrderTagEo();
        this.param(orderTagEo, orderTagReqDto);
        PageInfo eoPageInfo = this.orderTagDas.selectPage((BaseEo)orderTagEo, pageNum, pageSize, Boolean.valueOf(false));
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), DgOrderTagRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<DgOrderTagRespDto> queryByTagCodes(List<String> tagCodes) {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(tagCodes), (String)"\u6807\u7b7e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return this.orderTagDomain.queryByTagCodes(tagCodes);
    }

    @Override
    public DgOrderTagRelationRespDto queryByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgOrderTagReqDto orderTagReqDto = new DgOrderTagReqDto();
        orderTagReqDto.setOrderIds(Arrays.asList(orderId));
        DgOrderTagRelationsRespDto relationsRespDto = this.queryOrderTagRelations(orderTagReqDto);
        if (Objects.isNull(relationsRespDto)) {
            return null;
        }
        DgOrderTagRelationRespDto relationRespDto = new DgOrderTagRelationRespDto();
        if (Objects.nonNull(relationsRespDto.getOrderTagRecordMaps())) {
            relationRespDto.setOrderTagRecords((List)relationsRespDto.getOrderTagRecordMaps().get(orderId.toString()));
        }
        if (Objects.nonNull(relationsRespDto.getOrderTagItemMaps())) {
            relationRespDto.setOrderTagItems((List)relationsRespDto.getOrderTagItemMaps().get(orderId.toString()));
        }
        return relationRespDto;
    }

    @Override
    public DgOrderTagRelationsRespDto queryOrderTagRelations(DgOrderTagReqDto orderTagReqDto) {
        return null;
    }

    public List<DgOrderTagRespDto> queryByParam(DgOrderTagReqDto orderTagReqDto) {
        DgOrderTagEo orderTagEo = new DgOrderTagEo();
        orderTagEo.setDr(0);
        this.param(orderTagEo, orderTagReqDto);
        List orderTagEos = this.orderTagDas.selectList((BaseEo)orderTagEo);
        if (CollectionUtils.isEmpty((Collection)orderTagEos)) {
            return null;
        }
        ArrayList<DgOrderTagRespDto> dtoList = new ArrayList<DgOrderTagRespDto>();
        CubeBeanUtils.copyCollection(dtoList, (Collection)orderTagEos, DgOrderTagRespDto.class);
        return dtoList;
    }

    private void param(DgOrderTagEo orderTagEo, DgOrderTagReqDto orderTagReqDto) {
        ArrayList orderSqlFilter = Lists.newArrayList();
        if (Objects.nonNull(orderTagReqDto.getId())) {
            orderTagEo.setId(orderTagReqDto.getId());
        }
        if (Objects.nonNull(orderTagReqDto.getTagStatus())) {
            orderTagEo.setTagStatus(orderTagReqDto.getTagStatus());
        }
        if (Objects.nonNull(orderTagReqDto.getTagType())) {
            orderTagEo.setTagType(orderTagReqDto.getTagType());
        }
        if (Objects.nonNull(orderTagReqDto.getTagCode())) {
            orderSqlFilter.add(SqlFilter.like((String)"tag_code", (Object)orderTagReqDto.getTagCode()));
        }
        if (Objects.nonNull(orderTagReqDto.getTagName())) {
            orderSqlFilter.add(SqlFilter.like((String)"tag_name", (Object)orderTagReqDto.getTagName()));
        }
        if (Objects.nonNull(orderTagReqDto.getUpdateStartTime()) && Objects.nonNull(orderTagReqDto.getUpdateEndTime())) {
            orderSqlFilter.add(SqlFilter.ge((String)"updateTime", (Object)orderTagReqDto.getUpdateStartTime()));
            orderSqlFilter.add(SqlFilter.le((String)"updateTime", (Object)orderTagReqDto.getUpdateEndTime()));
        }
        if (CollectionUtils.isNotEmpty((Collection)orderTagReqDto.getTagCodes())) {
            orderSqlFilter.add(SqlFilter.in((String)"tag_code", (Object)orderTagReqDto.getTagCodes()));
        }
        orderTagEo.setOrderByDesc("update_time");
        orderTagEo.setSqlFilters((List)orderSqlFilter);
    }

    private List<String> getTagCodes(List<? extends DgOrderTagRecordDto> ... orderTagRecordList) {
        ArrayList tagCodes = Lists.newArrayList();
        for (List<? extends DgOrderTagRecordDto> orderTagBaseResp : orderTagRecordList) {
            List tagCodeList = Optional.ofNullable(orderTagBaseResp).orElse(Lists.newArrayList()).stream().map(DgOrderTagRecordDto::getTagCode).collect(Collectors.toList());
            tagCodes.addAll(tagCodeList);
        }
        return tagCodes;
    }

    private List<DgOrderTagRespDto> convertTag(List<? extends DgOrderTagRecordDto> orderTagBaseRespDtos, Map<String, DgOrderTagRespDto> orderTagRespDtoMaps) {
        return orderTagBaseRespDtos.stream().map(e -> {
            if (orderTagRespDtoMaps.containsKey(e.getTagCode())) {
                DgOrderTagRespDto orderTagRespDto = (DgOrderTagRespDto)orderTagRespDtoMaps.get(e.getTagCode());
                DgOrderTagRespDto newOrderTag = new DgOrderTagRespDto();
                CubeBeanUtils.copyProperties((Object)newOrderTag, (Object)orderTagRespDto, (String[])new String[0]);
                newOrderTag.setOrderId(e.getOrderId());
                if (e instanceof DgOrderTagItemRespDto) {
                    newOrderTag.setSkuCode(((DgOrderTagItemRespDto)e).getSkuCode());
                }
                return newOrderTag;
            }
            return null;
        }).collect(Collectors.toList());
    }

    @Override
    public String getLatestNo() {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderWrapper.orderByDesc(BaseEo::getId)).orderByDesc(BaseEo::getCreateTime)).last(" limit 1");
        DgOrderTagEo orderTagEo = (DgOrderTagEo)this.orderTagDas.getMapper().selectOne((Wrapper)queryOrderWrapper);
        if (orderTagEo == null) {
            return "";
        }
        return orderTagEo.getTagCode();
    }
}

