/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryRecordReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OutDeliveryResultReqDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.domain.entity.IDgDeliveryOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgDeliveryRecordDomain;
import com.yunxi.dg.base.center.trade.eo.DgDeliveryOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgDeliveryRecordEo;
import com.yunxi.dg.base.center.trade.service.tc.IPcpDeliveryRecordService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PcpDeliveryRecordServiceImpl
implements IPcpDeliveryRecordService {
    @Resource
    private IDgDeliveryRecordDomain dgDeliveryRecordDomain;
    @Resource
    private IDgDeliveryOrderItemDomain dgDeliveryOrderItemDomain;

    @Override
    public Long addDeliveryRecord(DeliveryRecordReqDto addReqDto) {
        DgDeliveryRecordEo pcpDeliveryRecordEo = new DgDeliveryRecordEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)pcpDeliveryRecordEo);
        this.dgDeliveryRecordDomain.insert((BaseEo)pcpDeliveryRecordEo);
        return pcpDeliveryRecordEo.getId();
    }

    @Override
    public void saveDeliveryRecord(OutDeliveryResultReqDto reqDto, String deliveryStatus) {
        DgDeliveryRecordEo pcpDeliveryRecordEo = new DgDeliveryRecordEo();
        pcpDeliveryRecordEo.setDeliveryStatus(deliveryStatus);
        pcpDeliveryRecordEo.setOrderNo(reqDto.getOrderNo());
        this.dgDeliveryRecordDomain.insert((BaseEo)pcpDeliveryRecordEo);
        List deliveryDetailList = reqDto.getDeliveryDetailList();
        if (CollectionUtils.isNotEmpty((Collection)deliveryDetailList)) {
            ArrayList batchInsertEoList = Lists.newArrayList();
            deliveryDetailList.forEach(item -> {
                DgDeliveryOrderItemEo deliveryOrderItemEo = new DgDeliveryOrderItemEo();
                deliveryOrderItemEo.setDeliveryRecordId(pcpDeliveryRecordEo.getId());
                deliveryOrderItemEo.setSkuCode(item.getLongCode());
                deliveryOrderItemEo.setBatchNo(item.getBatch());
                deliveryOrderItemEo.setDeliveryItemNum(item.getOutQuantity());
                batchInsertEoList.add(deliveryOrderItemEo);
            });
            this.dgDeliveryOrderItemDomain.insertBatch((List)batchInsertEoList);
        }
    }

    @Override
    public void modifyDeliveryRecord(DeliveryRecordReqDto modifyReqDto) {
        DgDeliveryRecordEo pcpDeliveryRecordEo = new DgDeliveryRecordEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)pcpDeliveryRecordEo);
        this.dgDeliveryRecordDomain.updateSelective((BaseEo)pcpDeliveryRecordEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDeliveryRecord(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.dgDeliveryRecordDomain.logicDeleteById(Long.valueOf(id));
        }
    }
}

