/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderOptLogReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderOptLogRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderOptLogDomain;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderOptLogEo;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderOptLogService;
import com.yunxi.dg.base.center.trade.track.enums.OrderOperationTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleOrderOptLogServiceImpl
implements ISaleOrderOptLogService {
    @Resource
    private IDgSaleOrderOptLogDomain dgSaleOrderOptLogDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addSaleOrderOptLog(SaleOrderOptLogReqDto addReqDto) {
        DgSaleOrderOptLogEo saleOrderOptLogEo = new DgSaleOrderOptLogEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)saleOrderOptLogEo);
        if (StringUtils.isEmpty((CharSequence)saleOrderOptLogEo.getOptPerson())) {
            saleOrderOptLogEo.setOptPerson("system");
        }
        this.dgSaleOrderOptLogDomain.insert((BaseEo)saleOrderOptLogEo);
        return saleOrderOptLogEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddOrderLogByOrderIds(List<Long> orderIdList, OrderOperationTypeEnum orderOperationTypeEnum, String optResult) {
        ArrayList addList = Lists.newArrayList();
        for (Long orderId : orderIdList) {
            DgSaleOrderOptLogEo saleOrderOptLogEo = new DgSaleOrderOptLogEo();
            saleOrderOptLogEo.setSaleOrderId(orderId);
            saleOrderOptLogEo.setOptTime(new Date());
            String optPerson = StringUtils.isNotBlank((CharSequence)ServiceContext.getContext().getRequestUserCode()) ? ServiceContext.getContext().getRequestUserCode() : "system";
            saleOrderOptLogEo.setOptPerson(optPerson);
            saleOrderOptLogEo.setOptType(orderOperationTypeEnum.getDesc());
            saleOrderOptLogEo.setOptContent(optResult);
            addList.add(saleOrderOptLogEo);
        }
        this.dgSaleOrderOptLogDomain.insertBatch((List)addList);
    }

    @Override
    public void modifySaleOrderOptLog(SaleOrderOptLogReqDto modifyReqDto) {
        DgSaleOrderOptLogEo saleOrderOptLogEo = new DgSaleOrderOptLogEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)saleOrderOptLogEo);
        this.dgSaleOrderOptLogDomain.updateSelective((BaseEo)saleOrderOptLogEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSaleOrderOptLog(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.dgSaleOrderOptLogDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SaleOrderOptLogRespDto queryById(Long id) {
        DgSaleOrderOptLogEo saleOrderOptLogEo = (DgSaleOrderOptLogEo)this.dgSaleOrderOptLogDomain.selectByPrimaryKey(id);
        SaleOrderOptLogRespDto saleOrderOptLogRespDto = new SaleOrderOptLogRespDto();
        DtoHelper.eo2Dto((BaseEo)saleOrderOptLogEo, (BaseVo)saleOrderOptLogRespDto);
        return saleOrderOptLogRespDto;
    }

    @Override
    public PageInfo<SaleOrderOptLogRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SaleOrderOptLogReqDto saleOrderOptLogReqDto = (SaleOrderOptLogReqDto)JSON.parseObject((String)filter, SaleOrderOptLogReqDto.class);
        DgSaleOrderOptLogEo saleOrderOptLogEo = new DgSaleOrderOptLogEo();
        DtoHelper.dto2Eo((BaseVo)saleOrderOptLogReqDto, (BaseEo)saleOrderOptLogEo);
        saleOrderOptLogEo.setOrderByDesc("id");
        PageInfo eoPageInfo = this.dgSaleOrderOptLogDomain.selectPage((BaseEo)saleOrderOptLogEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SaleOrderOptLogRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

