/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderTypeDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfirmReceiptDetailDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfirmReceiptRuleDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.OrderTypeReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.OrderTypeRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyConfirmReceiptRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyConfirmReceiptRuleRespDto;
import com.yunxi.dg.base.center.trade.eo.StrategyConfirmReceiptDetailEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfirmReceiptRuleEo;
import com.yunxi.dg.base.center.trade.service.IDgStrategyConfirmReceiptRuleService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgStrategyConfirmReceiptRuleServiceImpl
implements IDgStrategyConfirmReceiptRuleService {
    @Resource
    private IDgStrategyConfirmReceiptRuleDomain strategyConfirmReceiptRuleDomain;
    @Resource
    private IDgStrategyConfirmReceiptDetailDomain strategyConfirmReceiptDetailDomain;
    @Resource
    private IDgOrderTypeDomain dgOrderTypeDomain;

    @Override
    public Long addStrategyConfirmReceiptRule(DgStrategyConfirmReceiptRuleReqDto addReqDto) {
        this.checkRule(addReqDto);
        StrategyConfirmReceiptRuleEo stStrategyConfirmReceiptRuleEo = new StrategyConfirmReceiptRuleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)stStrategyConfirmReceiptRuleEo);
        this.strategyConfirmReceiptRuleDomain.insert((BaseEo)stStrategyConfirmReceiptRuleEo);
        ArrayList relationEoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getOrderTypeCodeList())) {
            addReqDto.getOrderTypeCodeList().forEach(orderTypeCode -> {
                StrategyConfirmReceiptDetailEo relationEo = new StrategyConfirmReceiptDetailEo();
                relationEo.setRuleId(stStrategyConfirmReceiptRuleEo.getId());
                relationEo.setOrderTypeCode(orderTypeCode);
                relationEoList.add(relationEo);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)relationEoList)) {
            this.strategyConfirmReceiptDetailDomain.insertBatch((List)relationEoList);
        }
        return stStrategyConfirmReceiptRuleEo.getId();
    }

    private void checkChannelCode(DgStrategyConfirmReceiptRuleReqDto addReqDto) {
        String orderChannelCode = addReqDto.getOrderChannelCode();
        StrategyConfirmReceiptRuleEo stStrategyConfirmReceiptRuleEo = new StrategyConfirmReceiptRuleEo();
        stStrategyConfirmReceiptRuleEo.setOrderChannelCode(orderChannelCode);
        stStrategyConfirmReceiptRuleEo.setDr(0);
        List strategyConfirmReceiptRuleEos = this.strategyConfirmReceiptRuleDomain.selectList((BaseEo)stStrategyConfirmReceiptRuleEo);
        if (CollectionUtils.isNotEmpty((Collection)strategyConfirmReceiptRuleEos)) {
            throw new BizException("\u8be5\u6e20\u9053\u5df2\u5b58\u5728\u6536\u8d27\u7b56\u7565\u4e2d:" + orderChannelCode);
        }
    }

    private void checkRule(DgStrategyConfirmReceiptRuleReqDto reqDto) {
        DgStrategyConfirmReceiptRuleReqDto queryReqDto = new DgStrategyConfirmReceiptRuleReqDto();
        queryReqDto.setOrderChannelCodeList(reqDto.getOrderChannelCodeList());
        ArrayList<Integer> integers = new ArrayList<Integer>();
        integers.add(1);
        integers.add(2);
        queryReqDto.setRuleStatusList(integers);
        queryReqDto.setOrderChannelCode(reqDto.getOrderChannelCode());
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderTypeCodeList())) {
            queryReqDto.setOrderTypeCodeList(reqDto.getOrderTypeCodeList());
        }
        if (reqDto.getId() != null) {
            queryReqDto.setIdNotIn(Arrays.asList(reqDto.getId()));
        }
        OrderTypeReqDto orderTypeReqDto = new OrderTypeReqDto();
        orderTypeReqDto.setTypeCodeList(reqDto.getOrderTypeCodeList());
        List orderTypeRespDtos = this.dgOrderTypeDomain.queryList(orderTypeReqDto);
        List dgStrategyConfirmReceiptRuleRespDtos = this.strategyConfirmReceiptRuleDomain.queryList(queryReqDto);
        AssertUtils.isTrue((boolean)CollectionUtils.isEmpty((Collection)dgStrategyConfirmReceiptRuleRespDtos), (String)("\u6e20\u9053\uff1a" + reqDto.getOrderChannelName() + ",\u8ba2\u5355\u7c7b\u578b\uff1a" + orderTypeRespDtos.stream().map(OrderTypeRespDto::getTypeName).toString() + "\u5df2\u5b58\u5728\u6536\u8d27\u7b56\u7565\u4e2d"));
    }

    @Override
    public void modifyStrategyConfirmReceiptRule(DgStrategyConfirmReceiptRuleReqDto modifyReqDto) {
        this.checkRule(modifyReqDto);
        StrategyConfirmReceiptRuleEo stStrategyConfirmReceiptRuleEo = new StrategyConfirmReceiptRuleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)stStrategyConfirmReceiptRuleEo);
        this.strategyConfirmReceiptRuleDomain.updateSelective((BaseEo)stStrategyConfirmReceiptRuleEo);
        StrategyConfirmReceiptDetailEo deleteRelationEo = new StrategyConfirmReceiptDetailEo();
        deleteRelationEo.setRuleId(modifyReqDto.getId());
        this.strategyConfirmReceiptDetailDomain.delete((BaseEo)deleteRelationEo);
        ArrayList relationEoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getOrderTypeCodeList())) {
            modifyReqDto.getOrderTypeCodeList().forEach(orderTypeCode -> {
                StrategyConfirmReceiptDetailEo relationEo = new StrategyConfirmReceiptDetailEo();
                relationEo.setRuleId(stStrategyConfirmReceiptRuleEo.getId());
                relationEo.setOrderTypeCode(orderTypeCode);
                relationEoList.add(relationEo);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)relationEoList)) {
            this.strategyConfirmReceiptDetailDomain.insertBatch((List)relationEoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStrategyConfirmReceiptRule(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.strategyConfirmReceiptRuleDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void updateStatus(String ids, Integer status) {
        List idList = Arrays.asList(ids.split(",")).stream().collect(Collectors.toList());
        if (status == 1) {
            Long aLong = Long.valueOf((String)idList.get(0));
            DgStrategyConfirmReceiptRuleReqDto dgStrategyConfirmReceiptRuleReqDto = new DgStrategyConfirmReceiptRuleReqDto();
            dgStrategyConfirmReceiptRuleReqDto.setId(aLong);
            List dgStrategyConfirmReceiptRuleRespDtos = this.strategyConfirmReceiptRuleDomain.queryList(dgStrategyConfirmReceiptRuleReqDto);
            DgStrategyConfirmReceiptRuleRespDto dgStrategyConfirmReceiptRuleRespDto = (DgStrategyConfirmReceiptRuleRespDto)dgStrategyConfirmReceiptRuleRespDtos.get(0);
            String orderTypeCode = dgStrategyConfirmReceiptRuleRespDto.getOrderTypeCode();
            List orderTypeCodeList = Arrays.asList(orderTypeCode.split(",")).stream().collect(Collectors.toList());
            dgStrategyConfirmReceiptRuleReqDto.setOrderTypeCodeList(orderTypeCodeList);
            dgStrategyConfirmReceiptRuleReqDto.setRuleStatus(Integer.valueOf(1));
            dgStrategyConfirmReceiptRuleReqDto.setId(null);
            List verify = this.strategyConfirmReceiptRuleDomain.queryList(dgStrategyConfirmReceiptRuleReqDto);
            if (CollectionUtils.isNotEmpty((Collection)verify)) {
                throw new BizException("\u8be5\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728\u542f\u52a8\u7684\u7b56\u7565\uff0c\u8bf7\u6838\u5b9e");
            }
        }
        this.strategyConfirmReceiptRuleDomain.updateStatus(idList.stream().map(Long::valueOf).collect(Collectors.toList()), status);
    }

    @Override
    public DgStrategyConfirmReceiptRuleRespDto queryById(Long id) {
        DgStrategyConfirmReceiptRuleReqDto selectParam = new DgStrategyConfirmReceiptRuleReqDto();
        selectParam.setId(id);
        List dgStrategyConfirmReceiptRuleRespDtos = this.strategyConfirmReceiptRuleDomain.queryList(selectParam);
        if (CollectionUtils.isEmpty((Collection)dgStrategyConfirmReceiptRuleRespDtos)) {
            return null;
        }
        return (DgStrategyConfirmReceiptRuleRespDto)dgStrategyConfirmReceiptRuleRespDtos.get(0);
    }

    @Override
    public PageInfo<DgStrategyConfirmReceiptRuleRespDto> queryByPage(DgStrategyConfirmReceiptRuleReqDto reqDto, Integer pageNum, Integer pageSize) {
        return this.strategyConfirmReceiptRuleDomain.queryPage(reqDto, pageNum, pageSize);
    }

    @Override
    public List<DgStrategyConfirmReceiptRuleRespDto> queryByList(DgStrategyConfirmReceiptRuleReqDto reqDto) {
        return this.strategyConfirmReceiptRuleDomain.queryList(reqDto);
    }
}

