/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.order.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.vo.BaseVo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyConfItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyRuleSuitTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemSuitDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleSuitDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgCustomerAuditStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgCustomerAuditStrategyRuleRespDto;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleSuitEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemSuitEo;
import com.yunxi.dg.base.center.trade.service.order.strategy.IDgCustomerStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.order.strategy.impl.DgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateInUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgCustomerDgStrategyRuleServiceImpl
extends DgStrategyRuleServiceImpl
implements IDgCustomerStrategyRuleService,
IResetRedisNoIndexCommon {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgCustomerDgStrategyRuleServiceImpl.class);
    @Resource
    private NoGreateInUtil noGreateInUtil;
    @Resource
    private IDgPerformOrderExtDomain performOrderExtDomain;
    @Resource
    private IDgStrategyRuleDomain strategyRuleDas;
    @Resource
    private IDgStrategyRuleSuitDomain strategyRuleSuitDas;
    @Resource
    private IDgStrategyConfItemSuitDomain strategyConfItemSuitDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCustomerAuditStrategyRule(DgCustomerAuditStrategyRuleReqDto addReqDto) {
        if ((Objects.isNull(addReqDto.getPeriodicEnd()) || Objects.isNull(addReqDto.getPeriodicStart())) && addReqDto.getPlatForm().equals("2b")) {
            throw new BizException("\u5468\u671f\u5f00\u59cb\u65f6\u95f4\u548c\u5468\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DgStrategyRuleEo dgStrategyRuleEo = new DgStrategyRuleEo();
        CubeBeanUtils.copyProperties((Object)dgStrategyRuleEo, (Object)addReqDto, (String[])new String[0]);
        dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.generateCustomerRuleNo());
        dgStrategyRuleEo.setStrategyType(addReqDto.getStrategyType());
        this.strategyRuleDas.insert((BaseEo)dgStrategyRuleEo);
        this.popStrategyConfItems(addReqDto, dgStrategyRuleEo);
        ArrayList dgStrategyRuleSuitEoList = Lists.newArrayList();
        this.popStrategyRuleSuits(addReqDto, dgStrategyRuleEo, dgStrategyRuleSuitEoList);
        this.strategyRuleSuitDas.insertBatch((List)dgStrategyRuleSuitEoList);
        return dgStrategyRuleEo.getId();
    }

    private void popStrategyRuleSuits(DgCustomerAuditStrategyRuleReqDto addReqDto, DgStrategyRuleEo dgStrategyRuleEo, List<DgStrategyRuleSuitEo> dgStrategyRuleSuitEoList) {
        if (addReqDto.getPlatForm().equals("2c")) {
            DgCustomerAuditStrategyRuleReqDto.ApplyShop applyShop = addReqDto.getApplyShop();
            DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyShop, DgStrategyRuleSuitTypeEnum.SUITTYPE_SHOP.getCode(), addReqDto);
        } else {
            DgCustomerAuditStrategyRuleReqDto.ApplyOrderType applyOrderType = addReqDto.getApplyOrderType();
            DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyOrderType, DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_TYPE.getCode(), addReqDto);
            DgCustomerAuditStrategyRuleReqDto.ApplyChannel applyChannel = addReqDto.getApplyChannel();
            DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyChannel, DgStrategyRuleSuitTypeEnum.SUITTYPE_CHANNEL.getCode(), addReqDto);
            DgCustomerAuditStrategyRuleReqDto.ApplyClient applyClient = addReqDto.getApplyClient();
            DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyClient, DgStrategyRuleSuitTypeEnum.SUITTYPE_CLEINT.getCode(), addReqDto);
            DgCustomerAuditStrategyRuleReqDto.ApplyChannelWarehouse applyChannelWarehouse = addReqDto.getApplyChannelWarehouse();
            DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyChannelWarehouse, DgStrategyRuleSuitTypeEnum.SUITTYPE_CHANNEL_WAREHOUSE.getCode(), addReqDto);
            DgCustomerAuditStrategyRuleReqDto.ApplyOrg applyOrg = addReqDto.getApplyOrg();
            DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyOrg, DgStrategyRuleSuitTypeEnum.SUITTYPE_ORG.getCode(), addReqDto);
            DgCustomerAuditStrategyRuleReqDto.ApplyOrderLabel applyOrderLabel = addReqDto.getApplyOrderLabel();
            DgCustomerDgStrategyRuleServiceImpl.extractedAddRange(dgStrategyRuleEo, dgStrategyRuleSuitEoList, (DgCustomerAuditStrategyRuleReqDto.Apply)applyOrderLabel, DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_LABEL.getCode(), addReqDto);
        }
    }

    private static void extractedAddRange(DgStrategyRuleEo dgStrategyRuleEo, List<DgStrategyRuleSuitEo> dgStrategyRuleSuitEoList, DgCustomerAuditStrategyRuleReqDto.Apply apply, String suitType, DgCustomerAuditStrategyRuleReqDto addReqDto) {
        DgStrategyRuleSuitEo dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
        dgStrategyRuleSuitEo.setRuleId(dgStrategyRuleEo.getId());
        dgStrategyRuleSuitEo.setSuitType(suitType);
        dgStrategyRuleSuitEo.setStrategyType(addReqDto.getStrategyType());
        dgStrategyRuleSuitEo.setMd5(MD5Util.getMd5ByString((String)apply.getMD5Content()));
        if (StringUtils.equals((CharSequence)apply.getApplicableType(), (CharSequence)"ALL")) {
            dgStrategyRuleSuitEo.setSuitKey("ALL");
            dgStrategyRuleSuitEo.setSuitSelectType("ALL");
            dgStrategyRuleSuitEo.setSuitMatchCode(dgStrategyRuleSuitEo.getSuitType() + "_" + dgStrategyRuleSuitEo.getSuitSelectType() + "_" + dgStrategyRuleSuitEo.getSuitKey());
            dgStrategyRuleSuitEoList.add(dgStrategyRuleSuitEo);
        } else if (CollectionUtils.isNotEmpty((Collection)apply.getApplicableList())) {
            for (String shopCode : apply.getApplicableList()) {
                dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
                dgStrategyRuleSuitEo.setRuleId(dgStrategyRuleEo.getId());
                dgStrategyRuleSuitEo.setSuitType(suitType);
                dgStrategyRuleSuitEo.setStrategyType(addReqDto.getStrategyType());
                dgStrategyRuleSuitEo.setSuitKey(shopCode);
                dgStrategyRuleSuitEo.setSuitSelectType("SELECT");
                dgStrategyRuleSuitEo.setSuitMatchCode(dgStrategyRuleSuitEo.getSuitType() + "_" + dgStrategyRuleSuitEo.getSuitSelectType() + "_" + shopCode);
                dgStrategyRuleSuitEo.setMd5(MD5Util.getMd5ByString((String)apply.getMD5Content()));
                dgStrategyRuleSuitEoList.add(dgStrategyRuleSuitEo);
            }
        }
    }

    private void popStrategyConfItems(DgCustomerAuditStrategyRuleReqDto addReqDto, DgStrategyRuleEo dgStrategyRuleEo) {
        StrategyConfItemSuitEo confItemSuitEo;
        ArrayList confItemEoList = Lists.newArrayList();
        if (Objects.nonNull(addReqDto.getNeedlessPersonAudit())) {
            StrategyConfItemEo needlessPersonAuditConfEo = new StrategyConfItemEo();
            needlessPersonAuditConfEo.setRuleId(dgStrategyRuleEo.getId());
            needlessPersonAuditConfEo.setStrategyType(CisStrategyConfItemTypeEnum.NEEDLESS_PERSON_AUDIT.getCode());
            needlessPersonAuditConfEo.setStrategyTypeName(CisStrategyConfItemTypeEnum.NEEDLESS_PERSON_AUDIT.getDesc());
            needlessPersonAuditConfEo.setEnable(addReqDto.getNeedlessPersonAudit());
            needlessPersonAuditConfEo.setMd5(MD5Util.getMd5ByString((String)String.valueOf(addReqDto.getNeedlessPersonAudit())));
            confItemEoList.add(needlessPersonAuditConfEo);
        }
        if (Objects.nonNull(addReqDto.getDelayAudit())) {
            StrategyConfItemEo delayAuditConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)delayAuditConfEo, (Object)addReqDto.getDelayAudit(), (String[])new String[0]);
            delayAuditConfEo.setContent(addReqDto.getDelayAudit().getContent());
            delayAuditConfEo.setRuleId(dgStrategyRuleEo.getId());
            delayAuditConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getDelayAudit().getMD5Content()));
            confItemEoList.add(delayAuditConfEo);
        }
        if (Objects.nonNull(addReqDto.getAutoDistribution())) {
            StrategyConfItemEo autoDistributionEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)autoDistributionEo, (Object)addReqDto.getAutoDistribution(), (String[])new String[0]);
            autoDistributionEo.setContent(addReqDto.getAutoDistribution().getContent());
            autoDistributionEo.setRuleId(dgStrategyRuleEo.getId());
            autoDistributionEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getAutoDistribution().getMD5Content()));
            confItemEoList.add(autoDistributionEo);
        }
        if (Objects.nonNull(addReqDto.getSpecialAmount())) {
            StrategyConfItemEo specialAmountConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)specialAmountConfEo, (Object)addReqDto.getSpecialAmount(), (String[])new String[0]);
            specialAmountConfEo.setRuleId(dgStrategyRuleEo.getId());
            specialAmountConfEo.setContent(addReqDto.getSpecialAmount().getContent());
            specialAmountConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSpecialAmount().getMD5Content()));
            confItemEoList.add(specialAmountConfEo);
        }
        ArrayList strategyConfItemSuitEoList = Lists.newArrayList();
        if (Objects.nonNull(addReqDto.getSpecialWarehouse())) {
            List warehouseCodeList = addReqDto.getSpecialWarehouse().getWarehouseCodeList();
            StrategyConfItemEo specialWarehouseConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)specialWarehouseConfEo, (Object)addReqDto.getSpecialWarehouse(), (String[])new String[0]);
            specialWarehouseConfEo.setRuleId(dgStrategyRuleEo.getId());
            specialWarehouseConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSpecialWarehouse().getMD5Content()));
            confItemEoList.add(specialWarehouseConfEo);
            if (CollectionUtils.isNotEmpty((Collection)warehouseCodeList)) {
                for (String warehouseCode : warehouseCodeList) {
                    confItemSuitEo = new StrategyConfItemSuitEo();
                    confItemSuitEo.setRuleId(dgStrategyRuleEo.getId());
                    confItemSuitEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_WAREHOUSE.getCode());
                    confItemSuitEo.setSuitValue(warehouseCode);
                    confItemSuitEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_WAREHOUSE.getCode() + "_" + warehouseCode);
                    strategyConfItemSuitEoList.add(confItemSuitEo);
                }
            }
        }
        if (Objects.nonNull(addReqDto.getSpecialOrderType())) {
            List orderTypeCodeList = addReqDto.getSpecialOrderType().getOrderTypeCodeList();
            StrategyConfItemEo orderTypeCodeConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)orderTypeCodeConfEo, (Object)addReqDto.getSpecialOrderType(), (String[])new String[0]);
            orderTypeCodeConfEo.setRuleId(dgStrategyRuleEo.getId());
            orderTypeCodeConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSpecialOrderType().getMD5Content()));
            confItemEoList.add(orderTypeCodeConfEo);
            if (CollectionUtils.isNotEmpty((Collection)orderTypeCodeList)) {
                for (String orderTypeCode : orderTypeCodeList) {
                    confItemSuitEo = new StrategyConfItemSuitEo();
                    confItemSuitEo.setRuleId(dgStrategyRuleEo.getId());
                    confItemSuitEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode());
                    confItemSuitEo.setSuitValue(orderTypeCode);
                    confItemSuitEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode() + "_" + orderTypeCode);
                    strategyConfItemSuitEoList.add(confItemSuitEo);
                }
            }
        }
        if (Objects.nonNull(addReqDto.getSpecialLabel())) {
            List labelCodeList = addReqDto.getSpecialLabel().getLabelCodeList();
            StrategyConfItemEo labelConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)labelConfEo, (Object)addReqDto.getSpecialLabel(), (String[])new String[0]);
            labelConfEo.setRuleId(dgStrategyRuleEo.getId());
            labelConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSpecialLabel().getMD5Content()));
            confItemEoList.add(labelConfEo);
            if (CollectionUtils.isNotEmpty((Collection)labelCodeList)) {
                for (String label : labelCodeList) {
                    confItemSuitEo = new StrategyConfItemSuitEo();
                    confItemSuitEo.setRuleId(dgStrategyRuleEo.getId());
                    confItemSuitEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode());
                    confItemSuitEo.setSuitValue(label);
                    confItemSuitEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode() + "_" + label);
                    strategyConfItemSuitEoList.add(confItemSuitEo);
                }
            }
        }
        if (Objects.nonNull(addReqDto.getSpecialSku())) {
            List skuCodeList = addReqDto.getSpecialSku().getSkuCodeList();
            StrategyConfItemEo specialSkuConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)specialSkuConfEo, (Object)addReqDto.getSpecialSku(), (String[])new String[0]);
            specialSkuConfEo.setContent(Optional.ofNullable(addReqDto.getSpecialSku().getContent()).orElse(""));
            specialSkuConfEo.setRuleId(dgStrategyRuleEo.getId());
            specialSkuConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSpecialSku().getMD5Content()));
            confItemEoList.add(specialSkuConfEo);
            if (CollectionUtils.isNotEmpty((Collection)skuCodeList)) {
                for (String skuCode : skuCodeList) {
                    confItemSuitEo = new StrategyConfItemSuitEo();
                    confItemSuitEo.setRuleId(dgStrategyRuleEo.getId());
                    confItemSuitEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_SKU.getCode());
                    confItemSuitEo.setSuitValue(skuCode);
                    confItemSuitEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_SKU.getCode() + "_" + skuCode);
                    strategyConfItemSuitEoList.add(confItemSuitEo);
                }
            }
        }
        if (Objects.nonNull(addReqDto.getSpecialArea())) {
            List areaCodeList = addReqDto.getSpecialArea().getAreaCodeList();
            StrategyConfItemEo areaCodeConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)areaCodeConfEo, (Object)addReqDto.getSpecialArea(), (String[])new String[0]);
            areaCodeConfEo.setRuleId(dgStrategyRuleEo.getId());
            areaCodeConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSpecialArea().getMD5Content()));
            confItemEoList.add(areaCodeConfEo);
            if (CollectionUtils.isNotEmpty((Collection)areaCodeList)) {
                for (String areaCode : areaCodeList) {
                    confItemSuitEo = new StrategyConfItemSuitEo();
                    confItemSuitEo.setRuleId(dgStrategyRuleEo.getId());
                    confItemSuitEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_AREA.getCode());
                    confItemSuitEo.setSuitValue(areaCode);
                    confItemSuitEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_AREA.getCode() + "_" + areaCode);
                    strategyConfItemSuitEoList.add(confItemSuitEo);
                }
            }
        }
        if (Objects.nonNull(addReqDto.getSpecialCustomer())) {
            List customerCodeList = addReqDto.getSpecialCustomer().getCustomerCodeList();
            StrategyConfItemEo specialCustomerConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)specialCustomerConfEo, (Object)addReqDto.getSpecialCustomer(), (String[])new String[0]);
            specialCustomerConfEo.setRuleId(dgStrategyRuleEo.getId());
            specialCustomerConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSpecialCustomer().getMD5Content()));
            confItemEoList.add(specialCustomerConfEo);
            if (CollectionUtils.isNotEmpty((Collection)customerCodeList)) {
                for (String customerCode : customerCodeList) {
                    confItemSuitEo = new StrategyConfItemSuitEo();
                    confItemSuitEo.setRuleId(dgStrategyRuleEo.getId());
                    confItemSuitEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_CUSTOMER.getCode());
                    confItemSuitEo.setSuitValue(customerCode);
                    confItemSuitEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_CUSTOMER.getCode() + "_" + customerCode);
                    strategyConfItemSuitEoList.add(confItemSuitEo);
                }
            }
        }
        if (Objects.nonNull(addReqDto.getBuyerRemark())) {
            StrategyConfItemEo buyerRemarkConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)buyerRemarkConfEo, (Object)addReqDto.getBuyerRemark(), (String[])new String[0]);
            buyerRemarkConfEo.setRuleId(dgStrategyRuleEo.getId());
            buyerRemarkConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getBuyerRemark().getMD5Content()));
            confItemEoList.add(buyerRemarkConfEo);
        }
        if (Objects.nonNull(addReqDto.getSellerRemark())) {
            StrategyConfItemEo sellerRemarkConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)sellerRemarkConfEo, (Object)addReqDto.getSellerRemark(), (String[])new String[0]);
            sellerRemarkConfEo.setStrategyType(CisStrategyConfItemTypeEnum.SELLER_REMARK.getCode());
            sellerRemarkConfEo.setStrategyTypeName(CisStrategyConfItemTypeEnum.SELLER_REMARK.getDesc());
            sellerRemarkConfEo.setRuleId(dgStrategyRuleEo.getId());
            sellerRemarkConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSellerRemark().getMD5Content()));
            confItemEoList.add(sellerRemarkConfEo);
        }
        if (Objects.nonNull(addReqDto.getInternalRemark())) {
            StrategyConfItemEo internalRemarkConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)internalRemarkConfEo, (Object)addReqDto.getInternalRemark(), (String[])new String[0]);
            internalRemarkConfEo.setRuleId(dgStrategyRuleEo.getId());
            internalRemarkConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getInternalRemark().getMD5Content()));
            confItemEoList.add(internalRemarkConfEo);
        }
        if (Objects.nonNull(addReqDto.getSpecialPayTime())) {
            StrategyConfItemEo specialPayTimeConfEo = new StrategyConfItemEo();
            CubeBeanUtils.copyProperties((Object)specialPayTimeConfEo, (Object)addReqDto.getSpecialPayTime(), (String[])new String[0]);
            specialPayTimeConfEo.setRuleId(dgStrategyRuleEo.getId());
            specialPayTimeConfEo.setMd5(MD5Util.getMd5ByString((String)addReqDto.getSpecialPayTime().getMD5Content()));
            confItemEoList.add(specialPayTimeConfEo);
        }
        this.strategyConfItemDas.insertBatch((List)confItemEoList);
        this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
    }

    @Override
    public void modifyCustomerAuditStrategyRule(DgCustomerAuditStrategyRuleReqDto modifyReqDto) {
        AssertUtils.notNull((Object)modifyReqDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        DgStrategyRuleEo newDgStrategyRuleEo = new DgStrategyRuleEo();
        CubeBeanUtils.copyProperties((Object)newDgStrategyRuleEo, (Object)modifyReqDto, (String[])new String[0]);
        this.strategyRuleDas.updateSelective((BaseEo)newDgStrategyRuleEo);
        this.modifyStrategyConfItems(modifyReqDto);
        this.extractedModifyRange(modifyReqDto);
    }

    private void extractedModifyRange(DgCustomerAuditStrategyRuleReqDto modifyReqDto) {
        if (modifyReqDto.getPlatForm().equals("2c")) {
            DgCustomerAuditStrategyRuleReqDto.ApplyShop applyShop = modifyReqDto.getApplyShop();
            this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyShop, DgStrategyRuleSuitTypeEnum.SUITTYPE_SHOP.getCode());
        } else {
            if (Objects.nonNull(modifyReqDto.getApplyChannel())) {
                DgCustomerAuditStrategyRuleReqDto.ApplyChannel applyChannel = modifyReqDto.getApplyChannel();
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyChannel, DgStrategyRuleSuitTypeEnum.SUITTYPE_CHANNEL.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyOrderType())) {
                DgCustomerAuditStrategyRuleReqDto.ApplyOrderType applyOrderType = modifyReqDto.getApplyOrderType();
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyOrderType, DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_TYPE.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyClient())) {
                DgCustomerAuditStrategyRuleReqDto.ApplyClient applyClient = modifyReqDto.getApplyClient();
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyClient, DgStrategyRuleSuitTypeEnum.SUITTYPE_CLEINT.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyChannelWarehouse())) {
                DgCustomerAuditStrategyRuleReqDto.ApplyChannelWarehouse applyChannelWarehouse = modifyReqDto.getApplyChannelWarehouse();
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyChannelWarehouse, DgStrategyRuleSuitTypeEnum.SUITTYPE_CHANNEL_WAREHOUSE.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyOrderLabel())) {
                DgCustomerAuditStrategyRuleReqDto.ApplyOrderLabel applyOrderLabel = modifyReqDto.getApplyOrderLabel();
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyOrderLabel, DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_LABEL.getCode());
            }
            if (Objects.nonNull(modifyReqDto.getApplyOrg())) {
                DgCustomerAuditStrategyRuleReqDto.ApplyOrg applyOrg = modifyReqDto.getApplyOrg();
                this.extractedModifyRange(modifyReqDto, (DgCustomerAuditStrategyRuleReqDto.Apply)applyOrg, DgStrategyRuleSuitTypeEnum.SUITTYPE_ORG.getCode());
            }
        }
    }

    private void extractedModifyRange(DgCustomerAuditStrategyRuleReqDto modifyReqDto, DgCustomerAuditStrategyRuleReqDto.Apply apply, String suitType) {
        DgStrategyRuleSuitEo deleteEo = new DgStrategyRuleSuitEo();
        deleteEo.setRuleId(modifyReqDto.getId());
        deleteEo.setSuitType(suitType);
        this.strategyRuleSuitDas.logicDeleteByExample(deleteEo);
        ArrayList dgStrategyRuleSuitEoList = Lists.newArrayList();
        DgStrategyRuleSuitEo dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
        dgStrategyRuleSuitEo.setRuleId(modifyReqDto.getId());
        dgStrategyRuleSuitEo.setSuitType(suitType);
        dgStrategyRuleSuitEo.setStrategyType(modifyReqDto.getStrategyType());
        dgStrategyRuleSuitEo.setMd5(MD5Util.getMd5ByString((String)apply.getMD5Content()));
        if (StringUtils.equals((CharSequence)apply.getApplicableType(), (CharSequence)"ALL")) {
            dgStrategyRuleSuitEo.setSuitKey("ALL");
            dgStrategyRuleSuitEo.setSuitSelectType("ALL");
            dgStrategyRuleSuitEo.setSuitMatchCode(dgStrategyRuleSuitEo.getSuitType() + "_" + dgStrategyRuleSuitEo.getSuitSelectType() + "_" + dgStrategyRuleSuitEo.getSuitKey());
            dgStrategyRuleSuitEoList.add(dgStrategyRuleSuitEo);
        } else if (CollectionUtils.isNotEmpty((Collection)apply.getApplicableList())) {
            for (String shopCode : apply.getApplicableList()) {
                dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
                dgStrategyRuleSuitEo.setRuleId(modifyReqDto.getId());
                dgStrategyRuleSuitEo.setSuitType(suitType);
                dgStrategyRuleSuitEo.setStrategyType(modifyReqDto.getStrategyType());
                dgStrategyRuleSuitEo.setSuitKey(shopCode);
                dgStrategyRuleSuitEo.setSuitSelectType("SELECT");
                dgStrategyRuleSuitEo.setSuitMatchCode(dgStrategyRuleSuitEo.getSuitType() + "_" + dgStrategyRuleSuitEo.getSuitSelectType() + "_" + shopCode);
                dgStrategyRuleSuitEo.setMd5(MD5Util.getMd5ByString((String)apply.getMD5Content()));
                dgStrategyRuleSuitEoList.add(dgStrategyRuleSuitEo);
            }
        }
        this.strategyRuleSuitDas.insertBatch((List)dgStrategyRuleSuitEoList);
    }

    private void modifyStrategyConfItems(DgCustomerAuditStrategyRuleReqDto modifyReqDto) {
        String specialPayTimeMd5;
        StrategyConfItemEo updateInternalRemarkConfEo;
        StrategyConfItemEo updateSpecialSkuConfEo;
        StrategyConfItemSuitEo confItemSuitEo;
        ArrayList strategyConfItemSuitEoList;
        StrategyConfItemSuitEo deleteEo;
        LambdaQueryWrapper queryStrategyConfItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getRuleId, (Object)modifyReqDto.getId());
        List strategyConfItemEoList = this.strategyConfItemDas.list(queryStrategyConfItemEo);
        Map groupStrategyMap = strategyConfItemEoList.stream().collect(Collectors.toMap(StrategyConfItemEo::getStrategyType, Function.identity(), (v1, v2) -> v2));
        if (Objects.nonNull(modifyReqDto.getNeedlessPersonAudit())) {
            StrategyConfItemEo needlessPersonAudit = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.NEEDLESS_PERSON_AUDIT.getCode());
            String needlessPersonAuditMd5 = MD5Util.getMd5ByString((String)String.valueOf(modifyReqDto.getNeedlessPersonAudit()));
            if (needlessPersonAudit != null && !StringUtils.equals((CharSequence)needlessPersonAudit.getMd5(), (CharSequence)needlessPersonAuditMd5)) {
                LOGGER.info("\u3010\u4fee\u6539\u5ba2\u5ba1\u7b56\u7565\u3011\u8ba2\u5355\u5747\u4e0d\u505a\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)modifyReqDto.getNeedlessPersonAudit());
                StrategyConfItemEo updateNeedlessPersonAuditConfEo = new StrategyConfItemEo();
                updateNeedlessPersonAuditConfEo.setId(needlessPersonAudit.getId());
                updateNeedlessPersonAuditConfEo.setEnable(modifyReqDto.getNeedlessPersonAudit());
                updateNeedlessPersonAuditConfEo.setMd5(needlessPersonAuditMd5);
                this.strategyConfItemDas.updateSelective((BaseEo)updateNeedlessPersonAuditConfEo);
            }
            if (null == needlessPersonAudit) {
                StrategyConfItemEo needlessPersonAuditConfEo = new StrategyConfItemEo();
                needlessPersonAuditConfEo.setRuleId(modifyReqDto.getId());
                needlessPersonAuditConfEo.setStrategyType(CisStrategyConfItemTypeEnum.NEEDLESS_PERSON_AUDIT.getCode());
                needlessPersonAuditConfEo.setStrategyTypeName(CisStrategyConfItemTypeEnum.NEEDLESS_PERSON_AUDIT.getDesc());
                needlessPersonAuditConfEo.setEnable(modifyReqDto.getNeedlessPersonAudit());
                needlessPersonAuditConfEo.setMd5(MD5Util.getMd5ByString((String)String.valueOf(modifyReqDto.getNeedlessPersonAudit())));
                this.strategyConfItemDas.insert((BaseEo)needlessPersonAuditConfEo);
            }
        }
        if (Objects.nonNull(modifyReqDto.getDelayAudit())) {
            String delayAuditMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getDelayAudit().getMD5Content());
            StrategyConfItemEo delayAudit = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.DELAY_AUDIT.getCode());
            if (delayAudit != null && !StringUtils.equals((CharSequence)delayAudit.getMd5(), (CharSequence)delayAuditMd5)) {
                LOGGER.info("\u3010\u4fee\u6539\u5ba2\u5ba1\u7b56\u7565\u3011\u5ef6\u65f6\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getDelayAudit()));
                StrategyConfItemEo updateDelayAuditConfEo = new StrategyConfItemEo();
                updateDelayAuditConfEo.setId(delayAudit.getId());
                updateDelayAuditConfEo.setEnable(modifyReqDto.getDelayAudit().getEnable());
                updateDelayAuditConfEo.setContent(StringUtils.isNotBlank((CharSequence)modifyReqDto.getDelayAudit().getContent()) ? modifyReqDto.getDelayAudit().getContent() : " ");
                updateDelayAuditConfEo.setMd5(delayAuditMd5);
                this.strategyConfItemDas.updateSelective((BaseEo)updateDelayAuditConfEo);
            }
            if (null == delayAudit) {
                StrategyConfItemEo delayAuditConfEo = new StrategyConfItemEo();
                delayAuditConfEo.setRuleId(modifyReqDto.getId());
                delayAuditConfEo.setStrategyType(CisStrategyConfItemTypeEnum.DELAY_AUDIT.getCode());
                delayAuditConfEo.setStrategyTypeName(CisStrategyConfItemTypeEnum.DELAY_AUDIT.getDesc());
                delayAuditConfEo.setEnable(modifyReqDto.getDelayAudit().getEnable());
                delayAuditConfEo.setContent(StringUtils.isNotBlank((CharSequence)modifyReqDto.getDelayAudit().getContent()) ? modifyReqDto.getDelayAudit().getContent() : " ");
                delayAuditConfEo.setMd5(delayAuditMd5);
                this.strategyConfItemDas.insert((BaseEo)delayAuditConfEo);
            }
        }
        if (Objects.nonNull(modifyReqDto.getSpecialAmount())) {
            String specialAmountMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getSpecialAmount().getMD5Content());
            StrategyConfItemEo specialAmount = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.SPECIAL_AMOUNT.getCode());
            if (specialAmount != null && !StringUtils.equals((CharSequence)specialAmount.getMd5(), (CharSequence)specialAmountMd5)) {
                LOGGER.info("\u3010\u4fee\u6539\u5ba2\u5ba1\u7b56\u7565\u3011\u6307\u5b9a\u91d1\u989d\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSpecialAmount()));
                StrategyConfItemEo updateSpecialAmountConfEo = new StrategyConfItemEo();
                updateSpecialAmountConfEo.setId(specialAmount.getId());
                updateSpecialAmountConfEo.setEnable(modifyReqDto.getSpecialAmount().getEnable());
                updateSpecialAmountConfEo.setContent(modifyReqDto.getSpecialAmount().getContent());
                updateSpecialAmountConfEo.setMd5(specialAmountMd5);
                this.strategyConfItemDas.updateSelective((BaseEo)updateSpecialAmountConfEo);
            }
            if (null == specialAmount) {
                StrategyConfItemEo specialAmountConfEo = new StrategyConfItemEo();
                CubeBeanUtils.copyProperties((Object)specialAmountConfEo, (Object)modifyReqDto.getSpecialAmount(), (String[])new String[0]);
                specialAmountConfEo.setRuleId(modifyReqDto.getId());
                specialAmountConfEo.setContent(modifyReqDto.getSpecialAmount().getContent());
                specialAmountConfEo.setMd5(MD5Util.getMd5ByString((String)modifyReqDto.getSpecialAmount().getMD5Content()));
                this.strategyConfItemDas.insert((BaseEo)specialAmountConfEo);
            }
        }
        if (Objects.nonNull(modifyReqDto.getSpecialWarehouse())) {
            String specialWarehouseMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getSpecialWarehouse().getMD5Content());
            StrategyConfItemEo specialWarehouse = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.SPECIAL_WAREHOUSE.getCode());
            if (specialWarehouse != null && !StringUtils.equals((CharSequence)specialWarehouse.getMd5(), (CharSequence)specialWarehouseMd5)) {
                LOGGER.info("\u3010\u4fee\u6539\u5ba2\u5ba1\u7b56\u7565\u3011\u6307\u5b9a\u903b\u8f91\u4ed3\u4eba\u5de5\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSpecialWarehouse()));
                StrategyConfItemEo updateSpecialWarehouseConfEo = new StrategyConfItemEo();
                updateSpecialWarehouseConfEo.setId(specialWarehouse.getId());
                updateSpecialWarehouseConfEo.setEnable(modifyReqDto.getSpecialWarehouse().getEnable());
                updateSpecialWarehouseConfEo.setMd5(specialWarehouseMd5);
                this.strategyConfItemDas.updateSelective((BaseEo)updateSpecialWarehouseConfEo);
                deleteEo = new StrategyConfItemSuitEo();
                deleteEo.setRuleId(modifyReqDto.getId());
                deleteEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_WAREHOUSE.getCode());
                this.strategyConfItemSuitDas.logicDeleteByExample(deleteEo);
                if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getSpecialWarehouse().getWarehouseCodeList())) {
                    strategyConfItemSuitEoList = Lists.newArrayList();
                    for (String warehouseCode : modifyReqDto.getSpecialWarehouse().getWarehouseCodeList()) {
                        confItemSuitEo = new StrategyConfItemSuitEo();
                        confItemSuitEo.setRuleId(modifyReqDto.getId());
                        confItemSuitEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_WAREHOUSE.getCode());
                        confItemSuitEo.setSuitValue(warehouseCode);
                        confItemSuitEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_WAREHOUSE.getCode() + "_" + warehouseCode);
                        strategyConfItemSuitEoList.add(confItemSuitEo);
                    }
                    this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
                }
            }
        }
        if (Objects.nonNull(modifyReqDto.getSpecialOrderType())) {
            String specialOrderTypeMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getSpecialOrderType().getMD5Content());
            StrategyConfItemEo specialOrderType = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode());
            if (specialOrderType != null && !StringUtils.equals((CharSequence)specialOrderType.getMd5(), (CharSequence)specialOrderTypeMd5)) {
                LOGGER.info("\u3010\u4fee\u6539\u5ba2\u5ba1\u7b56\u7565\u3011\u6307\u5b9a\u8ba2\u5355\u7c7b\u578b\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSpecialOrderType()));
                updateSpecialSkuConfEo = new StrategyConfItemEo();
                updateSpecialSkuConfEo.setId(specialOrderType.getId());
                updateSpecialSkuConfEo.setEnable(modifyReqDto.getSpecialOrderType().getEnable());
                updateSpecialSkuConfEo.setMd5(specialOrderTypeMd5);
                this.strategyConfItemDas.updateSelective((BaseEo)updateSpecialSkuConfEo);
                deleteEo = new StrategyConfItemSuitEo();
                deleteEo.setRuleId(modifyReqDto.getId());
                deleteEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode());
                this.strategyConfItemSuitDas.logicDeleteByExample(deleteEo);
                if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getSpecialOrderType().getOrderTypeCodeList())) {
                    strategyConfItemSuitEoList = Lists.newArrayList();
                    for (String orderTypeCode : modifyReqDto.getSpecialOrderType().getOrderTypeCodeList()) {
                        confItemSuitEo = new StrategyConfItemSuitEo();
                        confItemSuitEo.setRuleId(modifyReqDto.getId());
                        confItemSuitEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode());
                        confItemSuitEo.setSuitValue(orderTypeCode);
                        confItemSuitEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode() + "_" + orderTypeCode);
                        strategyConfItemSuitEoList.add(confItemSuitEo);
                    }
                    this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
                }
            }
        }
        if (Objects.nonNull(modifyReqDto.getSpecialLabel())) {
            String specialLabelMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getSpecialLabel().getMD5Content());
            StrategyConfItemEo specialLabel = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode());
            if (specialLabel != null && !StringUtils.equals((CharSequence)specialLabel.getMd5(), (CharSequence)specialLabelMd5)) {
                LOGGER.info("\u3010\u4fee\u6539\u5ba2\u5ba1\u7b56\u7565\u3011\u6307\u5b9a\u6807\u7b7e\u7c7b\u578b\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSpecialLabel()));
                updateSpecialSkuConfEo = new StrategyConfItemEo();
                updateSpecialSkuConfEo.setId(specialLabel.getId());
                updateSpecialSkuConfEo.setEnable(modifyReqDto.getSpecialLabel().getEnable());
                updateSpecialSkuConfEo.setMd5(specialLabelMd5);
                this.strategyConfItemDas.updateSelective((BaseEo)updateSpecialSkuConfEo);
                deleteEo = new StrategyConfItemSuitEo();
                deleteEo.setRuleId(modifyReqDto.getId());
                deleteEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode());
                this.strategyConfItemSuitDas.logicDeleteByExample(deleteEo);
                if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getSpecialLabel().getLabelCodeList())) {
                    strategyConfItemSuitEoList = Lists.newArrayList();
                    for (String labelCode : modifyReqDto.getSpecialLabel().getLabelCodeList()) {
                        confItemSuitEo = new StrategyConfItemSuitEo();
                        confItemSuitEo.setRuleId(modifyReqDto.getId());
                        confItemSuitEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode());
                        confItemSuitEo.setSuitValue(labelCode);
                        confItemSuitEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode() + "_" + labelCode);
                        strategyConfItemSuitEoList.add(confItemSuitEo);
                    }
                    this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
                }
            }
        }
        if (Objects.nonNull(modifyReqDto.getSpecialSku())) {
            String specialSkuMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getSpecialSku().getMD5Content());
            StrategyConfItemEo specialSku = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.SPECIAL_SKU.getCode());
            if (specialSku != null && !StringUtils.equals((CharSequence)specialSku.getMd5(), (CharSequence)specialSkuMd5)) {
                LOGGER.info("\u3010\u4fee\u6539\u5ba2\u5ba1\u7b56\u7565\u3011\u6307\u5b9asku\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSpecialSku()));
                updateSpecialSkuConfEo = new StrategyConfItemEo();
                updateSpecialSkuConfEo.setId(specialSku.getId());
                updateSpecialSkuConfEo.setContent(modifyReqDto.getSpecialSku().getContent());
                updateSpecialSkuConfEo.setEnable(modifyReqDto.getSpecialSku().getEnable());
                updateSpecialSkuConfEo.setMd5(specialSkuMd5);
                this.strategyConfItemDas.updateSelective((BaseEo)updateSpecialSkuConfEo);
                deleteEo = new StrategyConfItemSuitEo();
                deleteEo.setRuleId(modifyReqDto.getId());
                deleteEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_SKU.getCode());
                this.strategyConfItemSuitDas.logicDeleteByExample(deleteEo);
                if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getSpecialSku().getSkuCodeList())) {
                    strategyConfItemSuitEoList = Lists.newArrayList();
                    for (String skuCode : modifyReqDto.getSpecialSku().getSkuCodeList()) {
                        confItemSuitEo = new StrategyConfItemSuitEo();
                        confItemSuitEo.setRuleId(modifyReqDto.getId());
                        confItemSuitEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_SKU.getCode());
                        confItemSuitEo.setSuitValue(skuCode);
                        confItemSuitEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_SKU.getCode() + "_" + skuCode);
                        strategyConfItemSuitEoList.add(confItemSuitEo);
                    }
                    this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
                }
            }
        }
        if (Objects.nonNull(modifyReqDto.getSpecialCustomer())) {
            String specialCustomerMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getSpecialCustomer().getMD5Content());
            StrategyConfItemEo specialCustomer = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.SPECIAL_CUSTOMER.getCode());
            if (specialCustomer != null && !StringUtils.equals((CharSequence)specialCustomer.getMd5(), (CharSequence)specialCustomerMd5)) {
                LOGGER.info("\u3010\u4fee\u6539\u5ba2\u5ba1\u7b56\u7565\u3011\u6307\u5b9a\u5ba2\u6237\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSpecialCustomer()));
                StrategyConfItemEo updateCustomerConfEo = new StrategyConfItemEo();
                updateCustomerConfEo.setId(specialCustomer.getId());
                updateCustomerConfEo.setContent(modifyReqDto.getSpecialCustomer().getContent());
                updateCustomerConfEo.setEnable(modifyReqDto.getSpecialCustomer().getEnable());
                updateCustomerConfEo.setMd5(specialCustomerMd5);
                this.strategyConfItemDas.updateSelective((BaseEo)updateCustomerConfEo);
                deleteEo = new StrategyConfItemSuitEo();
                deleteEo.setRuleId(modifyReqDto.getId());
                deleteEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_CUSTOMER.getCode());
                this.strategyConfItemSuitDas.logicDeleteByExample(deleteEo);
                if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getSpecialCustomer().getCustomerCodeList())) {
                    strategyConfItemSuitEoList = Lists.newArrayList();
                    for (String customerCode : modifyReqDto.getSpecialCustomer().getCustomerCodeList()) {
                        StrategyConfItemSuitEo confCustomerEo = new StrategyConfItemSuitEo();
                        confCustomerEo.setRuleId(modifyReqDto.getId());
                        confCustomerEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_CUSTOMER.getCode());
                        confCustomerEo.setSuitValue(customerCode);
                        confCustomerEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_CUSTOMER.getCode() + "_" + customerCode);
                        strategyConfItemSuitEoList.add(confCustomerEo);
                    }
                    this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
                }
            }
        }
        if (Objects.nonNull(modifyReqDto.getSpecialArea())) {
            String specialAreaMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getSpecialArea().getMD5Content());
            StrategyConfItemEo specialArea = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.SPECIAL_AREA.getCode());
            if (specialArea != null && !StringUtils.equals((CharSequence)specialArea.getMd5(), (CharSequence)specialAreaMd5)) {
                LOGGER.info("\u3010\u4fee\u6539\u5ba2\u5ba1\u7b56\u7565\u3011\u6307\u5b9a\u533a\u57df\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSpecialArea()));
                StrategyConfItemEo updateSpecialAreaConfEo = new StrategyConfItemEo();
                updateSpecialAreaConfEo.setId(specialArea.getId());
                updateSpecialAreaConfEo.setEnable(modifyReqDto.getSpecialArea().getEnable());
                updateSpecialAreaConfEo.setMd5(specialAreaMd5);
                this.strategyConfItemDas.updateSelective((BaseEo)updateSpecialAreaConfEo);
                deleteEo = new StrategyConfItemSuitEo();
                deleteEo.setRuleId(modifyReqDto.getId());
                deleteEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_AREA.getCode());
                this.strategyConfItemSuitDas.logicDeleteByExample(deleteEo);
                if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getSpecialArea().getAreaCodeList())) {
                    strategyConfItemSuitEoList = Lists.newArrayList();
                    for (String areaCode : modifyReqDto.getSpecialArea().getAreaCodeList()) {
                        confItemSuitEo = new StrategyConfItemSuitEo();
                        confItemSuitEo.setRuleId(modifyReqDto.getId());
                        confItemSuitEo.setSuitType(CisStrategyConfItemTypeEnum.SPECIAL_AREA.getCode());
                        confItemSuitEo.setSuitValue(areaCode);
                        confItemSuitEo.setSuitMatchCode(CisStrategyConfItemTypeEnum.SPECIAL_AREA.getCode() + "_" + areaCode);
                        strategyConfItemSuitEoList.add(confItemSuitEo);
                    }
                    this.strategyConfItemSuitDas.insertBatch((List)strategyConfItemSuitEoList);
                }
            }
        }
        if (Objects.nonNull(modifyReqDto.getBuyerRemark())) {
            String buyerRemarkMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getBuyerRemark().getMD5Content());
            StrategyConfItemEo buyerRemark = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.BUYER_REMARK.getCode());
            if (buyerRemark != null && !StringUtils.equals((CharSequence)buyerRemark.getMd5(), (CharSequence)buyerRemarkMd5)) {
                LOGGER.info("\u3010\u4fee\u6539\u5ba2\u5ba1\u7b56\u7565\u3011\u4e70\u5bb6\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getBuyerRemark()));
                StrategyConfItemEo updateBuyerRemarkConfEo = new StrategyConfItemEo();
                updateBuyerRemarkConfEo.setId(buyerRemark.getId());
                updateBuyerRemarkConfEo.setEnable(modifyReqDto.getBuyerRemark().getEnable());
                updateBuyerRemarkConfEo.setContent(modifyReqDto.getBuyerRemark().getContent());
                updateBuyerRemarkConfEo.setMd5(buyerRemarkMd5);
                this.strategyConfItemDas.updateSelective((BaseEo)updateBuyerRemarkConfEo);
            }
        }
        if (Objects.nonNull(modifyReqDto.getSellerRemark())) {
            String sellerRemarkMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getSellerRemark().getMD5Content());
            StrategyConfItemEo sellerRemark = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.SELLER_REMARK.getCode());
            if (sellerRemark != null && !StringUtils.equals((CharSequence)sellerRemark.getMd5(), (CharSequence)sellerRemarkMd5)) {
                LOGGER.info("\u3010\u4fee\u6539\u5ba2\u5ba1\u7b56\u7565\u3011\u5356\u5bb6\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSellerRemark()));
                StrategyConfItemEo updateSellerRemarkConfEo = new StrategyConfItemEo();
                updateSellerRemarkConfEo.setId(sellerRemark.getId());
                updateSellerRemarkConfEo.setEnable(modifyReqDto.getSellerRemark().getEnable());
                updateSellerRemarkConfEo.setContent(modifyReqDto.getSellerRemark().getContent());
                updateSellerRemarkConfEo.setMd5(sellerRemarkMd5);
                this.strategyConfItemDas.updateSelective((BaseEo)updateSellerRemarkConfEo);
            }
        }
        if (Objects.nonNull(modifyReqDto.getInternalRemark())) {
            String internalRemarkMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getInternalRemark().getMD5Content());
            StrategyConfItemEo internalRemark = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.INTERNAL_REMARK.getCode());
            if (internalRemark != null && !StringUtils.equals((CharSequence)internalRemark.getMd5(), (CharSequence)internalRemarkMd5)) {
                LOGGER.info("\u3010\u4fee\u6539\u5ba2\u5ba1\u7b56\u7565\u3011\u5185\u90e8\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getInternalRemark()));
                updateInternalRemarkConfEo = new StrategyConfItemEo();
                updateInternalRemarkConfEo.setId(internalRemark.getId());
                updateInternalRemarkConfEo.setEnable(modifyReqDto.getInternalRemark().getEnable());
                updateInternalRemarkConfEo.setContent(modifyReqDto.getInternalRemark().getContent());
                updateInternalRemarkConfEo.setMd5(internalRemarkMd5);
                this.strategyConfItemDas.updateSelective((BaseEo)updateInternalRemarkConfEo);
            }
        }
        if (Objects.nonNull(modifyReqDto.getSpecialPayTime())) {
            specialPayTimeMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getSpecialPayTime().getMD5Content());
            StrategyConfItemEo specialPayTime = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.SPECIAL_PAYTIME.getCode());
            if (specialPayTime != null && !StringUtils.equals((CharSequence)specialPayTime.getMd5(), (CharSequence)specialPayTimeMd5)) {
                LOGGER.info("\u3010\u4fee\u6539\u5ba2\u5ba1\u7b56\u7565\u3011\u5356\u5bb6\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSpecialPayTime()));
                updateInternalRemarkConfEo = new StrategyConfItemEo();
                updateInternalRemarkConfEo.setId(specialPayTime.getId());
                updateInternalRemarkConfEo.setEnable(modifyReqDto.getSpecialPayTime().getEnable());
                updateInternalRemarkConfEo.setContent(modifyReqDto.getSpecialPayTime().getContent());
                updateInternalRemarkConfEo.setMd5(specialPayTimeMd5);
                this.strategyConfItemDas.updateSelective((BaseEo)updateInternalRemarkConfEo);
            }
        }
        if (Objects.nonNull(modifyReqDto.getAutoDistribution())) {
            specialPayTimeMd5 = MD5Util.getMd5ByString((String)modifyReqDto.getAutoDistribution().getMD5Content());
            StrategyConfItemEo specialAutoDistribution = (StrategyConfItemEo)groupStrategyMap.get(CisStrategyConfItemTypeEnum.AUTO_DISTRIBUTION.getCode());
            if (specialAutoDistribution != null && !StringUtils.equals((CharSequence)specialAutoDistribution.getMd5(), (CharSequence)specialPayTimeMd5)) {
                LOGGER.info("\u3010\u4fee\u6539\u5ba2\u5ba1\u7b56\u7565\u3011\u5356\u5bb6\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838\u6709\u4fee\u6539\uff0c\u6700\u65b0\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSpecialPayTime()));
                updateInternalRemarkConfEo = new StrategyConfItemEo();
                updateInternalRemarkConfEo.setId(specialAutoDistribution.getId());
                updateInternalRemarkConfEo.setEnable(modifyReqDto.getAutoDistribution().getEnable());
                updateInternalRemarkConfEo.setContent(modifyReqDto.getAutoDistribution().getContent());
                updateInternalRemarkConfEo.setMd5(specialPayTimeMd5);
                this.strategyConfItemDas.updateSelective((BaseEo)updateInternalRemarkConfEo);
            }
        }
    }

    @Override
    public DgCustomerAuditStrategyRuleRespDto queryCustomerAuditStrategyById(Long id) {
        LambdaQueryWrapper queryStrategyRuleEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyRuleEo.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)id);
        DgStrategyRuleEo dgStrategyRuleEo = this.strategyRuleDas.getOne(queryStrategyRuleEo);
        AssertUtils.notNull((Object)dgStrategyRuleEo, (String)"\u7b56\u7565\u4e0d\u5b58\u5728");
        DgCustomerAuditStrategyRuleRespDto strategyRuleRespDto = new DgCustomerAuditStrategyRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)dgStrategyRuleEo, (BaseVo)strategyRuleRespDto);
        this.getStrategyConfItems(id, strategyRuleRespDto);
        LambdaQueryWrapper queryStrategyRuleSuitEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyRuleSuitEo.eq(BaseEo::getDr, (Object)0)).eq(DgStrategyRuleSuitEo::getRuleId, (Object)id);
        List strategyRuleSuitList = this.strategyRuleSuitDas.list(queryStrategyRuleSuitEo);
        strategyRuleSuitList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getSuitType())).collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getSuitType)).forEach((k, v) -> {
            DgStrategyRuleSuitTypeEnum dgStrategyRuleSuitTypeEnum = DgStrategyRuleSuitTypeEnum.forCode((String)k);
            switch (dgStrategyRuleSuitTypeEnum) {
                case SUITTYPE_SHOP: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyShop applyShop = new DgCustomerAuditStrategyRuleRespDto.ApplyShop();
                    DgStrategyRuleSuitEo dgStrategyRuleSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)applyShop);
                    strategyRuleRespDto.setApplyShop(applyShop);
                    break;
                }
                case SUITTYPE_CHANNEL: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyChannel applyChannel = new DgCustomerAuditStrategyRuleRespDto.ApplyChannel();
                    DgStrategyRuleSuitEo dgStrategyRuleChannelSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleChannelSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)applyChannel);
                    strategyRuleRespDto.setApplyChannel(applyChannel);
                    break;
                }
                case SUITTYPE_CHANNEL_WAREHOUSE: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyChannelWarehouse applyChannelWarehouse = new DgCustomerAuditStrategyRuleRespDto.ApplyChannelWarehouse();
                    DgStrategyRuleSuitEo dgStrategyRuleChannelWarehouseSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleChannelWarehouseSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)applyChannelWarehouse);
                    strategyRuleRespDto.setApplyChannelWarehouse(applyChannelWarehouse);
                    break;
                }
                case SUITTYPE_ORDER_TYPE: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyOrderType applyOrderType = new DgCustomerAuditStrategyRuleRespDto.ApplyOrderType();
                    DgStrategyRuleSuitEo dgStrategyRuleOrderTypeSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleOrderTypeSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)applyOrderType);
                    strategyRuleRespDto.setApplyOrderType(applyOrderType);
                    break;
                }
                case SUITTYPE_CLEINT: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyClient applyClient = new DgCustomerAuditStrategyRuleRespDto.ApplyClient();
                    DgStrategyRuleSuitEo dgStrategyClientRuleSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyClientRuleSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)applyClient);
                    strategyRuleRespDto.setApplyClient(applyClient);
                    break;
                }
                case SUITTYPE_ORDER_LABEL: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyOrderLabel applyOrderLabel = new DgCustomerAuditStrategyRuleRespDto.ApplyOrderLabel();
                    DgStrategyRuleSuitEo dgStrategyRuleOrderLabelSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleOrderLabelSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)applyOrderLabel);
                    strategyRuleRespDto.setApplyOrderLabel(applyOrderLabel);
                    break;
                }
                case SUITTYPE_ORG: {
                    DgCustomerAuditStrategyRuleRespDto.ApplyOrg applyOrg = new DgCustomerAuditStrategyRuleRespDto.ApplyOrg();
                    DgStrategyRuleSuitEo dgStrategyRuleOrgSuitEo = (DgStrategyRuleSuitEo)v.get(0);
                    this.extractedAttributeAssignment((List<DgStrategyRuleSuitEo>)v, dgStrategyRuleOrgSuitEo, (DgCustomerAuditStrategyRuleRespDto.Apply)applyOrg);
                    strategyRuleRespDto.setApplyOrg(applyOrg);
                    break;
                }
            }
        });
        return strategyRuleRespDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DgStrategyRuleServiceImpl.MatchStrategyResult matchOrderStrtegyOfCustomer(Long orderId) {
        DgStrategyRuleServiceImpl.MatchStrategyResult matchStrategyResult = null;
        try {
            AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
            DgPerformOrderRespDto saleOrderRespDto = this.performOrderExtDomain.queryDtoById(orderId);
            AssertUtils.notNull((Object)saleOrderRespDto, (String)String.format("orderNo=%s\u7684\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728", orderId));
            LOGGER.info("\u3010\u81ea\u52a8\u7b56\u7565\u3011\u8ba2\u5355\uff08orderId={}\uff09\u8ba2\u5355\u7684\u8be6\u60c5\u4e3a\uff1a{}", (Object)orderId, (Object)JSON.toJSONString((Object)saleOrderRespDto));
            matchStrategyResult = new DgStrategyRuleServiceImpl.MatchStrategyResult();
            DgStrategyRuleEo strategyRuleEo = this.queryValidRule(saleOrderRespDto, DgCisStrategyOrderTypeEnum.CUSTOMER.getCode());
            if (strategyRuleEo == null) {
                matchStrategyResult.setMatchStrategy(false);
                DgStrategyRuleServiceImpl.MatchStrategyResult matchStrategyResult2 = matchStrategyResult;
                return matchStrategyResult2;
            }
            List<StrategyConfItemEo> strategyConfItemEoList = this.queryValidRuleConfItemList(strategyRuleEo);
            Boolean checkResult = this.checkRule(strategyConfItemEoList, saleOrderRespDto);
            if (!checkResult.booleanValue()) {
                this.saveHitConfItem();
                matchStrategyResult.setIntercepted(true);
                DgStrategyRuleServiceImpl.MatchStrategyResult matchStrategyResult3 = matchStrategyResult;
                return matchStrategyResult3;
            }
            Map strategyConfItemEoMap = strategyConfItemEoList.stream().collect(Collectors.toMap(StrategyConfItemEo::getStrategyType, Function.identity(), (v1, v2) -> v2));
            StrategyConfItemEo strategyConfItemEo = (StrategyConfItemEo)strategyConfItemEoMap.get(CisStrategyConfItemTypeEnum.DELAY_AUDIT.getCode());
            if (strategyConfItemEo != null) {
                LOGGER.info("\u3010\u81ea\u52a8\u7b56\u7565\u3011\u8ba2\u5355\u53f7={}\uff0c\u5ef6\u8fdf\u5ba1\u6838\u65f6\u95f4\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)strategyConfItemEo.getContent());
                this.handleDelayAuditByConf(strategyConfItemEo, saleOrderRespDto, saleOrderRespDto.getSaleCreateTime(), DgCisStrategyOrderTypeEnum.CUSTOMER);
            } else {
                LOGGER.info("\u3010\u81ea\u52a8\u7b56\u7565\u3011\u8ba2\u5355\u53f7={}\uff0c\u5ef6\u8fdf\u5ba1\u6838\u65f6\u95f4\u672a\u5339\u914d\u5230", (Object)saleOrderRespDto.getSaleOrderNo());
                strategyConfItemEo = new StrategyConfItemEo();
                strategyConfItemEo.setRuleId(strategyRuleEo.getId());
                strategyConfItemEo.setContent("0");
                this.handleDelayAuditByConf(strategyConfItemEo, saleOrderRespDto, saleOrderRespDto.getSaleCreateTime(), DgCisStrategyOrderTypeEnum.CUSTOMER);
            }
            DgStrategyRuleServiceImpl.MatchStrategyResult matchStrategyResult4 = matchStrategyResult;
            return matchStrategyResult4;
        }
        finally {
            this.cleanHitStrategyOrder();
        }
    }

    private void extractedAttributeAssignment(List<DgStrategyRuleSuitEo> strategyRuleSuitList, DgStrategyRuleSuitEo dgStrategyRuleSuitEo, DgCustomerAuditStrategyRuleRespDto.Apply apply) {
        apply.setApplicableType(dgStrategyRuleSuitEo.getSuitSelectType());
        if (StringUtils.equals((CharSequence)dgStrategyRuleSuitEo.getSuitSelectType(), (CharSequence)"SELECT")) {
            List shopCodeList = strategyRuleSuitList.stream().map(DgStrategyRuleSuitEo::getSuitKey).collect(Collectors.toList());
            apply.setApplicableList(shopCodeList);
        }
    }

    private void getStrategyConfItems(Long id, DgCustomerAuditStrategyRuleRespDto strategyRuleRespDto) {
        LambdaQueryWrapper queryStrategyConfItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getRuleId, (Object)id);
        List strategyConfItemEoList = this.strategyConfItemDas.list(queryStrategyConfItemEo);
        AssertUtils.notEmpty((Collection)strategyConfItemEoList, (String)"\u7b56\u7565\u914d\u7f6e\u9879\u4e3a\u7a7a");
        LambdaQueryWrapper queryStrategyConfItemSuitEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryStrategyConfItemSuitEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemSuitEo::getRuleId, (Object)id);
        List strategyConfItemSuitEoList = this.strategyConfItemSuitDas.list(queryStrategyConfItemSuitEo);
        Map<String, List<StrategyConfItemSuitEo>> strategyConfItemSuitMap = Optional.ofNullable(strategyConfItemSuitEoList).orElseGet(Collections::emptyList).stream().collect(Collectors.groupingBy(StrategyConfItemSuitEo::getSuitType));
        for (StrategyConfItemEo strategyConfItemEo : strategyConfItemEoList) {
            Map map;
            String content2;
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.NEEDLESS_PERSON_AUDIT.getCode())) {
                strategyRuleRespDto.setNeedlessPersonAudit(strategyConfItemEo.getEnable());
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.DELAY_AUDIT.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.DelayAudit delayAudit = new DgCustomerAuditStrategyRuleRespDto.DelayAudit();
                CubeBeanUtils.copyProperties((Object)delayAudit, (Object)strategyConfItemEo, (String[])new String[0]);
                delayAudit.setContent(strategyConfItemEo.getContent());
                content2 = strategyConfItemEo.getContent();
                if (StringUtils.isNotBlank((CharSequence)content2)) {
                    map = (HashMap)JSON.parseObject((String)content2, HashMap.class);
                    delayAudit.setTimeType(Integer.valueOf(Integer.parseInt(map.get("timeType").toString())));
                    delayAudit.setValue(Integer.valueOf(Integer.parseInt(map.get("value").toString())));
                }
                strategyRuleRespDto.setDelayAudit(delayAudit);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.AUTO_DISTRIBUTION.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.AutoDistribution autoDistribution = new DgCustomerAuditStrategyRuleRespDto.AutoDistribution();
                CubeBeanUtils.copyProperties((Object)autoDistribution, (Object)strategyConfItemEo, (String[])new String[0]);
                autoDistribution.setContent(strategyConfItemEo.getContent());
                content2 = strategyConfItemEo.getContent();
                if (StringUtils.isNotBlank((CharSequence)content2)) {
                    map = (HashMap)JSON.parseObject((String)content2, HashMap.class);
                    autoDistribution.setType(Integer.valueOf(Integer.parseInt(map.get("type").toString())));
                    autoDistribution.setValue(Integer.valueOf(Integer.parseInt(map.get("value").toString())));
                }
                strategyRuleRespDto.setAutoDistribution(autoDistribution);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.SPECIAL_AMOUNT.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.SpecialAmount specialAmount = new DgCustomerAuditStrategyRuleRespDto.SpecialAmount();
                CubeBeanUtils.copyProperties((Object)specialAmount, (Object)strategyConfItemEo, (String[])new String[0]);
                Optional.ofNullable(strategyConfItemEo.getContent()).ifPresent(content -> {
                    Map map = (Map)JSON.parseObject((String)content, Map.class);
                    if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)map, (Object)"minAmount"))) {
                        specialAmount.setMinAmount(new BigDecimal(MapUtils.getString((Map)map, (Object)"minAmount")));
                    }
                    if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)map, (Object)"maxAmount"))) {
                        specialAmount.setMaxAmount(new BigDecimal(MapUtils.getString((Map)map, (Object)"maxAmount")));
                    }
                });
                strategyRuleRespDto.setSpecialAmount(specialAmount);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.SpecialOrderType specialOrderType = new DgCustomerAuditStrategyRuleRespDto.SpecialOrderType();
                specialOrderType.setEnable(strategyConfItemEo.getEnable());
                List orderTypeCodeList = Optional.ofNullable(strategyConfItemSuitMap.get(CisStrategyConfItemTypeEnum.SPECIAL_ORDER_TPYE.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialOrderType.setOrderTypeCodeList(orderTypeCodeList);
                strategyRuleRespDto.setSpecialOrderType(specialOrderType);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.SpecialLabel specialLabel = new DgCustomerAuditStrategyRuleRespDto.SpecialLabel();
                specialLabel.setEnable(strategyConfItemEo.getEnable());
                List specialLabelCodeList = Optional.ofNullable(strategyConfItemSuitMap.get(CisStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialLabel.setLabelCodeList(specialLabelCodeList);
                strategyRuleRespDto.setSpecialLabel(specialLabel);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.SPECIAL_CUSTOMER.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.SpecialCustomer specialCustomer = new DgCustomerAuditStrategyRuleRespDto.SpecialCustomer();
                specialCustomer.setEnable(strategyConfItemEo.getEnable());
                List specialCustomerList = Optional.ofNullable(strategyConfItemSuitMap.get(CisStrategyConfItemTypeEnum.SPECIAL_CUSTOMER.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialCustomer.setCustomerCodeList(specialCustomerList);
                strategyRuleRespDto.setSpecialCustomer(specialCustomer);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.SPECIAL_WAREHOUSE.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.SpecialWarehouse specialWarehouse = new DgCustomerAuditStrategyRuleRespDto.SpecialWarehouse();
                specialWarehouse.setEnable(strategyConfItemEo.getEnable());
                List warehouseCodeList = Optional.ofNullable(strategyConfItemSuitMap.get(CisStrategyConfItemTypeEnum.SPECIAL_WAREHOUSE.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialWarehouse.setWarehouseCodeList(warehouseCodeList);
                strategyRuleRespDto.setSpecialWarehouse(specialWarehouse);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.SPECIAL_SKU.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.SpecialSku specialSku = new DgCustomerAuditStrategyRuleRespDto.SpecialSku();
                specialSku.setEnable(strategyConfItemEo.getEnable());
                specialSku.setContent(Optional.ofNullable(strategyConfItemEo.getContent()).orElse(""));
                specialSku.setApplicableType(Optional.ofNullable(strategyConfItemEo.getContent()).orElse(""));
                List skuCodeList = Optional.ofNullable(strategyConfItemSuitMap.get(CisStrategyConfItemTypeEnum.SPECIAL_SKU.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialSku.setSkuCodeList(skuCodeList);
                strategyRuleRespDto.setSpecialSku(specialSku);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.SPECIAL_AREA.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.SpecialArea specialArea = new DgCustomerAuditStrategyRuleRespDto.SpecialArea();
                specialArea.setEnable(strategyConfItemEo.getEnable());
                List areaCodeList = Optional.ofNullable(strategyConfItemSuitMap.get(CisStrategyConfItemTypeEnum.SPECIAL_AREA.getCode())).orElseGet(Collections::emptyList).stream().map(StrategyConfItemSuitEo::getSuitValue).collect(Collectors.toList());
                specialArea.setAreaCodeList(areaCodeList);
                strategyRuleRespDto.setSpecialArea(specialArea);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.BUYER_REMARK.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.BuyerRemark buyerRemark = new DgCustomerAuditStrategyRuleRespDto.BuyerRemark();
                CubeBeanUtils.copyProperties((Object)buyerRemark, (Object)strategyConfItemEo, (String[])new String[0]);
                content2 = strategyConfItemEo.getContent();
                map = (Map)JSON.parseObject((String)content2, Map.class);
                buyerRemark.setRemarkType(MapUtils.getString((Map)map, (Object)"remarkType", (String)"0"));
                buyerRemark.setKeyWords(MapUtils.getString((Map)map, (Object)"keyWords"));
                strategyRuleRespDto.setBuyerRemark(buyerRemark);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.SELLER_REMARK.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.SellerRemark sellerRemark = new DgCustomerAuditStrategyRuleRespDto.SellerRemark();
                CubeBeanUtils.copyProperties((Object)sellerRemark, (Object)strategyConfItemEo, (String[])new String[0]);
                content2 = strategyConfItemEo.getContent();
                map = (Map)JSON.parseObject((String)content2, Map.class);
                sellerRemark.setRemarkType(MapUtils.getString((Map)map, (Object)"remarkType", (String)"0"));
                sellerRemark.setKeyWords(MapUtils.getString((Map)map, (Object)"keyWords"));
                strategyRuleRespDto.setSellerRemark(sellerRemark);
                continue;
            }
            if (StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.INTERNAL_REMARK.getCode())) {
                DgCustomerAuditStrategyRuleRespDto.InternalRemark internalRemark = new DgCustomerAuditStrategyRuleRespDto.InternalRemark();
                CubeBeanUtils.copyProperties((Object)internalRemark, (Object)strategyConfItemEo, (String[])new String[0]);
                content2 = strategyConfItemEo.getContent();
                map = (Map)JSON.parseObject((String)content2, Map.class);
                internalRemark.setRemarkType(MapUtils.getString((Map)map, (Object)"remarkType", (String)"0"));
                internalRemark.setKeyWords(MapUtils.getString((Map)map, (Object)"keyWords"));
                strategyRuleRespDto.setInternalRemark(internalRemark);
                continue;
            }
            if (!StringUtils.equals((CharSequence)strategyConfItemEo.getStrategyType(), (CharSequence)CisStrategyConfItemTypeEnum.SPECIAL_PAYTIME.getCode())) continue;
            DgCustomerAuditStrategyRuleRespDto.SpecialPayTime specialPayTime = new DgCustomerAuditStrategyRuleRespDto.SpecialPayTime();
            specialPayTime.setEnable(strategyConfItemEo.getEnable());
            Optional.ofNullable(strategyConfItemEo.getContent()).ifPresent(content -> {
                Map map = (Map)JSON.parseObject((String)content, Map.class);
                if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)map, (Object)"startTime"))) {
                    specialPayTime.setStartTime(DateUtil.parse((String)MapUtils.getString((Map)map, (Object)"startTime"), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)map, (Object)"endTime"))) {
                    specialPayTime.setEndTime(DateUtil.parse((String)MapUtils.getString((Map)map, (Object)"endTime"), (String)"yyyy-MM-dd HH:mm:ss"));
                }
            });
            strategyRuleRespDto.setSpecialPayTime(specialPayTime);
        }
    }

    public String getLatestNo() {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderWrapper.eq(DgStrategyRuleEo::getStrategyType, (Object)"CUSTOMER")).orderByDesc(BaseEo::getId)).orderByDesc(BaseEo::getCreateTime)).last(" limit 1");
        DgStrategyRuleEo dgStrategyRuleEo = this.strategyRuleDas.getOne(queryOrderWrapper);
        if (dgStrategyRuleEo == null) {
            return "";
        }
        return dgStrategyRuleEo.getRuleCode();
    }
}

