/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.guard.impl;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.enums.DictEnum;
import com.yunxi.dg.base.center.source.dto.extend.OrderItemResultRespDto;
import com.yunxi.dg.base.center.source.dto.extend.SourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.action.IDgPerformOrderOptAction;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelItemDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderLabelItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.guard.IDgSplitOrderGuard;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgSplitOrderGuardImpl
implements IDgSplitOrderGuard {
    private static final Logger log = LoggerFactory.getLogger(DgSplitOrderGuardImpl.class);
    private static final String NO = "0";
    @Value(value="${oms.source.gift.split.tagCode:TAG202209028575}")
    private String giftSplitTagCode;
    @Resource
    private IPcpDictApi pcpDictApi;
    @Resource
    private IDgPerformOrderOptAction performOrderOptAction;
    @Resource
    private IDgOrderLabelItemDomain orderLabelItemDomain;
    @Resource
    private IDgPerformOrderItemExtDomain performOrderItemDomain;

    @Override
    public Boolean checkContainsLackLabel(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        List orderLabelItemRespDtos = this.orderLabelItemDomain.queryByOrderId(respDto.getId());
        if (CollectionUtils.isNotEmpty((Collection)orderLabelItemRespDtos)) {
            for (DgOrderLabelItemDto orderLabelItemRespDto : orderLabelItemRespDtos) {
                if (!StringUtils.equals((CharSequence)orderLabelItemRespDto.getLabelCode(), (CharSequence)DgOrderLabelEnum.ITEM_LACK.getCode())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @Override
    public void checkSplitLegalBySource(DgPerformOrderRespDto saleOrderRespDto, SourceOrderResultRespDto sourceOrderResultRespDto) {
        if (CollectionUtils.isNotEmpty((Collection)sourceOrderResultRespDto.getOrderItemResultRespDtoList())) {
            List saleOrderItemRespDtoList = this.performOrderItemDomain.queryOrderItemByOrderId(saleOrderRespDto.getId());
            AssertUtils.notEmpty((Collection)saleOrderItemRespDtoList, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
            long giftCount = saleOrderItemRespDtoList.stream().filter(saleOrderItemRespDto -> saleOrderItemRespDto.getGift().equals(DgGiftEnum.GIFT.getType())).count();
            if (giftCount == 0L) {
                log.info("[\u5bfb\u6e90\u62c6\u5355\u6821\u9a8c]\u8ba2\u5355\u4e0d\u5b58\u5728\u8d60\u54c1\uff0c\u65e0\u9700\u6821\u9a8c");
                return;
            }
            Map<String, List<OrderItemResultRespDto>> orderItemResultMap = sourceOrderResultRespDto.getOrderItemResultRespDtoList().stream().collect(Collectors.groupingBy(OrderItemResultRespDto::getDeliveryLogicWarehouseCode));
            if (orderItemResultMap.size() == 1) {
                return;
            }
            Map<Long, DgPerformOrderItemRespDto> saleOrderItemRespDtoMap = saleOrderItemRespDtoList.stream().collect(Collectors.toMap(BaseDto::getId, v1 -> v1));
            orderItemResultMap.forEach((deliveryLogicWarehouseCode, orderItemResultList) -> {
                List matchList = orderItemResultList.stream().map(orderItemResultRespDto -> (DgPerformOrderItemRespDto)saleOrderItemRespDtoMap.get(orderItemResultRespDto.getLinkOrderItemId())).filter(saleOrderItemRespDto -> DgGiftEnum.NOT_GIFT.getType().equals(saleOrderItemRespDto.getGift())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(matchList)) {
                    DgOrderTagRecordReqDto orderTagRecordReqDto = new DgOrderTagRecordReqDto();
                    orderTagRecordReqDto.setOrderId(saleOrderRespDto.getId());
                    orderTagRecordReqDto.setTagCode(this.giftSplitTagCode);
                    this.performOrderOptAction.manualAddTag(saleOrderRespDto, orderTagRecordReqDto);
                    throw DgPcpTradeExceptionCode.SPLIT_ORDER_BY_SOURCE_ILLEGAL.builderException();
                }
            });
            List sourceSplitOrderItemIdList = sourceOrderResultRespDto.getOrderItemResultRespDtoList().stream().map(OrderItemResultRespDto::getLinkOrderItemId).collect(Collectors.toList());
            List saleOrderItemOfRemain = saleOrderItemRespDtoList.stream().filter(saleOrderItemRespDto -> !sourceSplitOrderItemIdList.contains(saleOrderItemRespDto.getId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(saleOrderItemOfRemain)) {
                log.info("[\u5bfb\u6e90\u62c6\u5355\u6821\u9a8c]\u5bfb\u6e90\u62c6\u5355\u540e\uff0c\u5b58\u5728\u5269\u4f59\u5546\u54c1\u5408\u6210\u4e00\u4e2a\u5b50\u5355\uff0c\u9700\u8981\u6821\u9a8c\u5269\u4f59\u5546\u54c1\u7684\u8ba2\u5355\u662f\u5426\u53ea\u5b58\u5728\u8d60\u54c1");
                List matchList = saleOrderItemOfRemain.stream().filter(saleOrderItemRespDto -> DgGiftEnum.NOT_GIFT.getType().equals(saleOrderItemRespDto.getGift())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(matchList)) {
                    DgOrderTagRecordReqDto orderTagRecordReqDto = new DgOrderTagRecordReqDto();
                    orderTagRecordReqDto.setOrderId(saleOrderRespDto.getId());
                    orderTagRecordReqDto.setTagCode(this.giftSplitTagCode);
                    this.performOrderOptAction.manualAddTag(saleOrderRespDto, orderTagRecordReqDto);
                    throw DgPcpTradeExceptionCode.SPLIT_ORDER_BY_SOURCE_ILLEGAL.builderException();
                }
            }
        }
    }

    @Override
    public Boolean getSplitOrderBySourceIllegal() {
        List dictList = (List)RestResponseHelper.extractData((RestResponse)this.pcpDictApi.queryByGroupCode("COMMON_CONFIG"));
        DictDto dict = (DictDto)Optional.ofNullable(dictList).orElseGet(Collections::emptyList).stream().filter(dictDto -> DictEnum.IF_GIFT_ALLOWED_TO_SPLIT.equals((Object)DictEnum.getByDict((DictDto)dictDto))).collect(Collectors.toList()).get(0);
        if (dict == null || NO.equals(dict.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean checkSplitLegalByAppoint(DgPerformOrderRespDto saleOrderRespDto, List<DgPerformOrderRespDto> childOrderList) {
        List childOrderIdList = childOrderList.stream().map(BaseDto::getId).collect(Collectors.toList());
        List saleOrderItemRespDtoList = this.performOrderItemDomain.queryOrderItemByOrderIds(childOrderIdList);
        AssertUtils.notEmpty((Collection)saleOrderItemRespDtoList, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        Map<Long, List<DgPerformOrderItemRespDto>> orderItemListForGroup = saleOrderItemRespDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemDto::getOrderId));
        AtomicReference<Boolean> result = new AtomicReference<Boolean>(Boolean.TRUE);
        orderItemListForGroup.forEach((orderId, orderItemList) -> {
            List matchList = orderItemList.stream().filter(saleOrderItemRespDto -> DgGiftEnum.NOT_GIFT.getType().equals(saleOrderItemRespDto.getGift())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(matchList)) {
                DgOrderTagRecordReqDto orderTagRecordReqDto = new DgOrderTagRecordReqDto();
                orderTagRecordReqDto.setOrderId(saleOrderRespDto.getId());
                orderTagRecordReqDto.setTagCode(this.giftSplitTagCode);
                this.performOrderOptAction.addGiftSplitTag(saleOrderRespDto, orderTagRecordReqDto);
                result.set(Boolean.FALSE);
            }
        });
        return result.get();
    }
}

