/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.tc.order.config.model;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.statemachine.engine.action.AbstractCisBaseStatemachineAction;
import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.dtyunxi.cube.statemachine.engine.config.builder.SATRegionModelBuilder;
import com.dtyunxi.cube.statemachine.engine.config.model.StatemachineSATRegionConfigurerModel;
import com.dtyunxi.cube.statemachine.engine.guard.AbstractCisGuard;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisGuardResult;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AllotTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderSourceEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.action.IDgPerformOrderHandleAction;
import com.yunxi.dg.base.center.trade.action.IDgPerformOrderOptAction;
import com.yunxi.dg.base.center.trade.action.tc.IDgTcMqMessageAction;
import com.yunxi.dg.base.center.trade.action.tc.IDgTcOrderTagRecordAction;
import com.yunxi.dg.base.center.trade.action.tc.IDgTcPerformOrderHandleAction;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.proxy.data.api.IPcpDictProxy;
import com.yunxi.dg.base.center.trade.proxy.data.entity.DictDto;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.config.engine.action.DgTcMaiyouOrderPickAction;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.config.engine.action.DgTcPreemptChannelStockAction;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.config.engine.action.DgTcSendOrderCheckMqAction;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.config.engine.action.DgTcUpdateDefaultWarehouseAction;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.config.engine.guard.AbstractTcGByAGuard;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.config.model.DgTcStatemachineConfigurerModel;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderActionDefineEnum;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderMachineStatus;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderStatemachineDefine;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.vo.DgTcOrderThroughRespDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.config.builders.StateMachineStateConfigurer;
import org.springframework.statemachine.config.builders.StateMachineTransitionConfigurer;
import org.springframework.statemachine.config.configurers.ExternalTransitionConfigurer;

public class DgTcOrderInitStateSTAConfigurerModel
extends DgTcStatemachineConfigurerModel {
    private final Logger logger = LoggerFactory.getLogger(DgTcOrderInitStateSTAConfigurerModel.class);
    @Resource
    private IDgPerformOrderExtDomain performOrderDomain;
    @Resource
    private IDgPerformOrderOptAction performOrderOptAction;
    @Resource
    private DgTcPreemptChannelStockAction dgTcPreemptChannelStockAction;
    @Resource
    private IDgTcMqMessageAction dgTcMqMessageAction;
    @Resource
    private IDgPerformOrderHandleAction performOrderHandleAction;
    @Resource
    private IDgTcPerformOrderHandleAction dgTcPerformOrderHandleAction;
    @Resource
    private IPcpDictProxy pcpDictProxy;
    @Resource
    private IDgTcOrderTagRecordAction dgTcOrderTagRecordAction;
    @Resource
    private DgTcUpdateDefaultWarehouseAction dgTcUpdateDefaultWarehouseAction;
    @Resource
    private DgTcMaiyouOrderPickAction tcMaiyouOrderPickAction;
    @Resource
    private DgTcSendOrderCheckMqAction dgTcSendOrderCheckMqAction;

    public List<StatemachineSATRegionConfigurerModel<DgTcOrderMachineStatus, DgTcOrderMachineEvents>> drawConfigModel() throws Exception {
        ArrayList<StatemachineSATRegionConfigurerModel<DgTcOrderMachineStatus, DgTcOrderMachineEvents>> statemachineSATRegionConfigurerModelList = new ArrayList<StatemachineSATRegionConfigurerModel<DgTcOrderMachineStatus, DgTcOrderMachineEvents>>();
        statemachineSATRegionConfigurerModelList.add(SATRegionModelBuilder.build(() -> DgTcOrderStatemachineDefine.TOC_INIT_CONFIG.getCode(), this::withStatesConfig));
        statemachineSATRegionConfigurerModelList.add(SATRegionModelBuilder.build(() -> DgTcOrderStatemachineDefine.ORDER_MODEL_CONFIG.getCode(), this::orderModelConfig));
        return statemachineSATRegionConfigurerModelList;
    }

    private void withStatesConfig(StateMachineStateConfigurer<DgTcOrderMachineStatus, DgTcOrderMachineEvents> stateConfig, StateMachineTransitionConfigurer<DgTcOrderMachineStatus, DgTcOrderMachineEvents> transitionConfigurer) throws Exception {
        stateConfig.withStates().initial((Object)DgTcOrderMachineStatus.INIT_STATE).state((Object)DgTcOrderMachineStatus.INIT_STATE).state((Object)DgTcOrderMachineStatus.CREATE_ORDER).choice((Object)DgTcOrderMachineStatus.CREATE_ORDER_CHOOSE).state((Object)DgTcOrderMachineStatus.STATE_PCP_WAIT_CHECK).state((Object)DgTcOrderMachineStatus.STATE_PCP_RECEIVED).state((Object)DgTcOrderMachineStatus.STATE_OMS_WAIT_PICK);
    }

    private void orderModelConfig(StateMachineStateConfigurer<DgTcOrderMachineStatus, DgTcOrderMachineEvents> stateConfig, StateMachineTransitionConfigurer<DgTcOrderMachineStatus, DgTcOrderMachineEvents> transitionConfigurer) throws Exception {
        ((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)transitionConfigurer.withExternal().source((Object)DgTcOrderMachineStatus.INIT_STATE)).target((Object)DgTcOrderMachineStatus.CREATE_ORDER_CHOOSE).action((Action)this.saveOrder().ifNext(this.checkOrderPreeStockGuard(), (Action)this.dgTcPreemptChannelStockAction).ifNext(this.checkOrderKmhTagGuard(), (Action)this.orderKmhTagAction().nextAction((Action)this.dgTcUpdateDefaultWarehouseAction)))).event((Object)DgTcOrderMachineEvents.OMS_CREATE_ORDER)).and()).withChoice().source((Object)DgTcOrderMachineStatus.CREATE_ORDER_CHOOSE).first((Object)DgTcOrderMachineStatus.STATE_PCP_RECEIVED, this.checkChildDirectOrderGuard()).then((Object)DgTcOrderMachineStatus.STATE_OMS_WAIT_PICK, this.checkMaiyouAllotOrderGuard(), (Action)this.tcMaiyouOrderPickAction.nextAction((Action)this.dgTcSendOrderCheckMqAction)).last((Object)DgTcOrderMachineStatus.STATE_PCP_WAIT_CHECK, (Action)this.orderAutoCheck().nextAction((Action)builder.ac().build((CisActionDefine)DgTcOrderActionDefineEnum.SEND_MSG_CREATED_SAVE_ORDER, (dto, req) -> this.dgTcMqMessageAction.sendEasSaleOrder((DgBizPerformOrderReqDto)req)))).and();
    }

    public AbstractCisBaseStatemachineAction<DgTcOrderActionDefineEnum, DgTcOrderMachineStatus, DgTcOrderMachineEvents, DgBizPerformOrderReqDto, RestResponse<String>, DgTcOrderThroughRespDto> saveOrder() {
        return new AbstractCisBaseStatemachineAction<DgTcOrderActionDefineEnum, DgTcOrderMachineStatus, DgTcOrderMachineEvents, DgBizPerformOrderReqDto, RestResponse<String>, DgTcOrderThroughRespDto>(DgTcOrderActionDefineEnum.SAVE_ORDER, true){

            public RestResponse<String> executeSub(DgTcOrderThroughRespDto through, DgBizPerformOrderReqDto request) {
                DgTcOrderInitStateSTAConfigurerModel.this.logger.info("[\u72b6\u6001\u673a]\u521b\u5efa\u8ba2\u5355-action");
                request.setOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
                request.setOmsSaleOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
                DgTcOrderInitStateSTAConfigurerModel.this.dgTcPerformOrderHandleAction.setTargetWarehouse(request);
                String orderNo = (String)RestResponseHelper.extractData((RestResponse)DgTcOrderInitStateSTAConfigurerModel.this.performOrderOptAction.createSaleOrder((DgPerformOrderRespDto)through, request));
                DgTcOrderInitStateSTAConfigurerModel.this.logger.info("\u521b\u5efa\u8ba2\u5355\u6210\u529f{}", (Object)orderNo);
                DgPerformOrderRespDto performOrderRespDto = DgTcOrderInitStateSTAConfigurerModel.this.performOrderDomain.queryDtoById(request.getId());
                request.setId(performOrderRespDto.getId());
                CubeBeanUtils.copyProperties((Object)((Object)through), (Object)performOrderRespDto, (String[])new String[]{"extensionDto"});
                return new RestResponse((Object)orderNo);
            }
        };
    }

    private AbstractCisGuard<DgTcOrderMachineStatus, DgTcOrderMachineEvents, DgTcOrderActionDefineEnum> checkOrderPreeStockGuard() {
        return new AbstractTcGByAGuard<Object>("\u5224\u65ad\u662f\u5426\u9700\u8981\u9884\u5360\u6e20\u9053\u5e93\u5b58", false){

            public CisGuardResult actionGuard(DgTcOrderThroughRespDto through, Object request) {
                boolean require;
                DgBizPerformOrderReqDto reqDto = (DgBizPerformOrderReqDto)request;
                boolean bl = require = reqDto.getManualCreate() != false || Objects.equals(reqDto.getOrderSource(), SaleOrderSourceEnum.IMPORT.getType());
                if (require && (SaleOrderTypeEnum.CHILD_DIRECT_SALES.getType().equals(through.getOrderType()) || SaleOrderTypeEnum.PRESALE_ORDER.getType().equals(through.getOrderType()) || Objects.equals(through.getAllotType(), AllotTypeEnum.MAIYOU_CC_ALLOT.getType()) || Objects.equals(through.getAllotType(), AllotTypeEnum.MAIYOU_CC_ALLOT_OUT.getType()))) {
                    require = false;
                }
                return new CisGuardResult(require);
            }
        };
    }

    private AbstractCisGuard<DgTcOrderMachineStatus, DgTcOrderMachineEvents, DgTcOrderActionDefineEnum> checkOrderKmhTagGuard() {
        return new AbstractTcGByAGuard<Object>("\u5224\u65ad\u662f\u5426\u5728\u5f00\u95e8\u7ea2\u65f6\u95f4", false){

            public CisGuardResult actionGuard(DgTcOrderThroughRespDto through, Object request) {
                DgBizPerformOrderReqDto reqDto = (DgBizPerformOrderReqDto)request;
                boolean kmhTagFalg = DgTcOrderInitStateSTAConfigurerModel.this.getDictKmhDate(through.getSaleCreateTime(), reqDto.getPerformOrderSnapshotDto().getOrganizationCode(), through.getOrderType(), reqDto.getPerformOrderSnapshotDto().getChannelWarehouseCode());
                DgTcOrderInitStateSTAConfigurerModel.this.logger.info("\u662f\u5426\u5c5e\u4e8e\u5f00\u95e8\u7ea2\u8ba2\u5355:{}", (Object)kmhTagFalg);
                return new CisGuardResult(kmhTagFalg);
            }
        };
    }

    private boolean getDictKmhDate(Date creteTime, String organizationCode, String orderType, String channelWarehouseCode) {
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.pcpDictProxy.queryByGroupCodeAndCode("COMMON_CONFIG", "KMH_DATE"));
        this.logger.info("\u83b7\u53d6\u8f6c\u5355\u5b57\u5178\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)dictDto));
        if (Objects.isNull(dictDto) || Objects.isNull(dictDto.getValue())) {
            return false;
        }
        String value = dictDto.getValue();
        Map map = (Map)JSON.parseObject((String)value, Map.class);
        if (!(map.containsKey("startDate") && map.containsKey("endDate") && map.containsKey("orgCode"))) {
            return false;
        }
        String startDate = map.get("startDate").toString();
        Date startTime = DateUtil.parseDate((String)startDate, (String)"yyyy-MM-dd HH:mm:ss");
        String endDate = map.get("endDate").toString();
        Date endTime = DateUtil.parseDate((String)endDate, (String)"yyyy-MM-dd HH:mm:ss");
        List orderTypes = (List)map.get("orderTypes");
        List channelWarehouseCodes = (List)map.get("channelWarehouseCodes");
        return creteTime.compareTo(startTime) >= 0 && creteTime.compareTo(endTime) <= 0 && channelWarehouseCodes.contains(channelWarehouseCode) && orderTypes.contains(orderType);
    }

    public AbstractCisBaseStatemachineAction<DgTcOrderActionDefineEnum, DgTcOrderMachineStatus, DgTcOrderMachineEvents, DgBizPerformOrderReqDto, RestResponse<Void>, DgTcOrderThroughRespDto> orderKmhTagAction() {
        return new AbstractCisBaseStatemachineAction<DgTcOrderActionDefineEnum, DgTcOrderMachineStatus, DgTcOrderMachineEvents, DgBizPerformOrderReqDto, RestResponse<Void>, DgTcOrderThroughRespDto>(DgTcOrderActionDefineEnum.SAVE_ORDER){

            public RestResponse<Void> executeSub(DgTcOrderThroughRespDto throughSaleOrderDto, DgBizPerformOrderReqDto request) {
                DgTcOrderInitStateSTAConfigurerModel.this.dgTcOrderTagRecordAction.kmhTagByOrderCreate(throughSaleOrderDto.getId());
                return new RestResponse();
            }
        };
    }

    public AbstractCisBaseStatemachineAction<DgTcOrderActionDefineEnum, DgTcOrderMachineStatus, DgTcOrderMachineEvents, DgBizPerformOrderReqDto, RestResponse<Void>, DgTcOrderThroughRespDto> preemptionStockAction() {
        return new AbstractCisBaseStatemachineAction<DgTcOrderActionDefineEnum, DgTcOrderMachineStatus, DgTcOrderMachineEvents, DgBizPerformOrderReqDto, RestResponse<Void>, DgTcOrderThroughRespDto>(DgTcOrderActionDefineEnum.SAVE_ORDER){

            public RestResponse<Void> executeSub(DgTcOrderThroughRespDto throughSaleOrderDto, DgBizPerformOrderReqDto request) {
                DgTcOrderInitStateSTAConfigurerModel.this.performOrderHandleAction.preemptChannelInventory(throughSaleOrderDto.getId());
                return new RestResponse();
            }
        };
    }

    private AbstractCisGuard<DgTcOrderMachineStatus, DgTcOrderMachineEvents, DgTcOrderActionDefineEnum> checkChildDirectOrderGuard() {
        return new AbstractTcGByAGuard<Object>("\u5224\u65ad\u662f\u5426\u4e3a\u5b50\u516c\u53f8\u76f4\u9500\u8ba2\u5355", false){

            public CisGuardResult actionGuard(DgTcOrderThroughRespDto through, Object request) {
                Boolean validationCreateOrder = SaleOrderTypeEnum.CHILD_DIRECT_SALES.getType().equals(through.getOrderType());
                return new CisGuardResult(validationCreateOrder.booleanValue());
            }
        };
    }

    private AbstractCisGuard<DgTcOrderMachineStatus, DgTcOrderMachineEvents, DgTcOrderActionDefineEnum> checkMaiyouAllotOrderGuard() {
        return new AbstractTcGByAGuard<Object>("\u5224\u65ad\u662f\u5426\u4e3a\u9ea6\u4f18\u8c03\u62e8\u8865\u8d27\u8ba2\u5355", false){

            public CisGuardResult actionGuard(DgTcOrderThroughRespDto through, Object request) {
                Boolean validationCreateOrder = SaleOrderTypeEnum.MAIYOU_ALLOT.getType().equals(through.getOrderType());
                return new CisGuardResult(validationCreateOrder.booleanValue());
            }
        };
    }

    public AbstractCisBaseStatemachineAction<DgTcOrderActionDefineEnum, DgTcOrderMachineStatus, DgTcOrderMachineEvents, DgBizPerformOrderReqDto, RestResponse<Void>, DgTcOrderThroughRespDto> orderAutoCheck() {
        return new AbstractCisBaseStatemachineAction<DgTcOrderActionDefineEnum, DgTcOrderMachineStatus, DgTcOrderMachineEvents, DgBizPerformOrderReqDto, RestResponse<Void>, DgTcOrderThroughRespDto>(DgTcOrderActionDefineEnum.SAVE_ORDER){

            public RestResponse<Void> executeSub(DgTcOrderThroughRespDto throughSaleOrderDto, DgBizPerformOrderReqDto request) {
                DgTcOrderInitStateSTAConfigurerModel.this.dgTcMqMessageAction.sendMsgForAutoCheck((DgPerformOrderRespDto)throughSaleOrderDto);
                return new RestResponse();
            }
        };
    }
}

