/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2b.order.Interceptor;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.statemachine.engine.exception.CisStatemachineAssert;
import com.dtyunxi.cube.statemachine.engine.exception.CisStatemachineExceptionCode;
import com.dtyunxi.cube.statemachine.engine.interceptor.AbstractDgStatemachineInterceptor;
import com.dtyunxi.cube.statemachine.engine.vo.ThroughDtoDefine;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseOrderMessageHeaders;
import com.dtyunxi.cube.statemachine.engine.vo.result.DgStatemachineStateResult;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.yunxi.dg.base.center.trade.action.IDgMqMessageAction;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IStrategyOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IStrategyPoolDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.event.SaleOrderInfoUpdateEvent;
import com.yunxi.dg.base.center.trade.dto.entity.StrategyOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.StrategyPoolDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.constant.DgB2BOrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.constant.DgB2BOrderMachineStatus;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.constant.DgB2BOrderStatus;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.vo.DgB2BOrderStatusChangeEvent;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.vo.DgB2BOrderThroughRespDto;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DgB2BOrderStatemachineInterceptor
extends AbstractDgStatemachineInterceptor<DgB2BOrderMachineStatus, DgB2BOrderMachineEvents, CisBaseOrderMessageHeaders<?, DgB2BOrderMachineStatus, DgB2BOrderMachineEvents, ?, DgB2BOrderThroughRespDto>, DgB2BOrderThroughRespDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgB2BOrderStatemachineInterceptor.class);
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IStrategyPoolDomain strategyPoolDomain;
    @Resource
    private IStrategyOrderDomain strategyOrderDomain;
    @Resource
    private ApplicationEventPublisher publisher;
    @Resource
    private IDgMqMessageAction mqMessageAction;
    @Resource
    private IDgPerformOrderExtDomain performOrderDomain;

    public void saveState(Long thoughId, String beforeState, DgB2BOrderMachineStatus afterState, DgB2BOrderMachineEvents event, CisBaseOrderMessageHeaders<?, DgB2BOrderMachineStatus, DgB2BOrderMachineEvents, ?, DgB2BOrderThroughRespDto> contextObj) {
        DgB2BOrderThroughRespDto throughDtoDefine = (DgB2BOrderThroughRespDto)contextObj.getThroughDto();
        LOGGER.info("<<<<<\u5b9e\u4f53{}\u4ece'{}'\u72b6\u6001\u5207\u6362\u5230'{}'\u72b6\u6001>>>>>", new Object[]{throughDtoDefine.getId(), beforeState, afterState.getCode()});
        CisStatemachineAssert.notNull((Object)((Object)throughDtoDefine), (CisStatemachineExceptionCode)CisStatemachineExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u900f\u4f20\u8ba2\u5355\u5b9e\u4f53\u4e0d\u5141\u8bb8\u4e3a\u7a7a"});
        if (Objects.nonNull(throughDtoDefine.getId())) {
            DgB2BOrderStatusChangeEvent dgB2BOrderStatusChangeEvent = new DgB2BOrderStatusChangeEvent();
            CubeBeanUtils.copyProperties((Object)((Object)dgB2BOrderStatusChangeEvent), (Object)((Object)throughDtoDefine), (String[])new String[0]);
            dgB2BOrderStatusChangeEvent.setBeforeStatus(throughDtoDefine.getOrderStatus());
            dgB2BOrderStatusChangeEvent.setChangeByEvent(event.getCode());
            DgPerformOrderInfoEo updateEo = new DgPerformOrderInfoEo();
            this.supplementStateBySaleOrderRespDto(updateEo, afterState);
            DgPerformOrderInfoEo queryEo = new DgPerformOrderInfoEo();
            queryEo.setId(throughDtoDefine.getId());
            UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
            if (StringUtils.isNotBlank((CharSequence)throughDtoDefine.getOmsSaleOrderStatus())) {
                updateWrapper.in((Object)"oms_sale_order_status", new Object[]{throughDtoDefine.getOmsSaleOrderStatus()});
            }
            LOGGER.info("<<<<<\u5b9e\u4f53{}\u4ece'{}'\u72b6\u6001\u5207\u6362\u5230'{}'\u72b6\u6001>>>>>'", new Object[]{throughDtoDefine.getId(), throughDtoDefine.getOmsSaleOrderStatus(), updateEo.getOmsSaleOrderStatus()});
            this.performOrderInfoDomain.optimisticModifySaleOrder(updateEo, updateWrapper, 1, true);
            this.saveStrategyPoolOrder(throughDtoDefine, updateEo.getOmsSaleOrderStatus());
            throughDtoDefine.setOmsSaleOrderStatus(updateEo.getOmsSaleOrderStatus());
            throughDtoDefine.setOrderStatus(updateEo.getOrderStatus());
            if (!updateEo.getOrderStatus().equals(dgB2BOrderStatusChangeEvent.getBeforeStatus())) {
                dgB2BOrderStatusChangeEvent.setOrderStatus(updateEo.getOrderStatus());
                if (TransactionSynchronizationManager.isSynchronizationActive()) {
                    this.publisher.publishEvent((Object)dgB2BOrderStatusChangeEvent);
                    this.publisher.publishEvent((Object)new SaleOrderInfoUpdateEvent(throughDtoDefine.getId()));
                } else {
                    this.mqMessageAction.sendMsgOrderStatusChange((DgPerformOrderRespDto)dgB2BOrderStatusChangeEvent, dgB2BOrderStatusChangeEvent.getBeforeStatus(), dgB2BOrderStatusChangeEvent.getChangeByEvent());
                }
            }
        }
    }

    public DgStatemachineStateResult<DgB2BOrderMachineStatus, DgB2BOrderMachineEvents, DgB2BOrderThroughRespDto> queryStateByThroughId(Long throughId, CisBaseOrderMessageHeaders<?, DgB2BOrderMachineStatus, DgB2BOrderMachineEvents, ?, DgB2BOrderThroughRespDto> contextObj) {
        DgB2BOrderThroughRespDto nowDto = (DgB2BOrderThroughRespDto)contextObj.getThroughDto();
        CisStatemachineAssert.notNull((Object)((Object)nowDto), (CisStatemachineExceptionCode)CisStatemachineExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u8bfb\u53d6\u5b9e\u4f53\u4e0d\u5141\u8bb8\u4e3a\u7a7a"});
        CisStatemachineAssert.notNull((Object)nowDto.getId(), (CisStatemachineExceptionCode)CisStatemachineExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u8bfb\u53d6\u5b9e\u4f53id\u4e0d\u5141\u8bb8\u4e3a\u7a7a"});
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(nowDto.getId());
        CisStatemachineAssert.notNull((Object)saleOrderRespDto, (CisStatemachineExceptionCode)CisStatemachineExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u83b7\u53d6\u4e0d\u5230\u5b9e\u4f53\u4fe1\u606f"});
        CisStatemachineAssert.needEquals((Object)saleOrderRespDto.getBizModel(), (Object)DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), (CisStatemachineExceptionCode)CisStatemachineExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u8ba2\u5355\u6a21\u578b\u4e0d\u4e00\u81f4"});
        DgB2BOrderMachineStatus state = Optional.of(this.exchangeStateBySaleOrderRespDto(saleOrderRespDto)).orElseThrow(() -> CisStatemachineExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u72b6\u6001"}));
        DgB2BOrderThroughRespDto nowRespDto = new DgB2BOrderThroughRespDto();
        CubeBeanUtils.copyProperties((Object)((Object)nowRespDto), (Object)saleOrderRespDto, (String[])new String[0]);
        LOGGER.info("<<<<<\u5b9e\u4f53{}\u6062\u590d\u5230'{}'\u72b6\u6001>>>>>", (Object)throughId, (Object)state.getCode());
        return DgStatemachineStateResult.builder().state((Object)state).throughDto((ThroughDtoDefine)nowRespDto).build();
    }

    public boolean checkNeedSaveState(DgB2BOrderMachineStatus state) throws Exception {
        return !DgB2BOrderMachineStatus.EMPTY.equals((Object)state);
    }

    private DgB2BOrderMachineStatus exchangeStateBySaleOrderRespDto(DgPerformOrderRespDto contextObj) {
        return DgB2BOrderMachineStatus.exchangeDgB2BOrderStatus(contextObj.getOmsSaleOrderStatus());
    }

    private void supplementStateBySaleOrderRespDto(DgPerformOrderInfoEo updateEo, DgB2BOrderMachineStatus dgSaleOrderMachineStates) {
        dgSaleOrderMachineStates.getDgB2BOrderStatusRelEnumsSet().stream().limit(1L).forEach(cisSaleOrderStatusRelEnum -> {
            updateEo.setOrderStatus(Optional.ofNullable(cisSaleOrderStatusRelEnum.getShowStatus()).map(DgB2BOrderStatus::getCode).orElse(cisSaleOrderStatusRelEnum.getTargetStatus().getCode()));
            updateEo.setOmsSaleOrderStatus(cisSaleOrderStatusRelEnum.getTargetStatus().getCode());
        });
    }

    private void saveStrategyPoolOrder(DgB2BOrderThroughRespDto throughDto, String afterStatus) {
        DgB2BOrderStatus beforeDgB2BOrderStatus = DgB2BOrderStatus.forCode(throughDto.getOmsSaleOrderStatus());
        DgB2BOrderStatus afterDgB2BOrderStatus = DgB2BOrderStatus.forCode(afterStatus);
        switch (afterDgB2BOrderStatus) {
            case WAIT_AUDIT: {
                if (!beforeDgB2BOrderStatus.equals((Object)DgB2BOrderStatus.CREATED)) break;
                this.forwardAddPoolAndRemovePool(throughDto, null, DgCisStrategyOrderTypeEnum.ORDER_REVIEW);
                break;
            }
            case WAIT_CHECK: {
                if (!beforeDgB2BOrderStatus.equals((Object)DgB2BOrderStatus.WAIT_AUDIT)) break;
                this.forwardAddPoolAndRemovePool(throughDto, DgCisStrategyOrderTypeEnum.ORDER_REVIEW, DgCisStrategyOrderTypeEnum.ORDER_CONFIRM);
                break;
            }
            case WAIT_PICK: {
                if (!beforeDgB2BOrderStatus.equals((Object)DgB2BOrderStatus.WAIT_CHECK)) break;
                this.forwardAddPoolAndRemovePool(throughDto, DgCisStrategyOrderTypeEnum.ORDER_CONFIRM, DgCisStrategyOrderTypeEnum.AUTOMATIC_ALLOCATION);
                break;
            }
            case PICKED: {
                if (!beforeDgB2BOrderStatus.equals((Object)DgB2BOrderStatus.WAIT_PICK)) break;
                this.forwardAddPoolAndRemovePool(throughDto, DgCisStrategyOrderTypeEnum.AUTOMATIC_ALLOCATION, DgCisStrategyOrderTypeEnum.AUTOMATIC_DELIVERY);
                break;
            }
            default: {
                this.reverseAddPoolAndRemovePool(throughDto, null, null);
            }
        }
    }

    private void forwardAddPoolAndRemovePool(DgB2BOrderThroughRespDto throughDto, DgCisStrategyOrderTypeEnum beforeType, DgCisStrategyOrderTypeEnum afterType) {
        StrategyPoolDto strategyPoolReqDto = new StrategyPoolDto();
        strategyPoolReqDto.setSaleOrderId(throughDto.getId());
        this.strategyPoolDomain.removeStrategyPool(strategyPoolReqDto);
        StrategyOrderDto strategyOrderReqDto = new StrategyOrderDto();
        strategyOrderReqDto.setSaleOrderId(throughDto.getId());
        this.strategyOrderDomain.modifyStrategyOrderExpired(strategyOrderReqDto);
        StrategyPoolDto pickStrategyPoolDto = new StrategyPoolDto();
        pickStrategyPoolDto.setPoolType(afterType.getCode());
        pickStrategyPoolDto.setSaleOrderId(throughDto.getId());
        this.strategyPoolDomain.addStrategyPool(pickStrategyPoolDto);
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u6dfb\u52a0\u8ba2\u5355\u7f13\u51b2\u6c60\u548c\u8fc7\u671f\u547d\u4e2d\u6c60\u6570\u636e\uff0c\u8ba2\u5355id={}\uff0c\u8ba2\u5355\u53f7={}\uff0c\u6dfb\u52a0\u7f13\u51b2\u7c7b\u578b={}", new Object[]{throughDto.getId(), throughDto.getSaleOrderNo(), afterType.getCode()});
    }

    private void reverseAddPoolAndRemovePool(DgB2BOrderThroughRespDto throughDto, DgCisStrategyOrderTypeEnum beforeType, DgCisStrategyOrderTypeEnum afterType) {
        StrategyPoolDto strategyPoolReqDto = new StrategyPoolDto();
        strategyPoolReqDto.setSaleOrderId(throughDto.getId());
        this.strategyPoolDomain.removeStrategyPool(strategyPoolReqDto);
        StrategyOrderDto strategyOrderReqDto = new StrategyOrderDto();
        strategyOrderReqDto.setSaleOrderId(throughDto.getId());
        this.strategyOrderDomain.modifyStrategyOrderExpired(strategyOrderReqDto);
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u79fb\u9664\u8ba2\u5355\u7f13\u51b2\u6c60\u548c\u8fc7\u671f\u547d\u4e2d\u6c60\u6570\u636e\uff0c\u8ba2\u5355id={}\uff0c\u8ba2\u5355\u53f7={}", (Object)throughDto.getId(), (Object)throughDto.getSaleOrderNo());
    }
}

