/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2b.order.constant;

import com.yunxi.dg.base.center.trade.statemachine.b2b.order.constant.DgB2BOrderStatus;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public enum DgB2BOrderStatusRelEnum {
    CREATED(DgB2BOrderStatus.CREATED),
    DRAFT(DgB2BOrderStatus.DRAFT),
    WAIT_AUDIT(DgB2BOrderStatus.WAIT_AUDIT),
    WAIT_CUSTOMER_AUDIT(DgB2BOrderStatus.WAIT_CUSTOMER_AUDIT),
    WAIT_BUSINESS_AUDIT(DgB2BOrderStatus.WAIT_BUSINESS_AUDIT),
    WAIT_CHECK(DgB2BOrderStatus.WAIT_CHECK),
    LACK(DgB2BOrderStatus.LACK),
    WAIT_PICK(DgB2BOrderStatus.WAIT_PICK),
    PICKED(DgB2BOrderStatus.PICKED),
    WAIT_PICK_UNLOCK(WAIT_PICK, DgB2BOrderStatus.WAIT_PICK_UNLOCK),
    WAIT_WAREHOUSE_SOURCE(WAIT_PICK, DgB2BOrderStatus.WAIT_WAREHOUSE_SOURCE),
    WAIT_LOGISTICS_SOURCE(WAIT_PICK, DgB2BOrderStatus.WAIT_LOGISTICS_SOURCE),
    WAIT_LOCK_INVENTORY(WAIT_PICK, DgB2BOrderStatus.WAIT_LOCK_INVENTORY),
    WAIT_ASSIGN(WAIT_PICK, DgB2BOrderStatus.WAIT_ASSIGN),
    WAIT_DELIVERY(DgB2BOrderStatus.WAIT_DELIVERY),
    DELIVERED(DgB2BOrderStatus.DELIVERED),
    DELIVERY_PART_ONE(DgB2BOrderStatus.DELIVERY_PART),
    DELIVERY_ALL_ONE(DgB2BOrderStatus.DELIVERY_ALL),
    COMPLETE(DgB2BOrderStatus.COMPLETE),
    RECEIVED(DgB2BOrderStatus.RECEIVED),
    CANCEL(DgB2BOrderStatus.CANCEL),
    FINISH(DgB2BOrderStatus.FINISH),
    SPLIT(DgB2BOrderStatus.SPLIT),
    SPLIT_CANCELING(DgB2BOrderStatus.SPLIT, DgB2BOrderStatus.SPLIT_CANCELING),
    CANCELING(DgB2BOrderStatus.CANCELING),
    OBSOLETE(DgB2BOrderStatus.OBSOLETE);

    private final DgB2BOrderStatusRelEnum parenStatus;
    private final String code;
    private final String desc;
    private final DgB2BOrderStatus targetStatus;
    private final DgB2BOrderStatus showStatus;
    public static final Map<String, DgB2BOrderStatusRelEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;
    public static final Map<DgB2BOrderStatus, DgB2BOrderStatusRelEnum> ORDER_STATUS_REL_ENUM_MAP;

    private DgB2BOrderStatusRelEnum(DgB2BOrderStatus targetStatus) {
        this(targetStatus, targetStatus);
    }

    private DgB2BOrderStatusRelEnum(DgB2BOrderStatusRelEnum parenStatus, DgB2BOrderStatus targetStatus) {
        this.code = targetStatus.getCode();
        this.desc = targetStatus.getDesc();
        this.targetStatus = targetStatus;
        this.parenStatus = parenStatus;
        this.showStatus = parenStatus.getTargetStatus();
    }

    private DgB2BOrderStatusRelEnum(DgB2BOrderStatus showStatus, DgB2BOrderStatus targetStatus) {
        this.code = targetStatus.getCode();
        this.desc = targetStatus.getDesc();
        this.targetStatus = targetStatus;
        this.parenStatus = null;
        this.showStatus = showStatus;
    }

    public static DgB2BOrderStatusRelEnum forOrderStatus(DgB2BOrderStatus code) {
        return ORDER_STATUS_REL_ENUM_MAP.get((Object)code);
    }

    public static DgB2BOrderStatusRelEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public DgB2BOrderStatusRelEnum getParenStatus() {
        return this.parenStatus;
    }

    public DgB2BOrderStatus getTargetStatus() {
        return this.targetStatus;
    }

    public DgB2BOrderStatus getShowStatus() {
        return this.showStatus;
    }

    static {
        CODE_LOOKUP = Arrays.stream(DgB2BOrderStatusRelEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(DgB2BOrderStatusRelEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
        ORDER_STATUS_REL_ENUM_MAP = new ConcurrentHashMap<DgB2BOrderStatus, DgB2BOrderStatusRelEnum>();
        Arrays.stream(DgB2BOrderStatusRelEnum.values()).forEach(state -> ORDER_STATUS_REL_ENUM_MAP.put(state.getTargetStatus(), (DgB2BOrderStatusRelEnum)((Object)state)));
    }
}

