/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.config.engine.action;

import com.dtyunxi.cube.statemachine.engine.action.AbstractCisBaseStatemachineAction;
import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.dtyunxi.util.JacksonUtil;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderBizTypeEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderBizTypeEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.PlatformServiceTypeEnum;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.constant.DgB2CAfterSaleActionDefineEnum;
import com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.constant.DgB2CAfterSaleMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.constant.DgB2CAfterSaleMachineStatus;
import com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.vo.DgB2CAfterSaleThroughRespDto;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgAfterFillServiceTypeAndBizTypeAction
extends AbstractCisBaseStatemachineAction<DgB2CAfterSaleActionDefineEnum, DgB2CAfterSaleMachineStatus, DgB2CAfterSaleMachineEvents, DgBizAfterSaleOrderReqDto, DgBizAfterSaleOrderReqDto, DgB2CAfterSaleThroughRespDto> {
    private static final Logger logger = LoggerFactory.getLogger(DgAfterFillServiceTypeAndBizTypeAction.class);

    public DgAfterFillServiceTypeAndBizTypeAction() {
        super((CisActionDefine)DgB2CAfterSaleActionDefineEnum.FILL_SERVICE_AND_BUSINESS_TYPE, false);
    }

    public DgBizAfterSaleOrderReqDto executeSub(DgB2CAfterSaleThroughRespDto throughSaleOrderDto, DgBizAfterSaleOrderReqDto request) {
        logger.info("fillServiceTypeAndBizType throughSaleOrderDto: {}", (Object)JacksonUtil.toJson((Object)((Object)throughSaleOrderDto)));
        logger.info("fillServiceTypeAndBizType request: {}", (Object)JacksonUtil.toJson((Object)request));
        String bizType = request.getBizType();
        if (PlatformServiceTypeEnum.WX.getCode().equals(bizType)) {
            request.setBizType(DgAfterSaleOrderBizTypeEnum.WX.getCode());
            request.setServiceType(DgSaleOrderBizTypeEnum.WX.getCode());
        } else {
            List itemList = request.getAfterSaleOrderItemReqDtoList();
            Set returnItemSet = itemList.stream().filter(item -> item.getAfterSaleOrderItemType() == 0).map(item -> item.getSkuCode() + item.getItemNum()).collect(Collectors.toSet());
            Set exchangeItemSet = itemList.stream().filter(item -> item.getAfterSaleOrderItemType() == 1).map(item -> item.getSkuCode() + item.getItemNum()).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(returnItemSet) || CollectionUtils.isEmpty(exchangeItemSet)) {
                request.setBizType(DgAfterSaleOrderBizTypeEnum.WX.getCode());
                request.setServiceType(DgSaleOrderBizTypeEnum.WX.getCode());
                return request;
            }
            if (returnItemSet.size() != exchangeItemSet.size()) {
                request.setBizType(DgAfterSaleOrderBizTypeEnum.A2B.getCode());
                request.setServiceType(DgSaleOrderBizTypeEnum.A2B.getCode());
                return request;
            }
            boolean completeMatch = true;
            for (String returnKey : returnItemSet) {
                if (exchangeItemSet.contains(returnKey)) continue;
                completeMatch = false;
                break;
            }
            if (completeMatch) {
                request.setBizType(DgAfterSaleOrderBizTypeEnum.A2A.getCode());
                request.setServiceType(DgSaleOrderBizTypeEnum.A2A.getCode());
            } else {
                request.setBizType(DgAfterSaleOrderBizTypeEnum.A2B.getCode());
                request.setServiceType(DgSaleOrderBizTypeEnum.A2B.getCode());
            }
        }
        logger.info("fillServiceTypeAndBizType response bizType: {},serviceType: {}", (Object)request.getBizType(), (Object)request.getServiceType());
        return request;
    }
}

