/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.tc.order.config.engine.action;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.statemachine.engine.action.AbstractCisBaseStatemachineAction;
import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AllotTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderBySourceInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.trade.action.tc.IDgTcPerformOrderOptAction;
import com.yunxi.dg.base.center.trade.baseservice.BInventoryApiServcie;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderActionDefineEnum;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.constant.DgTcOrderMachineStatus;
import com.yunxi.dg.base.center.trade.statemachine.tc.order.vo.DgTcOrderThroughRespDto;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgTcMaiyouArrangeWarehouseDeliveryAction
extends AbstractCisBaseStatemachineAction<DgTcOrderActionDefineEnum, DgTcOrderMachineStatus, DgTcOrderMachineEvents, Object, RestResponse<Boolean>, DgTcOrderThroughRespDto> {
    private static final Logger logger = LoggerFactory.getLogger(DgTcMaiyouArrangeWarehouseDeliveryAction.class);
    @Resource
    private IDgTcPerformOrderOptAction dgTcPerformOrderOptAction;
    @Resource
    private ISaleOrderService saleOrderService;
    @Resource
    private ISaleOrderItemService saleOrderItemService;
    @Resource
    private BInventoryApiServcie bInventoryApiServcie;
    @Resource
    private IInventoryApi inventoryApi;

    public DgTcMaiyouArrangeWarehouseDeliveryAction() {
        super((CisActionDefine)DgTcOrderActionDefineEnum.MAIYOU_ARRANGE_WAREHOUSE_DELIVERY, false);
    }

    public RestResponse<Boolean> executeSub(DgTcOrderThroughRespDto throughSaleOrderDto, Object request) {
        logger.info("\u8fdb\u5165\u9ea6\u4f18\u8ba2\u5355-\u6307\u5b9a\u903b\u8f91\u4ed3\u914d\u8d27");
        SaleOrderRespDto saleOrderRespDto = this.saleOrderService.querySaleOrderById(throughSaleOrderDto.getId());
        if (!Objects.equals(saleOrderRespDto.getAllotType(), AllotTypeEnum.MAIYOU_BC_SAME_ORG_ALLOT.getType())) {
            throw new BizException("\u975ebc\u540c\u7ec4\u7ec7\u8c03\u62e8\u6d41\u7a0b\u5f02\u5e38:" + saleOrderRespDto.getAllotType());
        }
        List orderItemRespDtoList = this.saleOrderItemService.queryOrderItemByOrderId(throughSaleOrderDto.getId());
        List<SplitOrderBySourceInfoReqDto> sourceInfoReqDtoList = this.convertSourceInfoReqDtoList(saleOrderRespDto, orderItemRespDtoList);
        ReleasePreemptDto releasePreemptDto = new ReleasePreemptDto();
        if (ObjectUtil.isEmpty((Object)releasePreemptDto.getIsSaleOrder())) {
            releasePreemptDto.setIsSaleOrder(Boolean.TRUE);
        }
        releasePreemptDto.setSourceType(saleOrderRespDto.getOrderType());
        releasePreemptDto.setSourceNo(saleOrderRespDto.getPlatformOrderNo());
        releasePreemptDto.setEmptyForError(Boolean.valueOf(false));
        logger.info("\u903b\u8f91\u5e93\u5b58\u9884\u5360preemptLogicInventory\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)releasePreemptDto));
        RestResponseHelper.extractData((RestResponse)this.inventoryApi.releaseLogicPreempt(releasePreemptDto));
        this.dgTcPerformOrderOptAction.maiyouAllotDelivery(throughSaleOrderDto.getId(), sourceInfoReqDtoList);
        return new RestResponse((Object)Boolean.TRUE);
    }

    private List<SplitOrderBySourceInfoReqDto> convertSourceInfoReqDtoList(SaleOrderRespDto saleOrder, List<SaleOrderItemRespDto> orderItemRespDtoList) {
        ArrayList<SplitOrderBySourceInfoReqDto> list = new ArrayList<SplitOrderBySourceInfoReqDto>();
        SplitOrderBySourceInfoReqDto splitOrderReqDto = new SplitOrderBySourceInfoReqDto();
        splitOrderReqDto.setSaleOrderId(saleOrder.getId());
        splitOrderReqDto.setSaleOrderNo(saleOrder.getSaleOrderNo());
        splitOrderReqDto.setIntransitPreemptFlag(Boolean.valueOf(false));
        splitOrderReqDto.setDeliveryType(saleOrder.getAllotType());
        List csLogicWarehousePageRespDtos = this.bInventoryApiServcie.queryCsLogicWarehousePageRespDtoListByCodeList(Collections.singletonList(saleOrder.getMyArrangeLogicalWarehouseCode()));
        AssertUtils.notEmpty((Collection)csLogicWarehousePageRespDtos, (String)("\u83b7\u53d6\u4e0d\u5230" + saleOrder.getMyArrangeLogicalWarehouseCode() + "\u903b\u8f91\u4ed3\u4fe1\u606f"));
        splitOrderReqDto.setDeliveryLogicWarehouseCode(((CsLogicWarehouseRespDto)csLogicWarehousePageRespDtos.get(0)).getWarehouseCode());
        splitOrderReqDto.setDeliveryLogicWarehouseId(((CsLogicWarehouseRespDto)csLogicWarehousePageRespDtos.get(0)).getId());
        splitOrderReqDto.setDeliveryLogicWarehouseName(((CsLogicWarehouseRespDto)csLogicWarehousePageRespDtos.get(0)).getWarehouseName());
        splitOrderReqDto.setInLogicWarehouseCode(saleOrder.getAllotInWarehouseCode());
        splitOrderReqDto.setInLogicWarehouseName(saleOrder.getAllotInWarehouseName());
        ArrayList goodsList = Lists.newArrayList();
        for (SaleOrderItemRespDto saleOrderItemRespDto : orderItemRespDtoList) {
            SplitOrderItemReqDto splitOrderItemReqDto = new SplitOrderItemReqDto();
            splitOrderItemReqDto.setDeliveryItemBatchNo(saleOrderItemRespDto.getDeliveryItemBatchNo());
            splitOrderItemReqDto.setGoodsCode(saleOrderItemRespDto.getItemCode());
            splitOrderItemReqDto.setGoodsId(saleOrderItemRespDto.getItemId());
            splitOrderItemReqDto.setIsGiftFlag(Integer.valueOf(0));
            splitOrderItemReqDto.setGoodsNum(saleOrderItemRespDto.getItemNum());
            splitOrderItemReqDto.setGoodsSku(saleOrderItemRespDto.getSkuCode());
            splitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemRespDto.getId());
            splitOrderItemReqDto.setWarehouseItemNum(saleOrderItemRespDto.getItemNum());
            goodsList.add(splitOrderItemReqDto);
        }
        splitOrderReqDto.setGoodsList((List)goodsList);
        list.add(splitOrderReqDto);
        logger.info("bc\u8de8\u7ec4\u7ec7\u8c03\u62e8\u9500\u552e\u5355\u53d1\u8d27\u5165\u53c2={}", (Object)JSON.toJSONString(list));
        return list;
    }
}

