/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant;

import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderStatus;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum DgB2COrderStatusRelEnum {
    CREATED(DgB2COrderStatus.CREATED),
    DRAFT(DgB2COrderStatus.DRAFT),
    WAIT_CUSTOMER_AUDIT(DgB2COrderStatus.WAIT_CUSTOMER_AUDIT),
    WAIT_BUSINESS_AUDIT(DgB2COrderStatus.WAIT_BUSINESS_AUDIT),
    WAIT_CHECK(DgB2COrderStatus.WAIT_CHECK),
    LACK(DgB2COrderStatus.LACK),
    WAIT_PICK(DgB2COrderStatus.WAIT_PICK),
    PICKED(DgB2COrderStatus.PICKED),
    WAIT_PICK_UNLOCK(WAIT_PICK, DgB2COrderStatus.WAIT_PICK_UNLOCK),
    WAIT_WAREHOUSE_SOURCE(WAIT_PICK, DgB2COrderStatus.WAIT_WAREHOUSE_SOURCE),
    WAIT_LOGISTICS_SOURCE(WAIT_PICK, DgB2COrderStatus.WAIT_LOGISTICS_SOURCE),
    WAIT_LOCK_INVENTORY(WAIT_PICK, DgB2COrderStatus.WAIT_LOCK_INVENTORY),
    WAIT_ASSIGN(WAIT_PICK, DgB2COrderStatus.WAIT_ASSIGN),
    WAIT_DELIVERY(DgB2COrderStatus.WAIT_DELIVERY),
    DELIVERED(DgB2COrderStatus.DELIVERED),
    DELIVERY_PART(DELIVERED, DgB2COrderStatus.DELIVERY_PART),
    DELIVERY_ALL(DELIVERED, DgB2COrderStatus.DELIVERY_ALL),
    COMPLETE(DgB2COrderStatus.COMPLETE),
    RECEIVED(DgB2COrderStatus.RECEIVED),
    CANCEL(DgB2COrderStatus.CANCEL),
    FINISH(DgB2COrderStatus.FINISH),
    SPLIT(DgB2COrderStatus.SPLIT),
    SPLIT_CANCELING(DgB2COrderStatus.SPLIT, DgB2COrderStatus.SPLIT_CANCELING),
    CANCELING(DgB2COrderStatus.CANCELING),
    OBSOLETE(DgB2COrderStatus.OBSOLETE);

    private final DgB2COrderStatusRelEnum parenStatus;
    private final String code;
    private final String desc;
    private final DgB2COrderStatus targetStatus;
    private final DgB2COrderStatus showStatus;
    public static final Map<String, DgB2COrderStatusRelEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private DgB2COrderStatusRelEnum(DgB2COrderStatus targetStatus) {
        this(targetStatus, targetStatus);
    }

    private DgB2COrderStatusRelEnum(DgB2COrderStatusRelEnum parenStatus, DgB2COrderStatus targetStatus) {
        this.code = targetStatus.getCode();
        this.desc = targetStatus.getDesc();
        this.targetStatus = targetStatus;
        this.parenStatus = parenStatus;
        this.showStatus = parenStatus.getTargetStatus();
    }

    private DgB2COrderStatusRelEnum(DgB2COrderStatus showStatus, DgB2COrderStatus targetStatus) {
        this.code = targetStatus.getCode();
        this.desc = targetStatus.getDesc();
        this.targetStatus = targetStatus;
        this.parenStatus = null;
        this.showStatus = showStatus;
    }

    public static DgB2COrderStatusRelEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public DgB2COrderStatusRelEnum getParenStatus() {
        return this.parenStatus;
    }

    public DgB2COrderStatus getTargetStatus() {
        return this.targetStatus;
    }

    public DgB2COrderStatus getShowStatus() {
        return this.showStatus;
    }

    static {
        CODE_LOOKUP = Arrays.stream(DgB2COrderStatusRelEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(DgB2COrderStatusRelEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

