/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.controller;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.controller.BaseHandleExceptionController;
import com.cyberway.msf.commons.base.service.BaseService;
import com.cyberway.msf.commons.base.util.BusinessPreconditions;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.commons.model.filter.FilterModel;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class BaseController<T extends EntityImpl>
extends BaseHandleExceptionController {
    @Autowired
    private BaseService<T> baseServiceImpl;

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/{id}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", paramType="path", required=true, dataType="string")})
    public ApiResponseResult<T> selectById(@PathVariable String id) {
        return this.getById(id, this.baseServiceImpl);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    @ApiImplicitParams(value={@ApiImplicitParam(name="filterModel", value="\u5206\u9875", paramType="body", required=true, dataType="FilterModel")})
    public ApiResponseResult<PageDataModel<T>> listSite(@RequestBody FilterModel filterModel) {
        ApiResponseResult res = null;
        PageDataModel<T> pageDataModel = this.baseServiceImpl.selectByFiltersPaging(filterModel);
        res = new ApiResponseResult(ApiResultCode.SUCCESS, pageDataModel);
        return res;
    }

    @ApiOperation(value="\u65b0\u589e\u5b9e\u4f53")
    @PostMapping
    public ApiResponseResult insert(@RequestBody @Valid T entity) {
        return this.insert(entity, this.baseServiceImpl);
    }

    @ApiOperation(value="\u4fee\u6539\u5b9e\u4f53")
    @PutMapping(value={"/{id}"})
    public ApiResponseResult updateSite(@PathVariable String id, @RequestBody @Valid T entity) {
        return this.update(id, entity, this.baseServiceImpl);
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u5b9e\u4f53")
    @DeleteMapping(value={"/{id}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", paramType="path", required=true, dataType="string")})
    public ApiResponseResult deleteSite(@PathVariable String id) {
        return this.batchDelete(Lists.newArrayList((Object[])new String[]{id}), this.baseServiceImpl);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @DeleteMapping
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id", paramType="body", required=true, allowMultiple=true, dataType="string")})
    public ApiResponseResult deleteSite(@RequestBody List<String> ids) {
        return this.batchDelete(ids, this.baseServiceImpl);
    }

    protected ApiResponseResult<T> getById(String id, BaseService<T> baseServiceImpl) {
        BusinessPreconditions.checkArgument(StringUtils.isNotEmpty((CharSequence)id), MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, "id"));
        EntityImpl entity = (EntityImpl)baseServiceImpl.selectById(id);
        if (null != entity) {
            return new ApiResponseResult(ApiResultCode.SUCCESS, (Object)entity);
        }
        throw MessageUtils.buildException(ApiResultCode.GET_DATA_NOT_EXIST, id);
    }

    protected ApiResponseResult<List<T>> selectByFilters(FilterModel filterModel, BaseService<T> baseServiceImpl) {
        BusinessPreconditions.checkArgument(filterModel != null, MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, new Object[0]));
        List<T> entities = baseServiceImpl.selectByFilters(filterModel);
        return new ApiResponseResult(ApiResultCode.SUCCESS, entities);
    }

    protected ApiResponseResult<Serializable> insert(T entity, BaseService<T> baseServiceImpl) {
        if (entity.getId() != null) {
            throw MessageUtils.buildException(ApiResultCode.PARAM_NOT_ALLOW, "id");
        }
        int sum = baseServiceImpl.insert(entity);
        if (sum > 0) {
            return new ApiResponseResult(ApiResultCode.SUCCESS, (Object)entity.getId());
        }
        throw MessageUtils.buildException(ApiResultCode.INSERT_DATA_FAIL, new Object[0]);
    }

    protected ApiResponseResult<Integer> batchDelete(List<String> ids, BaseService baseService) {
        if (CollectionUtils.isEmpty(ids)) {
            throw MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, "ids");
        }
        int sum = baseService.batchDelete(ids);
        if (sum > 0) {
            return new ApiResponseResult(ApiResultCode.SUCCESS, (Object)sum);
        }
        throw MessageUtils.buildException(ApiResultCode.DELETE_DATA_FAIL, new Object[0]);
    }

    public ApiResponseResult<Integer> update(String id, T entity, BaseService<T> baseServiceImpl) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, "id");
        }
        entity.setId((Serializable)((Object)id));
        int sum = baseServiceImpl.update(entity);
        if (sum > 0) {
            return new ApiResponseResult(ApiResultCode.SUCCESS, (Object)sum);
        }
        throw MessageUtils.buildException(ApiResultCode.UPDATE_DATA_FAIL, new Object[0]);
    }
}

