/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.annotation.log;

import com.cyberway.msf.commons.base.support.annotation.log.LogRequired;
import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.util.JsonUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.log.model.BussinessLog;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class LogAspect {
    @Autowired
    private AmqpTemplate rabbitTemplate;
    @Autowired
    private CommonsBaseProperties commonsBaseProperties;

    @Pointcut(value="execution(@com.cyberway.msf.commons.base.support.annotation.log.LogRequired * *(..))")
    public void log() {
    }

    @AfterReturning(value="log() && @annotation(logRequired)", returning="ret")
    public void doAfterReturning(LogRequired logRequired, Object ret) throws BaseException {
        String content = logRequired.content();
        if (null != ret) {
            String phraseStr;
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setVariable("ret", ret);
            SpelExpressionParser parser = new SpelExpressionParser();
            Expression exp = parser.parseExpression(logRequired.content());
            content = phraseStr = (String)exp.getValue((EvaluationContext)context);
        }
        String fromIp = "";
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            fromIp = request.getRemoteAddr();
        }
        BussinessLog log = new BussinessLog();
        log.setContent(content);
        log.setFromIp(fromIp);
        log.setCreateTime(new Date());
        log.setModule(logRequired.module().getCode());
        UserInfo userInfo = UserUtils.getLoggedInUser();
        log.setCreateBy(userInfo == null ? null : userInfo.getUsername());
        if (this.commonsBaseProperties.getLogEnable().booleanValue()) {
            this.rabbitTemplate.convertAndSend("exchange.common.logs", "topic.common.logs", (Object)JsonUtils.toJson(log));
        }
    }
}

