/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.helper;

import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.model.base.BusinessEntity;
import com.cyberway.msf.commons.model.base.BusinessEntityWithCommunity;
import com.cyberway.msf.commons.model.base.BusinessEntityWithCompany;
import com.cyberway.msf.commons.model.base.BusinessEntityWithOrganization;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamHelper {
    private static final Map<Class<?>, Map<String, Method>> CLASS_PROPERTIES_MAP = new HashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(ParamHelper.class);

    private ParamHelper() {
    }

    public static void validateNotBlank(Object param, boolean allowNull, String ... properties) {
        if (!CLASS_PROPERTIES_MAP.containsKey(param.getClass())) {
            ParamHelper.initClassMethods(param.getClass());
        }
        Map<String, Method> propertiesMap = CLASS_PROPERTIES_MAP.get(param.getClass());
        for (String property : properties) {
            if (propertiesMap.containsKey(property)) {
                try {
                    Object value = propertiesMap.get(property).invoke(param, new Object[0]);
                    if (!allowNull && value == null || value != null && StringUtils.isBlank((CharSequence)value.toString())) {
                        throw MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, property);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Fail to read value of property " + property + " of class " + param.getClass().getName(), (Throwable)e);
                }
                continue;
            }
            LOGGER.warn("Unknown property {} of class {}", (Object)property, (Object)param.getClass().getName());
        }
    }

    public static void cleanBusinessEntityWithCommunityForUpdate(BusinessEntityWithCommunity businessEntityWithCommunity) {
        ParamHelper.cleanBusinessEntityWithCompanyForUpdate((BusinessEntityWithCompany)businessEntityWithCommunity);
        businessEntityWithCommunity.setCommunityId(null);
    }

    public static void cleanBusinessEntityWithCompanyForUpdate(BusinessEntityWithCompany businessEntityWithCompany) {
        ParamHelper.cleanBusinessEntityWithOrganizationForUpdate((BusinessEntityWithOrganization)businessEntityWithCompany);
        businessEntityWithCompany.setCompanyId(null);
    }

    public static void cleanBusinessEntityWithOrganizationForUpdate(BusinessEntityWithOrganization businessEntityWithOrganization) {
        ParamHelper.cleanBusinessEntityForUpdate((BusinessEntity)businessEntityWithOrganization);
        businessEntityWithOrganization.setOrg(null);
    }

    public static void cleanBusinessEntityForUpdate(BusinessEntity businessEntity) {
        businessEntity.setCreatedBy(null);
        businessEntity.setCreatedByName(null);
        businessEntity.setCreatedDate(null);
        businessEntity.setLastModified(null);
        businessEntity.setLastModifiedBy(null);
        businessEntity.setLastModifiedByName(null);
        businessEntity.setOwner(null);
        businessEntity.setSystemLastModified(null);
    }

    public static void validateNotNull(Object param, String ... properties) {
        if (!CLASS_PROPERTIES_MAP.containsKey(param.getClass())) {
            ParamHelper.initClassMethods(param.getClass());
        }
        Map<String, Method> propertiesMap = CLASS_PROPERTIES_MAP.get(param.getClass());
        for (String property : properties) {
            if (propertiesMap.containsKey(property)) {
                try {
                    Object value = propertiesMap.get(property).invoke(param, new Object[0]);
                    if (value == null) {
                        throw MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, property);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Fail to read value of property " + property + " of class " + param.getClass().getName(), (Throwable)e);
                }
                continue;
            }
            LOGGER.warn("Unknown property {} of class {}", (Object)property, (Object)param.getClass().getName());
        }
    }

    private static void initClassMethods(Class<?> clazz) {
        HashMap<String, Method> propertiesMap = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || method.getReturnType().equals(Void.TYPE) || method.getParameterCount() != 0) continue;
            String methodName = method.getName();
            if (methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3))) {
                propertiesMap.put(methodName.substring(3, 4).toLowerCase() + methodName.substring(4), method);
                continue;
            }
            if (!methodName.startsWith("is") || methodName.length() <= 2 || !Character.isUpperCase(methodName.charAt(2)) || !method.getReturnType().equals(Boolean.TYPE)) continue;
            propertiesMap.put(methodName.substring(2, 3).toLowerCase() + methodName.substring(3), method);
        }
        CLASS_PROPERTIES_MAP.put(clazz, propertiesMap);
    }
}

