/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.multitable;

import com.cyberway.msf.commons.base.support.multitable.MultiTableResultCode;
import com.cyberway.msf.commons.base.support.multitable.SelectBaseExample;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTableSelectExample
extends SelectBaseExample {
    private static final Logger logger = LoggerFactory.getLogger(MultiTableSelectExample.class);
    private boolean leftJoinFlag = false;
    private String leftJoinOn;

    public MultiTableSelectExample(Class<?> entityClass) {
        super(entityClass);
        super.setUseMultipart(true);
    }

    public MultiTableSelectExample(String tableName, String alias) {
        super(tableName, alias);
        super.setUseMultipart(true);
    }

    public MultiTableSelectExample(String tableName) {
        super(tableName);
        super.setUseMultipart(true);
    }

    @Override
    public void end() throws BaseException {
        super.end();
        if (this.leftJoinFlag && StringUtils.isBlank((CharSequence)this.leftJoinOn)) {
            throw MessageUtils.buildException(MultiTableResultCode.LACK_OF_ON_EXPRESSION, new Object[0]);
        }
    }

    @Override
    public MultiTableSelectExample groupBy(String field) {
        super.groupBy(field);
        return this;
    }

    @Override
    public MultiTableSelectExample orderBy(String field, String orderType) {
        super.orderBy(field, orderType);
        return this;
    }

    public MultiTableSelectExample addLeftJoin(String tableName, String alias, String on) {
        this.leftJoinFlag = true;
        super.addTableName(tableName);
        super.addAlias(alias, tableName);
        this.leftJoinOn = on;
        return this;
    }

    public boolean isLeftJoinFlag() {
        return this.leftJoinFlag;
    }

    public void setLeftJoinFlag(boolean leftJoinFlag) {
        this.leftJoinFlag = leftJoinFlag;
    }

    public String getLeftJoinOn() {
        return this.leftJoinOn;
    }

    public void setLeftJoinOn(String leftJoinOn) {
        this.leftJoinOn = leftJoinOn;
    }
}

