/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.multitable;

import com.cyberway.msf.commons.base.support.multitable.BaseExample;
import com.cyberway.msf.commons.core.exception.BaseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tk.mybatis.mapper.entity.EntityTable;
import tk.mybatis.mapper.mapperhelper.EntityHelper;

public class SelectBaseExample
extends BaseExample {
    private static final Logger logger = LoggerFactory.getLogger(SelectBaseExample.class);
    private Map<String, Object> order;
    private String groupBy;
    private List<String> fields;

    public SelectBaseExample(Class<?> entityClass) {
        super(entityClass);
        super.setUseMultipart(false);
        EntityTable table = EntityHelper.getEntityTable(entityClass);
        super.addTableName(table.getName());
        super.addAlias(table.getName(), table.getName());
    }

    public SelectBaseExample(String tableName, String alias, Map<String, Object> orderBy, String groupBy) {
        super(null);
        super.setUseMultipart(false);
        super.addTableName(tableName);
        super.addAlias(alias, tableName);
        this.order = orderBy;
        this.groupBy = groupBy;
    }

    public SelectBaseExample(String tableName, String alias) {
        super(null);
        super.setUseMultipart(false);
        super.addTableName(tableName);
        super.addAlias(alias, tableName);
    }

    public SelectBaseExample(String tableName) {
        super(null);
        super.setUseMultipart(false);
        super.addTableName(tableName);
    }

    @Override
    public void end() throws BaseException {
        super.end();
        if (this.fields == null || this.fields.size() == 0) {
            logger.debug("\u672a\u4f20\u5165\u5b57\u6bb5\uff0c\u9ed8\u8ba4\u9009\u62e9\u67e5\u8be2\u6240\u6709\u5b57\u6bb5\uff01");
            this.fields = new ArrayList<String>();
            this.fields.add("*");
        }
    }

    public SelectBaseExample addField(String field) {
        if (this.fields == null) {
            this.fields = new ArrayList<String>();
        }
        this.fields.add(field);
        return this;
    }

    public SelectBaseExample addField(List fields) {
        if (this.fields == null) {
            this.fields = new ArrayList<String>();
        }
        this.fields.addAll(fields);
        return this;
    }

    public SelectBaseExample orderBy(String field, String orderType) {
        if (this.order == null) {
            this.order = new HashMap<String, Object>();
        }
        this.order.put(field, orderType);
        return this;
    }

    public SelectBaseExample groupBy(String field) {
        this.groupBy = field;
        return this;
    }

    public void leftJoin(String table) {
    }

    public void leftJoin(String table, String alias) {
    }

    public Map<String, Object> getOrder() {
        return this.order;
    }

    public void setOrder(Map<String, Object> order) {
        this.order = order;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }
}

