/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.controller;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.controller.BaseHandleExceptionController;
import com.cyberway.msf.commons.base.service.BaseService;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.model.base.EntityImpl;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

public class BaseVoController<T extends EntityImpl>
extends BaseHandleExceptionController {
    @Autowired
    protected BaseService<T> baseServiceImpl;

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u5b9e\u4f53", position=1)
    @DeleteMapping(value={"/{id}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", paramType="path", required=true, dataType="string")})
    public ApiResponseResult delete(@PathVariable String id) {
        return this.batchDelete(Lists.newArrayList((Object[])new String[]{id}), this.baseServiceImpl);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664", position=1)
    @DeleteMapping
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id", paramType="body", required=true, allowMultiple=true, dataType="string")})
    public ApiResponseResult batchDelete(@RequestBody List<String> ids) {
        return this.batchDelete(ids, this.baseServiceImpl);
    }

    protected ApiResponseResult<Integer> batchDelete(List<String> ids, BaseService baseService) {
        if (CollectionUtils.isEmpty(ids)) {
            throw MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, "ids");
        }
        int sum = baseService.batchDelete(ids);
        if (sum > 0) {
            return new ApiResponseResult(ApiResultCode.SUCCESS);
        }
        throw MessageUtils.buildException(ApiResultCode.DELETE_DATA_FAIL, new Object[0]);
    }
}

