/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.annotation.api;

import com.alibaba.fastjson.JSON;
import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.support.converter.ErrorCodeConverter;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.owasp.encoder.Encode;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.NestedServletException;

@Component
public class ExceptionHandlerFilter
extends OncePerRequestFilter {
    private final ErrorCodeConverter errorCodeConverter;

    public ExceptionHandlerFilter(ErrorCodeConverter errorCodeConverter) {
        this.errorCodeConverter = errorCodeConverter;
    }

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (NestedServletException e) {
            this.setErrorResponse(request, response, (Exception)((Object)e));
        }
    }

    private void setErrorResponse(HttpServletRequest request, HttpServletResponse response, Exception exception) {
        this.logger.warn((Object)"got a Exception", (Throwable)exception);
        String message = "";
        String exceptionCode = "";
        int httpStatus = HttpStatus.INTERNAL_SERVER_ERROR.value();
        if (exception instanceof NestedServletException && exception.getCause() instanceof BaseException) {
            BaseException baseException = (BaseException)exception.getCause();
            exceptionCode = baseException.getCode();
            Object[] args = baseException.getValues();
            if (StringUtils.isNotBlank((CharSequence)exceptionCode)) {
                httpStatus = this.errorCodeConverter.convertErrorCodeToHttpStatus(exceptionCode);
                message = MessageUtils.getErrorMessage(exceptionCode, baseException.getMessage(), request, args);
            } else {
                String string = message = args == null ? baseException.getMessage() : String.format(baseException.getMessage(), args);
            }
        }
        if (StringUtils.isBlank((CharSequence)exceptionCode)) {
            exceptionCode = ApiResultCode.UNKNOWN_SYSTEM_ERROR.getResultCode();
        }
        if (StringUtils.isBlank((CharSequence)message)) {
            message = ApiResultCode.UNKNOWN_SYSTEM_ERROR.getResultMessage();
        }
        String uri = request.getRequestURI();
        response.setStatus(httpStatus);
        try {
            if (StringUtils.contains((CharSequence)uri, (CharSequence)"/api/")) {
                String json = JSON.toJSONString((Object)new ApiResponseResult(exceptionCode, message));
                response.setContentType("application/json;charset=utf-8");
                response.getWriter().write(Encode.forHtml((String)json));
            } else {
                response.getWriter().write(Encode.forHtml((String)String.format("%s:%s", exceptionCode, message)));
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"handle exception from filter error", (Throwable)e);
        }
    }
}

