/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.configuration;

import com.cyberway.msf.commons.base.util.MqUtils;
import com.cyberway.msf.commons.base.util.MsUtils;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.boot.autoconfigure.amqp.SimpleRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RabbitTemplate.class})
public class MsConfig {
    @Bean
    @ConditionalOnMissingBean(value={MqUtils.class})
    public MqUtils mqUtils() {
        return new MqUtils();
    }

    @Bean
    @ConditionalOnMissingBean(value={MqUtils.class})
    public MsUtils msUtils() {
        return new MsUtils();
    }

    @Bean
    @ConditionalOnBean(value={ConnectionFactory.class, RabbitListenerContainerFactory.class})
    public SimpleRabbitListenerContainerFactory myContainerFactory(SimpleRabbitListenerContainerFactoryConfigurer configurer, ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setPrefetchCount(Integer.valueOf(1000));
        configurer.configure(factory, connectionFactory);
        return factory;
    }
}

