/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static Logger logger = LoggerFactory.getLogger(JsonUtils.class);
    private static ObjectMapper mapper = new ObjectMapper();

    private JsonUtils() {
    }

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        if (json == null) {
            return null;
        }
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (Exception var) {
            logger.info("Cannot parse json string to Object. Json: <" + json + ">, Object class: <" + clazz.getName() + ">.", (Throwable)var);
            return null;
        }
    }

    public static <T> List<T> toList(String json, Class<T> clazz) throws IOException {
        JavaType javaType = mapper.getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
        return (List)mapper.readValue(json, javaType);
    }

    public static <T> T fromMap(Map<?, ?> map, Class<T> clazz) {
        if (map == null) {
            return null;
        }
        try {
            return (T)mapper.readValue(JsonUtils.toJsonString(map), clazz);
        }
        catch (Exception var) {
            logger.info("Cannot parse map to Object. Map: <" + map + ">, Object class: <" + clazz.getName() + ">.", (Throwable)var);
            return null;
        }
    }

    public static <T> Map<String, T> toMap(String jsonText, Class<T> clazz) throws IOException {
        JavaType javaType = mapper.getTypeFactory().constructParametricType(Map.class, new Class[]{String.class, clazz});
        return (Map)mapper.readValue(jsonText, javaType);
    }

    public static Map toMap(String jsonText) {
        return JsonUtils.fromJson(jsonText, Map.class);
    }

    public static String toJsonString(Object obj) {
        try {
            if (obj != null) {
                return mapper.writeValueAsString(obj);
            }
        }
        catch (Exception var) {
            logger.warn("Cannot convert to json " + obj);
        }
        return "{}";
    }

    public static String toJsonStr(Object obj, boolean ignoreError) {
        block3: {
            try {
                if (obj != null) {
                    return mapper.writeValueAsString(obj);
                }
            }
            catch (Exception var) {
                logger.debug("convert to json error for object: {}", obj, (Object)var);
                if (ignoreError) break block3;
                throw new IllegalArgumentException("convert to json error for object", var);
            }
        }
        return null;
    }

    public static String toJson(Object o) {
        try {
            return mapper.writeValueAsString(o);
        }
        catch (JsonProcessingException var2) {
            logger.warn("toJson exception", (Throwable)var2);
            return null;
        }
    }

    public static <T> T load(String filePath, Class<T> clazz) {
        FileInputStream is = null;
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        try {
            is = new FileInputStream(new File(filePath));
        }
        catch (FileNotFoundException var4) {
            logger.error(var4.getMessage());
        }
        return JsonUtils.load(is, clazz);
    }

    public static <T> T load(InputStream is, Class<T> clazz) {
        try {
            return (T)mapper.readValue(is, clazz);
        }
        catch (JsonParseException var) {
            logger.warn("JsonParseException", (Throwable)var);
        }
        catch (JsonMappingException var1) {
            logger.warn("JsonMappingException", (Throwable)var1);
        }
        catch (IOException var2) {
            logger.warn("IOException", (Throwable)var2);
        }
        return null;
    }

    public static <T> T parser(String json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException var) {
            logger.error(var.getMessage());
            return null;
        }
    }

    static {
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

