/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.model.page.Orders;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.cyberway.msf.commons.model.page.PageModel;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class PageUtils<T> {
    private PageUtils() {
    }

    public static void sortAndPagination(PageModel pageModel, String defaultSort, String defaultOrder) {
        if (PageUtils.pagination(pageModel)) {
            PageHelper.orderBy((String)(defaultSort + ' ' + defaultOrder));
            return;
        }
        List orders = pageModel.getOrders();
        if (CollectionUtils.isEmpty((Collection)orders)) {
            PageHelper.orderBy((String)(defaultSort + ' ' + defaultOrder));
            return;
        }
        StringBuilder orderBy = new StringBuilder();
        PageUtils.getOrderString(orders, orderBy);
    }

    public static void sortAndPagination(PageModel pageModel) {
        if (PageUtils.pagination(pageModel)) {
            return;
        }
        List orders = pageModel.getOrders();
        if (CollectionUtils.isEmpty((Collection)orders)) {
            return;
        }
        StringBuilder orderBy = new StringBuilder();
        PageUtils.getOrderString(orders, orderBy);
    }

    public static void sortAndPagination(PageModel pageModel, String defaultSort, String defaultOrder, Class<?> clazz) {
        List<Object> orders = new ArrayList<Orders>();
        if (PageUtils.pagination(pageModel)) {
            orders.add(new Orders(defaultSort, defaultOrder));
        } else {
            orders = pageModel.getOrders();
            if (CollectionUtils.isEmpty(orders)) {
                orders = Lists.newArrayList((Object[])new Orders[]{new Orders(defaultSort, defaultOrder)});
            }
        }
        StringBuilder orderBy = new StringBuilder();
        if (clazz != null) {
            String name = clazz.getAnnotation(Table.class).name().toLowerCase();
            ArrayList<String> fieldList = new ArrayList<String>();
            while (clazz != null) {
                fieldList.addAll(new ArrayList(Lists.transform(Arrays.asList(clazz.getDeclaredFields()), Field::getName)));
                clazz = clazz.getSuperclass();
            }
            PageUtils.getOrderString(orders, orderBy, name, fieldList);
        } else {
            PageUtils.getOrderString(orders, orderBy);
        }
    }

    public static void sortAndPagination(PageModel pageModel, Class<?> clazz) {
        if (PageUtils.pagination(pageModel)) {
            return;
        }
        List orders = pageModel.getOrders();
        if (CollectionUtils.isEmpty((Collection)orders)) {
            return;
        }
        StringBuilder orderBy = new StringBuilder();
        if (clazz != null) {
            String name = clazz.getAnnotation(Table.class).name().toLowerCase();
            ArrayList<String> fieldList = new ArrayList<String>();
            while (clazz != null) {
                fieldList.addAll(new ArrayList(Lists.transform(Arrays.asList(clazz.getDeclaredFields()), Field::getName)));
                clazz = clazz.getSuperclass();
            }
            PageUtils.getOrderString(orders, orderBy, name, fieldList);
        } else {
            PageUtils.getOrderString(orders, orderBy);
        }
    }

    public static void sortAndPaginationWithDefaultSort(PageModel pageModel, Class<?> clazz) {
        if (PageUtils.pagination(pageModel)) {
            return;
        }
        List orders = pageModel.getOrders();
        if (CollectionUtils.isEmpty((Collection)orders)) {
            return;
        }
        StringBuilder orderBy = new StringBuilder();
        if (clazz != null) {
            String name = "this_";
            ArrayList<String> fieldList = new ArrayList<String>();
            while (clazz != null) {
                fieldList.addAll(new ArrayList(Lists.transform(Arrays.asList(clazz.getDeclaredFields()), Field::getName)));
                clazz = clazz.getSuperclass();
            }
            PageUtils.getOrderString(orders, orderBy, name, fieldList);
        } else {
            PageUtils.getOrderString(orders, orderBy);
        }
    }

    public static void sortAndPagination(PageModel pageModel, String orderBy) {
        if (PageUtils.pagination(pageModel)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)orderBy)) {
            return;
        }
        PageHelper.orderBy((String)orderBy);
    }

    private static void getOrderString(List<Orders> orders, StringBuilder orderBy, String name, List<String> fieldList) {
        for (Orders order : orders) {
            if (StringUtils.isEmpty((CharSequence)order.getSort()) || StringUtils.isEmpty((CharSequence)order.getOrder())) continue;
            PageUtils.sqlValidate(order.getSort(), order.getOrder());
            if (fieldList.contains(order.getSort())) {
                orderBy.append(name).append('.').append(order.getSort()).append(' ').append(order.getOrder()).append(",");
                continue;
            }
            orderBy.append(order.getSort()).append(' ').append(order.getOrder()).append(",");
        }
        PageHelper.orderBy((String)StringUtils.removeEnd((String)orderBy.toString(), (String)","));
    }

    private static void getOrderString(List<Orders> orders, StringBuilder orderBy) {
        for (Orders order : orders) {
            if (StringUtils.isEmpty((CharSequence)order.getSort()) || StringUtils.isEmpty((CharSequence)order.getOrder())) continue;
            PageUtils.sqlValidate(order.getSort(), order.getOrder());
            orderBy.append(order.getSort()).append(' ').append(order.getOrder()).append(",");
        }
        PageHelper.orderBy((String)StringUtils.removeEnd((String)orderBy.toString(), (String)","));
    }

    public static <T> PageDataModel<T> getPageDataModel(PageModel pageModel, Collection<T> rows) {
        if (null == pageModel) {
            return new PageDataModel(rows);
        }
        if (null != pageModel.getPageNum() && null != pageModel.getPageSize()) {
            try {
                if (rows instanceof Page) {
                    Page page = (Page)rows;
                    return new PageDataModel(rows, pageModel.getPageNum().intValue(), (int)page.getTotal(), pageModel.getPageSize().intValue());
                }
                return new PageDataModel(rows);
            }
            catch (Exception e) {
                throw new BaseException("Get PageDataModel fail.");
            }
        }
        return new PageDataModel(rows);
    }

    public static <T, K> PageDataModel<K> getPageDataModel(PageModel pageModel, PageDataModel<T> pageDataModel, List<K> list) {
        if (null == pageModel) {
            return new PageDataModel(list);
        }
        if (null != pageModel.getPageNum() && null != pageModel.getPageSize()) {
            return new PageDataModel(list, pageModel.getPageNum().intValue(), pageDataModel.getTotal().intValue(), pageModel.getPageSize().intValue());
        }
        return new PageDataModel(list);
    }

    private static boolean pagination(PageModel pageModel) {
        if (null == pageModel) {
            PageHelper.startPage((Object)0);
            return true;
        }
        if (null == pageModel.getPageNum() && null != pageModel.getPageSize()) {
            pageModel.setPageNum(Integer.valueOf(0));
        }
        if (null != pageModel.getPageNum() && null != pageModel.getPageSize()) {
            PageHelper.startPage((int)pageModel.getPageNum(), (int)pageModel.getPageSize());
        }
        return false;
    }

    public static void sqlValidate(String sort, String order) {
        Boolean sortValidate = !sort.trim().contains(" ") && !sort.contains(";");
        Boolean orderValidate = "asc".equalsIgnoreCase(order) || "desc".equalsIgnoreCase(order);
        if (sortValidate.booleanValue() && orderValidate.booleanValue()) {
            return;
        }
        throw MessageUtils.buildException(ApiResultCode.SORT_STRING_ERROR, sort + ' ' + order);
    }
}

