/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.util.JsonUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.log.model.BussinessLog;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class LogUtils {
    @Autowired
    private AmqpTemplate rabbitTemplate;
    @Autowired
    private CommonsBaseProperties commonsBaseProperties;
    private static LogUtils logUtils;

    @PostConstruct
    public void init() {
        logUtils = this;
    }

    public static void log(String content, String tag) {
        String fromIp = "";
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            fromIp = request.getRemoteAddr();
        }
        BussinessLog log = new BussinessLog();
        log.setContent(content);
        log.setFromIp(fromIp);
        log.setCreateTime(new Date());
        log.setModule(tag);
        UserInfo userInfo = UserUtils.getLoggedInUser();
        log.setCreateBy(userInfo == null ? null : userInfo.getUsername());
        if (LogUtils.logUtils.commonsBaseProperties.getLogEnable().booleanValue()) {
            LogUtils.logUtils.rabbitTemplate.convertAndSend("exchange.common.logs", "topic.common.logs", (Object)JsonUtils.toJson(log));
        }
    }
}

