/*
 * Decompiled with CFR 0.152.
 */
package com.fatboyindustrial.gsonjavatime;

import com.fatboyindustrial.gsonjavatime.InstantConverter;
import com.fatboyindustrial.gsonjavatime.LocalDateConverter;
import com.fatboyindustrial.gsonjavatime.LocalDateTimeConverter;
import com.fatboyindustrial.gsonjavatime.LocalTimeConverter;
import com.fatboyindustrial.gsonjavatime.OffsetDateTimeConverter;
import com.fatboyindustrial.gsonjavatime.OffsetTimeConverter;
import com.fatboyindustrial.gsonjavatime.ZonedDateTimeConverter;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;

public class Converters {
    public static final Type LOCAL_DATE_TYPE = new TypeToken<LocalDate>(){}.getType();
    public static final Type LOCAL_DATE_TIME_TYPE = new TypeToken<LocalDateTime>(){}.getType();
    public static final Type LOCAL_TIME_TYPE = new TypeToken<LocalTime>(){}.getType();
    public static final Type OFFSET_DATE_TIME_TYPE = new TypeToken<OffsetDateTime>(){}.getType();
    public static final Type OFFSET_TIME_TYPE = new TypeToken<OffsetTime>(){}.getType();
    public static final Type ZONED_DATE_TIME_TYPE = new TypeToken<ZonedDateTime>(){}.getType();
    public static final Type INSTANT_TYPE = new TypeToken<Instant>(){}.getType();

    public static GsonBuilder registerAll(GsonBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("builder cannot be null");
        }
        Converters.registerLocalDate(builder);
        Converters.registerLocalDateTime(builder);
        Converters.registerLocalTime(builder);
        Converters.registerOffsetDateTime(builder);
        Converters.registerOffsetTime(builder);
        Converters.registerZonedDateTime(builder);
        Converters.registerInstant(builder);
        return builder;
    }

    public static GsonBuilder registerLocalDate(GsonBuilder builder) {
        builder.registerTypeAdapter(LOCAL_DATE_TYPE, (Object)new LocalDateConverter());
        return builder;
    }

    public static GsonBuilder registerLocalDateTime(GsonBuilder builder) {
        builder.registerTypeAdapter(LOCAL_DATE_TIME_TYPE, (Object)new LocalDateTimeConverter());
        return builder;
    }

    public static GsonBuilder registerLocalTime(GsonBuilder builder) {
        builder.registerTypeAdapter(LOCAL_TIME_TYPE, (Object)new LocalTimeConverter());
        return builder;
    }

    public static GsonBuilder registerOffsetDateTime(GsonBuilder builder) {
        builder.registerTypeAdapter(OFFSET_DATE_TIME_TYPE, (Object)new OffsetDateTimeConverter());
        return builder;
    }

    public static GsonBuilder registerOffsetTime(GsonBuilder builder) {
        builder.registerTypeAdapter(OFFSET_TIME_TYPE, (Object)new OffsetTimeConverter());
        return builder;
    }

    public static GsonBuilder registerZonedDateTime(GsonBuilder builder) {
        builder.registerTypeAdapter(ZONED_DATE_TIME_TYPE, (Object)new ZonedDateTimeConverter());
        return builder;
    }

    public static GsonBuilder registerInstant(GsonBuilder builder) {
        builder.registerTypeAdapter(INSTANT_TYPE, (Object)new InstantConverter());
        return builder;
    }
}

