/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.actuate;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpResponseWriter;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.unsafe.ByteBufHttpData;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.InvocationContext;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.core.io.Resource;

final class WebOperationHttpService
implements HttpService {
    private static final Pattern FILENAME_BAD_CHARS = Pattern.compile("['/\\\\?%*:|\"<> ]");
    private static final Logger logger = LoggerFactory.getLogger(WebOperationHttpService.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<Map<String, Object>> JSON_MAP = new TypeReference<Map<String, Object>>(){};
    private final WebOperation operation;

    WebOperationHttpService(WebOperation operation) {
        this.operation = operation;
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) {
        CompletableFuture resFuture = new CompletableFuture();
        req.aggregate().handle((msg, t) -> {
            if (t != null) {
                resFuture.completeExceptionally((Throwable)t);
                return null;
            }
            if (this.operation.isBlocking()) {
                ctx.blockingTaskExecutor().execute(() -> this.invoke(ctx, (AggregatedHttpMessage)msg, resFuture));
            } else {
                this.invoke(ctx, (AggregatedHttpMessage)msg, resFuture);
            }
            return null;
        });
        return HttpResponse.from(resFuture);
    }

    private void invoke(ServiceRequestContext ctx, AggregatedHttpMessage req, CompletableFuture<HttpResponse> resFuture) {
        Map<String, Object> arguments = WebOperationHttpService.getArguments(ctx, req);
        Object result = this.operation.invoke(new InvocationContext(SecurityContext.NONE, arguments));
        try {
            HttpResponse res = WebOperationHttpService.handleResult(ctx, result, req.method());
            resFuture.complete(res);
        }
        catch (IOException e) {
            resFuture.completeExceptionally(e);
        }
    }

    private static Map<String, Object> getArguments(ServiceRequestContext ctx, AggregatedHttpMessage msg) {
        String query;
        LinkedHashMap arguments = new LinkedHashMap(ctx.pathParams());
        if (!msg.content().isEmpty()) {
            Map bodyParams;
            try {
                bodyParams = (Map)OBJECT_MAPPER.readValue(msg.content().array(), JSON_MAP);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid JSON in request.");
            }
            arguments.putAll(bodyParams);
        }
        if ((query = ctx.query()) != null) {
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(query, false);
            queryStringDecoder.parameters().forEach((key, values) -> arguments.put(key, values.size() != 1 ? values : values.get(0)));
        }
        return ImmutableMap.copyOf(arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpResponse handleResult(ServiceRequestContext ctx, @Nullable Object result, HttpMethod method) throws IOException {
        Object body;
        HttpStatus status;
        if (result == null) {
            return HttpResponse.of((HttpStatus)(method != HttpMethod.GET ? HttpStatus.NO_CONTENT : HttpStatus.NOT_FOUND));
        }
        if (result instanceof WebEndpointResponse) {
            WebEndpointResponse webResult = (WebEndpointResponse)result;
            status = HttpStatus.valueOf((int)webResult.getStatus());
            body = webResult.getBody();
        } else {
            status = HttpStatus.OK;
            body = result;
        }
        MediaType contentType = (MediaType)MoreObjects.firstNonNull((Object)ctx.negotiatedResponseMediaType(), (Object)MediaType.JSON_UTF_8);
        String contentSubType = contentType.subtype();
        if ("json".equals(contentSubType) || contentSubType.endsWith("+json")) {
            return HttpResponse.of((HttpStatus)status, (MediaType)contentType, (byte[])OBJECT_MAPPER.writeValueAsBytes(body));
        }
        if (body instanceof CharSequence) {
            return HttpResponse.of((HttpStatus)status, (MediaType)contentType, (CharSequence)((CharSequence)body));
        }
        if (body instanceof Resource) {
            HttpResponseWriter httpResponseWriter;
            block14: {
                Resource resource = (Resource)body;
                String filename = resource.getFilename();
                HttpResponseWriter res = HttpResponse.streaming();
                long length = resource.contentLength();
                HttpHeaders headers = (HttpHeaders)((HttpHeaders)HttpHeaders.of((HttpStatus)status).contentType(contentType).setLong((Object)HttpHeaderNames.CONTENT_LENGTH, length)).setTimeMillis((Object)HttpHeaderNames.LAST_MODIFIED, resource.lastModified());
                if (filename != null) {
                    headers.set((Object)HttpHeaderNames.CONTENT_DISPOSITION, (Object)("attachment;filename=" + FILENAME_BAD_CHARS.matcher(filename).replaceAll("_")));
                }
                res.write((Object)headers);
                boolean success = false;
                ReadableByteChannel in = null;
                try {
                    ReadableByteChannel finalIn = in = resource.readableChannel();
                    ctx.blockingTaskExecutor().execute(() -> WebOperationHttpService.streamResource(ctx, res, finalIn, length));
                    success = true;
                    httpResponseWriter = res;
                    if (success || in == null) break block14;
                }
                catch (Throwable throwable) {
                    if (!success && in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            logger.warn("{} Failed to close an actuator resource: {}", new Object[]{ctx, resource, e});
                        }
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.warn("{} Failed to close an actuator resource: {}", new Object[]{ctx, resource, e});
                }
            }
            return httpResponseWriter;
        }
        logger.warn("{} Cannot convert an actuator response: {}", (Object)ctx, body);
        return HttpResponse.of((HttpStatus)status, (MediaType)contentType, (String)body.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void streamResource(ServiceRequestContext ctx, HttpResponseWriter res, ReadableByteChannel in, long remainingBytes) {
        boolean endOfStream;
        int readBytes;
        int chunkSize = (int)Math.min(8192L, remainingBytes);
        ByteBuf buf = ctx.alloc().buffer(chunkSize);
        boolean success = false;
        try {
            readBytes = WebOperationHttpService.read(in, buf);
            if (readBytes < 0) {
                throw new EOFException();
            }
            success = true;
        }
        catch (Exception e) {
            WebOperationHttpService.close(res, in, e);
            return;
        }
        finally {
            if (!success) {
                buf.release();
            }
        }
        long nextRemainingBytes = remainingBytes - (long)readBytes;
        boolean bl = endOfStream = nextRemainingBytes == 0L;
        if (readBytes > 0) {
            if (!res.tryWrite((Object)new ByteBufHttpData(buf, endOfStream))) {
                WebOperationHttpService.close(in);
                return;
            }
        } else {
            buf.release();
        }
        if (endOfStream) {
            WebOperationHttpService.close(res, in);
            return;
        }
        res.onDemand(() -> {
            try {
                ctx.blockingTaskExecutor().execute(() -> WebOperationHttpService.streamResource(ctx, res, in, nextRemainingBytes));
            }
            catch (Exception e) {
                WebOperationHttpService.close(res, in, e);
            }
        });
    }

    private static int read(ReadableByteChannel src, ByteBuf dst) throws IOException {
        if (src instanceof ScatteringByteChannel) {
            return dst.writeBytes((ScatteringByteChannel)src, dst.writableBytes());
        }
        int readBytes = src.read(dst.nioBuffer(dst.writerIndex(), dst.writableBytes()));
        if (readBytes > 0) {
            dst.writerIndex(dst.writerIndex() + readBytes);
        }
        return readBytes;
    }

    private static void close(HttpResponseWriter res, Closeable in) {
        WebOperationHttpService.close(in);
        res.close();
    }

    private static void close(HttpResponseWriter res, Closeable in, Exception cause) {
        WebOperationHttpService.close(in);
        res.close((Throwable)cause);
    }

    private static void close(Closeable in) {
        try {
            in.close();
        }
        catch (Exception e) {
            logger.warn("Failed to close a stream for: {}", (Object)in, (Object)e);
        }
    }
}

