/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaModule;
import com.thoughtworks.qdox.model.JavaModuleDescriptor;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.impl.AbstractJavaModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaModuleDescriptor
implements JavaModuleDescriptor {
    private Collection<DefaultJavaExports> exports = new ArrayList<DefaultJavaExports>();
    private Collection<DefaultJavaRequires> requires = new ArrayList<DefaultJavaRequires>();
    private Collection<DefaultJavaUses> uses = new ArrayList<DefaultJavaUses>();
    private Collection<DefaultJavaProvides> provides = new ArrayList<DefaultJavaProvides>();

    public void addExports(DefaultJavaExports exports) {
        this.exports.add(exports);
    }

    @Override
    public Collection<JavaModuleDescriptor.JavaExports> getExports() {
        return Collections.unmodifiableCollection(this.exports);
    }

    public void addRequires(DefaultJavaRequires requires) {
        this.requires.add(requires);
    }

    @Override
    public Collection<JavaModuleDescriptor.JavaRequires> getRequires() {
        return Collections.unmodifiableCollection(this.requires);
    }

    public void addProvides(DefaultJavaProvides provides) {
        this.provides.add(provides);
    }

    @Override
    public Collection<JavaModuleDescriptor.JavaProvides> getProvides() {
        return Collections.unmodifiableCollection(this.provides);
    }

    public void addUses(DefaultJavaUses uses) {
        this.uses.add(uses);
    }

    @Override
    public Collection<JavaModuleDescriptor.JavaUses> getUses() {
        return Collections.unmodifiableCollection(this.uses);
    }

    public static class DefaultJavaUses
    extends AbstractJavaModel
    implements JavaModuleDescriptor.JavaUses {
        private JavaClass service;

        public DefaultJavaUses(JavaClass service) {
            this.service = service;
        }

        public JavaClass getService() {
            return this.service;
        }

        public String getCodeBlock() {
            return this.getModelWriter().writeModuleUses(this).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultJavaRequires
    extends AbstractJavaModel
    implements JavaModuleDescriptor.JavaRequires {
        private JavaModule module;
        private Collection<String> modifiers;

        public DefaultJavaRequires(JavaModule module, Collection<String> modifiers) {
            this.module = module;
            this.modifiers = modifiers;
        }

        @Override
        public JavaModule getModule() {
            return this.module;
        }

        @Override
        public boolean isPublic() {
            return this.getModifiers().contains("public");
        }

        @Override
        public boolean isStatic() {
            return this.getModifiers().contains("static");
        }

        @Override
        public Collection<String> getModifiers() {
            if (this.modifiers == null) {
                return Collections.emptyList();
            }
            return this.modifiers;
        }

        @Override
        public String getCodeBlock() {
            return this.getModelWriter().writeModuleRequires(this).toString();
        }
    }

    public static class DefaultJavaProvides
    extends AbstractJavaModel
    implements JavaModuleDescriptor.JavaProvides {
        private JavaClass service;
        private JavaClass provider;

        public DefaultJavaProvides(JavaClass service, JavaClass provider) {
            this.service = service;
            this.provider = provider;
        }

        public JavaClass getService() {
            return this.service;
        }

        public JavaClass getProvider() {
            return this.provider;
        }

        public String getCodeBlock() {
            return this.getModelWriter().writeModuleProvides(this).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultJavaExports
    extends AbstractJavaModel
    implements JavaModuleDescriptor.JavaExports {
        private JavaPackage source;
        private Collection<String> modifiers;
        private Collection<JavaModule> targets;

        public DefaultJavaExports(JavaPackage source, Collection<String> modifiers, Collection<JavaModule> targets) {
            this.source = source;
            this.modifiers = modifiers;
            this.targets = targets;
        }

        @Override
        public JavaPackage getSource() {
            return this.source;
        }

        @Override
        public Collection<JavaModule> getTargets() {
            if (this.targets == null) {
                return Collections.emptyList();
            }
            return this.targets;
        }

        @Override
        public boolean isDynamic() {
            return this.getModifiers().contains("dynamic");
        }

        @Override
        public Collection<String> getModifiers() {
            if (this.modifiers == null) {
                return Collections.emptyList();
            }
            return this.modifiers;
        }

        @Override
        public String getCodeBlock() {
            return this.getModelWriter().writeModuleExports(this).toString();
        }
    }
}

