/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import java.net.InetSocketAddress;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.FutureMono;
import reactor.ipc.netty.ReactorNetty;

@FunctionalInterface
public interface NettyContext
extends Disposable {
    public static boolean isPersistent(Channel channel) {
        return !channel.hasAttr(ReactorNetty.PERSISTENT_CHANNEL) || (Boolean)channel.attr(ReactorNetty.PERSISTENT_CHANNEL).get() != false;
    }

    default public NettyContext addHandler(ChannelHandler handler) {
        return this.addHandler(handler.getClass().getSimpleName(), handler);
    }

    default public NettyContext addHandler(String name, ChannelHandler handler) {
        if (handler instanceof ChannelOutboundHandler) {
            this.addHandlerFirst(name, handler);
        } else {
            this.addHandlerLast(name, handler);
        }
        return this;
    }

    default public NettyContext addHandlerLast(ChannelHandler handler) {
        return this.addHandlerLast(handler.getClass().getSimpleName(), handler);
    }

    default public NettyContext addHandlerLast(String name, ChannelHandler handler) {
        ReactorNetty.addHandlerBeforeReactorEndHandlers(this, name, handler);
        return this;
    }

    default public NettyContext addHandlerFirst(ChannelHandler handler) {
        return this.addHandlerFirst(handler.getClass().getSimpleName(), handler);
    }

    default public NettyContext addHandlerFirst(String name, ChannelHandler handler) {
        ReactorNetty.addHandlerAfterReactorCodecs(this, name, handler);
        return this;
    }

    default public InetSocketAddress address() {
        Channel c = this.channel();
        if (c instanceof SocketChannel) {
            return ((SocketChannel)c).remoteAddress();
        }
        if (c instanceof ServerSocketChannel) {
            return ((ServerSocketChannel)c).localAddress();
        }
        if (c instanceof DatagramChannel) {
            InetSocketAddress a = ((DatagramChannel)c).remoteAddress();
            return a != null ? a : ((DatagramChannel)c).localAddress();
        }
        throw new IllegalStateException("Does not have an InetSocketAddress");
    }

    public Channel channel();

    default public void dispose() {
        this.channel().close();
    }

    default public boolean isDisposed() {
        return !this.channel().isActive();
    }

    default public NettyContext markPersistent(boolean persist) {
        if (persist && !this.channel().hasAttr(ReactorNetty.PERSISTENT_CHANNEL)) {
            return this;
        }
        this.channel().attr(ReactorNetty.PERSISTENT_CHANNEL).set((Object)persist);
        return this;
    }

    default public Mono<Void> onClose() {
        return FutureMono.from(this.channel().closeFuture());
    }

    default public NettyContext onClose(Runnable onClose) {
        this.onClose().subscribe(null, e -> onClose.run(), onClose);
        return this;
    }

    default public NettyContext removeHandler(String name) {
        ReactorNetty.removeHandler(this.channel(), name);
        return this;
    }

    default public NettyContext replaceHandler(String name, ChannelHandler handler) {
        ReactorNetty.replaceHandler(this.channel(), name, handler);
        return this;
    }
}

