/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.resources;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.NonBlocking;
import reactor.ipc.netty.FutureMono;
import reactor.ipc.netty.resources.DefaultLoop;
import reactor.ipc.netty.resources.DefaultLoopNativeDetector;
import reactor.ipc.netty.resources.LoopResources;

final class DefaultLoopResources
extends AtomicLong
implements LoopResources {
    final String prefix;
    final boolean daemon;
    final int selectCount;
    final int workerCount;
    final EventLoopGroup serverLoops;
    final EventLoopGroup clientLoops;
    final EventLoopGroup serverSelectLoops;
    final AtomicReference<EventLoopGroup> cacheNativeClientLoops;
    final AtomicReference<EventLoopGroup> cacheNativeServerLoops;
    final AtomicReference<EventLoopGroup> cacheNativeSelectLoops;
    final AtomicBoolean running = new AtomicBoolean(true);

    static ThreadFactory threadFactory(DefaultLoopResources parent, String prefix) {
        return new EventLoopFactory(parent.daemon, parent.prefix + "-" + prefix, parent);
    }

    DefaultLoopResources(String prefix, int workerCount, boolean daemon) {
        this(prefix, -1, workerCount, daemon);
    }

    DefaultLoopResources(String prefix, int selectCount, int workerCount, boolean daemon) {
        this.daemon = daemon;
        this.workerCount = workerCount;
        this.prefix = prefix;
        this.serverLoops = new NioEventLoopGroup(workerCount, DefaultLoopResources.threadFactory(this, "nio"));
        this.clientLoops = LoopResources.colocate(this.serverLoops);
        this.cacheNativeClientLoops = new AtomicReference();
        this.cacheNativeServerLoops = new AtomicReference();
        if (selectCount == -1) {
            this.selectCount = workerCount;
            this.serverSelectLoops = this.serverLoops;
            this.cacheNativeSelectLoops = this.cacheNativeServerLoops;
        } else {
            this.selectCount = selectCount;
            this.serverSelectLoops = new NioEventLoopGroup(selectCount, DefaultLoopResources.threadFactory(this, "select-nio"));
            this.cacheNativeSelectLoops = new AtomicReference();
        }
    }

    public boolean isDisposed() {
        return !this.running.get();
    }

    @Override
    public Mono<Void> disposeLater() {
        return Mono.defer(() -> {
            EventLoopGroup cacheNativeClientGroup = this.cacheNativeClientLoops.get();
            EventLoopGroup cacheNativeSelectGroup = this.cacheNativeSelectLoops.get();
            EventLoopGroup cacheNativeServerGroup = this.cacheNativeServerLoops.get();
            if (this.running.compareAndSet(true, false)) {
                this.clientLoops.shutdownGracefully();
                this.serverSelectLoops.shutdownGracefully();
                this.serverLoops.shutdownGracefully();
                if (cacheNativeClientGroup != null) {
                    cacheNativeClientGroup.shutdownGracefully();
                }
                if (cacheNativeSelectGroup != null) {
                    cacheNativeSelectGroup.shutdownGracefully();
                }
                if (cacheNativeServerGroup != null) {
                    cacheNativeServerGroup.shutdownGracefully();
                }
            }
            Mono<Void> clMono = FutureMono.from(this.clientLoops.terminationFuture());
            Mono<Void> sslMono = FutureMono.from(this.serverSelectLoops.terminationFuture());
            Mono<Void> slMono = FutureMono.from(this.serverLoops.terminationFuture());
            Mono<Void> cnclMono = Mono.empty();
            if (cacheNativeClientGroup != null) {
                cnclMono = FutureMono.from(cacheNativeClientGroup.terminationFuture());
            }
            Mono<Void> cnslMono = Mono.empty();
            if (cacheNativeSelectGroup != null) {
                cnslMono = FutureMono.from(cacheNativeSelectGroup.terminationFuture());
            }
            Mono<Void> cnsrvlMono = Mono.empty();
            if (cacheNativeServerGroup != null) {
                cnsrvlMono = FutureMono.from(cacheNativeServerGroup.terminationFuture());
            }
            return Mono.when((Publisher[])new Publisher[]{clMono, sslMono, slMono, cnclMono, cnslMono, cnsrvlMono});
        });
    }

    @Override
    public EventLoopGroup onServerSelect(boolean useNative) {
        if (useNative && this.preferNative()) {
            return this.cacheNativeSelectLoops();
        }
        return this.serverSelectLoops;
    }

    @Override
    public EventLoopGroup onServer(boolean useNative) {
        if (useNative && this.preferNative()) {
            return this.cacheNativeServerLoops();
        }
        return this.serverLoops;
    }

    @Override
    public EventLoopGroup onClient(boolean useNative) {
        if (useNative && this.preferNative()) {
            return this.cacheNativeClientLoops();
        }
        return this.clientLoops;
    }

    @Override
    public String toString() {
        return "DefaultLoopResources {prefix=" + this.prefix + ", daemon=" + this.daemon + ", selectCount=" + this.selectCount + ", workerCount=" + this.workerCount + '}';
    }

    EventLoopGroup cacheNativeSelectLoops() {
        if (this.cacheNativeSelectLoops == this.cacheNativeServerLoops) {
            return this.cacheNativeServerLoops();
        }
        EventLoopGroup eventLoopGroup = this.cacheNativeSelectLoops.get();
        if (null == eventLoopGroup) {
            DefaultLoop defaultLoop = DefaultLoopNativeDetector.getInstance();
            EventLoopGroup newEventLoopGroup = defaultLoop.newEventLoopGroup(this.selectCount, DefaultLoopResources.threadFactory(this, "select-" + defaultLoop.getName()));
            if (!this.cacheNativeSelectLoops.compareAndSet(null, newEventLoopGroup)) {
                newEventLoopGroup.shutdownGracefully();
            }
            eventLoopGroup = this.cacheNativeSelectLoops();
        }
        return eventLoopGroup;
    }

    EventLoopGroup cacheNativeServerLoops() {
        EventLoopGroup eventLoopGroup = this.cacheNativeServerLoops.get();
        if (null == eventLoopGroup) {
            DefaultLoop defaultLoop = DefaultLoopNativeDetector.getInstance();
            EventLoopGroup newEventLoopGroup = defaultLoop.newEventLoopGroup(this.workerCount, DefaultLoopResources.threadFactory(this, "server-" + defaultLoop.getName()));
            if (!this.cacheNativeServerLoops.compareAndSet(null, newEventLoopGroup)) {
                newEventLoopGroup.shutdownGracefully();
            }
            eventLoopGroup = this.cacheNativeServerLoops();
        }
        return eventLoopGroup;
    }

    EventLoopGroup cacheNativeClientLoops() {
        EventLoopGroup eventLoopGroup = this.cacheNativeClientLoops.get();
        if (null == eventLoopGroup) {
            DefaultLoop defaultLoop = DefaultLoopNativeDetector.getInstance();
            EventLoopGroup newEventLoopGroup = defaultLoop.newEventLoopGroup(this.workerCount, DefaultLoopResources.threadFactory(this, "client-" + defaultLoop.getName()));
            if (!this.cacheNativeClientLoops.compareAndSet(null, newEventLoopGroup = LoopResources.colocate(newEventLoopGroup))) {
                newEventLoopGroup.shutdownGracefully();
            }
            eventLoopGroup = this.cacheNativeClientLoops();
        }
        return eventLoopGroup;
    }

    static final class EventLoop
    extends Thread
    implements NonBlocking {
        EventLoop(Runnable target) {
            super(target);
        }
    }

    static final class EventLoopFactory
    implements ThreadFactory {
        final boolean daemon;
        final AtomicLong counter;
        final String prefix;

        EventLoopFactory(boolean daemon, String prefix, AtomicLong counter) {
            this.daemon = daemon;
            this.counter = counter;
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            EventLoop t = new EventLoop(r);
            t.setDaemon(this.daemon);
            t.setName(this.prefix + "-" + this.counter.incrementAndGet());
            return t;
        }
    }
}

