/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.ssl;

import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.activemq.artemis.utils.ClassloadingUtil;

public class SSLSupport {
    public static SSLContext createContext(String keystoreProvider, String keystorePath, String keystorePassword, String trustStoreProvider, String trustStorePath, String trustStorePassword) throws Exception {
        return SSLSupport.createContext(keystoreProvider, keystorePath, keystorePassword, trustStoreProvider, trustStorePath, trustStorePassword, false);
    }

    public static SSLContext createContext(String keystoreProvider, String keystorePath, String keystorePassword, String trustStoreProvider, String trustStorePath, String trustStorePassword, boolean trustAll) throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        KeyManager[] keyManagers = SSLSupport.loadKeyManagers(keystoreProvider, keystorePath, keystorePassword);
        TrustManager[] trustManagers = SSLSupport.loadTrustManager(trustStoreProvider, trustStorePath, trustStorePassword, trustAll);
        context.init(keyManagers, trustManagers, new SecureRandom());
        return context;
    }

    public static String[] parseCommaSeparatedListIntoArray(String suites) {
        String[] cipherSuites = suites.split(",");
        for (int i = 0; i < cipherSuites.length; ++i) {
            cipherSuites[i] = cipherSuites[i].trim();
        }
        return cipherSuites;
    }

    public static String parseArrayIntoCommandSeparatedList(String[] suites) {
        StringBuilder supportedSuites = new StringBuilder();
        for (String suite : suites) {
            supportedSuites.append(suite);
            supportedSuites.append(", ");
        }
        return supportedSuites.delete(supportedSuites.length() - 2, supportedSuites.length()).toString();
    }

    private static TrustManager[] loadTrustManager(String trustStoreProvider, String trustStorePath, String trustStorePassword, boolean trustAll) throws Exception {
        if (trustAll) {
            return InsecureTrustManagerFactory.INSTANCE.getTrustManagers();
        }
        if (!(trustStorePath != null || trustStoreProvider != null && "PKCS11".equals(trustStoreProvider.toUpperCase()))) {
            return null;
        }
        KeyStore trustStore = SSLSupport.loadKeystore(trustStoreProvider, trustStorePath, trustStorePassword);
        TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustMgrFactory.init(trustStore);
        return trustMgrFactory.getTrustManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeystore(String keystoreProvider, String keystorePath, String keystorePassword) throws Exception {
        KeyStore ks = KeyStore.getInstance(keystoreProvider);
        InputStream in = null;
        try {
            if (keystorePath != null) {
                URL keystoreURL = SSLSupport.validateStoreURL(keystorePath);
                in = keystoreURL.openStream();
            }
            ks.load(in, keystorePassword == null ? null : keystorePassword.toCharArray());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ks;
    }

    private static KeyManager[] loadKeyManagers(String keyStoreProvider, String keystorePath, String keystorePassword) throws Exception {
        if (!(keystorePath != null || keyStoreProvider != null && "PKCS11".equals(keyStoreProvider.toUpperCase()))) {
            return null;
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = SSLSupport.loadKeystore(keyStoreProvider, keystorePath, keystorePassword);
        kmf.init(ks, keystorePassword == null ? null : keystorePassword.toCharArray());
        return kmf.getKeyManagers();
    }

    private static URL validateStoreURL(String storePath) throws Exception {
        assert (storePath != null);
        try {
            return new URL(storePath);
        }
        catch (MalformedURLException e) {
            File file = new File(storePath);
            if (file.exists() && file.isFile()) {
                return file.toURI().toURL();
            }
            URL url = SSLSupport.findResource(storePath);
            if (url != null) {
                return url;
            }
            throw new Exception("Failed to find a store at " + storePath);
        }
    }

    private static URL findResource(final String resourceName) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return ClassloadingUtil.findResource((String)resourceName);
            }
        });
    }
}

