/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;

public class AddressFilterPredicate
extends ActiveMQFilterPredicate<SimpleString> {
    private Field f;
    private final ActiveMQServer server;

    public AddressFilterPredicate(ActiveMQServer server) {
        this.server = server;
    }

    @Override
    public boolean apply(SimpleString addressName) {
        AddressInfo address = this.server.getAddressInfo(addressName);
        if (this.f == null) {
            return true;
        }
        try {
            switch (this.f) {
                case ID: {
                    return this.matches(address.getId());
                }
                case NAME: {
                    return this.matches(address.getName());
                }
                case ROUTING_TYPES: {
                    return this.matchAny(address.getRoutingTypes());
                }
                case PRODUCER_ID: {
                    return this.matches("TODO");
                }
                case QUEUE_COUNT: {
                    return this.matches(this.server.bindingQuery(address.getName()).getQueueNames().size());
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void setField(String field) {
        if (field != null && !field.equals("")) {
            this.f = Field.valueOf(field.toUpperCase());
        }
    }

    static enum Field {
        ID,
        NAME,
        ROUTING_TYPES,
        PRODUCER_ID,
        QUEUE_COUNT;

    }
}

