/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.messagecounter.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.messagecounter.MessageCounter;
import org.apache.activemq.artemis.core.messagecounter.MessageCounterManager;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;

public class MessageCounterManagerImpl
implements MessageCounterManager {
    public static final long DEFAULT_SAMPLE_PERIOD = ActiveMQDefaultConfiguration.getDefaultMessageCounterSamplePeriod();
    public static final long MIN_SAMPLE_PERIOD = 1000L;
    public static final int DEFAULT_MAX_DAY_COUNT = ActiveMQDefaultConfiguration.getDefaultMessageCounterMaxDayHistory();
    private final Map<String, MessageCounter> messageCounters;
    private final MessageCountersPinger messageCountersPinger;
    private int maxDayCount = DEFAULT_MAX_DAY_COUNT;

    public MessageCounterManagerImpl(ScheduledExecutorService scheduledThreadPool, Executor executor) {
        this.messageCounters = new HashMap<String, MessageCounter>();
        this.messageCountersPinger = new MessageCountersPinger(scheduledThreadPool, executor, DEFAULT_SAMPLE_PERIOD, TimeUnit.MILLISECONDS, false);
    }

    @Override
    public synchronized void start() {
        this.messageCountersPinger.start();
    }

    @Override
    public synchronized void stop() {
        this.messageCountersPinger.stop();
    }

    @Override
    public synchronized void clear() {
        this.messageCounters.clear();
    }

    @Override
    public synchronized void reschedule(long newPeriod) {
        this.messageCountersPinger.setPeriod(newPeriod);
    }

    @Override
    public long getSamplePeriod() {
        return this.messageCountersPinger.getPeriod();
    }

    @Override
    public int getMaxDayCount() {
        return this.maxDayCount;
    }

    @Override
    public void setMaxDayCount(int count) {
        this.maxDayCount = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMessageCounter(String name, MessageCounter counter) {
        Map<String, MessageCounter> map = this.messageCounters;
        synchronized (map) {
            this.messageCounters.put(name, counter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageCounter unregisterMessageCounter(String name) {
        Map<String, MessageCounter> map = this.messageCounters;
        synchronized (map) {
            return this.messageCounters.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MessageCounter> getMessageCounters() {
        Map<String, MessageCounter> map = this.messageCounters;
        synchronized (map) {
            return new HashSet<MessageCounter>(this.messageCounters.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetAllCounters() {
        Map<String, MessageCounter> map = this.messageCounters;
        synchronized (map) {
            for (MessageCounter counter : this.messageCounters.values()) {
                counter.resetCounter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetAllCounterHistories() {
        Map<String, MessageCounter> map = this.messageCounters;
        synchronized (map) {
            for (MessageCounter counter : this.messageCounters.values()) {
                counter.resetHistory();
            }
        }
    }

    private class MessageCountersPinger
    extends ActiveMQScheduledComponent {
        MessageCountersPinger(ScheduledExecutorService scheduledExecutorService, Executor executor, long checkPeriod, TimeUnit timeUnit, boolean onDemand) {
            super(scheduledExecutorService, executor, checkPeriod, timeUnit, onDemand);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = MessageCounterManagerImpl.this.messageCounters;
            synchronized (map) {
                for (MessageCounter counter : MessageCounterManagerImpl.this.messageCounters.values()) {
                    counter.onTimer();
                }
            }
        }
    }
}

