/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.activemq.artemis.core.server.impl.jdbc.JdbcLeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.LeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.SharedStateManager;
import org.apache.activemq.artemis.jdbc.store.drivers.AbstractJDBCDriver;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.utils.UUID;

final class JdbcSharedStateManager
extends AbstractJDBCDriver
implements SharedStateManager {
    private final String holderId;
    private final long lockExpirationMillis;
    private JdbcLeaseLock liveLock;
    private JdbcLeaseLock backupLock;
    private PreparedStatement readNodeId;
    private PreparedStatement writeNodeId;
    private PreparedStatement readState;
    private PreparedStatement writeState;

    public static JdbcSharedStateManager usingDataSource(String holderId, long locksExpirationMillis, DataSource dataSource, SQLProvider provider) {
        JdbcSharedStateManager sharedStateManager = new JdbcSharedStateManager(holderId, locksExpirationMillis);
        sharedStateManager.setDataSource(dataSource);
        sharedStateManager.setSqlProvider(provider);
        try {
            sharedStateManager.start();
            return sharedStateManager;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static JdbcSharedStateManager usingConnectionUrl(String holderId, long locksExpirationMillis, String jdbcConnectionUrl, String jdbcDriverClass, SQLProvider provider) {
        JdbcSharedStateManager sharedStateManager = new JdbcSharedStateManager(holderId, locksExpirationMillis);
        sharedStateManager.setJdbcConnectionUrl(jdbcConnectionUrl);
        sharedStateManager.setJdbcDriverClass(jdbcDriverClass);
        sharedStateManager.setSqlProvider(provider);
        try {
            sharedStateManager.start();
            return sharedStateManager;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void createSchema() throws SQLException {
        try {
            this.createTable(new String[]{this.sqlProvider.createNodeManagerStoreTableSQL(), this.sqlProvider.createNodeIdSQL(), this.sqlProvider.createStateSQL(), this.sqlProvider.createLiveLockSQL(), this.sqlProvider.createBackupLockSQL()});
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static JdbcLeaseLock createLiveLock(String holderId, Connection connection, SQLProvider sqlProvider, long expirationMillis, long maxAllowableMillisDiffFromDBtime) throws SQLException {
        return new JdbcLeaseLock(holderId, connection, connection.prepareStatement(sqlProvider.tryAcquireLiveLockSQL()), connection.prepareStatement(sqlProvider.tryReleaseLiveLockSQL()), connection.prepareStatement(sqlProvider.renewLiveLockSQL()), connection.prepareStatement(sqlProvider.isLiveLockedSQL()), connection.prepareStatement(sqlProvider.currentTimestampSQL()), expirationMillis, maxAllowableMillisDiffFromDBtime);
    }

    static JdbcLeaseLock createBackupLock(String holderId, Connection connection, SQLProvider sqlProvider, long expirationMillis, long maxAllowableMillisDiffFromDBtime) throws SQLException {
        return new JdbcLeaseLock(holderId, connection, connection.prepareStatement(sqlProvider.tryAcquireBackupLockSQL()), connection.prepareStatement(sqlProvider.tryReleaseBackupLockSQL()), connection.prepareStatement(sqlProvider.renewBackupLockSQL()), connection.prepareStatement(sqlProvider.isBackupLockedSQL()), connection.prepareStatement(sqlProvider.currentTimestampSQL()), expirationMillis, maxAllowableMillisDiffFromDBtime);
    }

    protected void prepareStatements() throws SQLException {
        this.liveLock = JdbcSharedStateManager.createLiveLock(this.holderId, this.connection, this.sqlProvider, this.lockExpirationMillis, 0L);
        this.backupLock = JdbcSharedStateManager.createBackupLock(this.holderId, this.connection, this.sqlProvider, this.lockExpirationMillis, 0L);
        this.readNodeId = this.connection.prepareStatement(this.sqlProvider.readNodeIdSQL());
        this.writeNodeId = this.connection.prepareStatement(this.sqlProvider.writeNodeIdSQL());
        this.writeState = this.connection.prepareStatement(this.sqlProvider.writeStateSQL());
        this.readState = this.connection.prepareStatement(this.sqlProvider.readStateSQL());
    }

    private JdbcSharedStateManager(String holderId, long lockExpirationMillis) {
        this.holderId = holderId;
        this.lockExpirationMillis = lockExpirationMillis;
    }

    @Override
    public LeaseLock liveLock() {
        return this.liveLock;
    }

    @Override
    public LeaseLock backupLock() {
        return this.backupLock;
    }

    private UUID rawReadNodeId() throws SQLException {
        PreparedStatement preparedStatement = this.readNodeId;
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            if (!resultSet.next()) {
                UUID uUID = null;
                return uUID;
            }
            String nodeId = resultSet.getString(1);
            if (nodeId != null) {
                UUID uUID = new UUID(1, UUID.stringToBytes((String)nodeId));
                return uUID;
            }
            UUID uUID = null;
            return uUID;
        }
    }

    @Override
    public UUID readNodeId() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setTransactionIsolation(2);
                this.connection.setAutoCommit(true);
                UUID nodeId = this.rawReadNodeId();
                return nodeId;
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeNodeId(UUID nodeId) {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setTransactionIsolation(2);
                this.connection.setAutoCommit(true);
                this.rawWriteNodeId(nodeId);
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void rawWriteNodeId(UUID nodeId) throws SQLException {
        PreparedStatement preparedStatement = this.writeNodeId;
        preparedStatement.setString(1, nodeId.toString());
        if (preparedStatement.executeUpdate() != 1) {
            throw new IllegalStateException("can't write NODE_ID on the JDBC Node Manager Store!");
        }
    }

    @Override
    public UUID setup(Supplier<? extends UUID> nodeIdFactory) {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                UUID nodeId;
                this.connection.setTransactionIsolation(8);
                this.connection.setAutoCommit(false);
                try {
                    UUID readNodeId = this.rawReadNodeId();
                    if (readNodeId == null) {
                        nodeId = nodeIdFactory.get();
                        this.rawWriteNodeId(nodeId);
                    } else {
                        nodeId = readNodeId;
                    }
                }
                catch (SQLException e) {
                    this.connection.rollback();
                    this.connection.setAutoCommit(true);
                    throw e;
                }
                this.connection.commit();
                this.connection.setAutoCommit(true);
                return nodeId;
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static SharedStateManager.State decodeState(String s) {
        if (s == null) {
            return SharedStateManager.State.NOT_STARTED;
        }
        switch (s) {
            case "L": {
                return SharedStateManager.State.LIVE;
            }
            case "F": {
                return SharedStateManager.State.FAILING_BACK;
            }
            case "P": {
                return SharedStateManager.State.PAUSED;
            }
            case "N": {
                return SharedStateManager.State.NOT_STARTED;
            }
        }
        throw new IllegalStateException("unknown state [" + s + "]");
    }

    private static String encodeState(SharedStateManager.State state) {
        switch (state) {
            case LIVE: {
                return "L";
            }
            case FAILING_BACK: {
                return "F";
            }
            case PAUSED: {
                return "P";
            }
            case NOT_STARTED: {
                return "N";
            }
        }
        throw new IllegalStateException("unknown state [" + (Object)((Object)state) + "]");
    }

    @Override
    public SharedStateManager.State readState() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                SharedStateManager.State state;
                this.connection.setTransactionIsolation(2);
                this.connection.setAutoCommit(true);
                PreparedStatement preparedStatement = this.readState;
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    state = !resultSet.next() ? SharedStateManager.State.FIRST_TIME_START : JdbcSharedStateManager.decodeState(resultSet.getString(1));
                }
                return state;
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeState(SharedStateManager.State state) {
        String encodedState = JdbcSharedStateManager.encodeState(state);
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setTransactionIsolation(2);
                this.connection.setAutoCommit(true);
                PreparedStatement preparedStatement = this.writeState;
                preparedStatement.setString(1, encodedState);
                if (preparedStatement.executeUpdate() != 1) {
                    throw new IllegalStateException("can't write STATE to the JDBC Node Manager Store!");
                }
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws SQLException {
        if (this.sqlProvider.closeConnectionOnShutdown()) {
            Connection connection = this.connection;
            synchronized (connection) {
                this.readNodeId.close();
                this.writeNodeId.close();
                this.readState.close();
                this.writeState.close();
                this.liveLock.close();
                this.backupLock.close();
                super.stop();
            }
        }
    }

    @Override
    public void close() throws SQLException {
        this.stop();
    }
}

