/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management;

import org.apache.activemq.artemis.core.config.JMXConnectorConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.management.ArtemisMBeanServerBuilder;
import org.apache.activemq.artemis.core.server.management.ArtemisMBeanServerGuard;
import org.apache.activemq.artemis.core.server.management.JMXAccessControlList;
import org.apache.activemq.artemis.core.server.management.ManagementConnector;

public class ManagementContext
implements ActiveMQComponent {
    private boolean isStarted = false;
    private JMXAccessControlList accessControlList;
    private JMXConnectorConfiguration jmxConnectorConfiguration;
    private ManagementConnector mBeanServer;

    public void start() throws Exception {
        if (this.accessControlList != null) {
            System.setProperty("javax.management.builder.initial", ArtemisMBeanServerBuilder.class.getCanonicalName());
            ArtemisMBeanServerGuard guardHandler = new ArtemisMBeanServerGuard();
            guardHandler.setJMXAccessControlList(this.accessControlList);
            ArtemisMBeanServerBuilder.setGuard(guardHandler);
        }
        if (this.jmxConnectorConfiguration != null) {
            this.mBeanServer = new ManagementConnector(this.jmxConnectorConfiguration);
            this.mBeanServer.start();
        }
        this.isStarted = true;
    }

    public void stop() throws Exception {
        this.isStarted = false;
        if (this.mBeanServer != null) {
            this.mBeanServer.stop();
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void setAccessControlList(JMXAccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    public JMXAccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setJmxConnectorConfiguration(JMXConnectorConfiguration jmxConnectorConfiguration) {
        this.jmxConnectorConfiguration = jmxConnectorConfiguration;
    }

    public JMXConnectorConfiguration getJmxConnectorConfiguration() {
        return this.jmxConnectorConfiguration;
    }
}

